/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.model;

import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPackage;
import com.intellij.spring.boot.SpringBootApiBundle;
import com.intellij.spring.boot.library.SpringBootLibraryUtil;
import com.intellij.spring.boot.model.autoconfigure.jam.SpringBootApplication;
import com.intellij.spring.model.highlighting.jam.SpringUastInspectionBase;
import com.intellij.spring.model.jam.stereotype.SpringJamComponentScan;
import com.intellij.spring.model.jam.stereotype.SpringJamComponentScanArchetype;
import com.intellij.spring.model.jam.stereotype.SpringJamComponentScans;
import com.intellij.spring.model.utils.SpringCommonUtils;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UAnnotationKt;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UElementKt;
import org.jetbrains.uast.UastContextKt;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J-\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010\fJ\"\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0002J\u0018\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u00a8\u0006\u0016"}, d2={"Lcom/intellij/spring/boot/model/SpringBootApplicationSetupInspection;", "Lcom/intellij/spring/model/highlighting/jam/SpringUastInspectionBase;", "()V", "checkClass", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "uClass", "Lorg/jetbrains/uast/UClass;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "isOnTheFly", "", "(Lorg/jetbrains/uast/UClass;Lcom/intellij/codeInspection/InspectionManager;Z)[Lcom/intellij/codeInspection/ProblemDescriptor;", "checkComponentScan", "", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "packageName", "", "componentScan", "Lcom/intellij/spring/model/jam/stereotype/SpringJamComponentScan;", "isRedundantDeclaration", "intellij.spring.boot.core"})
public final class SpringBootApplicationSetupInspection
extends SpringUastInspectionBase {
    /*
     * WARNING - void declaration
     */
    @Nullable
    public ProblemDescriptor[] checkClass(@NotNull UClass uClass, @NotNull InspectionManager manager, boolean isOnTheFly) {
        UAnnotation enableAutoConfigurationAnno;
        Intrinsics.checkNotNullParameter((Object)uClass, (String)"uClass");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        PsiElement psiElement = UElementKt.getSourcePsiElement((UElement)uClass.getUastAnchor());
        if (psiElement == null) {
            return null;
        }
        PsiElement nameIdentifier = psiElement;
        PsiClass psiClass = uClass.getJavaPsi();
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)((PsiElement)psiClass));
        if (module == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)module, (String)"ModuleUtilCore.findModul\u2026(psiClass) ?: return null");
        Module module2 = module;
        if (!SpringBootLibraryUtil.hasSpringBootLibrary(module2)) {
            return null;
        }
        if (!SpringCommonUtils.isSpringBeanCandidateClass((PsiClass)psiClass)) {
            return null;
        }
        if ((SpringBootApplication)SpringBootApplication.META.getJamElement((PsiModifierListOwner)psiClass) == null) {
            return null;
        }
        ProblemsHolder holder = new ProblemsHolder(manager, nameIdentifier.getContainingFile(), isOnTheFly);
        String string = psiClass.getQualifiedName();
        Intrinsics.checkNotNull((Object)string);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"psiClass.qualifiedName!!");
        String qualifiedName = string;
        if (Intrinsics.areEqual((Object)qualifiedName, (Object)psiClass.getName())) {
            holder.registerProblem(nameIdentifier, SpringBootApiBundle.message("spring.boot.application.in.default.package", new Object[0]), new LocalQuickFix[0]);
            return holder.getResultsArray();
        }
        String string2 = StringUtil.getPackageName((String)qualifiedName);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringUtil.getPackageName(qualifiedName)");
        String packageName = string2;
        SpringJamComponentScan componentScan = (SpringJamComponentScan)SpringJamComponentScan.META.getJamElement((PsiModifierListOwner)psiClass);
        this.checkComponentScan(holder, packageName, componentScan);
        SpringJamComponentScans componentScans = (SpringJamComponentScans)SpringJamComponentScans.META.getJamElement((PsiModifierListOwner)psiClass);
        if (componentScans != null) {
            for (SpringJamComponentScan jamComponentScan : componentScans.getComponentScans()) {
                this.checkComponentScan(holder, packageName, jamComponentScan);
            }
        }
        if ((enableAutoConfigurationAnno = uClass.findAnnotation("org.springframework.boot.autoconfigure.EnableAutoConfiguration")) != null) {
            Collection collection = enableAutoConfigurationAnno.getAttributeValues();
            boolean bl = false;
            if (!collection.isEmpty()) {
                PsiElement psiElement2 = UAnnotationKt.getNamePsiElement((UAnnotation)enableAutoConfigurationAnno);
                Intrinsics.checkNotNull((Object)psiElement2);
                holder.registerProblem(psiElement2, SpringBootApiBundle.message("spring.boot.application.attribute.in.wrong.annotation", StringUtil.getShortName((String)"org.springframework.boot.autoconfigure.SpringBootApplication")), new LocalQuickFix[0]);
            } else {
                LocalQuickFixAndIntentionActionOnPsiElement localQuickFixAndIntentionActionOnPsiElement;
                String cause = SpringBootApiBundle.message("spring.boot.application.already.applies.annotation", StringUtil.getShortName((String)"org.springframework.boot.autoconfigure.SpringBootApplication"), StringUtil.getShortName((String)"org.springframework.boot.autoconfigure.EnableAutoConfiguration"));
                ProblemsHolder problemsHolder = holder;
                PsiElement psiElement3 = UAnnotationKt.getNamePsiElement((UAnnotation)enableAutoConfigurationAnno);
                PsiElement psiElement4 = psiElement3;
                Intrinsics.checkNotNull((Object)psiElement3);
                String string3 = SpringBootApiBundle.message("spring.boot.application.redundant.declaration", cause);
                LocalQuickFix[] localQuickFixArray = new LocalQuickFix[1];
                LocalQuickFix[] localQuickFixArray2 = localQuickFixArray;
                LocalQuickFix[] localQuickFixArray3 = localQuickFixArray;
                int n = 0;
                PsiElement psiElement5 = enableAutoConfigurationAnno.getSourcePsi();
                if (psiElement5 != null) {
                    void it;
                    PsiElement psiElement6 = psiElement5;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    PsiElement psiElement7 = psiElement6;
                    int n2 = n;
                    LocalQuickFix[] localQuickFixArray4 = localQuickFixArray2;
                    LocalQuickFix[] localQuickFixArray5 = localQuickFixArray3;
                    String string4 = string3;
                    PsiElement psiElement8 = psiElement4;
                    ProblemsHolder problemsHolder2 = problemsHolder;
                    boolean bl4 = false;
                    LocalQuickFixAndIntentionActionOnPsiElement localQuickFixAndIntentionActionOnPsiElement2 = QuickFixFactory.getInstance().createDeleteFix((PsiElement)it);
                    problemsHolder = problemsHolder2;
                    psiElement4 = psiElement8;
                    string3 = string4;
                    localQuickFixArray3 = localQuickFixArray5;
                    localQuickFixArray2 = localQuickFixArray4;
                    n = n2;
                    localQuickFixAndIntentionActionOnPsiElement = localQuickFixAndIntentionActionOnPsiElement2;
                } else {
                    localQuickFixAndIntentionActionOnPsiElement = null;
                }
                localQuickFixArray2[n] = (LocalQuickFix)localQuickFixAndIntentionActionOnPsiElement;
                problemsHolder.registerProblem(psiElement4, string3, localQuickFixArray3);
            }
        }
        return holder.getResultsArray();
    }

    /*
     * WARNING - void declaration
     */
    private final void checkComponentScan(ProblemsHolder holder, String packageName, SpringJamComponentScan componentScan) {
        block6: {
            LocalQuickFixAndIntentionActionOnPsiElement localQuickFixAndIntentionActionOnPsiElement;
            PsiAnnotation psiAnnotation;
            block8: {
                block7: {
                    if (componentScan == null || !this.isRedundantDeclaration(componentScan, packageName)) break block6;
                    psiAnnotation = componentScan.getAnnotation();
                    if (psiAnnotation == null) break block7;
                    PsiElement $this$toUElementOfType$iv = (PsiElement)psiAnnotation;
                    boolean $i$f$toUElementOfType = false;
                    psiAnnotation = (UAnnotation)UastContextKt.toUElement((PsiElement)$this$toUElementOfType$iv, UAnnotation.class);
                    if (psiAnnotation != null) break block8;
                }
                return;
            }
            PsiAnnotation annotationElement = psiAnnotation;
            String cause = SpringBootApiBundle.message("spring.boot.application.already.applies.given.annotation", StringUtil.getShortName((String)"org.springframework.boot.autoconfigure.SpringBootApplication"), StringUtil.getShortName((String)"org.springframework.context.annotation.ComponentScan"));
            ProblemsHolder problemsHolder = holder;
            PsiElement psiElement = UAnnotationKt.getNamePsiElement((UAnnotation)annotationElement);
            if (psiElement == null) {
                return;
            }
            String string = SpringBootApiBundle.message("spring.boot.application.redundant.declaration", cause);
            LocalQuickFix[] localQuickFixArray = new LocalQuickFix[1];
            LocalQuickFix[] localQuickFixArray2 = localQuickFixArray;
            LocalQuickFix[] localQuickFixArray3 = localQuickFixArray;
            int n = 0;
            PsiElement psiElement2 = annotationElement.getSourcePsi();
            if (psiElement2 != null) {
                void it;
                PsiElement psiElement3 = psiElement2;
                boolean bl = false;
                boolean bl2 = false;
                PsiElement psiElement4 = psiElement3;
                int n2 = n;
                LocalQuickFix[] localQuickFixArray4 = localQuickFixArray2;
                LocalQuickFix[] localQuickFixArray5 = localQuickFixArray3;
                String string2 = string;
                PsiElement psiElement5 = psiElement;
                ProblemsHolder problemsHolder2 = problemsHolder;
                boolean bl3 = false;
                LocalQuickFixAndIntentionActionOnPsiElement localQuickFixAndIntentionActionOnPsiElement2 = QuickFixFactory.getInstance().createDeleteFix((PsiElement)it);
                problemsHolder = problemsHolder2;
                psiElement = psiElement5;
                string = string2;
                localQuickFixArray3 = localQuickFixArray5;
                localQuickFixArray2 = localQuickFixArray4;
                n = n2;
                localQuickFixAndIntentionActionOnPsiElement = localQuickFixAndIntentionActionOnPsiElement2;
            } else {
                localQuickFixAndIntentionActionOnPsiElement = null;
            }
            localQuickFixArray2[n] = (LocalQuickFix)localQuickFixAndIntentionActionOnPsiElement;
            problemsHolder.registerProblem(psiElement, string, localQuickFixArray3);
        }
    }

    private final boolean isRedundantDeclaration(SpringJamComponentScan componentScan, String packageName) {
        block6: {
            block3: {
                block5: {
                    block4: {
                        Iterator iterator = componentScan.getPsiPackages().iterator();
                        while (iterator.hasNext()) {
                            PsiPackage psiPackage;
                            PsiPackage psiPackage2 = psiPackage = (PsiPackage)iterator.next();
                            Intrinsics.checkNotNullExpressionValue((Object)psiPackage2, (String)"psiPackage");
                            if (!(Intrinsics.areEqual((Object)psiPackage2.getQualifiedName(), (Object)packageName) ^ true)) continue;
                            return false;
                        }
                        if (!componentScan.useDefaultFilters() || componentScan.isLazyInit() || componentScan.getResourcePattern() != null && Intrinsics.areEqual((Object)componentScan.getResourcePattern(), (Object)"**/*.class") ^ true || componentScan.getScopedProxy() != null && componentScan.getScopedProxy() != SpringJamComponentScanArchetype.ScopedProxyMode.DEFAULT) break block3;
                        if (componentScan.getNameGenerator() == null) break block4;
                        PsiClass psiClass = componentScan.getNameGenerator();
                        Intrinsics.checkNotNull((Object)psiClass);
                        Intrinsics.checkNotNullExpressionValue((Object)psiClass, (String)"componentScan.nameGenerator!!");
                        if (Intrinsics.areEqual((Object)psiClass.getQualifiedName(), (Object)"org.springframework.beans.factory.support.BeanNameGenerator") ^ true) break block3;
                    }
                    if (componentScan.getScopeResolver() == null) break block5;
                    PsiClass psiClass = componentScan.getScopeResolver();
                    Intrinsics.checkNotNull((Object)psiClass);
                    Intrinsics.checkNotNullExpressionValue((Object)psiClass, (String)"componentScan.scopeResolver!!");
                    if (Intrinsics.areEqual((Object)psiClass.getQualifiedName(), (Object)"org.springframework.context.annotation.AnnotationScopeMetadataResolver") ^ true) break block3;
                }
                Set set = componentScan.getIncludeContextFilters();
                Intrinsics.checkNotNullExpressionValue((Object)set, (String)"componentScan.includeContextFilters");
                Collection collection = set;
                boolean bl = false;
                if (!collection.isEmpty()) break block3;
                Set set2 = componentScan.getExcludeContextFilters();
                Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"componentScan.excludeContextFilters");
                collection = set2;
                bl = false;
                if (!(!collection.isEmpty())) break block6;
            }
            return false;
        }
        return true;
    }
}

