/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.library;

import com.intellij.codeInsight.daemon.quickFix.ExternalLibraryResolver;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.ExternalLibraryDescriptor;
import com.intellij.spring.boot.library.SpringBootLibraryUtil;
import com.intellij.util.ThreeState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class SpringBootStartersExternalLibraryResolver
extends ExternalLibraryResolver {
    SpringBootStartersExternalLibraryResolver() {
    }

    @Nullable
    public ExternalLibraryResolver.ExternalClassResolveResult resolveClass(@NotNull String shortClassName, @NotNull ThreeState isAnnotation, @NotNull Module contextModule) {
        if (shortClassName == null) {
            SpringBootStartersExternalLibraryResolver.$$$reportNull$$$0(0);
        }
        if (isAnnotation == null) {
            SpringBootStartersExternalLibraryResolver.$$$reportNull$$$0(1);
        }
        if (contextModule == null) {
            SpringBootStartersExternalLibraryResolver.$$$reportNull$$$0(2);
        }
        if (!SpringBootLibraryUtil.hasSpringBootLibrary(contextModule)) {
            return null;
        }
        if (isAnnotation == ThreeState.YES) {
            return SpringBootStartersExternalLibraryResolver.handleAnnotation(shortClassName, contextModule);
        }
        return SpringBootStartersExternalLibraryResolver.handleClass(shortClassName, contextModule);
    }

    @Nullable
    private static ExternalLibraryResolver.ExternalClassResolveResult handleClass(@NotNull String shortClassName, @NotNull Module contextModule) {
        if (shortClassName == null) {
            SpringBootStartersExternalLibraryResolver.$$$reportNull$$$0(3);
        }
        if (contextModule == null) {
            SpringBootStartersExternalLibraryResolver.$$$reportNull$$$0(4);
        }
        if ("JdbcTemplate".equals(shortClassName)) {
            return SpringBootStartersExternalLibraryResolver.createStarterResult(contextModule, "org.springframework.jdbc.core.JdbcTemplate", "jdbc");
        }
        if ("DataSource".equals(shortClassName)) {
            return SpringBootStartersExternalLibraryResolver.createStarterResult(contextModule, "javax.sql.DataSource", "jdbc");
        }
        return null;
    }

    @Nullable
    private static ExternalLibraryResolver.ExternalClassResolveResult handleAnnotation(@NotNull String shortClassName, @NotNull Module module) {
        if (shortClassName == null) {
            SpringBootStartersExternalLibraryResolver.$$$reportNull$$$0(5);
        }
        if (module == null) {
            SpringBootStartersExternalLibraryResolver.$$$reportNull$$$0(6);
        }
        if ("EnableBatchProcessing".equals(shortClassName)) {
            return SpringBootStartersExternalLibraryResolver.createStarterResult(module, "org.springframework.batch.core.configuration.annotation.EnableBatchProcessing", "batch");
        }
        if ("EnableCaching".equals(shortClassName) && SpringBootLibraryUtil.isAtLeastVersion(module, SpringBootLibraryUtil.SpringBootVersion.VERSION_1_3_0)) {
            return SpringBootStartersExternalLibraryResolver.createStarterResult(module, "org.springframework.cache.annotation.EnableCaching", "cache");
        }
        if ("EnableIntegration".equals(shortClassName)) {
            return SpringBootStartersExternalLibraryResolver.createStarterResult(module, "org.springframework.integration.config.EnableIntegration", "integration");
        }
        if ("MessageEndpoint".equals(shortClassName)) {
            return SpringBootStartersExternalLibraryResolver.createStarterResult(module, "org.springframework.integration.annotation.MessageEndpoint", "integration");
        }
        if ("Entity".equals(shortClassName)) {
            return SpringBootStartersExternalLibraryResolver.createStarterResult(module, "javax.persistence.Entity", "data-jpa");
        }
        if ("RequestMapping".equals(shortClassName)) {
            return SpringBootStartersExternalLibraryResolver.createStarterResult(module, "org.springframework.web.bind.annotation.RequestMapping", "web");
        }
        if ("RestController".equals(shortClassName)) {
            return SpringBootStartersExternalLibraryResolver.createStarterResult(module, "org.springframework.web.bind.annotation.RestController", "web");
        }
        if ("EnableRabbit".equals(shortClassName)) {
            return SpringBootStartersExternalLibraryResolver.createStarterResult(module, "org.springframework.amqp.rabbit.annotation.EnableRabbit", "amqp");
        }
        if ("EnableWebSecurity".equals(shortClassName)) {
            return SpringBootStartersExternalLibraryResolver.createStarterResult(module, "org.springframework.security.config.annotation.web.configuration.EnableWebSecurity", "security");
        }
        if ("EnableGlobalMethodSecurity".equals(shortClassName)) {
            return SpringBootStartersExternalLibraryResolver.createStarterResult(module, "org.springframework.security.config.annotation.method.configuration.EnableGlobalMethodSecurity", "security");
        }
        if ("Test".equals(shortClassName)) {
            return SpringBootStartersExternalLibraryResolver.createStarterResult(module, "org.junit.Test", "test");
        }
        if ("NotNull".equals(shortClassName)) {
            return SpringBootStartersExternalLibraryResolver.createStarterResult(module, "javax.validation.constraints.NotNull", "validation");
        }
        if ("EnableWebSocket".equals(shortClassName)) {
            return SpringBootStartersExternalLibraryResolver.createStarterResult(module, "org.springframework.web.socket.config.annotation.EnableWebSocket", "websocket");
        }
        if ("EnableWebSocketMessageBroker".equals(shortClassName)) {
            return SpringBootStartersExternalLibraryResolver.createStarterResult(module, "org.springframework.web.socket.config.annotation.EnableWebSocketMessageBroker", "websocket");
        }
        return null;
    }

    @NotNull
    private static ExternalLibraryResolver.ExternalClassResolveResult createStarterResult(@NotNull Module contextModule, String qualifiedClassName, String starterSuffix) {
        if (contextModule == null) {
            SpringBootStartersExternalLibraryResolver.$$$reportNull$$$0(7);
        }
        String springBootVersion = SpringBootLibraryUtil.getVersionFromJar(contextModule);
        ExternalLibraryDescriptor libraryDescriptor = new ExternalLibraryDescriptor("org.springframework.boot", "spring-boot-starter-" + starterSuffix, springBootVersion, springBootVersion);
        return new ExternalLibraryResolver.ExternalClassResolveResult(qualifiedClassName, libraryDescriptor);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shortClassName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "isAnnotation";
                break;
            }
            case 2: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextModule";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        objectArray2[1] = "com/intellij/spring/boot/library/SpringBootStartersExternalLibraryResolver";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "resolveClass";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "handleClass";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "handleAnnotation";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "createStarterResult";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

