/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.initializr.gradle;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.spring.boot.application.config.SpringBootReplacementTokenResolver;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.StringSearcher;
import icons.GradleIcons;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.plugins.gradle.model.ExternalProject;
import org.jetbrains.plugins.gradle.service.project.data.ExternalProjectDataCache;
import org.jetbrains.plugins.gradle.settings.GradleExtensionsSettings;

final class SpringBootGradleReplacementTokenResolver
extends SpringBootReplacementTokenResolver {
    private static GradleExtensionsSettings.GradleExtensionsData myTestData;
    private static PsiFile myBuildFile;

    SpringBootGradleReplacementTokenResolver() {
    }

    @Override
    @NotNull
    public List<PsiElement> resolve(PsiReference reference) {
        GradleExtensionsSettings.GradleExtensionsData extensionsData = SpringBootGradleReplacementTokenResolver.getExtensionsData(reference);
        if (extensionsData == null) {
            List<PsiElement> list = Collections.emptyList();
            if (list == null) {
                SpringBootGradleReplacementTokenResolver.$$$reportNull$$$0(0);
            }
            return list;
        }
        String canonicalText = reference.getCanonicalText();
        GradleExtensionsSettings.GradleProp property = extensionsData.findProperty(canonicalText);
        if (property == null) {
            List<PsiElement> list = Collections.emptyList();
            if (list == null) {
                SpringBootGradleReplacementTokenResolver.$$$reportNull$$$0(1);
            }
            return list;
        }
        PsiFile buildFile = SpringBootGradleReplacementTokenResolver.resolveBuildFile(reference);
        if (buildFile == null) {
            List<PsiElement> list = Collections.emptyList();
            if (list == null) {
                SpringBootGradleReplacementTokenResolver.$$$reportNull$$$0(2);
            }
            return list;
        }
        return SpringBootGradleReplacementTokenResolver.resolveCandidates(buildFile, canonicalText);
    }

    @Override
    @NotNull
    public List<LookupElement> getVariants(PsiReference reference) {
        GradleExtensionsSettings.GradleExtensionsData extensionsData = SpringBootGradleReplacementTokenResolver.getExtensionsData(reference);
        if (extensionsData == null) {
            List<LookupElement> list = Collections.emptyList();
            if (list == null) {
                SpringBootGradleReplacementTokenResolver.$$$reportNull$$$0(3);
            }
            return list;
        }
        PsiFile buildFile = SpringBootGradleReplacementTokenResolver.resolveBuildFile(reference);
        if (buildFile == null) {
            List<LookupElement> list = Collections.emptyList();
            if (list == null) {
                SpringBootGradleReplacementTokenResolver.$$$reportNull$$$0(4);
            }
            return list;
        }
        PsiElementFactory psiElementFactory = JavaPsiFacade.getElementFactory((Project)reference.getElement().getProject());
        List list = ContainerUtil.map2List(extensionsData.properties.values(), prop -> {
            List<PsiElement> candidates = SpringBootGradleReplacementTokenResolver.resolveCandidates(buildFile, prop.name);
            LookupElementBuilder builder = candidates.size() != 1 ? LookupElementBuilder.create((String)prop.name) : LookupElementBuilder.create((Object)candidates.get(0), (String)prop.name);
            PsiClassType type = psiElementFactory.createTypeByFQClassName(prop.getTypeFqn());
            return builder.withIcon(GradleIcons.Gradle).withTypeText(type.getPresentableText());
        });
        if (list == null) {
            SpringBootGradleReplacementTokenResolver.$$$reportNull$$$0(5);
        }
        return list;
    }

    @NotNull
    private static List<PsiElement> resolveCandidates(PsiFile buildFile, String name) {
        SmartList results = new SmartList();
        StringSearcher searcher = new StringSearcher(name, true, true);
        searcher.processOccurrences((CharSequence)buildFile.getText(), arg_0 -> SpringBootGradleReplacementTokenResolver.lambda$resolveCandidates$1(buildFile, (List)results, arg_0));
        SmartList smartList = results;
        if (smartList == null) {
            SpringBootGradleReplacementTokenResolver.$$$reportNull$$$0(6);
        }
        return smartList;
    }

    @Nullable
    private static PsiFile resolveBuildFile(PsiReference reference) {
        if (myBuildFile != null && SpringBootGradleReplacementTokenResolver.isTestMode()) {
            return myBuildFile;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)reference.getElement());
        String gradleProjectPath = ExternalSystemApiUtil.getExternalRootProjectPath((Module)module);
        if (module == null || gradleProjectPath == null) {
            return null;
        }
        ExternalProject externalProject = ExternalProjectDataCache.getInstance((Project)module.getProject()).getRootExternalProject(gradleProjectPath);
        if (externalProject == null) {
            return null;
        }
        File buildFile = externalProject.getBuildFile();
        if (buildFile == null) {
            return null;
        }
        VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByIoFile(buildFile);
        if (virtualFile == null) {
            return null;
        }
        return PsiManager.getInstance((Project)module.getProject()).findFile(virtualFile);
    }

    @Nullable
    private static GradleExtensionsSettings.GradleExtensionsData getExtensionsData(PsiReference reference) {
        if (myTestData != null && SpringBootGradleReplacementTokenResolver.isTestMode()) {
            return myTestData;
        }
        Project project = reference.getElement().getProject();
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)reference.getElement());
        return GradleExtensionsSettings.getInstance((Project)project).getExtensionsFor(module);
    }

    private static boolean isTestMode() {
        return ApplicationManager.getApplication().isUnitTestMode();
    }

    @TestOnly
    public static void setMyTestData(GradleExtensionsSettings.GradleExtensionsData myTestData) {
        SpringBootGradleReplacementTokenResolver.myTestData = myTestData;
    }

    @TestOnly
    public static void setBuildFile(PsiFile buildFile) {
        myBuildFile = buildFile;
    }

    private static /* synthetic */ boolean lambda$resolveCandidates$1(PsiFile buildFile, List results, int occurrence) {
        PsiElement at = buildFile.findElementAt(occurrence);
        ContainerUtil.addIfNotNull((Collection)results, (Object)at);
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/spring/boot/initializr/gradle/SpringBootGradleReplacementTokenResolver";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "resolve";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveCandidates";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

