/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.initializr;

import com.intellij.openapi.util.text.StringUtil;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Version
implements Comparable<Version> {
    private static final Pattern VERSION_PATTERN = Pattern.compile("^(\\d+)\\.(\\d+)\\.(\\d+)(?:([.|-])([^0-9]+)(\\d+)?)?$");
    private static final VersionQualifierComparator qualifierComparator = new VersionQualifierComparator();
    private final Integer major;
    private final Integer minor;
    private final Integer patch;
    private final Qualifier qualifier;

    private Version(Integer major, Integer minor, Integer patch, Qualifier qualifier) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
        this.qualifier = qualifier;
    }

    public Integer getMajor() {
        return this.major;
    }

    public Integer getMinor() {
        return this.minor;
    }

    public Integer getPatch() {
        return this.patch;
    }

    public Qualifier getQualifier() {
        return this.qualifier;
    }

    public static Version parse(String text) {
        Matcher matcher = VERSION_PATTERN.matcher(text.trim());
        if (!matcher.matches()) {
            throw new InvalidVersionException("Could not determine version based on '" + text + "': version format is Major.Minor.Patch and an optional Qualifier (i.e. 1.0.5.RELEASE");
        }
        Integer major = Integer.valueOf(matcher.group(1));
        Integer minor = Integer.valueOf(matcher.group(2));
        Integer patch = Integer.valueOf(matcher.group(3));
        Qualifier qualifier = Version.parseQualifier(matcher);
        return new Version(major, minor, patch, qualifier);
    }

    private static Qualifier parseQualifier(Matcher matcher) {
        String qualifierSeparator = matcher.group(4);
        String qualifierId = matcher.group(5);
        if (!StringUtil.isEmptyOrSpaces((String)qualifierSeparator) && !StringUtil.isEmptyOrSpaces((String)qualifierId)) {
            String versionString = matcher.group(6);
            return new Qualifier(qualifierId, versionString != null ? Integer.valueOf(versionString) : null, qualifierSeparator);
        }
        return null;
    }

    static Version safeParse(String text) {
        try {
            return Version.parse(text);
        }
        catch (InvalidVersionException e) {
            return null;
        }
    }

    @Override
    public int compareTo(Version other) {
        if (other == null) {
            return 1;
        }
        int majorDiff = Version.safeCompare(this.major, other.major);
        if (majorDiff != 0) {
            return majorDiff;
        }
        int minorDiff = Version.safeCompare(this.minor, other.minor);
        if (minorDiff != 0) {
            return minorDiff;
        }
        int patch = Version.safeCompare(this.patch, other.patch);
        if (patch != 0) {
            return patch;
        }
        return qualifierComparator.compare(this.qualifier, other.qualifier);
    }

    private static int safeCompare(Integer first, Integer second) {
        Integer firstIndex = first != null ? first : 0;
        Integer secondIndex = second != null ? second : 0;
        return firstIndex.compareTo(secondIndex);
    }

    public String displayText() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.major);
        sb.append(".");
        sb.append(this.minor);
        sb.append(".");
        sb.append(this.patch);
        if (this.qualifier != null) {
            sb.append(this.qualifier.getSeparator());
            sb.append(this.qualifier.getId());
            Integer version = this.qualifier.getVersion();
            if (version != null) {
                sb.append(version);
            }
        }
        return sb.toString();
    }

    public String toString() {
        return "Version{major=" + this.major + ", minor=" + this.minor + ", patch=" + this.patch + ", qualifier=" + this.qualifier + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Version version = (Version)o;
        return Objects.equals(this.major, version.major) && Objects.equals(this.minor, version.minor) && Objects.equals(this.patch, version.patch) && Objects.equals(this.qualifier, version.qualifier);
    }

    public int hashCode() {
        int result2 = this.major != null ? this.major.hashCode() : 0;
        result2 = 31 * result2 + (this.minor != null ? this.minor.hashCode() : 0);
        result2 = 31 * result2 + (this.patch != null ? this.patch.hashCode() : 0);
        result2 = 31 * result2 + (this.qualifier != null ? this.qualifier.hashCode() : 0);
        return result2;
    }

    private static class VersionQualifierComparator
    implements Comparator<Qualifier> {
        private static final String RELEASE = "RELEASE";
        private static final String BUILD_SNAPSHOT = "BUILD-SNAPSHOT";
        private static final String SNAPSHOT = "SNAPSHOT";
        private static final String MILESTONE = "M";
        private static final String RC = "RC";
        private static final List<String> KNOWN_QUALIFIERS = Arrays.asList("M", "RC", "BUILD-SNAPSHOT", "SNAPSHOT", "RELEASE");

        private VersionQualifierComparator() {
        }

        @Override
        public int compare(Qualifier o1, Qualifier o2) {
            Qualifier first = o1 != null ? o1 : new Qualifier(RELEASE);
            Qualifier second = o2 != null ? o2 : new Qualifier(RELEASE);
            int qualifier = VersionQualifierComparator.compareQualifier(first, second);
            return qualifier != 0 ? qualifier : VersionQualifierComparator.compareQualifierVersion(first, second);
        }

        private static int compareQualifierVersion(Qualifier first, Qualifier second) {
            Integer firstVersion = first.getVersion() != null ? first.getVersion() : 0;
            Integer secondVersion = second.getVersion() != null ? second.getVersion() : 0;
            return firstVersion.compareTo(secondVersion);
        }

        private static int compareQualifier(Qualifier first, Qualifier second) {
            int firstIndex = VersionQualifierComparator.getQualifierIndex(first.id);
            int secondIndex = VersionQualifierComparator.getQualifierIndex(second.id);
            if (firstIndex == -1 && secondIndex == -1) {
                return first.id.compareTo(second.id);
            }
            return Integer.compare(firstIndex, secondIndex);
        }

        private static int getQualifierIndex(String qualifier) {
            String q = qualifier != null ? qualifier : RELEASE;
            return KNOWN_QUALIFIERS.indexOf(q);
        }
    }

    static class Qualifier {
        private final String id;
        private final Integer version;
        private final String separator;

        Qualifier(String id) {
            this(id, null, ".");
        }

        Qualifier(String id, Integer version, String separator) {
            this.id = id;
            this.version = version;
            this.separator = separator;
        }

        String getId() {
            return this.id;
        }

        Integer getVersion() {
            return this.version;
        }

        String getSeparator() {
            return this.separator;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Qualifier qualifier = (Qualifier)o;
            return this.id.equals(qualifier.id) && Objects.equals(this.version, qualifier.version) && Objects.equals(this.separator, qualifier.separator);
        }

        public int hashCode() {
            int result2 = this.id.hashCode();
            result2 = 31 * result2 + (this.version != null ? this.version.hashCode() : 0);
            result2 = 31 * result2 + this.separator.hashCode();
            return result2;
        }

        public String toString() {
            return "Qualifier{id=" + this.id + ", version=" + this.version + ", separator=" + this.separator + "}";
        }
    }

    public static class InvalidVersionException
    extends RuntimeException {
        public InvalidVersionException(String message) {
            super(message);
        }
    }
}

