/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.initializr;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.intellij.ide.starters.JavaStartersBundle;
import com.intellij.ide.starters.remote.DependencyAvailable;
import com.intellij.ide.starters.remote.DependencyState;
import com.intellij.ide.starters.remote.DependencyUnavailable;
import com.intellij.ide.starters.remote.WebStarterContext;
import com.intellij.ide.starters.remote.WebStarterContextProvider;
import com.intellij.ide.starters.remote.WebStarterDependency;
import com.intellij.ide.starters.remote.WebStarterDependencyCategory;
import com.intellij.ide.starters.remote.WebStarterFrameworkVersion;
import com.intellij.ide.starters.remote.WebStarterModuleBuilder;
import com.intellij.ide.starters.remote.WebStarterServerOptions;
import com.intellij.ide.starters.remote.WebStarterSettings;
import com.intellij.ide.starters.remote.wizard.WebStarterLibrariesStep;
import com.intellij.ide.starters.shared.CustomizedMessages;
import com.intellij.ide.starters.shared.LibraryLink;
import com.intellij.ide.starters.shared.LibraryLinkType;
import com.intellij.ide.starters.shared.StarterAppPackaging;
import com.intellij.ide.starters.shared.StarterLanguage;
import com.intellij.ide.starters.shared.StarterLanguageLevel;
import com.intellij.ide.starters.shared.StarterProjectType;
import com.intellij.openapi.observable.properties.GraphProperty;
import com.intellij.openapi.observable.properties.GraphPropertyImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.spring.boot.SpringBootApiBundle;
import com.intellij.spring.boot.initializr.SpringInitializrModuleBuilder;
import com.intellij.spring.boot.initializr.SpringSharedIndexesProvider;
import com.intellij.spring.boot.initializr.Version;
import com.intellij.spring.boot.initializr.VersionRange;
import com.intellij.spring.boot.options.SpringBootSettings;
import com.intellij.ui.layout.Cell;
import com.intellij.ui.layout.LayoutBuilder;
import com.intellij.ui.layout.Row;
import com.intellij.ui.layout.RowBuilder;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.io.ZipUtil;
import icons.SpringBootApiIcons;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u00a4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\b\u0000\u0018\u0000 E2\u00020\u0001:\u0004EFGHB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0004H\u0014J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0015J\b\u0010\u0015\u001a\u00020\nH\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0014J\b\u0010\u0018\u001a\u00020\u0019H\u0014J\b\u0010\u001a\u001a\u00020\nH\u0016J\b\u0010\u001b\u001a\u00020\nH\u0014J\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0014J\b\u0010\"\u001a\u00020\nH\u0016J\u000e\u0010#\u001a\b\u0012\u0004\u0012\u00020\n0$H\u0014J\b\u0010%\u001a\u00020\nH\u0016J\u000e\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00190$H\u0014J\u000e\u0010'\u001a\b\u0012\u0004\u0012\u00020(0$H\u0014J\b\u0010)\u001a\u00020*H\u0016J\u0010\u0010+\u001a\u00020\n2\u0006\u0010,\u001a\u00020\nH\u0002J\u000e\u0010-\u001a\b\u0012\u0004\u0012\u00020.0$H\u0014J\b\u0010/\u001a\u00020\nH\u0016J\u000e\u00100\u001a\b\u0012\u0004\u0012\u0002010$H\u0014J\b\u00102\u001a\u000203H\u0014J\u0010\u00104\u001a\u0002032\u0006\u00105\u001a\u000206H\u0014J\u0010\u00107\u001a\u0002082\u0006\u0010\t\u001a\u00020\nH\u0015J\u0016\u00109\u001a\b\u0012\u0004\u0012\u00020:0$2\u0006\u0010;\u001a\u00020<H\u0002J\u0016\u0010=\u001a\b\u0012\u0004\u0012\u00020\u001f0$2\u0006\u0010;\u001a\u00020<H\u0002J\u0016\u0010>\u001a\b\u0012\u0004\u0012\u00020\u00190$2\u0006\u0010;\u001a\u00020<H\u0002J\u0016\u0010?\u001a\b\u0012\u0004\u0012\u00020(0$2\u0006\u0010;\u001a\u00020<H\u0002J\u0010\u0010@\u001a\u0002082\u0006\u0010;\u001a\u00020<H\u0002J\u0016\u0010A\u001a\b\u0012\u0004\u0012\u00020.0$2\u0006\u0010;\u001a\u00020<H\u0002J\u0016\u0010B\u001a\b\u0012\u0004\u0012\u0002010$2\u0006\u0010;\u001a\u00020<H\u0002J\u0016\u0010C\u001a\u0004\u0018\u00010\n*\u00020<2\u0006\u0010D\u001a\u00020\nH\u0002R\u0014\u0010\u0003\u001a\u00020\u00048@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006I"}, d2={"Lcom/intellij/spring/boot/initializr/SpringInitializrModuleBuilder;", "Lcom/intellij/ide/starters/remote/WebStarterModuleBuilder;", "()V", "internalContext", "Lcom/intellij/ide/starters/remote/WebStarterContext;", "getInternalContext$intellij_spring_boot_initializr", "()Lcom/intellij/ide/starters/remote/WebStarterContext;", "composeGeneratorUrl", "Lcom/intellij/util/Url;", "serverUrl", "", "starterContext", "createLibrariesStep", "Lcom/intellij/ide/starters/remote/wizard/WebStarterLibrariesStep;", "contextProvider", "Lcom/intellij/ide/starters/remote/WebStarterContextProvider;", "extractGeneratorResult", "", "tempZipFile", "Ljava/io/File;", "contentEntryDir", "getBuilderId", "getCustomizedMessages", "Lcom/intellij/ide/starters/shared/CustomizedMessages;", "getDefaultLanguageLevel", "Lcom/intellij/ide/starters/shared/StarterLanguageLevel;", "getDefaultServerUrl", "getDefaultVersion", "getDependencyState", "Lcom/intellij/ide/starters/remote/DependencyState;", "frameworkVersion", "Lcom/intellij/ide/starters/remote/WebStarterFrameworkVersion;", "dependency", "Lcom/intellij/ide/starters/remote/WebStarterDependency;", "getDescription", "getFilePathsToOpen", "", "getHelpId", "getLanguageLevels", "getLanguages", "Lcom/intellij/ide/starters/shared/StarterLanguage;", "getNodeIcon", "Ljavax/swing/Icon;", "getOptionTitle", "option", "getPackagingTypes", "Lcom/intellij/ide/starters/shared/StarterAppPackaging;", "getPresentableName", "getProjectTypes", "Lcom/intellij/ide/starters/shared/StarterProjectType;", "isPackageNameEditable", "", "isReformatAfterCreation", "project", "Lcom/intellij/openapi/project/Project;", "loadServerOptions", "Lcom/intellij/ide/starters/remote/WebStarterServerOptions;", "parseDependencies", "Lcom/intellij/ide/starters/remote/WebStarterDependencyCategory;", "json", "Lcom/google/gson/JsonObject;", "parseFrameworkVersions", "parseLanguageLevels", "parseLanguages", "parseOptionsJson", "parsePackagingTypes", "parseProjectTypes", "getDefaultPropertyValue", "propertyName", "Companion", "SpringBootDependency", "SpringBootVersion", "SpringInitializrLibrariesStep", "intellij.spring.boot.initializr"})
public final class SpringInitializrModuleBuilder
extends WebStarterModuleBuilder {
    @JvmField
    @NotNull
    public static final Key<Boolean> SHARED_INDEXES_KEY;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public String getDefaultServerUrl() {
        return "https://start.spring.io";
    }

    @NotNull
    public String getDescription() {
        String string = SpringBootApiBundle.message("description.for.spring.initializr.project.starter", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"SpringBootApiBundle.mess\u2026tializr.project.starter\")");
        return string;
    }

    @NotNull
    public String getBuilderId() {
        return "SpringInitializr";
    }

    @NotNull
    public Icon getNodeIcon() {
        Icon icon = SpringBootApiIcons.SpringBoot;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"SpringBootApiIcons.SpringBoot");
        return icon;
    }

    @NotNull
    public String getPresentableName() {
        return "Spring Initializr";
    }

    @NotNull
    public String getHelpId() {
        return "reference.spring.boot";
    }

    @NotNull
    protected String getDefaultVersion() {
        return "0.0.1-SNAPSHOT";
    }

    protected boolean isPackageNameEditable() {
        return true;
    }

    @NotNull
    public final WebStarterContext getInternalContext$intellij_spring_boot_initializr() {
        return this.getStarterContext();
    }

    @NotNull
    protected List<StarterLanguageLevel> getLanguageLevels() {
        return CollectionsKt.listOf((Object[])new StarterLanguageLevel[]{new StarterLanguageLevel("15", "15", "15"), new StarterLanguageLevel("11", "11", "11"), new StarterLanguageLevel("1.8", "8", "1.8")});
    }

    @NotNull
    protected StarterLanguageLevel getDefaultLanguageLevel() {
        return new StarterLanguageLevel("11", "11", "11");
    }

    protected boolean isReformatAfterCreation(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        SpringBootSettings springBootSettings = SpringBootSettings.getInstance(project);
        Intrinsics.checkNotNullExpressionValue((Object)springBootSettings, (String)"SpringBootSettings.getInstance(project)");
        return springBootSettings.isReformatAfterCreation();
    }

    @NotNull
    protected List<StarterProjectType> getProjectTypes() {
        return CollectionsKt.listOf((Object[])new StarterProjectType[]{new StarterProjectType("maven-project", "Maven", null, 4, null), new StarterProjectType("gradle-project", "Gradle", null, 4, null)});
    }

    @NotNull
    protected List<StarterLanguage> getLanguages() {
        return CollectionsKt.listOf((Object[])new StarterLanguage[]{new StarterLanguage("java", "Java", "JAVA", false, null, 24, null), new StarterLanguage("kotlin", "Kotlin", "kotlin", false, null, 24, null), new StarterLanguage("groovy", "Groovy", "Groovy", false, null, 24, null)});
    }

    @NotNull
    protected List<StarterAppPackaging> getPackagingTypes() {
        return CollectionsKt.listOf((Object[])new StarterAppPackaging[]{new StarterAppPackaging("jar", "Jar", null, 4, null), new StarterAppPackaging("war", "War", null, 4, null)});
    }

    @NotNull
    protected CustomizedMessages getCustomizedMessages() {
        CustomizedMessages customizedMessages = new CustomizedMessages();
        boolean bl = false;
        boolean bl2 = false;
        CustomizedMessages $this$apply = customizedMessages;
        boolean bl3 = false;
        $this$apply.setFrameworkVersionLabel(SpringBootApiBundle.message("label.spring.boot.version", new Object[0]));
        $this$apply.setServerUrlDialogTitle(SpringBootApiBundle.message("label.spring.initializr.url", new Object[0]));
        return customizedMessages;
    }

    @NotNull
    protected List<String> getFilePathsToOpen() {
        return CollectionsKt.listOf((Object)"HELP.md");
    }

    @RequiresBackgroundThread
    @NotNull
    protected WebStarterServerOptions loadServerOptions(@NotNull String serverUrl) {
        JsonObject json;
        Intrinsics.checkNotNullParameter((Object)serverUrl, (String)"serverUrl");
        String mimeType = "application/vnd.initializr.v2.2+json,application/vnd.initializr.v2.1+json;q=0.9";
        JsonObject jsonObject = json = this.loadJsonData(serverUrl, mimeType).getAsJsonObject();
        Intrinsics.checkNotNullExpressionValue((Object)jsonObject, (String)"json");
        return this.parseOptionsJson(jsonObject);
    }

    /*
     * WARNING - void declaration
     */
    private final WebStarterServerOptions parseOptionsJson(JsonObject json) {
        StarterLanguageLevel starterLanguageLevel;
        List<WebStarterDependencyCategory> dependencies = this.parseDependencies(json);
        List<WebStarterFrameworkVersion> frameworkVersions = this.parseFrameworkVersions(json);
        WebStarterServerOptions options = new WebStarterServerOptions(frameworkVersions, dependencies);
        options.putUserData(WebStarterSettings.getSERVER_PROJECT_TYPES(), this.parseProjectTypes(json));
        options.putUserData(WebStarterSettings.getSERVER_LANGUAGES(), this.parseLanguages(json));
        options.putUserData(WebStarterSettings.getSERVER_PACKAGING_TYPES(), this.parsePackagingTypes(json));
        options.putUserData(WebStarterSettings.getSERVER_NAME_KEY(), (Object)this.getDefaultPropertyValue(json, "name"));
        options.putUserData(WebStarterSettings.getSERVER_GROUP_KEY(), (Object)this.getDefaultPropertyValue(json, "groupId"));
        options.putUserData(WebStarterSettings.getSERVER_ARTIFACT_KEY(), (Object)this.getDefaultPropertyValue(json, "artifactId"));
        options.putUserData(WebStarterSettings.getSERVER_VERSION_KEY(), (Object)this.getDefaultPropertyValue(json, "version"));
        options.putUserData(WebStarterSettings.getSERVER_PACKAGE_NAME_KEY(), (Object)this.getDefaultPropertyValue(json, "packageName"));
        options.putUserData(WebStarterSettings.getSERVER_LANGUAGE_LEVELS_KEY(), this.parseLanguageLevels(json));
        WebStarterServerOptions webStarterServerOptions = options;
        Key key = WebStarterSettings.getSERVER_LANGUAGE_LEVEL_KEY();
        String string = this.getDefaultPropertyValue(json, "javaVersion");
        if (string != null) {
            void it;
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String string3 = string2;
            Key key2 = key;
            WebStarterServerOptions webStarterServerOptions2 = webStarterServerOptions;
            boolean bl3 = false;
            StarterLanguageLevel starterLanguageLevel2 = new StarterLanguageLevel((String)it, (String)it, (String)it);
            webStarterServerOptions = webStarterServerOptions2;
            key = key2;
            starterLanguageLevel = starterLanguageLevel2;
        } else {
            starterLanguageLevel = null;
        }
        webStarterServerOptions.putUserData(key, starterLanguageLevel);
        return options;
    }

    /*
     * WARNING - void declaration
     */
    private final List<StarterAppPackaging> parsePackagingTypes(JsonObject json) {
        void $this$mapTo$iv$iv;
        JsonObject jsonObject = json.getAsJsonObject("packaging");
        if (jsonObject == null) {
            return CollectionsKt.emptyList();
        }
        JsonObject packagingNode = jsonObject;
        JsonArray jsonArray = packagingNode.getAsJsonArray("values");
        if (jsonArray == null) {
            return CollectionsKt.emptyList();
        }
        JsonArray values = jsonArray;
        Iterable $this$map$iv = (Iterable)values;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string;
            void it;
            Object packagingName;
            void valueNode;
            JsonElement jsonElement = (JsonElement)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            void v2 = valueNode;
            Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"valueNode");
            JsonElement jsonElement2 = v2.getAsJsonObject().get("id");
            Intrinsics.checkNotNullExpressionValue((Object)jsonElement2, (String)"valueNode.asJsonObject.get(\"id\")");
            String packagingId = jsonElement2.getAsString();
            Object object = valueNode.getAsJsonObject().get("name");
            if (object == null || (object = object.getAsString()) == null) {
                object = packagingId;
            }
            Object object2 = packagingName = object;
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"packagingName");
            String optionTitle = this.getOptionTitle((String)object2);
            Intrinsics.checkNotNullExpressionValue((Object)packagingId, (String)"packagingId");
            Object object3 = packagingName;
            boolean bl2 = false;
            boolean bl3 = false;
            Object object4 = object3;
            String string2 = optionTitle;
            boolean bl4 = false;
            boolean bl5 = Intrinsics.areEqual((Object)it, (Object)optionTitle) ^ true;
            Object object5 = bl5 ? object3 : null;
            String string3 = string2;
            String string4 = string;
            StarterAppPackaging starterAppPackaging = new StarterAppPackaging(string4, string3, (String)object5);
            collection.add(starterAppPackaging);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<StarterLanguage> parseLanguages(JsonObject json) {
        void $this$mapTo$iv$iv;
        JsonObject jsonObject = json.getAsJsonObject("language");
        if (jsonObject == null) {
            return CollectionsKt.emptyList();
        }
        JsonObject packagingNode = jsonObject;
        JsonArray jsonArray = packagingNode.getAsJsonArray("values");
        if (jsonArray == null) {
            return CollectionsKt.emptyList();
        }
        JsonArray values = jsonArray;
        Iterable $this$map$iv = (Iterable)values;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string;
            void it;
            Object languageName;
            void valueNode;
            JsonElement jsonElement = (JsonElement)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            void v2 = valueNode;
            Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"valueNode");
            JsonElement jsonElement2 = v2.getAsJsonObject().get("id");
            Intrinsics.checkNotNullExpressionValue((Object)jsonElement2, (String)"valueNode.asJsonObject.get(\"id\")");
            String languageId = jsonElement2.getAsString();
            Object object = valueNode.getAsJsonObject().get("name");
            if (object == null || (object = object.getAsString()) == null) {
                object = languageId;
            }
            Object object2 = languageName = object;
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"languageName");
            String optionTitle = this.getOptionTitle((String)object2);
            Intrinsics.checkNotNullExpressionValue((Object)languageId, (String)"languageId");
            Object object3 = languageName;
            boolean bl2 = false;
            boolean bl3 = false;
            Object object4 = object3;
            boolean bl4 = false;
            String string2 = languageId;
            String string3 = optionTitle;
            boolean bl5 = false;
            boolean bl6 = Intrinsics.areEqual((Object)it, (Object)optionTitle) ^ true;
            DefaultConstructorMarker defaultConstructorMarker = null;
            int n = 8;
            Object object5 = bl6 ? object3 : null;
            boolean bl7 = bl4;
            String string4 = string2;
            String string5 = string3;
            String string6 = string;
            StarterLanguage starterLanguage = new StarterLanguage(string6, string5, string4, bl7, (String)object5, n, defaultConstructorMarker);
            collection.add(starterLanguage);
        }
        return (List)destination$iv$iv;
    }

    private final String getOptionTitle(String option) {
        String string = StringsKt.substringBefore$default((String)option, (String)"(", null, (int)2, null);
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        return ((Object)StringsKt.trim((CharSequence)string2)).toString();
    }

    /*
     * WARNING - void declaration
     */
    private final List<StarterProjectType> parseProjectTypes(JsonObject json) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        void $this$mapTo$iv$iv;
        JsonObject jsonObject = json.getAsJsonObject("type");
        if (jsonObject == null) {
            return CollectionsKt.emptyList();
        }
        JsonObject javaVersionNode = jsonObject;
        JsonArray jsonArray = javaVersionNode.getAsJsonArray("values");
        if (jsonArray == null) {
            return CollectionsKt.emptyList();
        }
        JsonArray values = jsonArray;
        Iterable $this$map$iv = (Iterable)values;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string;
            void it;
            Object typeName;
            void versionNode;
            JsonElement jsonElement = (JsonElement)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            void v2 = versionNode;
            Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"versionNode");
            JsonObject versionItem = v2.getAsJsonObject();
            JsonElement jsonElement2 = versionItem.get("id");
            Intrinsics.checkNotNullExpressionValue((Object)jsonElement2, (String)"versionItem.get(\"id\")");
            String typeId = jsonElement2.getAsString();
            Object object = versionItem.get("name");
            if (object == null || (object = object.getAsString()) == null) {
                object = typeId;
            }
            Object object2 = typeName = object;
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"typeName");
            String optionTitle = this.getOptionTitle(StringsKt.removeSuffix((String)object2, (CharSequence)" Project"));
            Intrinsics.checkNotNullExpressionValue((Object)typeId, (String)"typeId");
            Object object3 = typeName;
            boolean bl2 = false;
            boolean bl3 = false;
            Object object4 = object3;
            String string2 = optionTitle;
            boolean bl4 = false;
            boolean bl5 = Intrinsics.areEqual((Object)it, (Object)optionTitle) ^ true;
            Object object5 = bl5 ? object3 : null;
            String string3 = string2;
            String string4 = string;
            StarterProjectType starterProjectType = new StarterProjectType(string4, string3, (String)object5);
            collection.add(starterProjectType);
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            StarterProjectType it = (StarterProjectType)element$iv$iv;
            boolean bl = false;
            if (!(Intrinsics.areEqual((Object)it.getId(), (Object)"maven-build") ^ true && Intrinsics.areEqual((Object)it.getId(), (Object)"gradle-build") ^ true)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<StarterLanguageLevel> parseLanguageLevels(JsonObject json) {
        void $this$mapTo$iv$iv;
        JsonObject jsonObject = json.getAsJsonObject("javaVersion");
        if (jsonObject == null) {
            return CollectionsKt.emptyList();
        }
        JsonObject javaVersionNode = jsonObject;
        JsonArray jsonArray = javaVersionNode.getAsJsonArray("values");
        if (jsonArray == null) {
            return CollectionsKt.emptyList();
        }
        JsonArray values = jsonArray;
        Iterable $this$map$iv = (Iterable)values;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            JsonElement jsonElement = (JsonElement)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            void v2 = it;
            Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"it");
            JsonObject versionItem = v2.getAsJsonObject();
            JsonElement jsonElement2 = versionItem.get("id");
            Intrinsics.checkNotNullExpressionValue((Object)jsonElement2, (String)"versionItem.get(\"id\")");
            String versionId = jsonElement2.getAsString();
            Object object = versionItem.get("name");
            if (object == null || (object = object.getAsString()) == null) {
                object = versionId;
            }
            Object versionName = object;
            String string = versionId;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"versionId");
            Object object2 = versionName;
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"versionName");
            StarterLanguageLevel starterLanguageLevel = new StarterLanguageLevel(string, (String)object2, versionId);
            collection.add(starterLanguageLevel);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<WebStarterFrameworkVersion> parseFrameworkVersions(JsonObject json) {
        void $this$mapTo$iv$iv;
        JsonObject jsonObject = json.getAsJsonObject("bootVersion");
        if (jsonObject == null) {
            return CollectionsKt.emptyList();
        }
        JsonObject bootVersionNode = jsonObject;
        JsonArray jsonArray = bootVersionNode.getAsJsonArray("values");
        if (jsonArray == null) {
            return CollectionsKt.emptyList();
        }
        JsonArray values = jsonArray;
        JsonElement jsonElement = this.getNullable(bootVersionNode, "default");
        String defaultVersion = jsonElement != null ? jsonElement.getAsString() : null;
        Iterable $this$map$iv = (Iterable)values;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            JsonElement jsonElement2 = (JsonElement)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            void v3 = it;
            Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"it");
            JsonObject versionItem = v3.getAsJsonObject();
            JsonElement jsonElement3 = versionItem.get("id");
            Intrinsics.checkNotNullExpressionValue((Object)jsonElement3, (String)"versionItem.get(\"id\")");
            String versionText = jsonElement3.getAsString();
            Object object = versionItem.get("name");
            if (object == null || (object = object.getAsString()) == null) {
                object = versionText;
            }
            Object versionName = object;
            Version version = Version.parse(versionText);
            String string = versionText;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"versionText");
            Object object2 = versionName;
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"versionName");
            Version version2 = version;
            Intrinsics.checkNotNullExpressionValue((Object)version2, (String)"version");
            SpringBootVersion springBootVersion = new SpringBootVersion(string, (String)object2, version2, Intrinsics.areEqual((Object)defaultVersion, (Object)versionText));
            collection.add(springBootVersion);
        }
        return (List)destination$iv$iv;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final List<WebStarterDependencyCategory> parseDependencies(JsonObject json) {
        v0 = this.getNullable(json, "dependencies");
        if (v0 == null || (v0 = v0.getAsJsonObject()) == null || (v0 = this.getNullable((JsonObject)v0, "values")) == null || (v0 = v0.getAsJsonArray()) == null) {
            return CollectionsKt.emptyList();
        }
        dependencyGroupItems = v0;
        $this$map$iv = (Iterable)dependencyGroupItems;
        $i$f$map = false;
        var5_5 = $this$map$iv;
        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (T item$iv$iv : $this$mapTo$iv$iv) {
            block23: {
                block21: {
                    var10_10 = (JsonElement)item$iv$iv;
                    var42_46 = destination$iv$iv;
                    $i$a$-map-SpringInitializrModuleBuilder$parseDependencies$1 = false;
                    v1 = groupElement;
                    Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"groupElement");
                    v2 = groupItem = v1.getAsJsonObject();
                    Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"groupItem");
                    v3 /* !! */  = this.getNullable(v2, "name");
                    if (v3 /* !! */  == null || (v3 /* !! */  = v3 /* !! */ .getAsString()) == null) {
                        v3 /* !! */  = "";
                    }
                    groupName /* !! */  = v3 /* !! */ ;
                    v4 = this.getNullable(groupItem, "values");
                    v5 = dependencyItems = v4 != null ? v4.getAsJsonArray() : null;
                    if (v5 == null) break block21;
                    $this$map$iv = (Iterable)v5;
                    $i$f$map = false;
                    var17_17 = $this$map$iv;
                    destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        block22: {
                            var22_22 = (JsonElement)item$iv$iv;
                            var23_23 = destination$iv$iv;
                            $i$a$-map-SpringInitializrModuleBuilder$parseDependencies$1$dependencies$1 = false;
                            v6 = dependencyElement;
                            Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"dependencyElement");
                            item = v6.getAsJsonObject();
                            v7 /* !! */  = item.get("id");
                            if (v7 /* !! */  == null || (v7 /* !! */  = v7 /* !! */ .getAsString()) == null) {
                                v7 /* !! */  = id /* !! */  = "";
                            }
                            if ((v8 /* !! */  = item.get("name")) == null || (v8 /* !! */  = v8 /* !! */ .getAsString()) == null) {
                                v8 /* !! */  = "";
                            }
                            name /* !! */  = v8 /* !! */ ;
                            v9 = item;
                            Intrinsics.checkNotNullExpressionValue((Object)v9, (String)"item");
                            v10 = this.getNullable(v9, "description");
                            description = v10 != null ? v10.getAsString() : null;
                            var29_30 = false;
                            links = new ArrayList<E>();
                            v11 = this.getNullable(item, "_links");
                            v12 /* !! */  = linksNode = v11 != null ? v11.getAsJsonObject() : null;
                            if (linksNode == null) break block22;
                            for (Map.Entry linkEntry : linksNode.entrySet()) {
                                if ((String)linkEntry.getKey() == null) ** GOTO lbl-1000
                                tmp = -1;
                                switch (var33_34.hashCode()) {
                                    case -925155509: {
                                        if (!var33_34.equals("reference")) break;
                                        tmp = 1;
                                        break;
                                    }
                                    case 98712316: {
                                        if (!var33_34.equals("guide")) break;
                                        tmp = 2;
                                        break;
                                    }
                                }
                                switch (tmp) {
                                    case 1: {
                                        v13 = LibraryLinkType.REFERENCE;
                                        break;
                                    }
                                    case 2: {
                                        v13 = LibraryLinkType.GUIDE;
                                        break;
                                    }
                                    default: lbl-1000:
                                    // 2 sources

                                    {
                                        v13 = LibraryLinkType.WEBSITE;
                                    }
                                }
                                linkType = v13;
                                v14 = linkEntry.getValue();
                                Intrinsics.checkNotNullExpressionValue(v14, (String)"linkEntry.value");
                                if (((JsonElement)v14).isJsonObject()) {
                                    v15 = linkEntry.getValue();
                                    Intrinsics.checkNotNullExpressionValue(v15, (String)"linkEntry.value");
                                    v16 = ((JsonElement)v15).getAsJsonObject();
                                    Intrinsics.checkNotNullExpressionValue((Object)v16, (String)"linkEntry.value.asJsonObject");
                                    v17 /* !! */  = this.getNullable(v16, "href");
                                    if (v17 /* !! */  == null || (v17 /* !! */  = v17 /* !! */ .getAsString()) == null) {
                                        v17 /* !! */  = "";
                                    }
                                    url /* !! */  = v17 /* !! */ ;
                                    links.add(new LibraryLink(linkType, (String)url /* !! */ , null, 4, null));
                                    continue;
                                }
                                v18 = linkEntry.getValue();
                                Intrinsics.checkNotNullExpressionValue(v18, (String)"linkEntry.value");
                                if (!((JsonElement)v18).isJsonArray()) continue;
                                v19 = linkEntry.getValue();
                                Intrinsics.checkNotNullExpressionValue(v19, (String)"linkEntry.value");
                                linksArray = ((JsonElement)v19).getAsJsonArray();
                                var35_37 = linksArray.iterator();
                                while (var35_37.hasNext()) {
                                    v20 = linkElement = (JsonElement)var35_37.next();
                                    Intrinsics.checkNotNullExpressionValue((Object)v20, (String)"linkElement");
                                    v21 = linkObject = v20.getAsJsonObject();
                                    Intrinsics.checkNotNullExpressionValue((Object)v21, (String)"linkObject");
                                    v22 = this.getNullable(v21, "title");
                                    title = v22 != null ? v22.getAsString() : null;
                                    v23 /* !! */  = this.getNullable(linkObject, "href");
                                    if (v23 /* !! */  == null || (v23 /* !! */  = v23 /* !! */ .getAsString()) == null) {
                                        v23 /* !! */  = "";
                                    }
                                    url /* !! */  = v23 /* !! */ ;
                                    links.add(new LibraryLink(linkType, (String)url /* !! */ , title));
                                }
                            }
                        }
                        v24 = item.get("versionRange");
                        v25 = versionRangeValue = v24 != null ? v24.getAsString() : null;
                        if (versionRangeValue != null) {
                            var33_35 = false;
                            var36_39 = false;
                            it = var34_36;
                            $i$a$-let-SpringInitializrModuleBuilder$parseDependencies$1$dependencies$1$versionRange$1 = false;
                            v26 = VersionRange.parse(it);
                        } else {
                            v26 = null;
                        }
                        versionRange = v26;
                        var40_44 = new SpringBootDependency((String)id /* !! */ , (String)name /* !! */ , description, links, versionRange);
                        var23_23.add(var40_44);
                    }
                    v27 = (List)destination$iv$iv;
                    break block23;
                }
                v27 = CollectionsKt.emptyList();
            }
            dependencies = v27;
            var43_47 = new WebStarterDependencyCategory((String)groupName /* !! */ , dependencies);
            var42_46.add(var43_47);
        }
        return (List)destination$iv$iv;
    }

    private final String getDefaultPropertyValue(JsonObject $this$getDefaultPropertyValue, String propertyName) {
        JsonElement defaultProperty;
        JsonElement jsonElement = $this$getDefaultPropertyValue.get(propertyName);
        if (jsonElement == null) {
            return null;
        }
        JsonElement property = jsonElement;
        JsonObject jsonObject = property.getAsJsonObject();
        Intrinsics.checkNotNullExpressionValue((Object)jsonObject, (String)"property.asJsonObject");
        JsonElement jsonElement2 = defaultProperty = this.getNullable(jsonObject, "default");
        return jsonElement2 != null ? jsonElement2.getAsString() : null;
    }

    @NotNull
    protected DependencyState getDependencyState(@NotNull WebStarterFrameworkVersion frameworkVersion, @NotNull WebStarterDependency dependency) {
        Intrinsics.checkNotNullParameter((Object)frameworkVersion, (String)"frameworkVersion");
        Intrinsics.checkNotNullParameter((Object)dependency, (String)"dependency");
        SpringBootDependency springDependency = (SpringBootDependency)dependency;
        VersionRange versionRange = springDependency.getVersionRange();
        if (versionRange == null) {
            return (DependencyState)DependencyAvailable.INSTANCE;
        }
        SpringBootVersion springBootVersion = (SpringBootVersion)frameworkVersion;
        if (!versionRange.match(springBootVersion.getVersion())) {
            return (DependencyState)new DependencyUnavailable(SpringBootApiBundle.message("message.requires.specific.spring.boot.version", versionRange.displayText()), versionRange.displayText());
        }
        return (DependencyState)DependencyAvailable.INSTANCE;
    }

    @NotNull
    protected Url composeGeneratorUrl(@NotNull String serverUrl, @NotNull WebStarterContext starterContext) {
        Intrinsics.checkNotNullParameter((Object)serverUrl, (String)"serverUrl");
        Intrinsics.checkNotNullParameter((Object)starterContext, (String)"starterContext");
        Pair[] pairArray = new Pair[11];
        StarterProjectType starterProjectType = starterContext.getProjectType();
        Intrinsics.checkNotNull((Object)starterProjectType);
        pairArray[0] = TuplesKt.to((Object)"type", (Object)starterProjectType.getId());
        WebStarterFrameworkVersion webStarterFrameworkVersion = starterContext.getFrameworkVersion();
        Intrinsics.checkNotNull((Object)webStarterFrameworkVersion);
        pairArray[1] = TuplesKt.to((Object)"bootVersion", (Object)webStarterFrameworkVersion.getId());
        pairArray[2] = TuplesKt.to((Object)"groupId", (Object)starterContext.getGroup());
        pairArray[3] = TuplesKt.to((Object)"artifactId", (Object)starterContext.getArtifact());
        pairArray[4] = TuplesKt.to((Object)"name", (Object)starterContext.getName());
        pairArray[5] = TuplesKt.to((Object)"version", (Object)starterContext.getVersion());
        pairArray[6] = TuplesKt.to((Object)"language", (Object)starterContext.getLanguage().getId());
        pairArray[7] = TuplesKt.to((Object)"packageName", (Object)starterContext.getPackageName());
        StarterLanguageLevel starterLanguageLevel = starterContext.getLanguageLevel();
        Intrinsics.checkNotNull((Object)starterLanguageLevel);
        pairArray[8] = TuplesKt.to((Object)"javaVersion", (Object)starterLanguageLevel.getId());
        StarterAppPackaging starterAppPackaging = starterContext.getPackaging();
        Intrinsics.checkNotNull((Object)starterAppPackaging);
        pairArray[9] = TuplesKt.to((Object)"packaging", (Object)starterAppPackaging.getId());
        pairArray[10] = TuplesKt.to((Object)"description", (Object)starterContext.getName());
        Map parameters = MapsKt.mapOf((Pair[])pairArray);
        Url url = Urls.newFromEncoded((String)(StringsKt.removeSuffix((String)serverUrl, (CharSequence)"/") + "/starter.zip")).addParameters(parameters);
        Intrinsics.checkNotNullExpressionValue((Object)url, (String)"newFromEncoded(serverUrl\u2026addParameters(parameters)");
        Url url2 = url;
        for (WebStarterDependency dependency : starterContext.getDependencies()) {
            Intrinsics.checkNotNullExpressionValue((Object)url2.addParameters(MapsKt.mapOf((Pair)TuplesKt.to((Object)"dependencies", (Object)dependency.getId()))), (String)"url.addParameters(mapOf(\u2026ncies\" to dependency.id))");
        }
        return url2;
    }

    @RequiresBackgroundThread
    protected void extractGeneratorResult(@NotNull File tempZipFile, @NotNull File contentEntryDir) {
        Intrinsics.checkNotNullParameter((Object)tempZipFile, (String)"tempZipFile");
        Intrinsics.checkNotNullParameter((Object)contentEntryDir, (String)"contentEntryDir");
        ZipUtil.extract((File)tempZipFile, (File)contentEntryDir, null);
    }

    @NotNull
    protected WebStarterLibrariesStep createLibrariesStep(@NotNull WebStarterContextProvider contextProvider) {
        Intrinsics.checkNotNullParameter((Object)contextProvider, (String)"contextProvider");
        return new SpringInitializrLibrariesStep(contextProvider);
    }

    static {
        Companion = new Companion(null);
        Key key = Key.create((String)"SPRING_SHARED_INDEXES");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"Key.create(\"SPRING_SHARED_INDEXES\")");
        SHARED_INDEXES_KEY = key;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014J\b\u0010\f\u001a\u00020\tH\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/spring/boot/initializr/SpringInitializrModuleBuilder$SpringInitializrLibrariesStep;", "Lcom/intellij/ide/starters/remote/wizard/WebStarterLibrariesStep;", "contextProvider", "Lcom/intellij/ide/starters/remote/WebStarterContextProvider;", "(Lcom/intellij/spring/boot/initializr/SpringInitializrModuleBuilder;Lcom/intellij/ide/starters/remote/WebStarterContextProvider;)V", "downloadSharedIndexesProperty", "Lcom/intellij/openapi/observable/properties/GraphProperty;", "", "addFieldsAfter", "", "layout", "Lcom/intellij/ui/layout/LayoutBuilder;", "updateDataModel", "intellij.spring.boot.initializr"})
    private final class SpringInitializrLibrariesStep
    extends WebStarterLibrariesStep {
        private final GraphProperty<Boolean> downloadSharedIndexesProperty;

        protected void addFieldsAfter(@NotNull LayoutBuilder layout) {
            Intrinsics.checkNotNullParameter((Object)layout, (String)"layout");
            if (SpringSharedIndexesProvider.Companion.isSharedIndexOptionAvailable()) {
                LayoutBuilder layoutBuilder = layout;
                boolean bl = false;
                boolean bl2 = false;
                LayoutBuilder $this$apply = layoutBuilder;
                boolean bl3 = false;
                RowBuilder.DefaultImpls.row$default((RowBuilder)((RowBuilder)$this$apply), null, (boolean)false, (Function1)((Function1)new Function1<Row, Unit>(this){
                    final /* synthetic */ SpringInitializrLibrariesStep this$0;
                    {
                        this.this$0 = springInitializrLibrariesStep;
                        super(1);
                    }

                    public final void invoke(@NotNull Row $this$row) {
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$receiver");
                        Cell cell = (Cell)$this$row;
                        String string = JavaStartersBundle.message((String)"title.project.shared.indexes.label", (Object[])new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"JavaStartersBundle.messa\u2026ct.shared.indexes.label\")");
                        Cell.checkBox$default((Cell)cell, (String)string, (GraphProperty)SpringInitializrLibrariesStep.access$getDownloadSharedIndexesProperty$p(this.this$0), null, (int)4, null);
                    }
                }), (int)3, null).largeGapAfter();
            }
        }

        public void updateDataModel() {
            super.updateDataModel();
            if (SpringSharedIndexesProvider.Companion.isSharedIndexOptionAvailable()) {
                this.getStarterContext().putUserData(SHARED_INDEXES_KEY, this.downloadSharedIndexesProperty.get());
            }
        }

        public SpringInitializrLibrariesStep(WebStarterContextProvider contextProvider) {
            Intrinsics.checkNotNullParameter((Object)contextProvider, (String)"contextProvider");
            super(contextProvider);
            this.downloadSharedIndexesProperty = GraphPropertyImpl.Companion.graphProperty(this.getPropertyGraph(), (Function0)downloadSharedIndexesProperty.1.INSTANCE);
        }

        public static final /* synthetic */ GraphProperty access$getDownloadSharedIndexesProperty$p(SpringInitializrLibrariesStep $this) {
            return $this.downloadSharedIndexesProperty;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/intellij/spring/boot/initializr/SpringInitializrModuleBuilder$SpringBootVersion;", "Lcom/intellij/ide/starters/remote/WebStarterFrameworkVersion;", "id", "", "title", "version", "Lcom/intellij/spring/boot/initializr/Version;", "isDefault", "", "(Ljava/lang/String;Ljava/lang/String;Lcom/intellij/spring/boot/initializr/Version;Z)V", "getVersion", "()Lcom/intellij/spring/boot/initializr/Version;", "intellij.spring.boot.initializr"})
    private static final class SpringBootVersion
    extends WebStarterFrameworkVersion {
        @NotNull
        private final Version version;

        @NotNull
        public final Version getVersion() {
            return this.version;
        }

        public SpringBootVersion(@NotNull String id, @NotNull String title, @NotNull Version version, boolean isDefault) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            super(id, title, isDefault);
            this.version = version;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bR\u0013\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lcom/intellij/spring/boot/initializr/SpringInitializrModuleBuilder$SpringBootDependency;", "Lcom/intellij/ide/starters/remote/WebStarterDependency;", "id", "", "title", "description", "links", "", "Lcom/intellij/ide/starters/shared/LibraryLink;", "versionRange", "Lcom/intellij/spring/boot/initializr/VersionRange;", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Lcom/intellij/spring/boot/initializr/VersionRange;)V", "getVersionRange", "()Lcom/intellij/spring/boot/initializr/VersionRange;", "intellij.spring.boot.initializr"})
    private static final class SpringBootDependency
    extends WebStarterDependency {
        @Nullable
        private final VersionRange versionRange;

        @Nullable
        public final VersionRange getVersionRange() {
            return this.versionRange;
        }

        public SpringBootDependency(@NotNull String id, @NotNull String title, @Nullable String description, @NotNull List<LibraryLink> links, @Nullable VersionRange versionRange) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            Intrinsics.checkNotNullParameter(links, (String)"links");
            super(id, title, description, links, false, false, 32, null);
            this.versionRange = versionRange;
        }

        public /* synthetic */ SpringBootDependency(String string, String string2, String string3, List list, VersionRange versionRange, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                string3 = null;
            }
            if ((n & 8) != 0) {
                list = CollectionsKt.emptyList();
            }
            this(string, string2, string3, list, versionRange);
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/spring/boot/initializr/SpringInitializrModuleBuilder$Companion;", "", "()V", "SHARED_INDEXES_KEY", "Lcom/intellij/openapi/util/Key;", "", "intellij.spring.boot.initializr"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

