/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.cloud.stream.model;

import com.intellij.jam.JamService;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.spring.boot.cloud.stream.library.SpringCloudStreamLibraryUtil;
import com.intellij.spring.boot.cloud.stream.model.SpringCloudStreamBindingService;
import com.intellij.spring.boot.cloud.stream.model.jam.EnableBinding;
import com.intellij.spring.boot.cloud.stream.model.jam.Input;
import com.intellij.spring.boot.cloud.stream.model.jam.Output;
import com.intellij.spring.contexts.model.LocalAnnotationModel;
import com.intellij.spring.contexts.model.LocalModel;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringImplicitBean;
import com.intellij.spring.model.custom.CustomLocalComponentsDiscoverer;
import com.intellij.spring.model.jam.stereotype.CustomSpringComponent;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.util.SmartList;
import java.lang.invoke.CallSite;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class SpringCloudStreamBindingsDiscoverer
extends CustomLocalComponentsDiscoverer {
    public static final String BINDINGS_PROVIDER_NAME = "Spring Cloud Stream";

    @NotNull
    public Collection<CommonSpringBean> getCustomComponents(@NotNull LocalModel localModel) {
        Module module;
        if (localModel == null) {
            SpringCloudStreamBindingsDiscoverer.$$$reportNull$$$0(0);
        }
        if ((module = localModel.getModule()) == null || module.isDisposed() || !(localModel instanceof LocalAnnotationModel)) {
            List<CommonSpringBean> list = List.of();
            if (list == null) {
                SpringCloudStreamBindingsDiscoverer.$$$reportNull$$$0(1);
            }
            return list;
        }
        if (!SpringCommonUtils.hasSpringFacet((Module)module) || !SpringCloudStreamLibraryUtil.hasSpringCloudStream(module)) {
            List<CommonSpringBean> list = List.of();
            if (list == null) {
                SpringCloudStreamBindingsDiscoverer.$$$reportNull$$$0(2);
            }
            return list;
        }
        PsiClass psiClass = ((LocalAnnotationModel)localModel).getConfig();
        EnableBinding enableBinding = (EnableBinding)EnableBinding.CLASS_META.getJamElement((PsiModifierListOwner)psiClass);
        if (enableBinding == null) {
            List<CommonSpringBean> list = List.of();
            if (list == null) {
                SpringCloudStreamBindingsDiscoverer.$$$reportNull$$$0(3);
            }
            return list;
        }
        HashSet<CallSite> errorChannels = new HashSet<CallSite>();
        SmartList beans = new SmartList();
        for (PsiClass bindingClass : enableBinding.getValue()) {
            CustomSpringComponent bean = new CustomSpringComponent(null, bindingClass);
            beans.add(bean);
            List outputs = JamService.getJamService((Project)bindingClass.getProject()).getAnnotatedMembersList(bindingClass, Output.OUTPUT_JAM_KEY, 10);
            beans.addAll(outputs);
            List inputs = JamService.getJamService((Project)bindingClass.getProject()).getAnnotatedMembersList(bindingClass, Input.INPUT_JAM_KEY, 10);
            SpringCloudStreamBindingService bindingService = SpringCloudStreamBindingService.getInstance(module.getProject());
            for (Input input : inputs) {
                String group;
                beans.add(input);
                String name = input.getBeanName();
                if (name == null || (group = bindingService.getGroup(name, module, localModel.getActiveProfiles())).isEmpty()) continue;
                for (String destination : bindingService.getDestinations(name, module, localModel.getActiveProfiles())) {
                    String errorChannel;
                    if (destination.isEmpty() || !errorChannels.add((CallSite)((Object)(errorChannel = destination + "." + group + ".errors")))) continue;
                    beans.add(SpringImplicitBean.create((Module)module, (String)BINDINGS_PROVIDER_NAME, (String)"org.springframework.integration.channel.DirectChannel", (String)errorChannel));
                }
            }
        }
        SmartList smartList = beans;
        if (smartList == null) {
            SpringCloudStreamBindingsDiscoverer.$$$reportNull$$$0(4);
        }
        return smartList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localModel";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/boot/cloud/stream/model/SpringCloudStreamBindingsDiscoverer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/boot/cloud/stream/model/SpringCloudStreamBindingsDiscoverer";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getCustomComponents";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getCustomComponents";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

