/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.yaml;

import com.intellij.microservices.config.MetaConfigKey;
import com.intellij.microservices.config.MetaConfigKeyManager;
import com.intellij.microservices.config.MetaConfigKeyReference;
import com.intellij.microservices.config.yaml.ConfigYamlAccessor;
import com.intellij.microservices.config.yaml.ConfigYamlUtils;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.spring.boot.application.metadata.SpringBootApplicationMetaConfigKeyManager;
import com.intellij.spring.boot.library.SpringBootLibraryUtil;
import com.intellij.spring.boot.model.ConfigurationValueResult;
import com.intellij.spring.boot.model.ConfigurationValueSearchParams;
import com.intellij.spring.boot.model.SpringBootModelConfigFileContributor;
import com.intellij.spring.profiles.SpringProfilesFactory;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLFileType;
import org.jetbrains.yaml.psi.YAMLDocument;
import org.jetbrains.yaml.psi.YAMLFile;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLMapping;
import org.jetbrains.yaml.psi.YAMLPsiElement;
import org.jetbrains.yaml.psi.YAMLScalar;
import org.jetbrains.yaml.psi.YAMLSequence;
import org.jetbrains.yaml.psi.YAMLSequenceItem;
import org.jetbrains.yaml.psi.YAMLValue;

public class SpringBootModelApplicationYamlConfigFileContributor
extends SpringBootModelConfigFileContributor {
    public SpringBootModelApplicationYamlConfigFileContributor() {
        super((FileType)YAMLFileType.YML);
    }

    @Override
    @NotNull
    public List<ConfigurationValueResult> findConfigurationValues(ConfigurationValueSearchParams params) {
        YAMLFile yamlFile = (YAMLFile)ObjectUtils.tryCast((Object)params.getConfigFile(), YAMLFile.class);
        if (yamlFile == null) {
            List<ConfigurationValueResult> list = Collections.emptyList();
            if (list == null) {
                SpringBootModelApplicationYamlConfigFileContributor.$$$reportNull$$$0(0);
            }
            return list;
        }
        String fileName = yamlFile.getVirtualFile().getNameWithoutExtension();
        String profileSuffix = StringUtil.substringAfter((String)fileName, (String)"-");
        if (!SpringBootModelApplicationYamlConfigFileContributor.isProfileRelevant(params, profileSuffix)) {
            List<ConfigurationValueResult> list = Collections.emptyList();
            if (list == null) {
                SpringBootModelApplicationYamlConfigFileContributor.$$$reportNull$$$0(1);
            }
            return list;
        }
        MetaConfigKey configKey = params.getConfigKey();
        String keyName = configKey.getName();
        MetaConfigKeyManager.ConfigKeyNameBinder binder = SpringBootApplicationMetaConfigKeyManager.getInstance().getConfigKeyNameBinder(params.getModule());
        boolean multipleOccurrencesPossible = configKey.isAccessType(new MetaConfigKey.AccessType[]{MetaConfigKey.AccessType.ENUM_MAP, MetaConfigKey.AccessType.MAP, MetaConfigKey.AccessType.INDEXED});
        boolean processParts = multipleOccurrencesPossible && (params.getKeyIndex() != null || params.getKeyProperty() != null);
        SmartList results = new SmartList();
        Processor processor2 = arg_0 -> SpringBootModelApplicationYamlConfigFileContributor.lambda$findConfigurationValues$0(keyName, processParts, params, (List)results, binder, configKey, arg_0);
        boolean processAllDocuments = params.isProcessAllProfiles();
        for (YAMLDocument document : yamlFile.getDocuments()) {
            if (!processAllDocuments && !SpringBootModelApplicationYamlConfigFileContributor.isProfileRelevantDocument(document, params, profileSuffix) || ConfigYamlAccessor.processAllKeys((YAMLPsiElement)document, (Processor)processor2) || processAllDocuments) continue;
            break;
        }
        SmartList smartList = results;
        if (smartList == null) {
            SpringBootModelApplicationYamlConfigFileContributor.$$$reportNull$$$0(2);
        }
        return smartList;
    }

    private static void processYamlKeyValue(ConfigurationValueSearchParams params, List<ConfigurationValueResult> results, YAMLKeyValue yamlKeyValue, String keyIndexText) {
        PsiElement keyElement = yamlKeyValue.getKey();
        if (keyElement == null) {
            return;
        }
        YAMLValue valueElement = yamlKeyValue.getValue();
        if (valueElement instanceof YAMLSequence) {
            YAMLSequence sequence = (YAMLSequence)valueElement;
            for (YAMLSequenceItem item : sequence.getItems()) {
                YAMLValue itemValue = item.getValue();
                if (!(itemValue instanceof YAMLScalar)) continue;
                results.add(new YamlConfigurationValueResult(yamlKeyValue, keyElement, keyIndexText, (PsiElement)itemValue, itemValue.getText(), params));
            }
            return;
        }
        if (valueElement instanceof YAMLMapping) {
            YAMLMapping mapping = (YAMLMapping)valueElement;
            for (YAMLKeyValue mapKeyValue : mapping.getKeyValues()) {
                if (mapKeyValue.getKey() == null) continue;
                results.add(new YamlConfigurationValueResult(mapKeyValue, mapKeyValue.getKey(), keyIndexText, (PsiElement)mapKeyValue.getValue(), mapKeyValue.getValueText(), params));
            }
            return;
        }
        results.add(new YamlConfigurationValueResult(yamlKeyValue, keyElement, keyIndexText, (PsiElement)valueElement, yamlKeyValue.getValueText(), params));
    }

    private static boolean isProfileRelevantDocument(YAMLDocument document, ConfigurationValueSearchParams params, String fileProfile) {
        Set<String> activeProfiles = params.getActiveProfiles();
        if (ContainerUtil.isEmpty(activeProfiles)) {
            return true;
        }
        ConfigYamlAccessor accessor = new ConfigYamlAccessor(document, params.getModule(), (MetaConfigKeyManager)SpringBootApplicationMetaConfigKeyManager.getInstance());
        return SpringBootModelApplicationYamlConfigFileContributor.isProfileRelevantByKey("spring.profiles", accessor, activeProfiles, null) || SpringBootModelApplicationYamlConfigFileContributor.isProfileRelevantByKey("spring.config.activate.on-profile", accessor, activeProfiles, fileProfile);
    }

    private static boolean isProfileRelevantByKey(String key, ConfigYamlAccessor accessor, Set<String> activeProfiles, String fileProfile) {
        String profileText;
        YAMLKeyValue profilesKey = accessor.findExistingKey(key);
        String string = profileText = profilesKey != null ? profilesKey.getValueText() : fileProfile;
        if (profileText == null) {
            return false;
        }
        try {
            Predicate profiles = SpringProfilesFactory.getInstance().parseProfileExpressions((Collection)StringUtil.split((String)profileText, (String)","));
            return profiles.test(activeProfiles);
        }
        catch (SpringProfilesFactory.MalformedProfileExpressionException e) {
            return false;
        }
    }

    private static /* synthetic */ boolean lambda$findConfigurationValues$0(String keyName, boolean processParts, ConfigurationValueSearchParams params, List results, MetaConfigKeyManager.ConfigKeyNameBinder binder, MetaConfigKey configKey, YAMLKeyValue keyValue) {
        ProgressManager.checkCanceled();
        String qualifiedKeyName = ConfigYamlUtils.getQualifiedConfigKeyName((YAMLKeyValue)keyValue);
        if (qualifiedKeyName.equals(keyName)) {
            if (processParts) {
                return true;
            }
            SpringBootModelApplicationYamlConfigFileContributor.processYamlKeyValue(params, results, keyValue, null);
            return false;
        }
        if (!params.getCheckRelaxedNames() && !qualifiedKeyName.startsWith(keyName)) {
            return true;
        }
        if (processParts) {
            String keyIndexText = binder.bindsToKeyProperty(configKey, params.getKeyProperty(), qualifiedKeyName);
            if (keyIndexText != null && (params.getKeyIndex() == null || keyIndexText.equals(params.getKeyIndex()))) {
                SpringBootModelApplicationYamlConfigFileContributor.processYamlKeyValue(params, results, keyValue, keyIndexText);
                return true;
            }
        } else if (binder.bindsTo(configKey, qualifiedKeyName)) {
            SpringBootModelApplicationYamlConfigFileContributor.processYamlKeyValue(params, results, keyValue, null);
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/yaml/SpringBootModelApplicationYamlConfigFileContributor", "findConfigurationValues"));
    }

    private static class YamlConfigurationValueResult
    extends ConfigurationValueResult {
        @NotNull
        private final YAMLKeyValue myValue;

        YamlConfigurationValueResult(@NotNull YAMLKeyValue yamlKeyValue, @NotNull PsiElement keyElement, @Nullable String keyIndexText, @Nullable PsiElement valueElement, @Nullable String valueText, ConfigurationValueSearchParams params) {
            if (yamlKeyValue == null) {
                YamlConfigurationValueResult.$$$reportNull$$$0(0);
            }
            if (keyElement == null) {
                YamlConfigurationValueResult.$$$reportNull$$$0(1);
            }
            super(keyElement, keyIndexText, valueElement, YamlConfigurationValueResult.convertAliasValue(valueText, params), params);
            this.myValue = yamlKeyValue;
        }

        @NotNull
        public MetaConfigKeyReference<?> getMetaConfigKeyReference() {
            MetaConfigKeyReference metaConfigKeyReference = (MetaConfigKeyReference)ContainerUtil.findInstance((Object[])this.myValue.getReferences(), MetaConfigKeyReference.class);
            if (metaConfigKeyReference == null) {
                String referencesText = StringUtil.join((Collection)ContainerUtil.map((Object[])this.myValue.getReferences(), ref -> ref.getClass().getName()), (String)"|");
                throw new IllegalStateException(this.myValue.getClass() + " - " + this.myValue.getText() + " - " + referencesText);
            }
            MetaConfigKeyReference metaConfigKeyReference2 = metaConfigKeyReference;
            if (metaConfigKeyReference2 == null) {
                YamlConfigurationValueResult.$$$reportNull$$$0(2);
            }
            return metaConfigKeyReference2;
        }

        private static String convertAliasValue(String valueText, ConfigurationValueSearchParams params) {
            if (StringUtil.isEmpty((String)valueText)) {
                return valueText;
            }
            char first = valueText.charAt(0);
            if (first != 'o' && first != 'O') {
                return valueText;
            }
            String aliasOf = null;
            if (StringUtil.equalsIgnoreCase((CharSequence)valueText, (CharSequence)"on")) {
                aliasOf = "true";
            } else if (StringUtil.equalsIgnoreCase((CharSequence)valueText, (CharSequence)"off")) {
                aliasOf = "false";
            }
            if (aliasOf == null) {
                return valueText;
            }
            if (!SpringBootLibraryUtil.isAtLeastVersion(params.getModule(), SpringBootLibraryUtil.SpringBootVersion.VERSION_2_2_0)) {
                return valueText;
            }
            return YamlConfigurationValueResult.hasBooleanEffectiveValueType(params.getConfigKey()) ? aliasOf : valueText;
        }

        private static boolean hasBooleanEffectiveValueType(MetaConfigKey configKey) {
            PsiClass typeClass;
            PsiType valueType = configKey.getEffectiveValueType();
            if (valueType == null) {
                return false;
            }
            if (configKey.isAccessType(MetaConfigKey.AccessType.MAP_GROUP)) {
                MetaConfigKey.AccessType valueAccessType = MetaConfigKey.AccessType.forPsiType((PsiType)valueType);
                valueType = valueAccessType.getEffectiveValueType(valueType);
            }
            if ((typeClass = PsiTypesUtil.getPsiClass((PsiType)valueType)) == null) {
                return false;
            }
            return "java.lang.Boolean".equals(typeClass.getQualifiedName());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "yamlKeyValue";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "keyElement";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/spring/boot/application/yaml/SpringBootModelApplicationYamlConfigFileContributor$YamlConfigurationValueResult";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/spring/boot/application/yaml/SpringBootModelApplicationYamlConfigFileContributor$YamlConfigurationValueResult";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMetaConfigKeyReference";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

