/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.yaml;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.spring.boot.model.SpringBootConfigurationFileService;
import com.intellij.spring.boot.model.SpringBootModelConfigFileNameContributor;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.jetbrains.jsonSchema.extension.JsonWidgetSuppressor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.psi.YAMLFile;

public class SpringBootApplicationYamlJsonWidgetSuppressor
implements JsonWidgetSuppressor {
    public boolean isCandidateForSuppress(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            SpringBootApplicationYamlJsonWidgetSuppressor.$$$reportNull$$$0(0);
        }
        if (project == null) {
            SpringBootApplicationYamlJsonWidgetSuppressor.$$$reportNull$$$0(1);
        }
        if (!SpringCommonUtils.hasSpringFacets((Project)project)) {
            return false;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
        if (!(psiFile instanceof YAMLFile)) {
            return false;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiFile);
        if (module == null) {
            return false;
        }
        for (SpringBootModelConfigFileNameContributor fileNameContributor : (SpringBootModelConfigFileNameContributor[])SpringBootModelConfigFileNameContributor.EP_NAME.getExtensions()) {
            String configName = fileNameContributor.getSpringConfigName(module);
            String fileNameWithoutExtension = file.getNameWithoutExtension();
            if (fileNameWithoutExtension.equals(configName) || fileNameWithoutExtension.startsWith(configName + "-")) {
                return true;
            }
            for (String customConfigFileUrl : fileNameContributor.getCustomConfigFileUrls(module)) {
                if (!customConfigFileUrl.endsWith(file.getName())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean suppressSwitcherWidget(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            SpringBootApplicationYamlJsonWidgetSuppressor.$$$reportNull$$$0(2);
        }
        if (project == null) {
            SpringBootApplicationYamlJsonWidgetSuppressor.$$$reportNull$$$0(3);
        }
        if (!SpringCommonUtils.hasSpringFacets((Project)project)) {
            return false;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
        return psiFile instanceof YAMLFile && SpringBootConfigurationFileService.getInstance().isApplicationConfigurationFile(psiFile);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/intellij/spring/boot/application/yaml/SpringBootApplicationYamlJsonWidgetSuppressor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isCandidateForSuppress";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "suppressSwitcherWidget";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

