/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.yaml;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.lang.ASTNode;
import com.intellij.microservices.config.MetaConfigKey;
import com.intellij.microservices.config.MetaConfigKeyManager;
import com.intellij.microservices.config.yaml.ConfigYamlAccessor;
import com.intellij.microservices.config.yaml.ConfigYamlUtils;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.spring.boot.SpringBootApiBundle;
import com.intellij.spring.boot.application.metadata.SpringBootApplicationMetaConfigKeyManager;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLTokenTypes;
import org.jetbrains.yaml.completion.YamlKeyCompletionInsertHandler;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLMapping;
import org.jetbrains.yaml.psi.YAMLSequence;
import org.jetbrains.yaml.psi.YAMLValue;

final class SpringBootApplicationYamlDeprecationFixFactory {
    SpringBootApplicationYamlDeprecationFixFactory() {
    }

    static LocalQuickFix[] getDeprecationFixes(PsiElement keyElement, MetaConfigKey configKey, boolean isOnTheFly) {
        String replacement = configKey.getDeprecation().getReplacement();
        if (replacement == null) {
            return LocalQuickFix.EMPTY_ARRAY;
        }
        if (!configKey.isAccessType(new MetaConfigKey.AccessType[]{MetaConfigKey.AccessType.NORMAL, MetaConfigKey.AccessType.INDEXED})) {
            return LocalQuickFix.EMPTY_ARRAY;
        }
        if (SpringBootApplicationYamlDeprecationFixFactory.replacementKeyExists(keyElement, replacement)) {
            return LocalQuickFix.EMPTY_ARRAY;
        }
        return new LocalQuickFix[]{new UseReplacementKeyFix(keyElement, replacement, configKey, isOnTheFly)};
    }

    private static boolean replacementKeyExists(PsiElement keyElement, String replacement) {
        ConfigYamlAccessor accessor = new ConfigYamlAccessor(keyElement, (MetaConfigKeyManager)SpringBootApplicationMetaConfigKeyManager.getInstance());
        YAMLKeyValue existingReplacement = accessor.findExistingKey(replacement);
        return existingReplacement != null;
    }

    private static final class UseReplacementKeyFix
    extends LocalQuickFixAndIntentionActionOnPsiElement {
        private final String myReplacement;
        private final MetaConfigKey myConfigKey;
        private final boolean myIsOnTheFly;

        private UseReplacementKeyFix(PsiElement keyElement, String replacement, MetaConfigKey configKey, boolean isOnTheFly) {
            super(keyElement);
            this.myReplacement = replacement;
            this.myConfigKey = configKey;
            this.myIsOnTheFly = isOnTheFly;
        }

        @NotNull
        public String getText() {
            String string = SpringBootApiBundle.message("application.config.replacement.quick.fix", this.myReplacement);
            if (string == null) {
                UseReplacementKeyFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            YAMLValue existingValueCopy;
            if (project == null) {
                UseReplacementKeyFix.$$$reportNull$$$0(1);
            }
            if (file == null) {
                UseReplacementKeyFix.$$$reportNull$$$0(2);
            }
            if (startElement == null) {
                UseReplacementKeyFix.$$$reportNull$$$0(3);
            }
            if (endElement == null) {
                UseReplacementKeyFix.$$$reportNull$$$0(4);
            }
            if (SpringBootApplicationYamlDeprecationFixFactory.replacementKeyExists(startElement, this.myReplacement)) {
                return;
            }
            YAMLKeyValue existingKey = (YAMLKeyValue)PsiTreeUtil.getParentOfType((PsiElement)startElement, YAMLKeyValue.class);
            if (existingKey == null) {
                return;
            }
            String existingKeyName = ConfigYamlUtils.getQualifiedConfigKeyName((YAMLKeyValue)existingKey);
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)startElement);
            assert (module != null) : "could not find module for deprecated element " + startElement;
            SpringBootApplicationMetaConfigKeyManager metaConfigKeyManager = SpringBootApplicationMetaConfigKeyManager.getInstance();
            MetaConfigKeyManager.ConfigKeyNameBinder binder = metaConfigKeyManager.getConfigKeyNameBinder(module);
            if (!binder.bindsTo(this.myConfigKey, existingKeyName)) {
                return;
            }
            ConfigYamlAccessor accessor = new ConfigYamlAccessor(startElement, (MetaConfigKeyManager)metaConfigKeyManager);
            YAMLValue existingValue = existingKey.getValue();
            YAMLValue yAMLValue = existingValueCopy = existingValue == null ? null : (YAMLValue)existingValue.copy();
            if (existingValueCopy instanceof YAMLSequence) {
                YamlKeyCompletionInsertHandler.trimSequenceItemIndents((YAMLSequence)((YAMLSequence)existingValueCopy));
            }
            YAMLMapping mapping = existingKey.getParentMapping();
            assert (existingKey.getParentMapping() != null);
            UseReplacementKeyFix.deleteKeyValuesRecursively(mapping, existingKey);
            YAMLKeyValue replacementKeyValue = accessor.create(this.myReplacement);
            assert (replacementKeyValue != null);
            if (existingValueCopy != null) {
                MetaConfigKey replacementMetaConfigKey = metaConfigKeyManager.findApplicationMetaConfigKey(module, this.myReplacement);
                if (replacementMetaConfigKey != null && replacementMetaConfigKey.getType() != null && this.myConfigKey.getType() != null && !this.myConfigKey.getType().isAssignableFrom(replacementMetaConfigKey.getType())) {
                    if (editor == null) {
                        return;
                    }
                    ASTNode[] colons = replacementKeyValue.getNode().getChildren(TokenSet.create((IElementType[])new IElementType[]{YAMLTokenTypes.COLON}));
                    assert (colons.length == 1);
                    ASTNode colon = colons[0];
                    editor.getCaretModel().moveToOffset(colon.getTextRange().getEndOffset());
                    PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(editor.getDocument());
                    EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)" ");
                    AutoPopupController.getInstance((Project)project).scheduleAutoPopup(editor);
                    return;
                }
                replacementKeyValue.setValue(existingValueCopy);
            }
            if (this.myIsOnTheFly) {
                replacementKeyValue.navigate(true);
            }
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = SpringBootApiBundle.message("application.config.replacement.quick.fix.family.name", new Object[0]);
            if (string == null) {
                UseReplacementKeyFix.$$$reportNull$$$0(5);
            }
            return string;
        }

        private static void deleteKeyValuesRecursively(YAMLMapping mapping, YAMLKeyValue keyValue) {
            mapping.deleteKeyValue(keyValue);
            for (YAMLKeyValue value : mapping.getKeyValues()) {
                if (value.getValue() == null) continue;
                return;
            }
            YAMLKeyValue parentKeyValue = (YAMLKeyValue)PsiTreeUtil.getParentOfType((PsiElement)mapping, YAMLKeyValue.class);
            YAMLMapping parentMapping = (YAMLMapping)PsiTreeUtil.getParentOfType((PsiElement)parentKeyValue, YAMLMapping.class);
            mapping.delete();
            if (parentMapping != null) {
                UseReplacementKeyFix.deleteKeyValuesRecursively(parentMapping, parentKeyValue);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/spring/boot/application/yaml/SpringBootApplicationYamlDeprecationFixFactory$UseReplacementKeyFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "endElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/spring/boot/application/yaml/SpringBootApplicationYamlDeprecationFixFactory$UseReplacementKeyFix";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

