/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.metadata.additional;

import com.intellij.json.psi.JsonFile;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.Processor;
import java.util.List;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.jps.model.java.JavaResourceRootType;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public class SpringBootAdditionalConfigUtils {
    private final Module myModule;
    private final List<VirtualFile> myResourceRoots;
    private static boolean OVERRIDE = false;

    public SpringBootAdditionalConfigUtils(Module module) {
        this.myModule = module;
        boolean testMode = ApplicationManager.getApplication().isUnitTestMode();
        JavaSourceRootType sourceRootType = testMode ? JavaSourceRootType.SOURCE : JavaResourceRootType.RESOURCE;
        this.myResourceRoots = ModuleRootManager.getInstance((Module)module).getSourceRoots((JpsModuleSourceRootType)sourceRootType);
    }

    boolean hasResourceRoots() {
        return !this.myResourceRoots.isEmpty();
    }

    List<VirtualFile> getResourceRoots() {
        return this.myResourceRoots;
    }

    public boolean processAllAdditionalMetadataFiles(Processor<? super PsiFile> processor2) {
        for (VirtualFile root : this.myResourceRoots) {
            PsiFile psiFile;
            VirtualFile vf = root.findFileByRelativePath("META-INF/additional-spring-configuration-metadata.json");
            if (vf == null || processor2.process((Object)(psiFile = PsiManager.getInstance((Project)this.myModule.getProject()).findFile(vf)))) continue;
            return false;
        }
        return true;
    }

    public boolean processAdditionalMetadataFiles(Processor<? super JsonFile> processor2) {
        return this.processAllAdditionalMetadataFiles((Processor<? super PsiFile>)((Processor)psiFile -> !(psiFile instanceof JsonFile) || processor2.process((Object)((JsonFile)psiFile))));
    }

    @TestOnly
    public static void setOverrideDetection(boolean value) {
        OVERRIDE = value;
    }

    public static boolean isAdditionalMetadataFile(PsiFile psiFile) {
        if (OVERRIDE) {
            return true;
        }
        return psiFile instanceof JsonFile && psiFile.getName().equals("additional-spring-configuration-metadata.json");
    }
}

