/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.metadata.additional;

import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.json.JsonUtil;
import com.intellij.json.psi.JsonArray;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.json.psi.JsonValue;
import com.intellij.microservices.config.MetaConfigKey;
import com.intellij.microservices.config.MetaConfigKeyManager;
import com.intellij.microservices.config.MetaConfigKeyReference;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.spring.boot.SpringBootApiBundle;
import com.intellij.spring.boot.application.metadata.SpringBootApplicationMetaConfigKey;
import com.intellij.spring.boot.application.metadata.SpringBootApplicationMetaConfigKeyManager;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

class SpringBootAdditionalConfigMetaConfigKeyReference
extends MetaConfigKeyReference<PsiElement>
implements EmptyResolveMessageProvider {
    private final Mode myMode;

    SpringBootAdditionalConfigMetaConfigKeyReference(PsiElement element, Mode mode) {
        super((MetaConfigKeyManager)SpringBootApplicationMetaConfigKeyManager.getInstance(), element, ElementManipulators.getValueText((PsiElement)element));
        this.myMode = mode;
    }

    protected TextRange calculateDefaultRangeInElement() {
        MetaConfigKey key = this.getResolvedKey();
        if (key != null && key.isAccessType(MetaConfigKey.AccessType.MAP_GROUP)) {
            String keyName = key.getName();
            return TextRange.allOf((String)keyName).shiftRight(ElementManipulators.getOffsetInElement((PsiElement)this.getElement()));
        }
        return super.calculateDefaultRangeInElement();
    }

    @NotNull
    protected List<MetaConfigKey> getAllKeys(String keyText) {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)this.getElement());
        if (module == null) {
            List<MetaConfigKey> list = Collections.emptyList();
            if (list == null) {
                SpringBootAdditionalConfigMetaConfigKeyReference.$$$reportNull$$$0(0);
            }
            return list;
        }
        List allKeys = SpringBootApplicationMetaConfigKeyManager.getInstance().getAllMetaConfigKeys(module);
        MetaConfigKeyManager.ConfigKeyNameBinder binder = SpringBootApplicationMetaConfigKeyManager.getInstance().getConfigKeyNameBinder(module);
        List list = ContainerUtil.filter((Collection)allKeys, configKey -> {
            String keyName = configKey.getName();
            if (configKey.isAccessType(MetaConfigKey.AccessType.MAP_GROUP)) {
                if (this.myMode == Mode.HINTS) {
                    return keyText.equals(keyName + ".keys") || keyText.equals(keyName + ".values");
                }
                return binder.bindsTo(configKey, keyText);
            }
            return keyText.equals(keyName);
        });
        if (list == null) {
            SpringBootAdditionalConfigMetaConfigKeyReference.$$$reportNull$$$0(1);
        }
        return list;
    }

    @NotNull
    public String getReferenceDisplayText() {
        String string = this.myMode.myDisplayName + " for " + ElementManipulators.getValueText((PsiElement)this.getElement());
        if (string == null) {
            SpringBootAdditionalConfigMetaConfigKeyReference.$$$reportNull$$$0(2);
        }
        return string;
    }

    public Object @NotNull [] getVariants() {
        Set<Object> existingKeys = this.myMode == Mode.HINTS ? this.collectExistingKeys() : Collections.emptySet();
        List<SpringBootApplicationMetaConfigKey> allKeys = SpringBootApplicationMetaConfigKeyManager.getInstance().getAllMetaConfigKeys(this.getElement());
        ArrayList<LookupElement> allVariants = new ArrayList<LookupElement>(allKeys.size());
        for (MetaConfigKey metaConfigKey : allKeys) {
            MetaConfigKey.MetaConfigKeyPresentation presentation = metaConfigKey.getPresentation();
            if (this.myMode == Mode.REPLACEMENT) {
                allVariants.add(presentation.tuneLookupElement((LookupElement)presentation.getLookupElement()));
                continue;
            }
            if (metaConfigKey.isAccessType(MetaConfigKey.AccessType.MAP_GROUP)) {
                String dotValuesName;
                String dotKeysName = metaConfigKey.getName() + ".keys";
                if (!existingKeys.contains(dotKeysName)) {
                    allVariants.add(presentation.tuneLookupElement((LookupElement)presentation.getLookupElement(dotKeysName)));
                }
                if (existingKeys.contains(dotValuesName = metaConfigKey.getName() + ".values")) continue;
                allVariants.add(presentation.tuneLookupElement((LookupElement)presentation.getLookupElement(dotValuesName)));
                continue;
            }
            if (existingKeys.contains(metaConfigKey.getName())) continue;
            allVariants.add(presentation.tuneLookupElement((LookupElement)presentation.getLookupElement()));
        }
        Object[] objectArray = allVariants.toArray(LookupElement.EMPTY_ARRAY);
        if (objectArray == null) {
            SpringBootAdditionalConfigMetaConfigKeyReference.$$$reportNull$$$0(3);
        }
        return objectArray;
    }

    @NotNull
    public String getUnresolvedMessagePattern() {
        String string = SpringBootApiBundle.message("additional.config.unresolved.config.key.reference", this.getValue());
        if (string == null) {
            SpringBootAdditionalConfigMetaConfigKeyReference.$$$reportNull$$$0(4);
        }
        return string;
    }

    private Set<String> collectExistingKeys() {
        PsiFile file = this.getElement().getContainingFile();
        if (!(file instanceof JsonFile)) {
            return Collections.emptySet();
        }
        JsonObject rootObject = (JsonObject)ObjectUtils.tryCast((Object)((JsonFile)file).getTopLevelValue(), JsonObject.class);
        if (rootObject == null) {
            return Collections.emptySet();
        }
        JsonArray hintsArray = (JsonArray)JsonUtil.getPropertyValueOfType((JsonObject)rootObject, (String)"hints", JsonArray.class);
        if (hintsArray == null) {
            return Collections.emptySet();
        }
        HashSet<String> result2 = new HashSet<String>();
        for (JsonValue value : hintsArray.getValueList()) {
            JsonStringLiteral literal;
            JsonObject entry = (JsonObject)ObjectUtils.tryCast((Object)value, JsonObject.class);
            if (entry == null || (literal = (JsonStringLiteral)JsonUtil.getPropertyValueOfType((JsonObject)entry, (String)"name", JsonStringLiteral.class)) == null) continue;
            ContainerUtil.addIfNotNull(result2, (Object)literal.getValue());
        }
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/spring/boot/application/metadata/additional/SpringBootAdditionalConfigMetaConfigKeyReference";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllKeys";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferenceDisplayText";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnresolvedMessagePattern";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    static enum Mode {
        HINTS("Hint"),
        REPLACEMENT("Replacement");

        private final String myDisplayName;

        private Mode(String displayName) {
            this.myDisplayName = displayName;
        }
    }
}

