/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.metadata;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.json.JsonFileType;
import com.intellij.json.psi.JsonFile;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiTreeChangeAdapter;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.psi.PsiTreeChangeListener;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.spring.SpringModificationTrackersManager;
import com.intellij.spring.boot.application.metadata.SpringBootMetadataNotificationPanel;
import com.intellij.spring.boot.application.metadata.additional.SpringBootAdditionalConfigUtils;
import com.intellij.spring.boot.library.SpringBootLibraryUtil;
import com.intellij.spring.boot.options.SpringBootSettings;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.ui.EditorNotifications;
import com.intellij.util.Alarm;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringBootMetadataEditorNotificationsProvider
extends EditorNotifications.Provider<SpringBootMetadataNotificationPanel>
implements Disposable {
    private static final Key<SpringBootMetadataNotificationPanel> KEY = Key.create((String)"SpringBootMetadata");
    private final ParameterizedCachedValue<Object, PsiFile> myPsiClassOwnerCachedTrigger;
    private final MergingUpdateQueue myUpdateQueue;

    public SpringBootMetadataEditorNotificationsProvider(Project project) {
        Disposer.register((Disposable)SpringBootSettings.getInstance(project), (Disposable)this);
        this.myPsiClassOwnerCachedTrigger = CachedValuesManager.getManager((Project)project).createParameterizedCachedValue(psiFile -> {
            if (DumbService.isDumb((Project)project) || SpringBootMetadataEditorNotificationsProvider.isRelevantProject(project)) {
                SpringBootMetadataEditorNotificationsProvider.updateNotifications(psiFile.getVirtualFile(), project);
                return CachedValueProvider.Result.create(null, (Object[])new Object[]{SpringModificationTrackersManager.getInstance((Project)project).getOuterModelsModificationTracker()});
            }
            return CachedValueProvider.Result.create(null, (Object[])new Object[]{ProjectRootManager.getInstance((Project)project)});
        }, false);
        this.myUpdateQueue = new MergingUpdateQueue("SpringBootMetadataEditorNotificationsProvider", 2000, true, null, (Disposable)this, null, Alarm.ThreadToUse.POOLED_THREAD);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        this.installListeners(project);
    }

    private static boolean isRelevantProject(@NotNull Project project) {
        if (project == null) {
            SpringBootMetadataEditorNotificationsProvider.$$$reportNull$$$0(0);
        }
        return SpringCommonUtils.hasSpringFacets((Project)project) && SpringBootLibraryUtil.hasSpringBootLibrary(project);
    }

    @NotNull
    public Key<SpringBootMetadataNotificationPanel> getKey() {
        Key<SpringBootMetadataNotificationPanel> key = KEY;
        if (key == null) {
            SpringBootMetadataEditorNotificationsProvider.$$$reportNull$$$0(1);
        }
        return key;
    }

    @Nullable
    public SpringBootMetadataNotificationPanel createNotificationPanel(@NotNull VirtualFile file, @NotNull FileEditor fileEditor, @NotNull Project project) {
        if (file == null) {
            SpringBootMetadataEditorNotificationsProvider.$$$reportNull$$$0(2);
        }
        if (fileEditor == null) {
            SpringBootMetadataEditorNotificationsProvider.$$$reportNull$$$0(3);
        }
        if (project == null) {
            SpringBootMetadataEditorNotificationsProvider.$$$reportNull$$$0(4);
        }
        if (!SpringBootSettings.getInstance(project).isShowAdditionalConfigNotification()) {
            return null;
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return null;
        }
        if (!SpringBootMetadataEditorNotificationsProvider.isRelevantProject(project)) {
            return null;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
        if (psiFile == null || !SpringBootAdditionalConfigUtils.isAdditionalMetadataFile(psiFile) && !SpringBootMetadataEditorNotificationsProvider.isConfigurationPropertiesAnnotatedClass(psiFile)) {
            return null;
        }
        Module module = ModuleUtilCore.findModuleForFile((VirtualFile)file, (Project)project);
        if (module == null) {
            return null;
        }
        if (SpringBootLibraryUtil.isBelowVersion(module, SpringBootLibraryUtil.SpringBootVersion.VERSION_1_2_0)) {
            return null;
        }
        return new SpringBootMetadataNotificationPanel(module, psiFile);
    }

    private static void updateNotifications(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            SpringBootMetadataEditorNotificationsProvider.$$$reportNull$$$0(5);
        }
        if (project == null) {
            SpringBootMetadataEditorNotificationsProvider.$$$reportNull$$$0(6);
        }
        EditorNotifications.getInstance((Project)project).updateNotifications(file);
    }

    private static boolean isConfigurationPropertiesAnnotatedClass(PsiFile psiFile) {
        if (!(psiFile instanceof PsiClassOwner)) {
            return false;
        }
        PsiClassOwner psiClassOwner = (PsiClassOwner)psiFile;
        Object[] classes = psiClassOwner.getClasses();
        PsiClass psiClass = (PsiClass)ArrayUtil.getFirstElement((Object[])classes);
        if (psiClass == null) {
            return false;
        }
        return AnnotationUtil.isAnnotated((PsiModifierListOwner)psiClass, (String)"org.springframework.boot.context.properties.ConfigurationProperties", (int)0);
    }

    private void installListeners(final @NotNull Project project) {
        if (project == null) {
            SpringBootMetadataEditorNotificationsProvider.$$$reportNull$$$0(7);
        }
        SpringBootSettings settings = SpringBootSettings.getInstance(project);
        VirtualFileManager.getInstance().addVirtualFileListener(new VirtualFileListener(){

            public void propertyChanged(@NotNull VirtualFilePropertyEvent event) {
                PsiFile file;
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                VirtualFile virtualFile = event.getFile();
                if (event.getPropertyName().equals("name") && FileTypeRegistry.getInstance().isFileOfType(virtualFile, (FileType)JsonFileType.INSTANCE) && (file = PsiManager.getInstance((Project)project).findFile(virtualFile)) instanceof JsonFile) {
                    SpringBootMetadataEditorNotificationsProvider.updateNotifications(virtualFile, project);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/spring/boot/application/metadata/SpringBootMetadataEditorNotificationsProvider$1", "propertyChanged"));
            }
        }, (Disposable)settings);
        PsiManager.getInstance((Project)project).addPsiTreeChangeListener((PsiTreeChangeListener)new PsiTreeChangeAdapter(){

            public void childMoved(@NotNull PsiTreeChangeEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                this.handleChange(event);
            }

            public void childReplaced(@NotNull PsiTreeChangeEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(1);
                }
                this.handleChange(event);
            }

            public void childRemoved(@NotNull PsiTreeChangeEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(2);
                }
                this.handleChange(event);
            }

            public void childAdded(@NotNull PsiTreeChangeEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(3);
                }
                this.handleChange(event);
            }

            public void childrenChanged(@NotNull PsiTreeChangeEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(4);
                }
                this.handleChange(event);
            }

            private void handleChange(PsiTreeChangeEvent event) {
                final PsiFile file = event.getFile();
                if (file instanceof PsiClassOwner || file instanceof JsonFile) {
                    if (DumbService.isDumb((Project)project)) {
                        return;
                    }
                    SpringBootMetadataEditorNotificationsProvider.this.myUpdateQueue.queue(new Update("SB metadata notification update"){

                        public void run() {
                            ReadAction.run(() -> SpringBootMetadataEditorNotificationsProvider.this.myPsiClassOwnerCachedTrigger.getValue((Object)file));
                        }
                    });
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "event";
                objectArray2[1] = "com/intellij/spring/boot/application/metadata/SpringBootMetadataEditorNotificationsProvider$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "childMoved";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "childReplaced";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "childRemoved";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "childAdded";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "childrenChanged";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, (Disposable)settings);
    }

    public void dispose() {
        this.myUpdateQueue.cancelAllUpdates();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/boot/application/metadata/SpringBootMetadataEditorNotificationsProvider";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/boot/application/metadata/SpringBootMetadataEditorNotificationsProvider";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isRelevantProject";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createNotificationPanel";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "updateNotifications";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "installListeners";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

