/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.metadata;

import com.intellij.microservices.config.MetaConfigKey;
import com.intellij.microservices.config.MetaConfigKeyManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.spring.boot.application.metadata.BinderConfigKeyNameBinder;
import com.intellij.spring.boot.application.metadata.RelaxedNamesConfigKeyNameBinder;
import com.intellij.spring.boot.application.metadata.SpringBootApplicationMetaConfigKeyManager;
import com.intellij.spring.boot.application.metadata.SpringBootConfigurationMetadataParser;
import com.intellij.spring.boot.library.SpringBootLibraryUtil;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import com.intellij.util.Processors;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringBootApplicationMetaConfigKeyManagerImpl
extends SpringBootApplicationMetaConfigKeyManager {
    private static final Logger LOG = Logger.getInstance(SpringBootApplicationMetaConfigKeyManagerImpl.class);
    private static final MetaConfigKeyManager.ConfigKeyNameBinder ourRelaxedConfigKeyNameBinder = new RelaxedNamesConfigKeyNameBinder();
    private static final MetaConfigKeyManager.ConfigKeyNameBinder ourBinderConfigKeyNameBinder = new BinderConfigKeyNameBinder();

    public List<MetaConfigKey> getAllMetaConfigKeys(@Nullable Module module) {
        if (SpringBootLibraryUtil.isBelowVersion(module, SpringBootLibraryUtil.SpringBootVersion.VERSION_1_2_0)) {
            return Collections.emptyList();
        }
        List fromLibraries = (List)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> {
            List metaInfConfigFiles = SpringCommonUtils.findConfigFilesInMetaInf((Module)module, (boolean)true, (String)"spring-configuration-metadata.json", PsiFile.class);
            ArrayList<MetaConfigKey> allKeys = new ArrayList<MetaConfigKey>();
            for (PsiFile configMetadataFile : metaInfConfigFiles) {
                List<MetaConfigKey> keys = SpringBootApplicationMetaConfigKeyManagerImpl.getConfigKeysForFile(module, configMetadataFile);
                allKeys.addAll(keys);
            }
            return CachedValueProvider.Result.create(allKeys, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        });
        List<MetaConfigKey> localKeys = SpringBootApplicationMetaConfigKeyManagerImpl.getLocalMetaConfigKeys(module);
        return ContainerUtil.concat((List)fromLibraries, localKeys);
    }

    private static List<MetaConfigKey> getConfigKeysForFile(Module module, PsiFile jsonFile) {
        ArrayList<MetaConfigKey> keys = new ArrayList<MetaConfigKey>();
        Processor collect = Processors.cancelableCollectProcessor(keys);
        try {
            SpringBootConfigurationMetadataParser parser = new SpringBootConfigurationMetadataParser(jsonFile);
            parser.processKeys(module, (Processor<MetaConfigKey>)collect);
        }
        catch (ProcessCanceledException | IndexNotReadyException e) {
            throw e;
        }
        catch (Throwable e) {
            LOG.warn("Error parsing " + jsonFile.getVirtualFile().getPath(), e);
        }
        return keys;
    }

    private static List<MetaConfigKey> getLocalMetaConfigKeys(Module localModule) {
        return (List)CachedValuesManager.getManager((Project)localModule.getProject()).getCachedValue((UserDataHolder)localModule, () -> {
            LinkedHashSet allModules = new LinkedHashSet();
            ModuleUtilCore.getDependencies((Module)localModule, allModules);
            boolean unitTestMode = ApplicationManager.getApplication().isUnitTestMode();
            if (ContainerUtil.process(allModules, module -> !SpringBootLibraryUtil.hasConfigurationMetadataAnnotationProcessor(module))) {
                Key libraryCheckDependency = unitTestMode ? PsiModificationTracker.MODIFICATION_COUNT : ProjectRootManager.getInstance((Project)localModule.getProject());
                return CachedValueProvider.Result.create(Collections.emptyList(), (Object[])new Object[]{libraryCheckDependency});
            }
            SmartList dependencies = new SmartList((Object)PsiModificationTracker.MODIFICATION_COUNT);
            ArrayList allKeys = new ArrayList();
            for (Module module2 : allModules) {
                File localJsonFile = SpringBootApplicationMetaConfigKeyManagerImpl.findLocalMetadataJsonFile((Module)module2, (String)"spring-configuration-metadata.json", (boolean)unitTestMode);
                if (localJsonFile == null) continue;
                ArrayList keys = new ArrayList();
                Processor collect = Processors.cancelableCollectProcessor(keys);
                try {
                    SpringBootConfigurationMetadataParser parser = new SpringBootConfigurationMetadataParser(module2, localJsonFile);
                    parser.processKeys(module2, (Processor<MetaConfigKey>)collect);
                }
                catch (ProcessCanceledException | IndexNotReadyException e) {
                    throw e;
                }
                catch (Throwable e) {
                    LOG.warn("Error parsing " + localJsonFile.getPath(), e);
                }
                allKeys.addAll(keys);
                ContainerUtil.addIfNotNull((Collection)dependencies, (Object)LocalFileSystem.getInstance().findFileByIoFile(localJsonFile));
            }
            return CachedValueProvider.Result.create(allKeys, (Object[])ArrayUtil.toObjectArray((Collection)dependencies));
        });
    }

    @NotNull
    public MetaConfigKeyManager.ConfigKeyNameBinder getConfigKeyNameBinder(@NotNull Module module) {
        if (module == null) {
            SpringBootApplicationMetaConfigKeyManagerImpl.$$$reportNull$$$0(0);
        }
        if (SpringBootLibraryUtil.isBelowVersion(module, SpringBootLibraryUtil.SpringBootVersion.VERSION_2_0_0)) {
            MetaConfigKeyManager.ConfigKeyNameBinder configKeyNameBinder = ourRelaxedConfigKeyNameBinder;
            if (configKeyNameBinder == null) {
                SpringBootApplicationMetaConfigKeyManagerImpl.$$$reportNull$$$0(1);
            }
            return configKeyNameBinder;
        }
        MetaConfigKeyManager.ConfigKeyNameBinder configKeyNameBinder = ourBinderConfigKeyNameBinder;
        if (configKeyNameBinder == null) {
            SpringBootApplicationMetaConfigKeyManagerImpl.$$$reportNull$$$0(2);
        }
        return configKeyNameBinder;
    }

    protected boolean isCaseSensitiveKeys() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/boot/application/metadata/SpringBootApplicationMetaConfigKeyManagerImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/boot/application/metadata/SpringBootApplicationMetaConfigKeyManagerImpl";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigKeyNameBinder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getConfigKeyNameBinder";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

