/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.metadata;

import com.intellij.microservices.config.ConfigKeyParts;
import com.intellij.microservices.config.MetaConfigKey;
import com.intellij.microservices.config.MetaConfigKeyManager;
import com.intellij.openapi.util.text.CharFilter;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class BinderConfigKeyNameBinder
implements MetaConfigKeyManager.ConfigKeyNameBinder {
    private static final CharFilter UNIFORM_CHAR_FILTER = ch -> Character.isLetterOrDigit(ch) || ch == '.';

    BinderConfigKeyNameBinder() {
    }

    public boolean bindsTo(@NotNull MetaConfigKey key, @NotNull String configKeyText) {
        if (key == null) {
            BinderConfigKeyNameBinder.$$$reportNull$$$0(0);
        }
        if (configKeyText == null) {
            BinderConfigKeyNameBinder.$$$reportNull$$$0(1);
        }
        if (!BinderConfigKeyNameBinder.matchesFirstChar(key.getName(), configKeyText)) {
            return false;
        }
        String uniformKeyName = BinderConfigKeyNameBinder.toUniform(key.getName());
        String cleanupConfigKeyText = BinderConfigKeyNameBinder.toUniform(configKeyText);
        boolean exactMatch = uniformKeyName.equals(cleanupConfigKeyText);
        if (key.isAccessType(new MetaConfigKey.AccessType[]{MetaConfigKey.AccessType.NORMAL})) {
            return exactMatch;
        }
        if (key.isAccessType(MetaConfigKey.AccessType.MAP_GROUP)) {
            return exactMatch || StringUtil.startsWith((CharSequence)cleanupConfigKeyText, (CharSequence)(uniformKeyName + "."));
        }
        if (key.isAccessType(new MetaConfigKey.AccessType[]{MetaConfigKey.AccessType.INDEXED})) {
            if (exactMatch) {
                return true;
            }
            if (!StringUtil.containsChar((String)configKeyText, (char)'[')) {
                return false;
            }
            String beforeIndexAccess = StringUtil.substringBefore((String)configKeyText, (String)"[");
            assert (beforeIndexAccess != null);
            beforeIndexAccess = StringUtil.trimEnd((String)beforeIndexAccess, (char)'.');
            return uniformKeyName.equals(BinderConfigKeyNameBinder.toUniform(beforeIndexAccess));
        }
        throw new IllegalArgumentException("unknown access type for " + key);
    }

    public boolean matchesPrefix(@NotNull MetaConfigKey key, @NotNull String prefixText) {
        if (key == null) {
            BinderConfigKeyNameBinder.$$$reportNull$$$0(2);
        }
        if (prefixText == null) {
            BinderConfigKeyNameBinder.$$$reportNull$$$0(3);
        }
        if (!BinderConfigKeyNameBinder.matchesFirstChar(key.getName(), prefixText)) {
            return false;
        }
        String uniformKeyName = BinderConfigKeyNameBinder.toUniform(key.getName());
        return StringUtil.startsWith((CharSequence)uniformKeyName, (CharSequence)BinderConfigKeyNameBinder.toUniform(prefixText));
    }

    public boolean matchesPart(@NotNull String keyPart, @NotNull String text) {
        if (keyPart == null) {
            BinderConfigKeyNameBinder.$$$reportNull$$$0(4);
        }
        if (text == null) {
            BinderConfigKeyNameBinder.$$$reportNull$$$0(5);
        }
        if (!BinderConfigKeyNameBinder.matchesFirstChar(keyPart, text)) {
            return false;
        }
        return BinderConfigKeyNameBinder.matches(keyPart, text);
    }

    @Nullable
    public String bindsToKeyProperty(@NotNull MetaConfigKey key, @Nullable String keyProperty, @NotNull String configKeyText) {
        if (key == null) {
            BinderConfigKeyNameBinder.$$$reportNull$$$0(6);
        }
        if (configKeyText == null) {
            BinderConfigKeyNameBinder.$$$reportNull$$$0(7);
        }
        if (key.isAccessType(new MetaConfigKey.AccessType[]{MetaConfigKey.AccessType.NORMAL})) {
            return null;
        }
        String keyName = key.getName();
        if (!BinderConfigKeyNameBinder.matchesFirstChar(keyName, configKeyText)) {
            return null;
        }
        ConfigKeyParts parts = ConfigKeyParts.splitToParts((MetaConfigKey)key, (String)configKeyText, (boolean)true);
        return parts != null ? parts.getKeyIndexIfMatches(keyName, keyProperty, BinderConfigKeyNameBinder::matches) : null;
    }

    private static boolean matchesFirstChar(String keyName, @NotNull String configKeyText) {
        if (configKeyText == null) {
            BinderConfigKeyNameBinder.$$$reportNull$$$0(8);
        }
        return !configKeyText.isEmpty() && StringUtil.charsEqualIgnoreCase((char)keyName.charAt(0), (char)configKeyText.charAt(0));
    }

    private static boolean matches(String keyName, String configKey) {
        return BinderConfigKeyNameBinder.toUniform(keyName).equals(BinderConfigKeyNameBinder.toUniform(configKey));
    }

    @NotNull
    private static String toUniform(String input) {
        String lowerCase = StringUtil.toLowerCase((String)input);
        if (StringUtil.isLatinAlphanumeric((CharSequence)lowerCase)) {
            String string = lowerCase;
            if (string == null) {
                BinderConfigKeyNameBinder.$$$reportNull$$$0(9);
            }
            return string;
        }
        String string = StringUtil.strip((String)lowerCase, (CharFilter)UNIFORM_CHAR_FILTER);
        if (string == null) {
            BinderConfigKeyNameBinder.$$$reportNull$$$0(10);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 1: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configKeyText";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefixText";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyPart";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/boot/application/metadata/BinderConfigKeyNameBinder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/boot/application/metadata/BinderConfigKeyNameBinder";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "toUniform";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "bindsTo";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "matchesPrefix";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "matchesPart";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "bindsToKeyProperty";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "matchesFirstChar";
                break;
            }
            case 9: 
            case 10: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

