/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.config.hints;

import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.microservices.config.MetaConfigKey;
import com.intellij.microservices.config.hints.HintReferenceBase;
import com.intellij.microservices.config.hints.HintReferenceProviderBase;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.spring.boot.application.metadata.SpringBootValueHintPsiElement;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import icons.SpringBootApiIcons;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ValueHintReferenceProvider
extends HintReferenceProviderBase {
    private final List<? extends MetaConfigKey.ValueHint> myValueHints;
    private final MetaConfigKey myConfigKey;
    private final int myStartInElement;
    private final boolean myAllowOtherValues;

    ValueHintReferenceProvider(MetaConfigKey configKey, List<? extends MetaConfigKey.ValueHint> valueHints, String prefix, boolean allowOtherValues) {
        this.myConfigKey = configKey;
        this.myValueHints = valueHints;
        this.myStartInElement = prefix.length();
        this.myAllowOtherValues = allowOtherValues;
    }

    protected boolean canProcess(@NotNull PsiElement element, @NotNull List<TextRange> textRanges, @NotNull ProcessingContext context) {
        if (element == null) {
            ValueHintReferenceProvider.$$$reportNull$$$0(0);
        }
        if (textRanges == null) {
            ValueHintReferenceProvider.$$$reportNull$$$0(1);
        }
        if (context == null) {
            ValueHintReferenceProvider.$$$reportNull$$$0(2);
        }
        for (TextRange range : textRanges) {
            if (range.getEndOffset() >= this.myStartInElement) continue;
            return false;
        }
        return true;
    }

    @NotNull
    protected PsiReference createReference(PsiElement element, TextRange textRange, ProcessingContext context) {
        TextRange shiftTextRange = textRange.shiftRight(this.myStartInElement).grown(-this.myStartInElement);
        return new HintReferenceBase(element, shiftTextRange){

            public TextAttributesKey getTextAttributesKey() {
                return DefaultLanguageHighlighterColors.INSTANCE_METHOD;
            }

            public boolean isSoft() {
                return ValueHintReferenceProvider.this.myAllowOtherValues;
            }

            @Nullable
            protected PsiElement doResolve() {
                String value = this.getValue();
                MetaConfigKey.ValueHint valueHint = (MetaConfigKey.ValueHint)ContainerUtil.find(ValueHintReferenceProvider.this.myValueHints, hint -> hint.getValue().equals(value));
                return valueHint != null ? new SpringBootValueHintPsiElement(this.getElement(), valueHint) : null;
            }

            public Object @NotNull [] getVariants() {
                Object[] objectArray = ContainerUtil.map2Array(ValueHintReferenceProvider.this.myValueHints, LookupElementBuilder.class, hint -> {
                    LookupElementBuilder builder = LookupElementBuilder.create((PsiNamedElement)new SpringBootValueHintPsiElement(this.getElement(), (MetaConfigKey.ValueHint)hint)).withBoldness(hint.getValue().equals(ValueHintReferenceProvider.this.myConfigKey.getDefaultValue()));
                    String shortDescriptionText = hint.getDescriptionText().getShortText();
                    if (StringUtil.isNotEmpty((String)shortDescriptionText)) {
                        builder = builder.appendTailText(" (" + shortDescriptionText + ")", true);
                    }
                    return builder.withIcon(SpringBootApiIcons.SpringBoot);
                });
                if (objectArray == null) {
                    1.$$$reportNull$$$0(0);
                }
                return objectArray;
            }

            @NotNull
            public String getUnresolvedMessagePattern() {
                String[] valueHintNames = (String[])ContainerUtil.map2Array(ValueHintReferenceProvider.this.myValueHints, String.class, hint -> "''" + hint.getValue() + "''");
                String string = "Invalid value ''{0}'', must be one of " + StringUtil.join((String[])valueHintNames, (String)"|");
                if (string == null) {
                    1.$$$reportNull$$$0(1);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/spring/boot/application/config/hints/ValueHintReferenceProvider$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getVariants";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getUnresolvedMessagePattern";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "textRanges";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "context";
                break;
            }
        }
        objectArray[1] = "com/intellij/spring/boot/application/config/hints/ValueHintReferenceProvider";
        objectArray[2] = "canProcess";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

