/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.config.hints;

import com.intellij.microservices.config.hints.HintReferenceProviderBase;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.spring.spi.SpringSpiClassesListJamConverter;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;

class SpringSpiClassesProvider
extends HintReferenceProviderBase {
    private final String myKey;

    SpringSpiClassesProvider(String key) {
        this.myKey = key;
    }

    @NotNull
    protected PsiReference createReference(PsiElement element, TextRange textRange, ProcessingContext context) {
        String elementText = element.getText();
        TextRange trimmedRange = SpringSpiClassesProvider.getTrimmedRange(textRange, elementText);
        String trimmedText = trimmedRange.substring(elementText);
        return new SpringSpiClassesListJamConverter.SpringSpiClassReference(this.myKey, element, trimmedRange, trimmedText);
    }

    private static TextRange getTrimmedRange(TextRange textRange, String elementText) {
        int offset;
        String text = textRange.substring(elementText);
        for (offset = 0; offset < text.length() && Character.isWhitespace(text.charAt(offset)); ++offset) {
        }
        int length = text.length();
        if (offset != length) {
            while (length > 0 && Character.isWhitespace(text.charAt(length - 1))) {
                --length;
            }
        }
        return TextRange.from((int)(textRange.getStartOffset() + offset), (int)(length - offset));
    }
}

