/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.config.hints;

import com.intellij.microservices.config.ConfigKeyPathReference;
import com.intellij.microservices.config.MetaConfigKey;
import com.intellij.microservices.config.hints.BooleanHintReferenceProvider;
import com.intellij.microservices.config.hints.ClassHintReferenceProvider;
import com.intellij.microservices.config.hints.EncodingHintReferenceProvider;
import com.intellij.microservices.config.hints.EnumHintReferenceProvider;
import com.intellij.microservices.config.hints.FloatHintReferenceProvider;
import com.intellij.microservices.config.hints.HintReferenceBase;
import com.intellij.microservices.config.hints.HintReferenceProvider;
import com.intellij.microservices.config.hints.HintReferenceProviderBase;
import com.intellij.microservices.config.hints.IntegerHintReferenceProvider;
import com.intellij.microservices.config.hints.LocaleHintReferenceProvider;
import com.intellij.microservices.config.hints.LongHintReferenceProvider;
import com.intellij.microservices.config.hints.StaticValuesHintReferenceProvider;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.impl.beanProperties.BeanPropertyElement;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.spring.boot.application.config.SpringBootHintReferencesProvider;
import com.intellij.spring.boot.application.config.hints.BeanReferenceProvider;
import com.intellij.spring.boot.application.config.hints.DataSizeReferenceProvider;
import com.intellij.spring.boot.application.config.hints.DurationReferenceProvider;
import com.intellij.spring.boot.application.config.hints.LoggerNameReferenceProvider;
import com.intellij.spring.boot.application.config.hints.RegExReferenceProvider;
import com.intellij.spring.boot.application.config.hints.ResourceReferenceProvider;
import com.intellij.spring.boot.application.config.hints.SpringBootCustomHintReferenceProvider;
import com.intellij.spring.boot.application.config.hints.SpringBootHintRegistryInfo;
import com.intellij.spring.boot.application.config.hints.SpringBootHintRegistryKey;
import com.intellij.spring.boot.application.config.hints.SpringSpiClassesProvider;
import com.intellij.spring.boot.application.config.hints.ValueHintReferenceProvider;
import com.intellij.spring.boot.application.metadata.SpringBootValueProvider;
import com.intellij.spring.boot.library.SpringBootLibraryUtil;
import com.intellij.spring.model.converters.PatternFileReferenceSet;
import com.intellij.spring.profiles.SpringProfilePsiReference;
import com.intellij.spring.profiles.SpringProfilesFactory;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ProcessingContext;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.XmlSerializer;
import com.intellij.xml.util.documentation.MimeTypeDictionary;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SpringBootHintReferencesProviderImpl
extends SpringBootHintReferencesProvider
implements Disposable {
    private static final String STATIC = "static";
    private static final String ENUM_VALUES = "enumValues";
    private static final String REGEX = "regex";
    private static final String RESOURCE = "resource";
    private static final String PATH_PATTERN = "pathPattern";
    private static final String CONTENT_TYPE = "contentType";
    private static final String SPRING_PROFILE_NAME = SpringBootValueProvider.SPRING_PROFILE_NAME.getId();
    private static final String SPRING_PROFILE_EXPRESSION = "spring-profile-expression";
    private static final String SPRING_SPI_CLASSES = "springSpiClasses";
    private static final ExtensionPointName<SpringBootCustomHintReferenceProvider> CUSTOM_HINT_REFERENCE_PROVIDER_EP_NAME = new ExtensionPointName("com.intellij.spring.boot.customHintReferenceProvider");
    private final HintReferenceProvider mySpringProfileNameHintReferenceProvider = new HintReferenceProviderBase(){

        protected boolean canProcess(@NotNull PsiElement element, @NotNull List<TextRange> textRanges, @NotNull ProcessingContext context) {
            if (element == null) {
                1.$$$reportNull$$$0(0);
            }
            if (textRanges == null) {
                1.$$$reportNull$$$0(1);
            }
            if (context == null) {
                1.$$$reportNull$$$0(2);
            }
            return ModuleUtilCore.findModuleForPsiElement((PsiElement)element) != null;
        }

        @NotNull
        protected PsiReference createReference(PsiElement element, TextRange textRange, ProcessingContext context) {
            String elementText = element.getText();
            String tokenText = textRange.substring(elementText);
            if (StringUtil.startsWithChar((CharSequence)tokenText, (char)'!')) {
                textRange = textRange.shiftRight(1).grown(-1);
            }
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
            assert (module != null);
            return new SpringProfilePsiReference(element, textRange, module, false);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "element";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "textRanges";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
            }
            objectArray[1] = "com/intellij/spring/boot/application/config/hints/SpringBootHintReferencesProviderImpl$1";
            objectArray[2] = "canProcess";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };
    private final HintReferenceProvider myDummyProvider = new HintReferenceProvider(){

        public PsiReference[] getReferences(@NotNull PsiElement element, @NotNull List<TextRange> textRanges, @NotNull ProcessingContext context) {
            if (element == null) {
                2.$$$reportNull$$$0(0);
            }
            if (textRanges == null) {
                2.$$$reportNull$$$0(1);
            }
            if (context == null) {
                2.$$$reportNull$$$0(2);
            }
            return PsiReference.EMPTY_ARRAY;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "element";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "textRanges";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
            }
            objectArray[1] = "com/intellij/spring/boot/application/config/hints/SpringBootHintReferencesProviderImpl$2";
            objectArray[2] = "getReferences";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };
    private final StaticValuesHintReferenceProvider myLocaleProvider = new LocaleHintReferenceProvider();
    private final StaticValuesHintReferenceProvider myContentTypeProvider = new StaticValuesHintReferenceProvider(true, true, null, MimeTypeDictionary.HTML_CONTENT_TYPES);
    private final EncodingHintReferenceProvider myEncodingProvider = new EncodingHintReferenceProvider();
    private final Map<String, String> myExplicitMappings = new HashMap<String, String>();
    private final Map<String, HintReferenceProvider> myExplicitProviders = new HashMap<String, HintReferenceProvider>();
    private final Map<String, HintReferenceProvider> myBuiltinProviders = new HashMap<String, HintReferenceProvider>();
    private final Set<String> myOverrideKeys = new HashSet<String>();
    private final Map<String, HintReferenceProvider> myByTypeProviders = ContainerUtil.immutableMapBuilder().put((Object)"java.lang.Boolean", (Object)new BooleanHintReferenceProvider()).put((Object)"java.lang.Integer", (Object)new IntegerHintReferenceProvider()).put((Object)"java.lang.Long", (Object)new LongHintReferenceProvider()).put((Object)"java.lang.Float", (Object)new FloatHintReferenceProvider()).put((Object)"java.nio.charset.Charset", (Object)this.myEncodingProvider).put((Object)"org.springframework.util.MimeType", (Object)this.myContentTypeProvider).put((Object)"org.springframework.http.MediaType", (Object)this.myContentTypeProvider).put((Object)"org.springframework.core.io.Resource", (Object)new ResourceReferenceProvider()).put((Object)"java.util.Locale", (Object)this.myLocaleProvider).put((Object)"java.time.Duration", (Object)new DurationReferenceProvider()).put((Object)"org.springframework.util.unit.DataSize", (Object)new DataSizeReferenceProvider()).build();

    private SpringBootHintReferencesProviderImpl() {
        this.myBuiltinProviders.put(SPRING_PROFILE_NAME, this.mySpringProfileNameHintReferenceProvider);
        this.myBuiltinProviders.put(SPRING_PROFILE_EXPRESSION, new HintReferenceProvider(){

            public PsiReference[] getReferences(@NotNull PsiElement element, @NotNull List<TextRange> textRanges, @NotNull ProcessingContext context) {
                Module module;
                if (element == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (textRanges == null) {
                    3.$$$reportNull$$$0(1);
                }
                if (context == null) {
                    3.$$$reportNull$$$0(2);
                }
                if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element)) == null) {
                    return PsiReference.EMPTY_ARRAY;
                }
                SmartList result2 = new SmartList();
                String elementText = element.getText();
                int offset = ElementManipulators.getOffsetInElement((PsiElement)element);
                for (TextRange textRange : textRanges) {
                    String profile = textRange.substring(elementText);
                    try {
                        SpringProfilesFactory.getInstance().parseProfileExpressions((Collection)new SmartList((Object)profile));
                        Object[] references = SpringProfilesFactory.getInstance().getProfilesReferences(module, element, profile, textRange.getStartOffset() - offset, "()&|", false);
                        ContainerUtil.addAll((Collection)result2, (Object[])references);
                    }
                    catch (SpringProfilesFactory.MalformedProfileExpressionException e) {
                        SpringProfilePsiReference delegate = new SpringProfilePsiReference(element, textRange, module, false);
                        result2.add(new MalformedProfileExpressionReference(element, textRange, e.getMessage(), (PsiReference)delegate));
                    }
                }
                return result2.toArray(PsiReference.EMPTY_ARRAY);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "textRanges";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "context";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/spring/boot/application/config/hints/SpringBootHintReferencesProviderImpl$3";
                objectArray[2] = "getReferences";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        this.myBuiltinProviders.put(RESOURCE, new ResourceReferenceProvider());
        this.myBuiltinProviders.put(PATH_PATTERN, new HintReferenceProvider(){

            public PsiReference[] getReferences(@NotNull PsiElement element, @NotNull List<TextRange> textRanges, @NotNull ProcessingContext context) {
                if (element == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (textRanges == null) {
                    4.$$$reportNull$$$0(1);
                }
                if (context == null) {
                    4.$$$reportNull$$$0(2);
                }
                String valueText = element.getText();
                Object[] allReferences = PsiReference.EMPTY_ARRAY;
                for (TextRange range : textRanges) {
                    Object[] references = new PatternFileReferenceSet(range.substring(valueText), element, range.getStartOffset(), true).getAllReferences();
                    allReferences = (PsiReference[])ArrayUtil.mergeArrays((Object[])allReferences, (Object[])references);
                }
                return allReferences;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "textRanges";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "context";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/spring/boot/application/config/hints/SpringBootHintReferencesProviderImpl$4";
                objectArray[2] = "getReferences";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        this.myBuiltinProviders.put(CONTENT_TYPE, (HintReferenceProvider)this.myContentTypeProvider);
        this.loadExplicitMappings();
        CUSTOM_HINT_REFERENCE_PROVIDER_EP_NAME.addChangeListener(() -> {
            this.myOverrideKeys.clear();
            this.myExplicitProviders.clear();
            this.myExplicitMappings.clear();
            this.loadExplicitMappings();
        }, (Disposable)this);
    }

    private void loadExplicitMappings() {
        URL url = SpringBootHintReferencesProviderImpl.class.getResource("spring-boot-hint-registry.xml");
        SpringBootHintRegistryInfo info = (SpringBootHintRegistryInfo)XmlSerializer.deserialize((URL)url, SpringBootHintRegistryInfo.class);
        HashMap<String, SpringBootCustomHintReferenceProvider> customProviders = new HashMap<String, SpringBootCustomHintReferenceProvider>();
        for (SpringBootCustomHintReferenceProvider customProvider : (SpringBootCustomHintReferenceProvider[])CUSTOM_HINT_REFERENCE_PROVIDER_EP_NAME.getExtensions()) {
            customProviders.put(customProvider.getId(), customProvider);
        }
        for (SpringBootHintRegistryKey key : Objects.requireNonNull(info).myKeys) {
            String providerId = key.myProvider;
            if (key.myOverride) {
                this.myOverrideKeys.add(key.myId);
            }
            if (providerId.equals(STATIC) || providerId.equals(ENUM_VALUES)) {
                this.myExplicitProviders.put(key.myId, SpringBootHintReferencesProviderImpl.createStaticOrEnumReferenceProvider(key));
                continue;
            }
            if (providerId.equals(SpringBootValueProvider.SPRING_BEAN_REFERENCE.getId())) {
                this.myExplicitProviders.put(key.myId, new BeanReferenceProvider(key.myValue));
                continue;
            }
            if (providerId.equals(SpringBootValueProvider.CLASS_REFERENCE.getId())) {
                this.myExplicitProviders.put(key.myId, SpringBootHintReferencesProviderImpl.createClassReferenceProvider(key.myValue, key.myAllowOtherValues, true));
                continue;
            }
            if (providerId.equals(REGEX)) {
                this.myExplicitProviders.put(key.myId, (HintReferenceProvider)new RegExReferenceProvider(key.myValue));
                continue;
            }
            if (providerId.equals(RESOURCE) || providerId.equals(PATH_PATTERN) || providerId.equals(SPRING_PROFILE_NAME) || providerId.equals(SPRING_PROFILE_EXPRESSION) || providerId.equals(CONTENT_TYPE)) {
                this.myExplicitMappings.put(key.myId, providerId);
                continue;
            }
            if (providerId.equals(SPRING_SPI_CLASSES)) {
                this.myExplicitProviders.put(key.myId, (HintReferenceProvider)new SpringSpiClassesProvider(key.myValue));
                continue;
            }
            SpringBootCustomHintReferenceProvider customProvider = (SpringBootCustomHintReferenceProvider)customProviders.get(providerId);
            if (customProvider != null) {
                this.myExplicitProviders.put(key.myId, customProvider);
                continue;
            }
            if (key.myOptional) {
                if (!key.myOverride) continue;
                this.myOverrideKeys.remove(key.myId);
                continue;
            }
            throw new IllegalArgumentException(providerId);
        }
    }

    @Override
    public PsiReference @NotNull [] getKeyReferences(Module module, MetaConfigKey configKey, PsiElement keyPsiElement, ProcessingContext context) {
        if (configKey.getKeyItemHint() != MetaConfigKey.ItemHint.NONE) {
            context.put(HINT_REFERENCES_CONFIG_KEY, (Object)configKey);
            return this.getItemHintReferences(configKey, ItemHintType.KEY, keyPsiElement, Collections.singletonList(ElementManipulators.getValueTextRange((PsiElement)keyPsiElement)), context);
        }
        if (PsiReference.EMPTY_ARRAY == null) {
            SpringBootHintReferencesProviderImpl.$$$reportNull$$$0(0);
        }
        return PsiReference.EMPTY_ARRAY;
    }

    @Override
    public PsiReference @NotNull [] getValueReferences(Module module, MetaConfigKey configKey, @Nullable PsiElement keyPsiElement, PsiElement valuePsiElement, List<TextRange> valueTextRanges, ProcessingContext context) {
        context.put(HINT_REFERENCES_CONFIG_KEY, (Object)configKey);
        if (SpringBootLibraryUtil.isBelowVersion(module, SpringBootLibraryUtil.SpringBootVersion.VERSION_1_3_0)) {
            PsiReference[] psiReferenceArray = this.getFallbackProvider(configKey).getReferences(valuePsiElement, valueTextRanges, context);
            if (psiReferenceArray == null) {
                SpringBootHintReferencesProviderImpl.$$$reportNull$$$0(1);
            }
            return psiReferenceArray;
        }
        if (configKey.getItemHint() != MetaConfigKey.ItemHint.NONE) {
            return this.getItemHintReferences(configKey, ItemHintType.VALUE, valuePsiElement, valueTextRanges, context);
        }
        HintReferenceProvider byTypeOrExplicitProvider = this.getByTypeOrExplicitProvider(configKey);
        if (byTypeOrExplicitProvider != this.myDummyProvider) {
            PsiReference[] psiReferenceArray = byTypeOrExplicitProvider.getReferences(valuePsiElement, valueTextRanges, context);
            if (psiReferenceArray == null) {
                SpringBootHintReferencesProviderImpl.$$$reportNull$$$0(2);
            }
            return psiReferenceArray;
        }
        if (keyPsiElement == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                SpringBootHintReferencesProviderImpl.$$$reportNull$$$0(3);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        PsiReference[] overrideOtherReferences = new PsiReference[]{PsiReferenceBase.createSelfReference((PsiElement)valuePsiElement, (PsiElement)valuePsiElement)};
        if (!MetaConfigKey.MAP_OR_INDEXED_WITHOUT_KEY_HINTS_CONDITION.value((Object)configKey)) {
            if (overrideOtherReferences == null) {
                SpringBootHintReferencesProviderImpl.$$$reportNull$$$0(4);
            }
            return overrideOtherReferences;
        }
        HintReferenceProvider pojoReferenceProvider = this.getPojoValueProvider(keyPsiElement);
        if (pojoReferenceProvider != null) {
            PsiReference[] psiReferenceArray = pojoReferenceProvider.getReferences(valuePsiElement, valueTextRanges, context);
            if (psiReferenceArray == null) {
                SpringBootHintReferencesProviderImpl.$$$reportNull$$$0(5);
            }
            return psiReferenceArray;
        }
        if (overrideOtherReferences == null) {
            SpringBootHintReferencesProviderImpl.$$$reportNull$$$0(6);
        }
        return overrideOtherReferences;
    }

    @Nullable
    private HintReferenceProvider getPojoValueProvider(@NotNull PsiElement keyPsiElement) {
        PsiReference lastReference;
        if (keyPsiElement == null) {
            SpringBootHintReferencesProviderImpl.$$$reportNull$$$0(7);
        }
        if (!((lastReference = (PsiReference)ArrayUtil.getLastElement((Object[])keyPsiElement.getReferences())) instanceof ConfigKeyPathReference)) {
            return null;
        }
        ConfigKeyPathReference configKeyPathReference = (ConfigKeyPathReference)lastReference;
        if (configKeyPathReference.getPathType() != ConfigKeyPathReference.PathType.BEAN_PROPERTY) {
            return null;
        }
        PsiElement resolve = configKeyPathReference.resolve();
        if (!(resolve instanceof BeanPropertyElement)) {
            return null;
        }
        PsiType type = ((BeanPropertyElement)resolve).getPropertyType();
        if (type instanceof PsiPrimitiveType) {
            type = ((PsiPrimitiveType)type).getBoxedType(keyPsiElement);
        }
        return this.getByTypeProvider(type);
    }

    @NotNull
    private HintReferenceProvider getByTypeOrExplicitProvider(MetaConfigKey configKey) {
        HintReferenceProvider explicitValuesProvider = this.getExplicitProvider(configKey, true);
        if (explicitValuesProvider != null) {
            HintReferenceProvider hintReferenceProvider = explicitValuesProvider;
            if (hintReferenceProvider == null) {
                SpringBootHintReferencesProviderImpl.$$$reportNull$$$0(8);
            }
            return hintReferenceProvider;
        }
        HintReferenceProvider byTypeProvider = this.getByTypeProvider(configKey);
        if (byTypeProvider != null) {
            HintReferenceProvider hintReferenceProvider = byTypeProvider;
            if (hintReferenceProvider == null) {
                SpringBootHintReferencesProviderImpl.$$$reportNull$$$0(9);
            }
            return hintReferenceProvider;
        }
        HintReferenceProvider hintReferenceProvider = this.myDummyProvider;
        if (hintReferenceProvider == null) {
            SpringBootHintReferencesProviderImpl.$$$reportNull$$$0(10);
        }
        return hintReferenceProvider;
    }

    private PsiReference @NotNull [] getItemHintReferences(MetaConfigKey configKey, ItemHintType itemHintType, PsiElement element, List<TextRange> valueTextRanges, ProcessingContext context) {
        List<HintReferenceProvider> providers = this.getItemHintProviders(element, configKey, itemHintType);
        if (providers.isEmpty()) {
            if (PsiReference.EMPTY_ARRAY == null) {
                SpringBootHintReferencesProviderImpl.$$$reportNull$$$0(11);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        Object[] allReferences = PsiReference.EMPTY_ARRAY;
        for (HintReferenceProvider provider : providers) {
            Object[] references = provider.getReferences(element, valueTextRanges, context);
            allReferences = (PsiReference[])ArrayUtil.mergeArrays((Object[])allReferences, (Object[])references);
        }
        if (allReferences == null) {
            SpringBootHintReferencesProviderImpl.$$$reportNull$$$0(12);
        }
        return allReferences;
    }

    private List<HintReferenceProvider> getItemHintProviders(PsiElement element, MetaConfigKey configKey, ItemHintType itemHintType) {
        MetaConfigKey.ItemHint keyOrValueHint = itemHintType == ItemHintType.VALUE ? configKey.getItemHint() : configKey.getKeyItemHint();
        String prefix = itemHintType == ItemHintType.VALUE ? "" : configKey.getName() + ".";
        List valueProviders = keyOrValueHint.getValueProviders();
        SmartList providers = new SmartList();
        List valueHints = keyOrValueHint.getValueHints();
        if (!valueHints.isEmpty()) {
            boolean hasValueProviders = !valueProviders.isEmpty();
            providers.add(new ValueHintReferenceProvider(configKey, valueHints, prefix, hasValueProviders));
        }
        if (valueProviders.isEmpty()) {
            return providers;
        }
        SpringBootValueProvider valueProvider = null;
        Map parameters = null;
        for (MetaConfigKey.ValueProvider provider : valueProviders) {
            valueProvider = SpringBootValueProvider.findById(provider.getName());
            if (valueProvider == null) continue;
            parameters = provider.getParameters();
            break;
        }
        if (valueProvider == null) {
            return providers;
        }
        if (itemHintType == ItemHintType.VALUE) {
            String target;
            if (valueProvider == SpringBootValueProvider.CLASS_REFERENCE) {
                target = (String)parameters.get("target");
                String concreteParameter = (String)parameters.get("concrete");
                Boolean concrete = concreteParameter == null ? Boolean.TRUE : Boolean.valueOf(concreteParameter);
                providers.add(SpringBootHintReferencesProviderImpl.createClassReferenceProvider(target, false, concrete));
            } else if (valueProvider == SpringBootValueProvider.SPRING_PROFILE_NAME) {
                providers.add(this.mySpringProfileNameHintReferenceProvider);
            } else if (valueProvider == SpringBootValueProvider.SPRING_BEAN_REFERENCE) {
                target = (String)parameters.get("target");
                providers.add(new BeanReferenceProvider(target));
            } else if (valueProvider == SpringBootValueProvider.HANDLE_AS && parameters.containsKey("target")) {
                target = (String)parameters.get("target");
                PsiType targetType = JavaPsiFacade.getElementFactory((Project)element.getProject()).createTypeFromText(target.replace('$', '.'), null);
                MetaConfigKey.AccessType targetAccessType = MetaConfigKey.AccessType.forPsiType((PsiType)targetType);
                PsiType effectiveTargetType = targetAccessType.getEffectiveValueType(targetType);
                if ((targetAccessType == MetaConfigKey.AccessType.MAP || targetAccessType == MetaConfigKey.AccessType.ENUM_MAP) && effectiveTargetType != null) {
                    MetaConfigKey.AccessType valueAccessType = MetaConfigKey.AccessType.forPsiType((PsiType)effectiveTargetType);
                    effectiveTargetType = valueAccessType.getEffectiveValueType(effectiveTargetType);
                }
                if (effectiveTargetType != null) {
                    targetType = effectiveTargetType;
                }
                ContainerUtil.addIfNotNull((Collection)providers, (Object)this.getByTypeProvider(targetType));
            }
        }
        if (valueProvider == SpringBootValueProvider.LOGGER_NAME) {
            String group = (String)parameters.get("group");
            boolean resolveGroups = group == null || Boolean.parseBoolean(group);
            providers.add(new LoggerNameReferenceProvider(prefix, resolveGroups));
        }
        return providers;
    }

    @Nullable
    private HintReferenceProvider getByTypeProvider(MetaConfigKey configKey) {
        PsiType valueType = configKey.getEffectiveValueType();
        if (valueType == null) {
            return null;
        }
        if (configKey.isAccessType(MetaConfigKey.AccessType.MAP_GROUP)) {
            MetaConfigKey.AccessType valueAccessType = MetaConfigKey.AccessType.forPsiType((PsiType)valueType);
            valueType = valueAccessType.getEffectiveValueType(valueType);
        }
        return this.getByTypeProvider(valueType);
    }

    @Nullable
    private HintReferenceProvider getByTypeProvider(@Nullable PsiType valueType) {
        if (valueType == null) {
            return null;
        }
        PsiClass typeClass = PsiTypesUtil.getPsiClass((PsiType)valueType);
        if (typeClass == null) {
            return null;
        }
        if (typeClass.isEnum()) {
            return new EnumHintReferenceProvider(typeClass);
        }
        String typeFqn = typeClass.getQualifiedName();
        if (typeFqn == null) {
            return null;
        }
        if ("java.lang.Class".equals(typeFqn)) {
            PsiType[] parameters = ((PsiClassType)valueType).getParameters();
            if (parameters.length != 1) {
                return SpringBootHintReferencesProviderImpl.createClassReferenceProvider(null, false, Boolean.TRUE);
            }
            PsiType typeParameter = parameters[0];
            if (!(typeParameter instanceof PsiWildcardType)) {
                return null;
            }
            PsiWildcardType parameter = (PsiWildcardType)typeParameter;
            return SpringBootHintReferencesProviderImpl.createClassReferenceProvider(parameter.getExtendsBound().getCanonicalText(), false, Boolean.TRUE);
        }
        return this.myByTypeProviders.get(typeFqn);
    }

    @Nullable
    private HintReferenceProvider getExplicitProvider(MetaConfigKey configKey, boolean isSpringBoot13OrHigher) {
        String configKeyName = configKey.getName();
        if (isSpringBoot13OrHigher && !this.myOverrideKeys.contains(configKeyName)) {
            return null;
        }
        HintReferenceProvider byKey = this.myExplicitProviders.get(configKeyName);
        if (byKey != null) {
            return byKey;
        }
        String explicitProviderId = this.myExplicitMappings.get(configKeyName);
        if (explicitProviderId == null) {
            return null;
        }
        HintReferenceProvider provider = this.myBuiltinProviders.get(explicitProviderId);
        if (provider == null) {
            throw new IllegalStateException("provider id '" + explicitProviderId + "' not found, configured for " + configKey);
        }
        return provider;
    }

    private HintReferenceProvider getFallbackProvider(MetaConfigKey configKey) {
        HintReferenceProvider byTypeProvider = this.getByTypeProvider(configKey);
        if (byTypeProvider != null) {
            return byTypeProvider;
        }
        HintReferenceProvider explicitReferenceProvider = this.getExplicitProvider(configKey, false);
        if (explicitReferenceProvider != null) {
            return explicitReferenceProvider;
        }
        String configKeyName = configKey.getName();
        if (StringUtil.endsWith((CharSequence)configKeyName, (CharSequence)"encoding") || StringUtil.endsWith((CharSequence)configKeyName, (CharSequence)"charset")) {
            return this.myEncodingProvider;
        }
        if (StringUtil.endsWith((CharSequence)configKeyName, (CharSequence)"content-type") || StringUtil.endsWith((CharSequence)configKeyName, (CharSequence)"mime-types")) {
            return this.myContentTypeProvider;
        }
        if (StringUtil.endsWith((CharSequence)configKeyName, (CharSequence)"locale")) {
            return this.myLocaleProvider;
        }
        return this.myDummyProvider;
    }

    public void dispose() {
    }

    private static HintReferenceProvider createStaticOrEnumReferenceProvider(SpringBootHintRegistryKey key) {
        String[] values = (String[])ContainerUtil.map2Array((Collection)StringUtil.split((String)key.myValue, (String)","), String.class, StringUtil::trim);
        return new StaticValuesHintReferenceProvider(key.myAllowOtherValues, key.myProvider.equals(ENUM_VALUES), null, values);
    }

    @NotNull
    private static HintReferenceProvider createClassReferenceProvider(String baseClass, boolean allowOtherValues, Boolean concrete) {
        return new ClassHintReferenceProvider(baseClass, allowOtherValues, concrete);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/boot/application/config/hints/SpringBootHintReferencesProviderImpl";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyPsiElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyReferences";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueReferences";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/boot/application/config/hints/SpringBootHintReferencesProviderImpl";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getByTypeOrExplicitProvider";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getItemHintReferences";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getPojoValueProvider";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class MalformedProfileExpressionReference
    extends HintReferenceBase {
        private final String myMessage;
        private final PsiReference myDelegate;

        private MalformedProfileExpressionReference(@NotNull PsiElement element, TextRange rangeInElement, String message, PsiReference delegate) {
            if (element == null) {
                MalformedProfileExpressionReference.$$$reportNull$$$0(0);
            }
            super(element, rangeInElement);
            this.myMessage = message;
            this.myDelegate = delegate;
        }

        @Nullable
        protected PsiElement doResolve() {
            return null;
        }

        public Object @NotNull [] getVariants() {
            Object[] objectArray = this.myDelegate.getVariants();
            if (objectArray == null) {
                MalformedProfileExpressionReference.$$$reportNull$$$0(1);
            }
            return objectArray;
        }

        @NotNull
        public String getUnresolvedMessagePattern() {
            String string = this.myMessage;
            if (string == null) {
                MalformedProfileExpressionReference.$$$reportNull$$$0(2);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/spring/boot/application/config/hints/SpringBootHintReferencesProviderImpl$MalformedProfileExpressionReference";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/spring/boot/application/config/hints/SpringBootHintReferencesProviderImpl$MalformedProfileExpressionReference";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVariants";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUnresolvedMessagePattern";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static enum ItemHintType {
        VALUE,
        KEY;

    }
}

