/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.config;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.microservices.config.MetaConfigKey;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.spring.boot.SpringBootApiBundle;
import com.intellij.spring.boot.application.metadata.additional.DefineLocalMetaConfigKeyFix;

public class SpringBootConfigFileHighlightingUtil {
    private final ProblemsHolder myHolder;

    public SpringBootConfigFileHighlightingUtil(ProblemsHolder holder) {
        this.myHolder = holder;
    }

    public void highlightDeprecatedConfigKey(PsiElement keyElement, MetaConfigKey configKey, LocalQuickFix ... quickFixes) {
        MetaConfigKey.Deprecation deprecation = configKey.getDeprecation();
        String reasonShortText = deprecation.getReason().getShortText();
        String reason = StringUtil.isNotEmpty((String)reasonShortText) ? SpringBootApiBundle.message("SpringBootConfigFileHighlightingUtil.deprecated", reasonShortText) : SpringBootApiBundle.message("SpringBootConfigFileHighlightingUtil.deprecated.configuration.property", configKey.getName());
        ProblemHighlightType problemHighlightType = deprecation.getLevel() == MetaConfigKey.Deprecation.DeprecationLevel.ERROR ? ProblemHighlightType.GENERIC_ERROR : ProblemHighlightType.LIKE_DEPRECATED;
        this.myHolder.registerProblem(keyElement, reason, problemHighlightType, quickFixes);
    }

    public void highlightUnresolvedConfigKey(PsiElement keyElement, String qualifiedConfigKeyName) {
        this.myHolder.registerProblem(keyElement, SpringBootApiBundle.message("SpringBootConfigFileHighlightingUtil.cannot.resolve.configuration.property", qualifiedConfigKeyName), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{new DefineLocalMetaConfigKeyFix(keyElement, qualifiedConfigKeyName)});
    }
}

