/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application;

import com.intellij.jam.JamService;
import com.intellij.jam.reflect.JamMemberMeta;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiMethodUtil;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.spring.boot.application.SpringBootApplicationService;
import com.intellij.spring.boot.model.autoconfigure.jam.EnableAutoConfiguration;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UFile;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;

final class SpringBootApplicationServiceImpl
implements SpringBootApplicationService {
    SpringBootApplicationServiceImpl() {
    }

    @Override
    public boolean isSpringApplication(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            SpringBootApplicationServiceImpl.$$$reportNull$$$0(0);
        }
        return SpringBootApplicationServiceImpl.isNotPrivateMain(psiClass) && JamService.getJamService((Project)psiClass.getProject()).getJamElement((PsiElement)psiClass, new JamMemberMeta[]{EnableAutoConfiguration.META}) != null;
    }

    @Override
    public List<PsiClass> getSpringApplications(Module module) {
        if (module.isDisposed() || DumbService.isDumb((Project)module.getProject()) || SpringCommonUtils.findLibraryClass((Module)module, (String)"org.springframework.boot.autoconfigure.EnableAutoConfiguration") == null) {
            return List.of();
        }
        return (List)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> {
            JamService jamService = JamService.getJamService((Project)module.getProject());
            GlobalSearchScope scope = module.getModuleScope(false);
            ArrayList<String> fqns = new ArrayList<String>((Collection)EnableAutoConfiguration.getAnnotations().fun((Object)module));
            fqns.add("org.springframework.boot.autoconfigure.EnableAutoConfiguration");
            SmartList applications = new SmartList();
            for (String fqn : fqns) {
                List elements = jamService.getJamClassElements(EnableAutoConfiguration.JAM_KEY, fqn, scope);
                for (EnableAutoConfiguration element : elements) {
                    PsiClass annotatedClass = element.getPsiElement();
                    if (!SpringBootApplicationServiceImpl.isNotPrivateMain(annotatedClass)) continue;
                    applications.add(annotatedClass);
                }
            }
            return CachedValueProvider.Result.create((Object)applications, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        });
    }

    @Override
    public boolean hasMainMethod(PsiClass springBootClass) {
        return UastUtils.findMainInClass((UClass)((UClass)UastContextKt.toUElement((PsiElement)this.findMainClassCandidate(springBootClass), UClass.class))) != null;
    }

    @Override
    @Nullable
    public PsiClass findMainClassCandidate(@Nullable PsiClass springBootClass) {
        if (springBootClass == null) {
            return null;
        }
        UFile file = (UFile)UastContextKt.getUastParentOfType((PsiElement)springBootClass, UFile.class);
        if (file == null) {
            return springBootClass;
        }
        SmartList mainMethodCandidates = new SmartList();
        for (UClass uClass : file.getClasses()) {
            for (UMethod method : uClass.getMethods()) {
                if (UastUtils.getMainMethodClass((UMethod)method) == null) continue;
                mainMethodCandidates.add(method);
            }
        }
        if (mainMethodCandidates.size() == 1) {
            PsiMethod psiMethod = ((UMethod)mainMethodCandidates.get(0)).getJavaPsi();
            return psiMethod.getContainingClass();
        }
        return springBootClass;
    }

    private static boolean isNotPrivateMain(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            SpringBootApplicationServiceImpl.$$$reportNull$$$0(1);
        }
        return PsiMethodUtil.MAIN_CLASS.value((Object)psiClass) && !psiClass.hasModifierProperty("private");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "psiClass";
        objectArray2[1] = "com/intellij/spring/boot/application/SpringBootApplicationServiceImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isSpringApplication";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isNotPrivateMain";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

