/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.sessions;

import com.android.tools.adtui.model.StreamingTimeline;
import com.android.tools.adtui.model.updater.Updatable;
import com.android.tools.idea.protobuf.GeneratedMessageV3;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profilers.StudioProfilers;
import java.io.OutputStream;
import org.jetbrains.annotations.NotNull;

public interface SessionArtifact<T extends GeneratedMessageV3>
extends Updatable {
    public static final String CAPTURING_SUBTITLE = "Recording...";

    @NotNull
    public StudioProfilers getProfilers();

    @NotNull
    public Common.Session getSession();

    @NotNull
    public T getArtifactProto();

    @NotNull
    public Common.SessionMetaData getSessionMetaData();

    @NotNull
    public String getName();

    public long getTimestampNs();

    public boolean isOngoing();

    default public boolean canExport() {
        return false;
    }

    public void onSelect();

    default public void export(@NotNull OutputStream outputStream) {
        if (outputStream == null) {
            SessionArtifact.$$$reportNull$$$0(0);
        }
    }

    default public void update(long elapseNs) {
    }

    public static void navigateTimelineToOngoingCapture(@NotNull StreamingTimeline timeline, long startTimeUs) {
        if (timeline == null) {
            SessionArtifact.$$$reportNull$$$0(1);
        }
        double viewRange90PercentLength = 0.9 * timeline.getViewRange().getLength();
        double currentOngoingCaptureLength = timeline.getDataRange().getMax() - (double)startTimeUs;
        if (currentOngoingCaptureLength > viewRange90PercentLength) {
            timeline.zoom(currentOngoingCaptureLength - viewRange90PercentLength);
        }
        timeline.setStreaming(true);
        timeline.setIsPaused(false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputStream";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "timeline";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/profilers/sessions/SessionArtifact";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "export";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "navigateTimelineToOngoingCapture";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

