/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.network.details;

import com.android.tools.adtui.TreeWalker;
import com.android.tools.adtui.common.AdtUiUtils;
import com.android.tools.adtui.event.NestedScrollPaneMouseWheelListener;
import com.android.tools.adtui.ui.HideablePanel;
import com.android.tools.profilers.ContentType;
import com.android.tools.profilers.IdeProfilerComponents;
import com.android.tools.profilers.ProfilerFonts;
import com.android.tools.profilers.dataviewer.DataViewer;
import com.android.tools.profilers.network.NetworkConnectionsModel;
import com.android.tools.profilers.network.details.TabUiUtils;
import com.android.tools.profilers.network.httpdata.HttpData;
import com.android.tools.profilers.network.httpdata.Payload;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ui.JBEmptyBorder;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager2;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class HttpDataComponentFactory {
    private static final String ID_PAYLOAD_VIEWER = "PAYLOAD_VIEWER";
    private static final Border PAYLOAD_BORDER = new JBEmptyBorder(6, 0, 0, 0);
    private final NetworkConnectionsModel myModel;
    private final HttpData myHttpData;

    public HttpDataComponentFactory(@NotNull NetworkConnectionsModel model, @NotNull HttpData httpData) {
        if (model == null) {
            HttpDataComponentFactory.$$$reportNull$$$0(0);
        }
        if (httpData == null) {
            HttpDataComponentFactory.$$$reportNull$$$0(1);
        }
        this.myModel = model;
        this.myHttpData = httpData;
    }

    @VisibleForTesting
    @Nullable
    static JComponent findPayloadViewer(@Nullable JComponent body) {
        if (body == null) {
            return null;
        }
        return TabUiUtils.findComponentWithUniqueName(body, ID_PAYLOAD_VIEWER);
    }

    @NotNull
    public JComponent createHeaderComponent(@NotNull ConnectionType type) {
        if (type == null) {
            HttpDataComponentFactory.$$$reportNull$$$0(2);
        }
        JComponent jComponent = TabUiUtils.createStyledMapComponent(type.getHeader(this.myHttpData).getFields());
        if (jComponent == null) {
            HttpDataComponentFactory.$$$reportNull$$$0(3);
        }
        return jComponent;
    }

    @NotNull
    private String getBodyTitle(@NotNull ConnectionType type) {
        HttpData.Header header;
        HttpData.ContentType contentType;
        if (type == null) {
            HttpDataComponentFactory.$$$reportNull$$$0(4);
        }
        if ((contentType = (header = type.getHeader(this.myHttpData)).getContentType()).isEmpty()) {
            return "Body";
        }
        String string = String.format("Body ( %s )", HttpDataComponentFactory.getDisplayName(contentType));
        if (string == null) {
            HttpDataComponentFactory.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public JComponent createBodyComponent(@NotNull IdeProfilerComponents components, @NotNull ConnectionType type) {
        Payload payload;
        if (components == null) {
            HttpDataComponentFactory.$$$reportNull$$$0(6);
        }
        if (type == null) {
            HttpDataComponentFactory.$$$reportNull$$$0(7);
        }
        if ((payload = type.getPayload(this.myModel, this.myHttpData)).getBytes().isEmpty()) {
            HideablePanel hideablePanel = TabUiUtils.createHideablePanel(this.getBodyTitle(type), new JLabel("Not available"), null);
            if (hideablePanel == null) {
                HttpDataComponentFactory.$$$reportNull$$$0(8);
            }
            return hideablePanel;
        }
        JComponent rawDataComponent = HttpDataComponentFactory.createRawDataComponent(payload, components);
        JComponent parsedDataComponent = HttpDataComponentFactory.createParsedDataComponent(payload, components);
        JComponent bodyComponent = rawDataComponent;
        JLabel northEastComponent = null;
        if (parsedDataComponent != null) {
            JLabel toggleLabel;
            final CardLayout cardLayout = new CardLayout();
            final JPanel payloadPanel = new JPanel(cardLayout);
            final String cardViewParsed = "View Parsed";
            final String cardViewSource = "View Source";
            parsedDataComponent.setName(cardViewParsed);
            rawDataComponent.setName(cardViewSource);
            payloadPanel.add((Component)parsedDataComponent, cardViewParsed);
            payloadPanel.add((Component)rawDataComponent, cardViewSource);
            bodyComponent = payloadPanel;
            northEastComponent = toggleLabel = new JLabel(cardViewSource);
            final Color toggleHoverColor = AdtUiUtils.overlayColor((int)toggleLabel.getBackground().getRGB(), (int)toggleLabel.getForeground().getRGB(), (float)0.9f);
            final Color toggleDefaultColor = AdtUiUtils.overlayColor((int)toggleLabel.getBackground().getRGB(), (int)toggleHoverColor.getRGB(), (float)0.6f);
            toggleLabel.setForeground(toggleDefaultColor);
            toggleLabel.setFont(ProfilerFonts.STANDARD_FONT);
            toggleLabel.setBorder((Border)new JBEmptyBorder(0, 10, 0, 5));
            toggleLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    toggleLabel.setText(cardViewSource.equals(toggleLabel.getText()) ? cardViewParsed : cardViewSource);
                    cardLayout.next(payloadPanel);
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                    toggleLabel.setForeground(toggleHoverColor);
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    toggleLabel.setForeground(toggleDefaultColor);
                }
            });
        }
        bodyComponent.setName(type.getBodyComponentId());
        HideablePanel hideablePanel = TabUiUtils.createHideablePanel(this.getBodyTitle(type), bodyComponent, northEastComponent);
        if (hideablePanel == null) {
            HttpDataComponentFactory.$$$reportNull$$$0(9);
        }
        return hideablePanel;
    }

    @NotNull
    private static JComponent createRawDataComponent(@NotNull Payload payload, @NotNull IdeProfilerComponents components) {
        if (payload == null) {
            HttpDataComponentFactory.$$$reportNull$$$0(10);
        }
        if (components == null) {
            HttpDataComponentFactory.$$$reportNull$$$0(11);
        }
        ContentType contentType = ContentType.fromMimeType(payload.getContentType().getMimeType());
        DataViewer viewer = components.createDataViewer(payload.getBytes().toByteArray(), contentType, DataViewer.Style.RAW);
        JComponent viewerComponent = viewer.getComponent();
        viewerComponent.setName(ID_PAYLOAD_VIEWER);
        viewerComponent.setBorder(PAYLOAD_BORDER);
        JPanel compressedVerticalPanel = new JPanel(new CompressedVerticalLayout());
        compressedVerticalPanel.add(viewerComponent);
        JPanel jPanel = compressedVerticalPanel;
        if (jPanel == null) {
            HttpDataComponentFactory.$$$reportNull$$$0(12);
        }
        return jPanel;
    }

    @Nullable
    private static JComponent createParsedDataComponent(@NotNull Payload payload, @NotNull IdeProfilerComponents components) {
        if (payload == null) {
            HttpDataComponentFactory.$$$reportNull$$$0(13);
        }
        if (components == null) {
            HttpDataComponentFactory.$$$reportNull$$$0(14);
        }
        if (payload.getContentType().isFormData()) {
            String contentToParse = payload.getBytes().toStringUtf8();
            LinkedHashMap<String, String> parsedContent = new LinkedHashMap<String, String>();
            Stream<String[]> parsedContentStream = Arrays.stream(contentToParse.trim().split("&")).map(s -> s.split("=", 2));
            parsedContentStream.forEach(a -> parsedContent.put(a[0], ((String[])a).length > 1 ? a[1] : ""));
            return TabUiUtils.createStyledMapComponent(parsedContent);
        }
        ContentType contentType = ContentType.fromMimeType(payload.getContentType().getMimeType());
        DataViewer viewer = components.createDataViewer(payload.getBytes().toByteArray(), contentType, DataViewer.Style.PRETTY);
        if (viewer.getStyle() == DataViewer.Style.PRETTY) {
            JComponent viewerComponent = viewer.getComponent();
            viewerComponent.setBorder(PAYLOAD_BORDER);
            new TreeWalker((Component)viewerComponent).descendantStream().filter(c -> c instanceof JScrollPane).map(c -> (JScrollPane)c).forEach(scroller -> NestedScrollPaneMouseWheelListener.installOn((JScrollPane)scroller));
            return viewerComponent;
        }
        return null;
    }

    @VisibleForTesting
    static String getDisplayName(@NotNull HttpData.ContentType contentType) {
        String name;
        String mimeType;
        if (contentType == null) {
            HttpDataComponentFactory.$$$reportNull$$$0(15);
        }
        if ((mimeType = contentType.getMimeType().trim()).isEmpty()) {
            return mimeType;
        }
        if (contentType.isFormData()) {
            return "Form Data";
        }
        String[] typeAndSubType = mimeType.split("/", 2);
        boolean showSubType = typeAndSubType.length > 1 && (typeAndSubType[0].equals("text") || typeAndSubType[0].equals("application"));
        String string = name = showSubType ? typeAndSubType[1] : typeAndSubType[0];
        if (name.isEmpty() || showSubType) {
            return StringUtil.toUpperCase((String)name);
        }
        return StringUtil.toUpperCase((String)name.substring(0, 1)) + name.substring(1);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 9: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 9: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "httpData";
                break;
            }
            case 2: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/network/details/HttpDataComponentFactory";
                break;
            }
            case 6: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "components";
                break;
            }
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "payload";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/network/details/HttpDataComponentFactory";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createHeaderComponent";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getBodyTitle";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createBodyComponent";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createRawDataComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createHeaderComponent";
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 9: 
            case 12: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getBodyTitle";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createBodyComponent";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createRawDataComponent";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createParsedDataComponent";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getDisplayName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 9: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @VisibleForTesting
    static class CompressedVerticalLayout
    implements LayoutManager2 {
        private static final int INVALID_SIZE = -1;
        private final Dimension myMinSize = new Dimension(-1, -1);
        private final Dimension myPreferredSize = new Dimension(-1, -1);
        private final Dimension myMaxSize = new Dimension(-1, -1);
        private boolean myNeedsLayout = true;

        CompressedVerticalLayout() {
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return CompressedVerticalLayout.getSize(parent, c -> c.getMinimumSize(), this.myMinSize);
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int parentWidth = parent.getWidth();
            return CompressedVerticalLayout.getSize(parent, c -> {
                c.setBounds(0, 0, parentWidth, Short.MAX_VALUE);
                return c.getPreferredSize();
            }, this.myPreferredSize);
        }

        @Override
        public Dimension maximumLayoutSize(Container parent) {
            return CompressedVerticalLayout.getSize(parent, c -> c.getMaximumSize(), this.myMaxSize);
        }

        @Override
        public void layoutContainer(Container parent) {
            if (!this.myNeedsLayout) {
                return;
            }
            int componentCount = parent.getComponentCount();
            int totalWidth = parent.getWidth();
            int totalHeight = parent.getHeight();
            for (int i2 = 0; i2 < componentCount; ++i2) {
                int width;
                Component c = parent.getComponent(i2);
                if (c.isMaximumSizeSet()) {
                    Dimension maxDim = c.getMaximumSize();
                    width = Math.min(totalWidth, maxDim.width);
                    c.setBounds(0, 0, width, maxDim.height);
                }
                Dimension preferredDim = c.getPreferredSize();
                width = Math.min(totalWidth, preferredDim.width);
                int height = Math.min(totalHeight, preferredDim.height);
                c.setBounds(0, 0, width, height);
            }
            this.myNeedsLayout = false;
        }

        @Override
        public float getLayoutAlignmentX(Container target) {
            return 0.0f;
        }

        @Override
        public float getLayoutAlignmentY(Container target) {
            return 0.0f;
        }

        @Override
        public void invalidateLayout(Container target) {
            this.invalidateLayout();
        }

        @Override
        public void addLayoutComponent(Component comp, Object constraints) {
            this.invalidateLayout();
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
            this.invalidateLayout();
        }

        @Override
        public void removeLayoutComponent(Component comp) {
            this.invalidateLayout();
        }

        @NotNull
        private static Dimension getSize(@NotNull Container parent, @NotNull Function<Component, Dimension> componentSizeGetter, @NotNull Dimension resultDimension) {
            if (parent == null) {
                CompressedVerticalLayout.$$$reportNull$$$0(0);
            }
            if (componentSizeGetter == null) {
                CompressedVerticalLayout.$$$reportNull$$$0(1);
            }
            if (resultDimension == null) {
                CompressedVerticalLayout.$$$reportNull$$$0(2);
            }
            if (resultDimension.width != -1 && resultDimension.height != -1) {
                Dimension dimension = resultDimension;
                if (dimension == null) {
                    CompressedVerticalLayout.$$$reportNull$$$0(3);
                }
                return dimension;
            }
            int w = 0;
            int h = 0;
            for (Component c : parent.getComponents()) {
                Dimension d = componentSizeGetter.apply(c);
                w = Math.max(w, d.width);
                h += d.height;
            }
            resultDimension.setSize(w, h);
            Dimension dimension = resultDimension;
            if (dimension == null) {
                CompressedVerticalLayout.$$$reportNull$$$0(4);
            }
            return dimension;
        }

        private void invalidateLayout() {
            this.myMinSize.setSize(-1, -1);
            this.myPreferredSize.setSize(-1, -1);
            this.myMaxSize.setSize(-1, -1);
            this.myNeedsLayout = true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "componentSizeGetter";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "resultDimension";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/profilers/network/details/HttpDataComponentFactory$CompressedVerticalLayout";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/profilers/network/details/HttpDataComponentFactory$CompressedVerticalLayout";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSize";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getSize";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static enum ConnectionType {
        REQUEST,
        RESPONSE;


        @NotNull
        HttpData.Header getHeader(@NotNull HttpData data) {
            if (data == null) {
                ConnectionType.$$$reportNull$$$0(0);
            }
            HttpData.Header header = this == REQUEST ? data.getRequestHeader() : data.getResponseHeader();
            if (header == null) {
                ConnectionType.$$$reportNull$$$0(1);
            }
            return header;
        }

        @NotNull
        Payload getPayload(@NotNull NetworkConnectionsModel model, @NotNull HttpData data) {
            if (model == null) {
                ConnectionType.$$$reportNull$$$0(2);
            }
            if (data == null) {
                ConnectionType.$$$reportNull$$$0(3);
            }
            Payload payload = this == REQUEST ? Payload.newRequestPayload(model, data) : Payload.newResponsePayload(model, data);
            if (payload == null) {
                ConnectionType.$$$reportNull$$$0(4);
            }
            return payload;
        }

        @NotNull
        String getBodyComponentId() {
            return this == REQUEST ? "REQUEST_PAYLOAD_COMPONENT" : "RESPONSE_PAYLOAD_COMPONENT";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/profilers/network/details/HttpDataComponentFactory$ConnectionType";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "model";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/profilers/network/details/HttpDataComponentFactory$ConnectionType";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getHeader";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPayload";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getHeader";
                    break;
                }
                case 1: 
                case 4: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getPayload";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

