/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.network;

import com.android.tools.adtui.TabularLayout;
import com.android.tools.adtui.TooltipComponent;
import com.android.tools.adtui.common.AdtUiUtils;
import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.Timeline;
import com.android.tools.adtui.model.formatter.TimeFormatter;
import com.android.tools.profilers.BorderlessTableCellRenderer;
import com.android.tools.profilers.ProfilerColors;
import com.android.tools.profilers.ProfilerFonts;
import com.android.tools.profilers.ProfilerLayout;
import com.android.tools.profilers.TimelineTable;
import com.android.tools.profilers.network.HttpDataFetcher;
import com.android.tools.profilers.network.NetworkProfilerAspect;
import com.android.tools.profilers.network.NetworkProfilerStage;
import com.android.tools.profilers.network.NetworkProfilerStageView;
import com.android.tools.profilers.network.httpdata.HttpData;
import com.google.common.collect.ImmutableMap;
import com.intellij.util.ui.JBUI;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.font.TextAttribute;
import java.awt.geom.Rectangle2D;
import java.text.AttributedCharacterIterator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableRowSorter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ThreadsView {
    private static final int STATE_HEIGHT = JBUI.scale((int)15);
    private static final int SELECTION_OUTLINE_PADDING = JBUI.scale((int)3);
    private static final int SELECTION_OUTLINE_BORDER = JBUI.scale((int)2);
    private static final int ROW_HEIGHT = STATE_HEIGHT + 2 * (SELECTION_OUTLINE_BORDER + SELECTION_OUTLINE_PADDING);
    @NotNull
    private final JTable myThreadsTable;
    @NotNull
    private final AspectObserver myObserver;

    ThreadsView(final @NotNull NetworkProfilerStageView stageView) {
        if (stageView == null) {
            ThreadsView.$$$reportNull$$$0(0);
        }
        ThreadsTableModel model = new ThreadsTableModel(((NetworkProfilerStage)stageView.getStage()).getHttpDataFetcher());
        this.myThreadsTable = TimelineTable.create(model, (Timeline)((NetworkProfilerStage)stageView.getStage()).getTimeline(), Column.TIMELINE.ordinal());
        TimelineRenderer timelineRenderer = new TimelineRenderer(this.myThreadsTable, (NetworkProfilerStage)stageView.getStage());
        this.myThreadsTable.getColumnModel().getColumn(Column.NAME.ordinal()).setCellRenderer(new BorderlessTableCellRenderer());
        this.myThreadsTable.getColumnModel().getColumn(Column.TIMELINE.ordinal()).setCellRenderer(timelineRenderer);
        this.myThreadsTable.setBackground(ProfilerColors.DEFAULT_BACKGROUND);
        this.myThreadsTable.setShowVerticalLines(true);
        this.myThreadsTable.setShowHorizontalLines(false);
        this.myThreadsTable.setCellSelectionEnabled(false);
        this.myThreadsTable.setFocusable(false);
        this.myThreadsTable.setRowMargin(0);
        this.myThreadsTable.setRowHeight(ROW_HEIGHT);
        this.myThreadsTable.setFocusTraversalKeys(0, null);
        this.myThreadsTable.setFocusTraversalKeys(1, null);
        this.myThreadsTable.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                ThreadsView.this.myThreadsTable.getColumnModel().getColumn(Column.NAME.ordinal()).setPreferredWidth((int)((double)ThreadsView.this.myThreadsTable.getWidth() * 1.0 / 8.0));
                ThreadsView.this.myThreadsTable.getColumnModel().getColumn(Column.TIMELINE.ordinal()).setPreferredWidth((int)((double)ThreadsView.this.myThreadsTable.getWidth() * 7.0 / 8.0));
            }
        });
        TableRowSorter<ThreadsTableModel> sorter = new TableRowSorter<ThreadsTableModel>(model);
        sorter.setComparator(Column.NAME.ordinal(), Comparator.comparing(String::toString));
        sorter.setComparator(Column.TIMELINE.ordinal(), Comparator.comparing(data -> ((HttpData)data.get(0)).getRequestStartTimeUs()));
        this.myThreadsTable.setRowSorter(sorter);
        this.myThreadsTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Range selection2 = ((NetworkProfilerStage)stageView.getStage()).getTimeline().getSelectionRange();
                HttpData data = ThreadsView.findHttpDataUnderCursor(ThreadsView.this.myThreadsTable, selection2, e);
                if (data != null) {
                    ((NetworkProfilerStage)stageView.getStage()).setSelectedConnection(data);
                    e.consume();
                }
            }
        });
        TooltipView.install(this.myThreadsTable, stageView);
        this.myObserver = new AspectObserver();
        ((NetworkProfilerStage)stageView.getStage()).getAspect().addDependency(this.myObserver).onChange((Enum)NetworkProfilerAspect.SELECTED_CONNECTION, () -> {
            timelineRenderer.updateRows();
            this.myThreadsTable.repaint();
        });
    }

    @NotNull
    JComponent getComponent() {
        JTable jTable = this.myThreadsTable;
        if (jTable == null) {
            ThreadsView.$$$reportNull$$$0(1);
        }
        return jTable;
    }

    @Nullable
    private static HttpData findHttpDataUnderCursor(@NotNull JTable table, @NotNull Range range, @NotNull MouseEvent e) {
        if (table == null) {
            ThreadsView.$$$reportNull$$$0(2);
        }
        if (range == null) {
            ThreadsView.$$$reportNull$$$0(3);
        }
        if (e == null) {
            ThreadsView.$$$reportNull$$$0(4);
        }
        Point p = SwingUtilities.convertPoint(e.getComponent(), e.getPoint(), table);
        int row = table.rowAtPoint(p);
        int column = table.columnAtPoint(p);
        if (row == -1 || column == -1) {
            return null;
        }
        if (column == Column.TIMELINE.ordinal()) {
            Rectangle cellBounds = table.getCellRect(row, column, false);
            int modelIndex = table.convertRowIndexToModel(row);
            List dataList = (List)table.getModel().getValueAt(modelIndex, 1);
            double at = ThreadsView.positionToRange(p.x - cellBounds.x, cellBounds.getWidth(), range);
            for (HttpData data : dataList) {
                if (!((double)data.getRequestStartTimeUs() <= at) || !(at <= (double)data.getConnectionEndTimeUs())) continue;
                return data;
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private static double positionToRange(double x, double width, @NotNull Range range) {
        void range2;
        if (range == null) {
            ThreadsView.$$$reportNull$$$0(5);
        }
        return x * range2.getLength() / width + range2.getMin();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stageView";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/network/ThreadsView";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/network/ThreadsView";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findHttpDataUnderCursor";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "positionToRange";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class TooltipView
    extends MouseAdapter {
        @NotNull
        private final JTable myTable;
        @NotNull
        private final Range myRange;
        @NotNull
        private final TooltipComponent myTooltipComponent;
        @NotNull
        private final JPanel myContent;

        private TooltipView(@NotNull JTable table, @NotNull NetworkProfilerStageView stageView) {
            if (table == null) {
                TooltipView.$$$reportNull$$$0(0);
            }
            if (stageView == null) {
                TooltipView.$$$reportNull$$$0(1);
            }
            this.myTable = table;
            this.myRange = ((NetworkProfilerStage)stageView.getStage()).getTimeline().getSelectionRange();
            this.myContent = new JPanel((LayoutManager)new TabularLayout("*", "*"));
            this.myContent.setBorder(ProfilerLayout.TOOLTIP_BORDER);
            this.myContent.setBackground(ProfilerColors.TOOLTIP_BACKGROUND);
            this.myContent.setFont(com.android.tools.adtui.TooltipView.TOOLTIP_BODY_FONT);
            this.myTooltipComponent = new TooltipComponent.Builder((JComponent)this.myContent, (JComponent)table, stageView.getProfilersView().getComponent()).build();
            this.myTooltipComponent.registerListenersOn((Component)table);
            this.myTooltipComponent.setVisible(false);
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            this.myTooltipComponent.setVisible(false);
            HttpData data = ThreadsView.findHttpDataUnderCursor(this.myTable, this.myRange, e);
            if (data != null) {
                this.showTooltip(data);
            }
        }

        private void showTooltip(@NotNull HttpData data) {
            if (data == null) {
                TooltipView.$$$reportNull$$$0(2);
            }
            this.myTooltipComponent.setVisible(true);
            String urlName = HttpData.getUrlName(data.getUrl());
            long duration = data.getConnectionEndTimeUs() - data.getRequestStartTimeUs();
            this.myContent.removeAll();
            this.addToContent(TooltipView.newTooltipLabel(urlName));
            JLabel durationLabel = TooltipView.newTooltipLabel(TimeFormatter.getSingleUnitDurationString((long)duration));
            durationLabel.setForeground(ProfilerColors.TOOLTIP_TEXT);
            this.addToContent(durationLabel);
            if (data.getJavaThreads().size() > 1) {
                JPanel divider = new JPanel();
                divider.setPreferredSize(new Dimension(0, 5));
                divider.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, ProfilerColors.NETWORK_THREADS_VIEW_TOOLTIP_DIVIDER));
                divider.setBackground(this.myContent.getBackground());
                this.myContent.add((Component)divider, new TabularLayout.Constraint(this.myContent.getComponentCount(), 0));
                JLabel alsoAccessedByLabel = TooltipView.newTooltipLabel("Also accessed by:");
                alsoAccessedByLabel.setFont(alsoAccessedByLabel.getFont().deriveFont((Map<? extends AttributedCharacterIterator.Attribute, ?>)ImmutableMap.of((Object)TextAttribute.WEIGHT, (Object)TextAttribute.WEIGHT_BOLD)));
                this.addToContent(alsoAccessedByLabel);
                for (int i2 = 1; i2 < data.getJavaThreads().size(); ++i2) {
                    JLabel label = TooltipView.newTooltipLabel(data.getJavaThreads().get(i2).getName());
                    this.addToContent(label);
                    if (i2 != data.getJavaThreads().size() - 1) continue;
                    label.setBorder((Border)JBUI.Borders.empty((int)5, (int)0));
                }
            }
        }

        private void addToContent(@NotNull JComponent component) {
            if (component == null) {
                TooltipView.$$$reportNull$$$0(3);
            }
            component.setBorder((Border)JBUI.Borders.emptyTop((int)5));
            this.myContent.add((Component)component, new TabularLayout.Constraint(this.myContent.getComponentCount(), 0));
        }

        private static JLabel newTooltipLabel(String text) {
            JLabel label = new JLabel(text);
            label.setForeground(ProfilerColors.TOOLTIP_TEXT);
            label.setFont(com.android.tools.adtui.TooltipView.TOOLTIP_BODY_FONT);
            return label;
        }

        public static void install(@NotNull JTable table, @NotNull NetworkProfilerStageView stageView) {
            if (table == null) {
                TooltipView.$$$reportNull$$$0(4);
            }
            if (stageView == null) {
                TooltipView.$$$reportNull$$$0(5);
            }
            table.addMouseMotionListener(new TooltipView(table, stageView));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "table";
                    break;
                }
                case 1: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "stageView";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/profilers/network/ThreadsView$TooltipView";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "showTooltip";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addToContent";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "install";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class ConnectionsInfoComponent
    extends JComponent {
        private static final int NAME_PADDING = 6;
        @NotNull
        private final List<HttpData> myDataList;
        @NotNull
        private final Range myRange;
        @NotNull
        private final JTable myTable;
        @NotNull
        private final NetworkProfilerStage myStage;

        private ConnectionsInfoComponent(@NotNull JTable table, @NotNull List<HttpData> data, @NotNull NetworkProfilerStage stage) {
            if (table == null) {
                ConnectionsInfoComponent.$$$reportNull$$$0(0);
            }
            if (data == null) {
                ConnectionsInfoComponent.$$$reportNull$$$0(1);
            }
            if (stage == null) {
                ConnectionsInfoComponent.$$$reportNull$$$0(2);
            }
            this.myStage = stage;
            this.myDataList = data;
            this.myRange = stage.getTimeline().getSelectionRange();
            this.setFont(ProfilerFonts.SMALL_FONT);
            this.setForeground(Color.BLACK);
            this.setBackground(ProfilerColors.DEFAULT_BACKGROUND);
            this.myTable = table;
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            Graphics2D g2d = (Graphics2D)g.create();
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            for (int i2 = 0; i2 < this.myDataList.size(); ++i2) {
                HttpData data = this.myDataList.get(i2);
                double endLimit = i2 + 1 < this.myDataList.size() ? this.rangeToPosition(this.myDataList.get(i2 + 1).getRequestStartTimeUs()) : (double)this.getWidth();
                this.drawState(g2d, data, endLimit);
                this.drawConnectionName(g2d, data, endLimit);
            }
            if (this.myStage.getSelectedConnection() != null && this.myDataList.contains(this.myStage.getSelectedConnection())) {
                this.drawSelection(g2d, this.myStage.getSelectedConnection(), this.getWidth());
            }
            g2d.dispose();
        }

        private void drawState(@NotNull Graphics2D g2d, @NotNull HttpData data, double endLimit) {
            if (g2d == null) {
                ConnectionsInfoComponent.$$$reportNull$$$0(3);
            }
            if (data == null) {
                ConnectionsInfoComponent.$$$reportNull$$$0(4);
            }
            double prev = this.rangeToPosition(data.getRequestStartTimeUs());
            g2d.setColor(ProfilerColors.NETWORK_SENDING_COLOR);
            if (data.getResponseStartTimeUs() > 0L) {
                double download = this.rangeToPosition(data.getResponseStartTimeUs());
                g2d.fill(new Rectangle2D.Double(prev, (double)(this.getHeight() - STATE_HEIGHT) / 2.0, download - prev, STATE_HEIGHT));
                g2d.setColor(ProfilerColors.NETWORK_RECEIVING_COLOR);
                prev = download;
            }
            double end = data.getConnectionEndTimeUs() > 0L ? this.rangeToPosition(data.getConnectionEndTimeUs()) : endLimit;
            g2d.fill(new Rectangle2D.Double(prev, (double)(this.getHeight() - STATE_HEIGHT) / 2.0, end - prev, STATE_HEIGHT));
        }

        private void drawConnectionName(@NotNull Graphics2D g2d, @NotNull HttpData data, double endLimit) {
            if (g2d == null) {
                ConnectionsInfoComponent.$$$reportNull$$$0(5);
            }
            if (data == null) {
                ConnectionsInfoComponent.$$$reportNull$$$0(6);
            }
            g2d.setFont(this.getFont());
            g2d.setColor(this.getForeground());
            double start = this.rangeToPosition(data.getRequestStartTimeUs());
            double end = data.getConnectionEndTimeUs() > 0L ? this.rangeToPosition(data.getConnectionEndTimeUs()) : endLimit;
            FontMetrics metrics = this.getFontMetrics(this.getFont());
            String text = AdtUiUtils.shrinkToFit((String)HttpData.getUrlName(data.getUrl()), (FontMetrics)metrics, (float)((float)(end - start - 12.0)));
            double availableSpace = end - start - (double)metrics.stringWidth(text);
            g2d.drawString(text, (float)(start + availableSpace / 2.0), (float)((double)(this.getHeight() - metrics.getHeight()) * 0.5 + (double)metrics.getAscent()));
        }

        private void drawSelection(@NotNull Graphics2D g2d, @NotNull HttpData data, double endLimit) {
            if (g2d == null) {
                ConnectionsInfoComponent.$$$reportNull$$$0(7);
            }
            if (data == null) {
                ConnectionsInfoComponent.$$$reportNull$$$0(8);
            }
            double start = this.rangeToPosition(data.getRequestStartTimeUs());
            double end = data.getConnectionEndTimeUs() > 0L ? this.rangeToPosition(data.getConnectionEndTimeUs()) : endLimit;
            g2d.setStroke(new BasicStroke(SELECTION_OUTLINE_BORDER));
            g2d.setColor(this.myTable.getSelectionBackground());
            Rectangle2D.Double rect = new Rectangle2D.Double(start - (double)SELECTION_OUTLINE_PADDING, (double)(this.getHeight() - STATE_HEIGHT) / 2.0 - (double)SELECTION_OUTLINE_PADDING, end - start + (double)(2 * SELECTION_OUTLINE_PADDING), STATE_HEIGHT + 2 * SELECTION_OUTLINE_PADDING);
            g2d.draw(rect);
        }

        private double rangeToPosition(double r) {
            return (r - this.myRange.getMin()) / this.myRange.getLength() * (double)this.getWidth();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "table";
                    break;
                }
                case 1: 
                case 4: 
                case 6: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "stage";
                    break;
                }
                case 3: 
                case 5: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "g2d";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/profilers/network/ThreadsView$ConnectionsInfoComponent";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "drawState";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "drawConnectionName";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "drawSelection";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class TimelineRenderer
    extends TimelineTable.CellRenderer
    implements TableModelListener {
        @NotNull
        private final JTable myTable;
        @NotNull
        private final List<JComponent> myConnectionsInfo;
        @NotNull
        private final NetworkProfilerStage myStage;

        TimelineRenderer(@NotNull JTable table, @NotNull NetworkProfilerStage stage) {
            if (table == null) {
                TimelineRenderer.$$$reportNull$$$0(0);
            }
            if (stage == null) {
                TimelineRenderer.$$$reportNull$$$0(1);
            }
            super((Timeline)stage.getTimeline());
            this.myTable = table;
            this.myConnectionsInfo = new ArrayList<JComponent>();
            this.myStage = stage;
            this.myTable.getModel().addTableModelListener(this);
            this.tableChanged(new TableModelEvent(this.myTable.getModel()));
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            this.updateRows();
        }

        private void updateRows() {
            this.myConnectionsInfo.clear();
            for (int index = 0; index < this.myTable.getModel().getRowCount(); ++index) {
                List data = (List)this.myTable.getModel().getValueAt(index, 1);
                this.myConnectionsInfo.add(new ConnectionsInfoComponent(this.myTable, data, this.myStage));
            }
        }

        @Override
        @NotNull
        protected Component getTableCellRendererComponent(boolean isSelected, int row) {
            Component component = this.myConnectionsInfo.get(this.myTable.convertRowIndexToModel(row));
            if (component == null) {
                TimelineRenderer.$$$reportNull$$$0(2);
            }
            return component;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "table";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "stage";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/profilers/network/ThreadsView$TimelineRenderer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/profilers/network/ThreadsView$TimelineRenderer";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTableCellRendererComponent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static final class ThreadsTableModel
    extends AbstractTableModel {
        @NotNull
        private final List<List<HttpData>> myThreads;

        private ThreadsTableModel(@NotNull HttpDataFetcher httpDataFetcher) {
            if (httpDataFetcher == null) {
                ThreadsTableModel.$$$reportNull$$$0(0);
            }
            this.myThreads = new ArrayList<List<HttpData>>();
            httpDataFetcher.addListener(this::httpDataChanged);
        }

        private void httpDataChanged(List<HttpData> dataList) {
            this.myThreads.clear();
            if (dataList.isEmpty()) {
                this.fireTableDataChanged();
                return;
            }
            HashMap threads = new HashMap();
            for (HttpData data : dataList) {
                if (data.getJavaThreads().isEmpty()) continue;
                if (!threads.containsKey(data.getJavaThreads().get(0).getId())) {
                    threads.put(data.getJavaThreads().get(0).getId(), new ArrayList());
                }
                ((List)threads.get(data.getJavaThreads().get(0).getId())).add(data);
            }
            threads.values().stream().sorted((o1, o2) -> {
                HttpData.JavaThread thread1 = ((HttpData)o1.get(0)).getJavaThreads().get(0);
                HttpData.JavaThread thread2 = ((HttpData)o2.get(0)).getJavaThreads().get(0);
                int nameCompare = thread1.getName().compareTo(thread2.getName());
                return nameCompare != 0 ? nameCompare : Long.compare(thread1.getId(), thread2.getId());
            }).forEach(this.myThreads::add);
            this.fireTableDataChanged();
        }

        @Override
        public int getRowCount() {
            return this.myThreads.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int column) {
            return column == Column.NAME.ordinal() ? "Initiating thread" : "Timeline";
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (columnIndex == Column.NAME.ordinal()) {
                return this.myThreads.get(rowIndex).get(0).getJavaThreads().get(0).getName();
            }
            return this.myThreads.get(rowIndex);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "httpDataFetcher", "com/android/tools/profilers/network/ThreadsView$ThreadsTableModel", "<init>"));
        }
    }

    private static enum Column {
        NAME,
        TIMELINE;

    }
}

