/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.network;

import com.android.tools.adtui.model.Range;
import com.android.tools.idea.protobuf.ByteString;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.Network;
import com.android.tools.profiler.proto.Transport;
import com.android.tools.profiler.proto.TransportServiceGrpc;
import com.android.tools.profilers.network.NetworkConnectionsModel;
import com.android.tools.profilers.network.httpdata.HttpData;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class RpcNetworkConnectionsModel
implements NetworkConnectionsModel {
    @NotNull
    private final TransportServiceGrpc.TransportServiceBlockingStub myTransportService;
    @NotNull
    private final Common.Session mySession;

    public RpcNetworkConnectionsModel(@NotNull TransportServiceGrpc.TransportServiceBlockingStub transportService, @NotNull Common.Session session) {
        if (transportService == null) {
            RpcNetworkConnectionsModel.$$$reportNull$$$0(0);
        }
        if (session == null) {
            RpcNetworkConnectionsModel.$$$reportNull$$$0(1);
        }
        this.myTransportService = transportService;
        this.mySession = session;
    }

    @Override
    @NotNull
    public List<HttpData> getData(@NotNull Range timeCurrentRangeUs) {
        if (timeCurrentRangeUs == null) {
            RpcNetworkConnectionsModel.$$$reportNull$$$0(2);
        }
        long queryStartTimeNs = TimeUnit.MICROSECONDS.toNanos((long)timeCurrentRangeUs.getMin());
        long queryEndTimeNs = TimeUnit.MICROSECONDS.toNanos((long)timeCurrentRangeUs.getMax());
        Transport.GetEventGroupsRequest request = Transport.GetEventGroupsRequest.newBuilder().setStreamId(this.mySession.getStreamId()).setPid(this.mySession.getPid()).setKind(Common.Event.Kind.NETWORK_HTTP_CONNECTION).build();
        Transport.GetEventGroupsResponse response = this.myTransportService.getEventGroups(request);
        Transport.GetEventGroupsRequest threadRequest = Transport.GetEventGroupsRequest.newBuilder().setStreamId(this.mySession.getStreamId()).setPid(this.mySession.getPid()).setKind(Common.Event.Kind.NETWORK_HTTP_THREAD).build();
        Map<Long, List> connectionThreadMap = this.myTransportService.getEventGroups(threadRequest).getGroupsList().stream().collect(Collectors.toMap(Transport.EventGroup::getGroupId, Transport.EventGroup::getEventsList));
        ArrayList<HttpData> httpDataList = new ArrayList<HttpData>(response.getGroupsCount());
        for (Transport.EventGroup connectionGroup : response.getGroupsList()) {
            if (connectionGroup.getEvents(0).getTimestamp() > queryEndTimeNs || connectionGroup.getEvents(connectionGroup.getEventsCount() - 1).getTimestamp() < queryStartTimeNs && connectionGroup.getEvents(connectionGroup.getEventsCount() - 1).getIsEnded()) continue;
            HashMap events = new HashMap();
            connectionGroup.getEventsList().forEach(e -> events.put(e.getNetworkHttpConnection().getUnionCase(), (Common.Event)e));
            Common.Event requestStartEvent = events.getOrDefault(Network.NetworkHttpConnectionData.UnionCase.HTTP_REQUEST_STARTED, Common.Event.getDefaultInstance());
            Common.Event requestCompleteEvent = events.getOrDefault(Network.NetworkHttpConnectionData.UnionCase.HTTP_REQUEST_COMPLETED, Common.Event.getDefaultInstance());
            Common.Event responseStartEvent = events.getOrDefault(Network.NetworkHttpConnectionData.UnionCase.HTTP_RESPONSE_STARTED, Common.Event.getDefaultInstance());
            Common.Event responseCompleteEvent = events.getOrDefault(Network.NetworkHttpConnectionData.UnionCase.HTTP_RESPONSE_COMPLETED, Common.Event.getDefaultInstance());
            Common.Event connectionEndEvent = events.getOrDefault(Network.NetworkHttpConnectionData.UnionCase.HTTP_CLOSED, Common.Event.getDefaultInstance());
            if (requestStartEvent.equals((Object)Common.Event.getDefaultInstance()) || !connectionThreadMap.containsKey(connectionGroup.getGroupId())) continue;
            long requestStartTimeUs = TimeUnit.NANOSECONDS.toMicros(requestStartEvent.getTimestamp());
            long requestCompleteTimeUs = TimeUnit.NANOSECONDS.toMicros(requestCompleteEvent.getTimestamp());
            long respondStartTimeUs = TimeUnit.NANOSECONDS.toMicros(responseStartEvent.getTimestamp());
            long respondCompleteTimeUs = TimeUnit.NANOSECONDS.toMicros(responseCompleteEvent.getTimestamp());
            long connectionEndTimeUs = TimeUnit.NANOSECONDS.toMicros(connectionEndEvent.getTimestamp());
            List<HttpData.JavaThread> threadData = connectionThreadMap.get(connectionGroup.getGroupId()).stream().map(e -> e.getNetworkHttpThread()).map(proto -> new HttpData.JavaThread(proto.getId(), proto.getName())).collect(Collectors.toList());
            HttpData.Builder httpBuilder = new HttpData.Builder(connectionGroup.getGroupId(), requestStartTimeUs, requestCompleteTimeUs, respondStartTimeUs, respondCompleteTimeUs, connectionEndTimeUs, threadData);
            Network.NetworkHttpConnectionData.HttpRequestStarted requestStartData = requestStartEvent.getNetworkHttpConnection().getHttpRequestStarted();
            httpBuilder.setUrl(requestStartData.getUrl());
            httpBuilder.setMethod(requestStartData.getMethod());
            httpBuilder.setTrace(requestStartData.getTrace());
            httpBuilder.setRequestFields(requestStartData.getFields());
            if (!requestCompleteEvent.equals((Object)Common.Event.getDefaultInstance())) {
                httpBuilder.setRequestPayloadId(requestCompleteEvent.getNetworkHttpConnection().getHttpRequestCompleted().getPayloadId());
            }
            if (!responseStartEvent.equals((Object)Common.Event.getDefaultInstance())) {
                httpBuilder.setResponseFields(responseStartEvent.getNetworkHttpConnection().getHttpResponseStarted().getFields());
            }
            if (!responseCompleteEvent.equals((Object)Common.Event.getDefaultInstance())) {
                httpBuilder.setResponsePayloadId(responseCompleteEvent.getNetworkHttpConnection().getHttpResponseCompleted().getPayloadId());
                httpBuilder.setResponsePayloadSize(responseCompleteEvent.getNetworkHttpConnection().getHttpResponseCompleted().getPayloadSize());
            }
            httpDataList.add(httpBuilder.build());
        }
        ArrayList<HttpData> arrayList = httpDataList;
        if (arrayList == null) {
            RpcNetworkConnectionsModel.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    @Override
    @NotNull
    public ByteString requestBytes(@NotNull String id) {
        if (id == null) {
            RpcNetworkConnectionsModel.$$$reportNull$$$0(4);
        }
        if (StringUtil.isEmpty((String)id)) {
            ByteString byteString = ByteString.EMPTY;
            if (byteString == null) {
                RpcNetworkConnectionsModel.$$$reportNull$$$0(5);
            }
            return byteString;
        }
        Transport.BytesRequest request = Transport.BytesRequest.newBuilder().setStreamId(this.mySession.getStreamId()).setId(id).build();
        Transport.BytesResponse response = this.myTransportService.getBytes(request);
        ByteString byteString = response.getContents();
        if (byteString == null) {
            RpcNetworkConnectionsModel.$$$reportNull$$$0(6);
        }
        return byteString;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transportService";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "timeCurrentRangeUs";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/network/RpcNetworkConnectionsModel";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/network/RpcNetworkConnectionsModel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getData";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "requestBytes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "requestBytes";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

