/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory.chart;

import com.android.tools.adtui.TabularLayout;
import com.android.tools.adtui.TooltipView;
import com.android.tools.adtui.chart.hchart.HTreeChart;
import com.android.tools.adtui.common.AdtUiUtils;
import com.android.tools.profilers.ChartTooltipViewBase;
import com.android.tools.profilers.ProfilerColors;
import com.android.tools.profilers.memory.adapters.classifiers.ClassifierSet;
import com.android.tools.profilers.memory.adapters.classifiers.NativeCallStackSet;
import com.android.tools.profilers.memory.chart.ClassifierSetHNode;
import com.android.tools.profilers.memory.chart.VisualizationTooltipModel;
import java.awt.Component;
import java.util.Arrays;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B#\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/android/tools/profilers/memory/chart/MemoryVisualizationTooltipView;", "Lcom/android/tools/profilers/ChartTooltipViewBase;", "Lcom/android/tools/profilers/memory/chart/ClassifierSetHNode;", "chart", "Lcom/android/tools/adtui/chart/hchart/HTreeChart;", "tooltipRoot", "Ljavax/swing/JLayeredPane;", "model", "Lcom/android/tools/profilers/memory/chart/VisualizationTooltipModel;", "(Lcom/android/tools/adtui/chart/hchart/HTreeChart;Ljavax/swing/JLayeredPane;Lcom/android/tools/profilers/memory/chart/VisualizationTooltipModel;)V", "showTooltip", "", "node", "intellij.android.profilers.ui"})
public final class MemoryVisualizationTooltipView
extends ChartTooltipViewBase<ClassifierSetHNode> {
    private final VisualizationTooltipModel model;

    @Override
    public void showTooltip(@NotNull ClassifierSetHNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        this.getTooltipContainer().removeAll();
        JLabel nameLabel = new JLabel(node.getName());
        nameLabel.setFont(TooltipView.TOOLTIP_BODY_FONT);
        nameLabel.setForeground(ProfilerColors.TOOLTIP_TEXT);
        String string = this.model.getVisualizationModel().formatter().getFormattedString(this.model.getCaptureRange().getLength(), (double)node.getDuration(), this.model.getVisualizationModel().isSizeAxis());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"model.visualizationModel\u2026zationModel.isSizeAxis())");
        String formattedNumber = string;
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        CharSequence charSequence = "%s: %s";
        Object object = new Object[]{this.model.getVisualizationModel().isSizeAxis() ? "Size" : "Count", formattedNumber};
        boolean bl = false;
        String string2 = String.format((String)charSequence, Arrays.copyOf(object, ((Object[])object).length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
        JLabel totalLabel = new JLabel(string2);
        this.getTooltipContainer().add((Component)nameLabel, new TabularLayout.Constraint(0, 0, 0, 4, null));
        if (node.getData() instanceof NativeCallStackSet) {
            ClassifierSet classifierSet = node.getData();
            if (classifierSet == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.android.tools.profilers.memory.adapters.classifiers.NativeCallStackSet");
            }
            NativeCallStackSet nativeCallStackSet = (NativeCallStackSet)classifierSet;
            JPanel jPanel = this.getTooltipContainer();
            charSequence = StringCompanionObject.INSTANCE;
            object = "Module: %s";
            Object[] objectArray = new Object[]{nativeCallStackSet.getModuleName()};
            boolean bl2 = false;
            String string3 = String.format((String)object, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"java.lang.String.format(format, *args)");
            Component component = new JLabel(string3);
            JPanel jPanel2 = this.getTooltipContainer();
            Intrinsics.checkNotNullExpressionValue((Object)jPanel2, (String)"tooltipContainer");
            jPanel.add(component, new TabularLayout.Constraint(jPanel2.getComponentCount(), 0, 0, 4, null));
            String string4 = nativeCallStackSet.getFileName();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"native.fileName");
            charSequence = string4;
            boolean bl3 = false;
            if (charSequence.length() > 0) {
                JPanel jPanel3 = this.getTooltipContainer();
                charSequence = StringCompanionObject.INSTANCE;
                String string5 = "File: %s";
                objectArray = new Object[]{nativeCallStackSet.getFileName()};
                bl2 = false;
                String string6 = String.format(string5, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"java.lang.String.format(format, *args)");
                Component component2 = new JLabel(string6);
                JPanel jPanel4 = this.getTooltipContainer();
                Intrinsics.checkNotNullExpressionValue((Object)jPanel4, (String)"tooltipContainer");
                jPanel3.add(component2, new TabularLayout.Constraint(jPanel4.getComponentCount(), 0, 0, 4, null));
            }
        }
        JPanel jPanel = this.getTooltipContainer();
        Component component = AdtUiUtils.createHorizontalSeparator();
        JPanel jPanel5 = this.getTooltipContainer();
        Intrinsics.checkNotNullExpressionValue((Object)jPanel5, (String)"tooltipContainer");
        jPanel.add(component, new TabularLayout.Constraint(jPanel5.getComponentCount(), 0, 0, 4, null));
        JPanel jPanel6 = this.getTooltipContainer();
        Component component3 = totalLabel;
        JPanel jPanel7 = this.getTooltipContainer();
        Intrinsics.checkNotNullExpressionValue((Object)jPanel7, (String)"tooltipContainer");
        jPanel6.add(component3, new TabularLayout.Constraint(jPanel7.getComponentCount(), 0, 0, 4, null));
    }

    public MemoryVisualizationTooltipView(@NotNull HTreeChart<ClassifierSetHNode> chart, @NotNull JLayeredPane tooltipRoot, @NotNull VisualizationTooltipModel model) {
        Intrinsics.checkNotNullParameter(chart, (String)"chart");
        Intrinsics.checkNotNullParameter((Object)tooltipRoot, (String)"tooltipRoot");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        super(chart, tooltipRoot);
        this.model = model;
    }
}

