/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory.adapters.classifiers;

import com.android.tools.profiler.proto.Memory;
import com.android.tools.profilers.memory.adapters.CaptureObject;
import com.android.tools.profilers.memory.adapters.ClassDb;
import com.android.tools.profilers.memory.adapters.InstanceObject;
import com.android.tools.profilers.memory.adapters.classifiers.ClassSet;
import com.android.tools.profilers.memory.adapters.classifiers.Classifier;
import com.android.tools.profilers.memory.adapters.classifiers.ClassifierSet;
import com.android.tools.profilers.stacktrace.CodeLocation;
import com.google.common.base.Strings;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MethodSet
extends ClassifierSet {
    @NotNull
    private final MethodSetInfo myMethodInfo;
    @NotNull
    private final CaptureObject myCaptureObject;
    private final int myCallstackDepth;

    @NotNull
    public static Classifier createDefaultClassifier(@NotNull CaptureObject captureObject) {
        if (captureObject == null) {
            MethodSet.$$$reportNull$$$0(0);
        }
        return new MethodClassifier(captureObject, 0);
    }

    public MethodSet(@NotNull CaptureObject captureObject, @NotNull MethodSetInfo methodInfo, int callstackDepth) {
        if (captureObject == null) {
            MethodSet.$$$reportNull$$$0(1);
        }
        if (methodInfo == null) {
            MethodSet.$$$reportNull$$$0(2);
        }
        super(() -> methodInfo.getName());
        this.myCaptureObject = captureObject;
        this.myMethodInfo = methodInfo;
        this.myCallstackDepth = callstackDepth;
    }

    @Override
    @NotNull
    public Classifier createSubClassifier() {
        return new MethodClassifier(this.myCaptureObject, this.myCallstackDepth);
    }

    @NotNull
    public String getClassName() {
        String string = this.myMethodInfo.getClassName();
        if (string == null) {
            MethodSet.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public String getMethodName() {
        String string = this.myMethodInfo.getMethodName();
        if (string == null) {
            MethodSet.$$$reportNull$$$0(4);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "captureObject";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodInfo";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/memory/adapters/classifiers/MethodSet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/memory/adapters/classifiers/MethodSet";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethodName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createDefaultClassifier";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class MethodSetInfo {
        static final long INVALID_METHOD_ID = -1L;
        @NotNull
        private final CaptureObject myCaptureObject;
        private long myMethodId;
        @Nullable
        private String myClassName;
        @Nullable
        private String myMethodName;
        private boolean myResolvedNames;
        private int myHashCode;

        MethodSetInfo(@NotNull CaptureObject captureObject, @NotNull String className, @NotNull String methodName) {
            if (captureObject == null) {
                MethodSetInfo.$$$reportNull$$$0(0);
            }
            if (className == null) {
                MethodSetInfo.$$$reportNull$$$0(1);
            }
            if (methodName == null) {
                MethodSetInfo.$$$reportNull$$$0(2);
            }
            this.myCaptureObject = captureObject;
            this.myClassName = className;
            this.myMethodName = methodName;
            this.myMethodId = -1L;
            this.myHashCode = Arrays.hashCode(new int[]{this.myClassName.hashCode(), this.myMethodName.hashCode()});
            this.myResolvedNames = true;
        }

        MethodSetInfo(@NotNull CaptureObject captureObject, long methodId) {
            if (captureObject == null) {
                MethodSetInfo.$$$reportNull$$$0(3);
            }
            this.myCaptureObject = captureObject;
            this.myMethodId = methodId;
            this.myHashCode = Long.hashCode(this.myMethodId);
            this.myResolvedNames = false;
        }

        public int hashCode() {
            return this.myHashCode;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof MethodSetInfo)) {
                return false;
            }
            MethodSetInfo other = (MethodSetInfo)obj;
            if (this.myMethodId == -1L) {
                return StringUtil.equals((CharSequence)this.myClassName, (CharSequence)other.myClassName) && StringUtil.equals((CharSequence)this.myMethodName, (CharSequence)other.myMethodName);
            }
            return this.myMethodId == other.myMethodId;
        }

        @NotNull
        String getName() {
            this.resolveNames();
            StringBuilder builder = new StringBuilder();
            if (this.myMethodName != null) {
                builder.append(this.myMethodName).append("()");
            } else {
                builder.append("<unknown method>");
            }
            if (!Strings.isNullOrEmpty((String)this.myClassName)) {
                builder.append(" (").append(this.myClassName).append(")");
            }
            String string = builder.toString();
            if (string == null) {
                MethodSetInfo.$$$reportNull$$$0(4);
            }
            return string;
        }

        @NotNull
        String getClassName() {
            this.resolveNames();
            String string = this.myClassName;
            if (string == null) {
                MethodSetInfo.$$$reportNull$$$0(5);
            }
            return string;
        }

        @NotNull
        String getMethodName() {
            this.resolveNames();
            String string = this.myMethodName;
            if (string == null) {
                MethodSetInfo.$$$reportNull$$$0(6);
            }
            return string;
        }

        private void resolveNames() {
            if (this.myResolvedNames) {
                return;
            }
            assert (this.myMethodId != -1L);
            Memory.AllocationStack.StackFrame frameInfo = this.myCaptureObject.getStackFrame(this.myMethodId);
            assert (frameInfo != null);
            this.myClassName = frameInfo.getClassName();
            this.myMethodName = frameInfo.getMethodName();
            this.myResolvedNames = true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "captureObject";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "className";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "methodName";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/profilers/memory/adapters/classifiers/MethodSet$MethodSetInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/profilers/memory/adapters/classifiers/MethodSet$MethodSetInfo";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getClassName";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMethodName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static final class MethodClassifier
    extends Classifier {
        @NotNull
        private final CaptureObject myCaptureObject;
        @NotNull
        private final Map<MethodSetInfo, MethodSet> myStackLineMap;
        @NotNull
        private final Map<ClassDb.ClassEntry, ClassSet> myClassMap;
        private final int myDepth;

        private MethodClassifier(@NotNull CaptureObject captureObject, int depth) {
            if (captureObject == null) {
                MethodClassifier.$$$reportNull$$$0(0);
            }
            this.myStackLineMap = new LinkedHashMap<MethodSetInfo, MethodSet>();
            this.myClassMap = new LinkedHashMap<ClassDb.ClassEntry, ClassSet>();
            this.myCaptureObject = captureObject;
            this.myDepth = depth;
        }

        @Override
        @Nullable
        public ClassifierSet getClassifierSet(@NotNull InstanceObject instance, boolean createIfAbsent) {
            MethodSetInfo methodInfo;
            if (instance == null) {
                MethodClassifier.$$$reportNull$$$0(1);
            }
            if ((methodInfo = this.getMethodInfo(instance)) != null) {
                MethodSet methodSet = this.myStackLineMap.get(methodInfo);
                if (methodSet == null && createIfAbsent) {
                    methodSet = new MethodSet(this.myCaptureObject, methodInfo, this.myDepth + 1);
                    this.myStackLineMap.put(methodInfo, methodSet);
                }
                return methodSet;
            }
            ClassDb.ClassEntry classEntry = instance.getClassEntry();
            ClassSet classSet = this.myClassMap.get(classEntry);
            if (classSet == null && createIfAbsent) {
                classSet = new ClassSet(classEntry);
                this.myClassMap.put(classEntry, classSet);
            }
            return classSet;
        }

        @Nullable
        private MethodSetInfo getMethodInfo(@NotNull InstanceObject instance) {
            int stackDepth;
            if (instance == null) {
                MethodClassifier.$$$reportNull$$$0(2);
            }
            if ((stackDepth = instance.getCallStackDepth()) <= 0 || this.myDepth >= stackDepth) {
                return null;
            }
            int frameIndex = stackDepth - this.myDepth - 1;
            Memory.AllocationStack stack = instance.getAllocationCallStack();
            if (stack != null) {
                switch (stack.getFrameCase()) {
                    case FULL_STACK: {
                        Memory.AllocationStack.StackFrameWrapper fullStack = stack.getFullStack();
                        Memory.AllocationStack.StackFrame stackFrame = fullStack.getFrames(frameIndex);
                        return new MethodSetInfo(this.myCaptureObject, stackFrame.getClassName(), stackFrame.getMethodName());
                    }
                    case ENCODED_STACK: {
                        Memory.AllocationStack.EncodedFrameWrapper smallStack = stack.getEncodedStack();
                        Memory.AllocationStack.EncodedFrame smallFrame = smallStack.getFrames(frameIndex);
                        return new MethodSetInfo(this.myCaptureObject, smallFrame.getMethodId());
                    }
                }
                throw new UnsupportedOperationException();
            }
            assert (frameIndex >= 0 && frameIndex < stackDepth);
            CodeLocation location = instance.getAllocationCodeLocations().get(frameIndex);
            return new MethodSetInfo(this.myCaptureObject, Strings.nullToEmpty((String)location.getClassName()), Strings.nullToEmpty((String)location.getMethodName()));
        }

        @Override
        @NotNull
        public List<ClassifierSet> getFilteredClassifierSets() {
            List<ClassifierSet> list = Stream.concat(this.myStackLineMap.values().stream(), this.myClassMap.values().stream()).filter(child -> !child.getIsFiltered()).collect(Collectors.toList());
            if (list == null) {
                MethodClassifier.$$$reportNull$$$0(3);
            }
            return list;
        }

        @Override
        @NotNull
        protected List<ClassifierSet> getAllClassifierSets() {
            List<ClassifierSet> list = Stream.concat(this.myStackLineMap.values().stream(), this.myClassMap.values().stream()).collect(Collectors.toList());
            if (list == null) {
                MethodClassifier.$$$reportNull$$$0(4);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "captureObject";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "instance";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/profilers/memory/adapters/classifiers/MethodSet$MethodClassifier";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/profilers/memory/adapters/classifiers/MethodSet$MethodClassifier";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFilteredClassifierSets";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAllClassifierSets";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getClassifierSet";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getMethodInfo";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

