/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory.adapters.classifiers;

import com.android.tools.adtui.model.filter.Filter;
import com.android.tools.profilers.CachedFunction;
import com.android.tools.profilers.memory.adapters.InstanceObject;
import com.android.tools.profilers.memory.adapters.MemoryObject;
import com.android.tools.profilers.memory.adapters.classifiers.Classifier;
import com.android.tools.profilers.memory.adapters.instancefilters.CaptureObjectInstanceFilter;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ClassifierSet
implements MemoryObject {
    @Nullable
    private String myName;
    @Nullable
    private Supplier<String> myNameSupplier;
    @NotNull
    protected final Set<InstanceObject> mySnapshotInstances;
    @NotNull
    protected final Set<InstanceObject> myDeltaInstances;
    @Nullable
    protected Classifier myClassifier;
    private int myObjectSetCount;
    private int myFilteredObjectSetCount;
    private int mySnapshotObjectCount;
    private int myDeltaAllocations;
    private int myDeltaDeallocations;
    private long myDeltaAllocationsSize;
    private long myDeltaDeallocationsSize;
    private long myTotalNativeSize;
    private long myTotalShallowSize;
    private long myTotalRetainedSize;
    private int myInstancesWithStackInfoCount;
    protected int myFilterMatchCount;
    private final CachedFunction<CaptureObjectInstanceFilter, Integer> myInstanceFilterMatchCounter;
    protected boolean myIsFiltered;
    protected boolean myIsMatched;
    protected boolean myNeedsRefiltering;

    public ClassifierSet(@NotNull String name) {
        if (name == null) {
            ClassifierSet.$$$reportNull$$$0(0);
        }
        this.myNameSupplier = null;
        this.mySnapshotInstances = new LinkedHashSet<InstanceObject>(0);
        this.myDeltaInstances = new LinkedHashSet<InstanceObject>(0);
        this.myClassifier = null;
        this.myObjectSetCount = 0;
        this.myFilteredObjectSetCount = 0;
        this.mySnapshotObjectCount = 0;
        this.myDeltaAllocations = 0;
        this.myDeltaDeallocations = 0;
        this.myDeltaAllocationsSize = 0L;
        this.myDeltaDeallocationsSize = 0L;
        this.myTotalNativeSize = 0L;
        this.myTotalShallowSize = 0L;
        this.myTotalRetainedSize = 0L;
        this.myInstancesWithStackInfoCount = 0;
        this.myFilterMatchCount = 0;
        this.myInstanceFilterMatchCounter = new CachedFunction(this::countInstanceFilterMatch, new IdentityHashMap());
        this.myName = name;
    }

    public ClassifierSet(@NotNull Supplier<String> nameSupplier) {
        if (nameSupplier == null) {
            ClassifierSet.$$$reportNull$$$0(1);
        }
        this.myNameSupplier = null;
        this.mySnapshotInstances = new LinkedHashSet<InstanceObject>(0);
        this.myDeltaInstances = new LinkedHashSet<InstanceObject>(0);
        this.myClassifier = null;
        this.myObjectSetCount = 0;
        this.myFilteredObjectSetCount = 0;
        this.mySnapshotObjectCount = 0;
        this.myDeltaAllocations = 0;
        this.myDeltaDeallocations = 0;
        this.myDeltaAllocationsSize = 0L;
        this.myDeltaDeallocationsSize = 0L;
        this.myTotalNativeSize = 0L;
        this.myTotalShallowSize = 0L;
        this.myTotalRetainedSize = 0L;
        this.myInstancesWithStackInfoCount = 0;
        this.myFilterMatchCount = 0;
        this.myInstanceFilterMatchCounter = new CachedFunction(this::countInstanceFilterMatch, new IdentityHashMap());
        this.myNameSupplier = nameSupplier;
    }

    @Override
    @NotNull
    public String getName() {
        if (this.myName == null) {
            assert (this.myNameSupplier != null);
            this.myName = this.myNameSupplier.get();
        }
        String string = this.myName;
        if (string == null) {
            ClassifierSet.$$$reportNull$$$0(2);
        }
        return string;
    }

    public final boolean isEmpty() {
        return this.mySnapshotObjectCount == 0 && this.myDeltaAllocations == 0 && this.myDeltaDeallocations == 0;
    }

    public final int getTotalObjectCount() {
        return this.mySnapshotObjectCount + this.myDeltaAllocations - this.myDeltaDeallocations;
    }

    public final int getTotalObjectSetCount() {
        return this.myObjectSetCount;
    }

    public final int getFilteredObjectSetCount() {
        return this.myFilteredObjectSetCount;
    }

    public final int getDeltaAllocationCount() {
        return this.myDeltaAllocations;
    }

    public final int getDeltaDeallocationCount() {
        return this.myDeltaDeallocations;
    }

    public final long getTotalRetainedSize() {
        return this.myTotalRetainedSize;
    }

    public final long getTotalShallowSize() {
        return this.myTotalShallowSize;
    }

    public final long getTotalNativeSize() {
        return this.myTotalNativeSize;
    }

    public final int getFilterMatchCount() {
        return this.myFilterMatchCount;
    }

    public final long getAllocationSize() {
        return this.myDeltaAllocationsSize;
    }

    public final long getDeallocationSize() {
        return this.myDeltaDeallocationsSize;
    }

    public final long getTotalRemainingSize() {
        return this.getAllocationSize() - this.getDeallocationSize();
    }

    public final int getInstanceFilterMatchCount(CaptureObjectInstanceFilter filter) {
        return this.myInstanceFilterMatchCounter.invoke(filter);
    }

    public void addSnapshotInstanceObject(@NotNull InstanceObject instanceObject) {
        if (instanceObject == null) {
            ClassifierSet.$$$reportNull$$$0(3);
        }
        this.changeSnapshotInstanceObject(instanceObject, true, Set::add);
    }

    public void removeSnapshotInstanceObject(@NotNull InstanceObject instanceObject) {
        if (instanceObject == null) {
            ClassifierSet.$$$reportNull$$$0(4);
        }
        this.changeSnapshotInstanceObject(instanceObject, false, Set::remove);
    }

    private void changeSnapshotInstanceObject(@NotNull InstanceObject instanceObject, boolean isAdding, BiConsumer<Set<InstanceObject>, InstanceObject> handler) {
        if (instanceObject == null) {
            ClassifierSet.$$$reportNull$$$0(5);
        }
        if (this.myClassifier != null && !this.myClassifier.isTerminalClassifier()) {
            ClassifierSet classifierSet = this.myClassifier.getClassifierSet(instanceObject, isAdding);
            assert (classifierSet != null);
            classifierSet.changeSnapshotInstanceObject(instanceObject, isAdding, handler);
        } else {
            assert (isAdding == !this.mySnapshotInstances.contains(instanceObject));
            handler.accept(this.mySnapshotInstances, instanceObject);
        }
        int unit = isAdding ? 1 : -1;
        this.mySnapshotObjectCount += unit;
        this.myTotalNativeSize += (long)unit * ClassifierSet.validOrZero(instanceObject.getNativeSize());
        this.myTotalShallowSize += (long)unit * ClassifierSet.validOrZero(instanceObject.getShallowSize());
        this.myTotalRetainedSize += (long)unit * ClassifierSet.validOrZero(instanceObject.getRetainedSize());
        if (!instanceObject.isCallStackEmpty()) {
            this.myInstancesWithStackInfoCount += unit;
        }
        this.myInstanceFilterMatchCounter.invalidate();
        this.myNeedsRefiltering = true;
    }

    public boolean addDeltaInstanceObject(@NotNull InstanceObject instanceObject) {
        if (instanceObject == null) {
            ClassifierSet.$$$reportNull$$$0(6);
        }
        return this.changeDeltaInstanceInformation(instanceObject, true, true, Set::add);
    }

    public boolean freeDeltaInstanceObject(@NotNull InstanceObject instanceObject) {
        if (instanceObject == null) {
            ClassifierSet.$$$reportNull$$$0(7);
        }
        return this.changeDeltaInstanceInformation(instanceObject, false, true, Set::add);
    }

    public boolean removeAddedDeltaInstanceObject(@NotNull InstanceObject instanceObject) {
        if (instanceObject == null) {
            ClassifierSet.$$$reportNull$$$0(8);
        }
        return this.changeDeltaInstanceInformation(instanceObject, true, false, Set::remove);
    }

    public boolean removeFreedDeltaInstanceObject(@NotNull InstanceObject instanceObject) {
        if (instanceObject == null) {
            ClassifierSet.$$$reportNull$$$0(9);
        }
        return this.changeDeltaInstanceInformation(instanceObject, false, false, Set::remove);
    }

    private boolean changeDeltaInstanceInformation(@NotNull InstanceObject instanceObject, boolean isAllocation, boolean isAdding, BiConsumer<Set<InstanceObject>, InstanceObject> handler) {
        int unit;
        if (instanceObject == null) {
            ClassifierSet.$$$reportNull$$$0(10);
        }
        boolean instanceChanged = false;
        if (this.myClassifier != null && !this.myClassifier.isTerminalClassifier()) {
            ClassifierSet classifierSet = this.myClassifier.getClassifierSet(instanceObject, isAdding);
            assert (classifierSet != null);
            instanceChanged = classifierSet.changeDeltaInstanceInformation(instanceObject, isAllocation, isAdding, handler);
        } else if ((isAdding || !instanceObject.hasTimeData()) && isAdding == !this.myDeltaInstances.contains(instanceObject)) {
            handler.accept(this.myDeltaInstances, instanceObject);
            instanceChanged = true;
        }
        int n = unit = isAdding ? 1 : -1;
        if (isAllocation) {
            this.myDeltaAllocations += unit * instanceObject.getInstanceCount();
            this.myDeltaAllocationsSize += (long)(unit * instanceObject.getShallowSize());
        } else {
            this.myDeltaDeallocations += unit * instanceObject.getInstanceCount();
            this.myDeltaDeallocationsSize += (long)(unit * instanceObject.getShallowSize());
        }
        int factor = unit * (isAllocation ? 1 : -1);
        this.myTotalNativeSize += (long)factor * ClassifierSet.validOrZero(instanceObject.getNativeSize());
        this.myTotalShallowSize += (long)factor * ClassifierSet.validOrZero(instanceObject.getShallowSize());
        this.myTotalRetainedSize += (long)factor * ClassifierSet.validOrZero(instanceObject.getRetainedSize());
        if (instanceChanged && !instanceObject.isCallStackEmpty()) {
            this.myInstancesWithStackInfoCount += unit;
            this.myNeedsRefiltering = true;
        }
        if (instanceChanged) {
            this.myInstanceFilterMatchCounter.invalidate();
        }
        return instanceChanged;
    }

    public void clearClassifierSets() {
        this.mySnapshotInstances.clear();
        this.myDeltaInstances.clear();
        this.myClassifier = this.createSubClassifier();
        this.mySnapshotObjectCount = 0;
        this.myDeltaAllocations = 0;
        this.myDeltaDeallocations = 0;
        this.myTotalShallowSize = 0L;
        this.myTotalNativeSize = 0L;
        this.myTotalRetainedSize = 0L;
        this.myInstancesWithStackInfoCount = 0;
        this.myObjectSetCount = 0;
        this.myFilteredObjectSetCount = 0;
        this.myFilterMatchCount = 0;
    }

    public int getInstancesCount() {
        return (int)this.getInstancesStream().count();
    }

    @NotNull
    public Stream<InstanceObject> getInstancesStream() {
        Stream<InstanceObject> stream = this.getStreamOf(me -> Stream.concat(me.mySnapshotInstances.stream(), me.myDeltaInstances.stream()).distinct());
        if (stream == null) {
            ClassifierSet.$$$reportNull$$$0(11);
        }
        return stream;
    }

    @NotNull
    protected Stream<InstanceObject> getDeltaInstanceStream() {
        Stream<InstanceObject> stream = this.getStreamOf(me -> me.myDeltaInstances.stream());
        if (stream == null) {
            ClassifierSet.$$$reportNull$$$0(12);
        }
        return stream;
    }

    @NotNull
    protected Stream<InstanceObject> getSnapshotInstanceStream() {
        Stream<InstanceObject> stream = this.getStreamOf(me -> me.mySnapshotInstances.stream());
        if (stream == null) {
            ClassifierSet.$$$reportNull$$$0(13);
        }
        return stream;
    }

    public Stream<InstanceObject> getFilterMatches() {
        return this.getStreamOf(me -> me.getIsMatched() ? me.getInstancesStream() : Stream.empty());
    }

    private Stream<InstanceObject> getStreamOf(Function<ClassifierSet, Stream<InstanceObject>> extractor) {
        return this.myClassifier == null ? extractor.apply(this) : Stream.concat(this.myClassifier.getAllClassifierSets().stream().flatMap(sub -> sub.getStreamOf(extractor)), extractor.apply(this));
    }

    public boolean hasStackInfo() {
        return this.myInstancesWithStackInfoCount > 0;
    }

    @NotNull
    public List<ClassifierSet> getChildrenClassifierSets() {
        this.ensurePartition();
        assert (this.myClassifier != null);
        List<ClassifierSet> list = this.myClassifier.getFilteredClassifierSets();
        if (list == null) {
            ClassifierSet.$$$reportNull$$$0(14);
        }
        return list;
    }

    @Nullable
    public ClassifierSet findContainingClassifierSet(@NotNull InstanceObject target) {
        if (target == null) {
            ClassifierSet.$$$reportNull$$$0(15);
        }
        boolean instancesContainsTarget = Stream.concat(this.mySnapshotInstances.stream(), this.myDeltaInstances.stream()).anyMatch(target::equals);
        if (instancesContainsTarget && this.myClassifier != null) {
            return this;
        }
        if (instancesContainsTarget || this.myClassifier != null) {
            List<ClassifierSet> childrenClassifierSets = this.getChildrenClassifierSets();
            boolean stillContainsTarget = Stream.concat(this.mySnapshotInstances.stream(), this.myDeltaInstances.stream()).anyMatch(target::equals);
            if (instancesContainsTarget && stillContainsTarget) {
                return this;
            }
            for (ClassifierSet set : childrenClassifierSets) {
                ClassifierSet result = set.findContainingClassifierSet(target);
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }

    @Nullable
    public ClassifierSet findClassifierSet(@NotNull Predicate<ClassifierSet> pred) {
        if (pred == null) {
            ClassifierSet.$$$reportNull$$$0(16);
        }
        if (pred.test(this)) {
            return this;
        }
        if (this.myClassifier != null) {
            return this.getChildrenClassifierSets().stream().map(s -> s.findClassifierSet(pred)).filter(Objects::nonNull).findFirst().orElse(null);
        }
        return null;
    }

    public boolean isSupersetOf(Set<InstanceObject> targetSet) {
        return this.getNonMembers(targetSet).isEmpty();
    }

    private Set<InstanceObject> getNonMembers(Set<InstanceObject> instances) {
        Set<InstanceObject> remainders = Collections.newSetFromMap(new IdentityHashMap());
        for (InstanceObject inst : instances) {
            if (this.myDeltaInstances.contains(inst) || this.mySnapshotInstances.contains(inst)) continue;
            remainders.add(inst);
        }
        if (this.myClassifier != null && !remainders.isEmpty()) {
            for (ClassifierSet child : this.myClassifier.getAllClassifierSets()) {
                remainders.retainAll(child.getNonMembers(remainders));
                if (!remainders.isEmpty()) continue;
                return remainders;
            }
        }
        return remainders;
    }

    protected void ensurePartition() {
        if (this.myClassifier == null) {
            this.myClassifier = this.createSubClassifier();
            this.myClassifier.partition(this.mySnapshotInstances, this.myDeltaInstances);
        }
    }

    @NotNull
    protected abstract Classifier createSubClassifier();

    public boolean getIsFiltered() {
        return this.isEmpty() || this.myIsFiltered;
    }

    public boolean getIsMatched() {
        return this.myIsMatched;
    }

    protected void applyFilter(@NotNull Filter filter, boolean hasMatchedAncestor, boolean filterChanged) {
        if (filter == null) {
            ClassifierSet.$$$reportNull$$$0(17);
        }
        if (!filterChanged && !this.myNeedsRefiltering) {
            return;
        }
        this.myIsFiltered = true;
        this.ensurePartition();
        this.mySnapshotObjectCount = 0;
        this.myDeltaAllocations = 0;
        this.myDeltaDeallocations = 0;
        this.myTotalShallowSize = 0L;
        this.myTotalNativeSize = 0L;
        this.myTotalRetainedSize = 0L;
        this.myInstancesWithStackInfoCount = 0;
        this.myObjectSetCount = this.myClassifier.getAllClassifierSets().size();
        this.myFilteredObjectSetCount = 0;
        this.myIsMatched = this.matches(filter);
        int n = this.myFilterMatchCount = this.myIsMatched ? 1 : 0;
        assert (this.myClassifier != null);
        for (ClassifierSet classifierSet : this.myClassifier.getAllClassifierSets()) {
            classifierSet.applyFilter(filter, hasMatchedAncestor || this.myIsMatched, filterChanged);
            this.myObjectSetCount += classifierSet.myObjectSetCount;
            if (classifierSet.getIsFiltered()) continue;
            this.myIsFiltered = false;
            this.mySnapshotObjectCount += classifierSet.mySnapshotObjectCount;
            this.myDeltaAllocations += classifierSet.myDeltaAllocations;
            this.myDeltaDeallocations += classifierSet.myDeltaDeallocations;
            this.myTotalShallowSize += classifierSet.myTotalShallowSize;
            this.myTotalNativeSize += classifierSet.myTotalNativeSize;
            this.myTotalRetainedSize += classifierSet.myTotalRetainedSize;
            this.myInstancesWithStackInfoCount += classifierSet.myInstancesWithStackInfoCount;
            this.myFilterMatchCount += classifierSet.myFilterMatchCount;
            ++this.myFilteredObjectSetCount;
        }
        this.myNeedsRefiltering = false;
    }

    protected boolean matches(@NotNull Filter filter) {
        if (filter == null) {
            ClassifierSet.$$$reportNull$$$0(18);
        }
        return filter.matches(this.getName());
    }

    private int countInstanceFilterMatch(CaptureObjectInstanceFilter filter) {
        if (this.myClassifier != null && !this.myClassifier.isTerminalClassifier()) {
            return this.myClassifier.getAllClassifierSets().stream().mapToInt(s -> s.getInstanceFilterMatchCount(filter)).sum();
        }
        int total = 0;
        for (InstanceObject inst : this.myDeltaInstances) {
            if (!((Boolean)filter.getInstanceTest().invoke((Object)inst)).booleanValue()) continue;
            ++total;
        }
        for (InstanceObject inst : this.mySnapshotInstances) {
            if (this.myDeltaInstances.contains(inst) || !((Boolean)filter.getInstanceTest().invoke((Object)inst)).booleanValue()) continue;
            ++total;
        }
        return total;
    }

    private static long validOrZero(long value) {
        return value == -1L ? 0L : value;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameSupplier";
                break;
            }
            case 2: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/memory/adapters/classifiers/ClassifierSet";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instanceObject";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pred";
                break;
            }
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/memory/adapters/classifiers/ClassifierSet";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstancesStream";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeltaInstanceStream";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getSnapshotInstanceStream";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildrenClassifierSets";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addSnapshotInstanceObject";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "removeSnapshotInstanceObject";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "changeSnapshotInstanceObject";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addDeltaInstanceObject";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "freeDeltaInstanceObject";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "removeAddedDeltaInstanceObject";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "removeFreedDeltaInstanceObject";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "changeDeltaInstanceInformation";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findContainingClassifierSet";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "findClassifierSet";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "applyFilter";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "matches";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

