/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory.adapters;

import com.android.tools.adtui.model.Range;
import com.android.tools.idea.protobuf.ByteString;
import com.android.tools.perflib.captures.DataBuffer;
import com.android.tools.perflib.heap.ClassObj;
import com.android.tools.perflib.heap.Instance;
import com.android.tools.perflib.heap.Snapshot;
import com.android.tools.perflib.heap.ext.NativeRegistryPostProcessor;
import com.android.tools.perflib.heap.io.InMemoryBuffer;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.Memory;
import com.android.tools.profiler.proto.Transport;
import com.android.tools.profilers.IdeProfilerServices;
import com.android.tools.profilers.ProfilerClient;
import com.android.tools.profilers.analytics.FeatureTracker;
import com.android.tools.profilers.memory.MemoryProfiler;
import com.android.tools.profilers.memory.MemoryProfilerStage;
import com.android.tools.profilers.memory.adapters.CaptureObject;
import com.android.tools.profilers.memory.adapters.CaptureObjectUtils;
import com.android.tools.profilers.memory.adapters.ClassDb;
import com.android.tools.profilers.memory.adapters.HeapDumpInstanceObject;
import com.android.tools.profilers.memory.adapters.InstanceObject;
import com.android.tools.profilers.memory.adapters.ValueObject;
import com.android.tools.profilers.memory.adapters.classifiers.AllHeapSet;
import com.android.tools.profilers.memory.adapters.classifiers.ClassifierSet;
import com.android.tools.profilers.memory.adapters.classifiers.HeapSet;
import com.android.tools.profilers.memory.adapters.instancefilters.ActivityFragmentLeakInstanceFilter;
import com.android.tools.profilers.memory.adapters.instancefilters.CaptureObjectInstanceFilter;
import com.android.tools.profilers.memory.adapters.instancefilters.ProjectClassesInstanceFilter;
import com.android.tools.proguard.ProguardMap;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import gnu.trove.TLongObjectHashMap;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HeapDumpCaptureObject
implements CaptureObject {
    @NotNull
    private final ProfilerClient myClient;
    @NotNull
    private final Common.Session mySession;
    @NotNull
    private final FeatureTracker myFeatureTracker;
    @NotNull
    private final Map<Integer, HeapSet> myHeapSets;
    @NotNull
    private final TLongObjectHashMap<InstanceObject> myInstanceIndex;
    @NotNull
    private final ClassDb myClassDb;
    @NotNull
    private final Memory.HeapDumpInfo myHeapDumpInfo;
    @Nullable
    private final ProguardMap myProguardMap;
    @Nullable
    private volatile boolean hasLoaded;
    private volatile boolean myIsLoadingError;
    private boolean myHasNativeAllocations;
    @NotNull
    private final IdeProfilerServices myIdeProfilerServices;
    private final ActivityFragmentLeakInstanceFilter myActivityFragmentLeakFilter;
    private final Set<CaptureObjectInstanceFilter> mySupportedInstanceFilters;
    private final Set<CaptureObjectInstanceFilter> myCurrentInstanceFilters;
    private final ListeningExecutorService myExecutorService;

    public HeapDumpCaptureObject(@NotNull ProfilerClient client, @NotNull Common.Session session, @NotNull Memory.HeapDumpInfo heapDumpInfo, @Nullable ProguardMap proguardMap, @NotNull FeatureTracker featureTracker, @NotNull IdeProfilerServices ideProfilerServices) {
        if (client == null) {
            HeapDumpCaptureObject.$$$reportNull$$$0(0);
        }
        if (session == null) {
            HeapDumpCaptureObject.$$$reportNull$$$0(1);
        }
        if (heapDumpInfo == null) {
            HeapDumpCaptureObject.$$$reportNull$$$0(2);
        }
        if (featureTracker == null) {
            HeapDumpCaptureObject.$$$reportNull$$$0(3);
        }
        if (ideProfilerServices == null) {
            HeapDumpCaptureObject.$$$reportNull$$$0(4);
        }
        this.myHeapSets = new HashMap<Integer, HeapSet>();
        this.myInstanceIndex = new TLongObjectHashMap();
        this.myClassDb = new ClassDb();
        this.hasLoaded = false;
        this.myIsLoadingError = false;
        this.myCurrentInstanceFilters = new HashSet<CaptureObjectInstanceFilter>();
        this.myExecutorService = MoreExecutors.listeningDecorator((ExecutorService)Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat("memory-heapdump-instancefilters").build()));
        this.myClient = client;
        this.mySession = session;
        this.myHeapDumpInfo = heapDumpInfo;
        this.myProguardMap = proguardMap;
        this.myFeatureTracker = featureTracker;
        this.myIdeProfilerServices = ideProfilerServices;
        this.myActivityFragmentLeakFilter = new ActivityFragmentLeakInstanceFilter(this.myClassDb);
        this.mySupportedInstanceFilters = ImmutableSet.of((Object)this.myActivityFragmentLeakFilter, (Object)new ProjectClassesInstanceFilter(ideProfilerServices));
    }

    @Override
    @NotNull
    public String getName() {
        return "Heap Dump";
    }

    @Override
    public boolean isExportable() {
        return true;
    }

    @Override
    @Nullable
    public String getExportableExtension() {
        return "hprof";
    }

    @Override
    public void saveToFile(@NotNull OutputStream outputStream) {
        if (outputStream == null) {
            HeapDumpCaptureObject.$$$reportNull$$$0(5);
        }
        MemoryProfiler.saveHeapDumpToFile(this.myClient, this.mySession, this.myHeapDumpInfo, outputStream, this.myFeatureTracker);
    }

    @VisibleForTesting
    @NotNull
    ClassDb getClassDb() {
        ClassDb classDb = this.myClassDb;
        if (classDb == null) {
            HeapDumpCaptureObject.$$$reportNull$$$0(6);
        }
        return classDb;
    }

    @Override
    @NotNull
    public Collection<HeapSet> getHeapSets() {
        Collection<HeapSet> collection = this.hasLoaded ? this.myHeapSets.values() : Collections.emptyList();
        if (collection == null) {
            HeapDumpCaptureObject.$$$reportNull$$$0(7);
        }
        return collection;
    }

    @Override
    @Nullable
    public HeapSet getHeapSet(int heapId) {
        return this.myHeapSets.getOrDefault(heapId, null);
    }

    @Override
    @NotNull
    public Stream<InstanceObject> getInstances() {
        Stream<InstanceObject> stream = this.hasLoaded ? this.getHeapSets().stream().map(ClassifierSet::getInstancesStream).flatMap(Function.identity()) : Stream.empty();
        if (stream == null) {
            HeapDumpCaptureObject.$$$reportNull$$$0(8);
        }
        return stream;
    }

    @Override
    public long getStartTimeNs() {
        return this.myHeapDumpInfo.getStartTime();
    }

    @Override
    public long getEndTimeNs() {
        return this.myHeapDumpInfo.getEndTime();
    }

    public boolean getHasNativeAllocations() {
        return this.myHasNativeAllocations;
    }

    @Override
    public ClassDb getClassDatabase() {
        return this.myClassDb;
    }

    @Override
    public boolean load(@Nullable Range queryRange, @Nullable Executor queryJoiner) {
        Transport.BytesResponse response = this.myClient.getTransportClient().getBytes(Transport.BytesRequest.newBuilder().setStreamId(this.mySession.getStreamId()).setId(Long.toString(this.myHeapDumpInfo.getStartTime())).build());
        if (response.getContents() == ByteString.EMPTY) {
            this.myIsLoadingError = true;
            return false;
        }
        this.load(new InMemoryBuffer(response.getContents().asReadOnlyByteBuffer()));
        return true;
    }

    @VisibleForTesting
    public final void load(InMemoryBuffer buffer) {
        NativeRegistryPostProcessor nativeRegistryPostProcessor = new NativeRegistryPostProcessor();
        Snapshot snapshot = Snapshot.createSnapshot((DataBuffer)buffer, (ProguardMap)(this.myProguardMap != null ? this.myProguardMap : new ProguardMap()), Collections.singletonList(nativeRegistryPostProcessor));
        snapshot.computeDominators();
        this.myHasNativeAllocations = nativeRegistryPostProcessor.getHasNativeAllocations();
        this.hasLoaded = true;
        InstanceObject javaLangClassObject = snapshot.getHeaps().stream().flatMap(h -> h.getClasses().stream().filter(obj -> "java.lang.Class".equals(obj.getClassName()))).map(cl -> this.createClassObjectInstance(null, (ClassObj)cl)).findAny().orElse(null);
        if (this.myIdeProfilerServices.getFeatureConfig().isSeparateHeapDumpUiEnabled()) {
            Map heapSets = snapshot.getHeaps().stream().collect(Collectors.toMap(Function.identity(), heap -> new HeapSet(this, heap.getName(), heap.getId())));
            AllHeapSet superHeap = new AllHeapSet(this, heapSets.values().toArray(new HeapSet[0]));
            superHeap.clearClassifierSets();
            this.myHeapSets.put(superHeap.getId(), superHeap);
            heapSets.forEach((heap, heapSet) -> {
                heap.getClasses().forEach(cl -> this.addInstance(superHeap, cl.getId(), this.createClassObjectInstance(javaLangClassObject, (ClassObj)cl)));
                heap.forEachInstance(instance -> {
                    assert (!"java.lang.Class".equals(instance.getClassObj().getClassName()));
                    ClassObj classObj = instance.getClassObj();
                    ClassDb.ClassEntry classEntry = classObj.getSuperClassObj() != null ? this.myClassDb.registerClass(classObj.getId(), classObj.getSuperClassObj().getId(), classObj.getClassName()) : this.myClassDb.registerClass(classObj.getId(), classObj.getClassName());
                    this.addInstance(superHeap, instance.getId(), new HeapDumpInstanceObject(this, (Instance)instance, classEntry, null));
                    return true;
                });
                if (!"default".equals(heap.getName()) || snapshot.getHeaps().size() == 1 || heap.getInstancesCount() > 0) {
                    this.myHeapSets.put(heap.getId(), (HeapSet)heapSet);
                }
            });
        } else {
            snapshot.getHeaps().forEach(heap -> {
                HeapSet heapSet = new HeapSet(this, heap.getName(), heap.getId());
                heap.getClasses().forEach(cl -> this.addInstance(heapSet, cl.getId(), this.createClassObjectInstance(javaLangClassObject, (ClassObj)cl)));
                heap.forEachInstance(instance -> {
                    assert (!"java.lang.Class".equals(instance.getClassObj().getClassName()));
                    ClassObj classObj = instance.getClassObj();
                    ClassDb.ClassEntry classEntry = classObj.getSuperClassObj() != null ? this.myClassDb.registerClass(classObj.getId(), classObj.getSuperClassObj().getId(), classObj.getClassName()) : this.myClassDb.registerClass(classObj.getId(), classObj.getClassName());
                    this.addInstance(heapSet, instance.getId(), new HeapDumpInstanceObject(this, (Instance)instance, classEntry, null));
                    return true;
                });
                if (!"default".equals(heap.getName()) || snapshot.getHeaps().size() == 1 || heap.getInstancesCount() > 0) {
                    this.myHeapSets.put(heap.getId(), heapSet);
                }
            });
        }
    }

    private void addInstance(HeapSet heapSet, long id, InstanceObject instObj) {
        assert (!this.myInstanceIndex.containsKey(id));
        this.myInstanceIndex.put(id, (Object)instObj);
        heapSet.addDeltaInstanceObject(instObj);
    }

    @Override
    public boolean isDoneLoading() {
        return this.hasLoaded || this.myIsLoadingError;
    }

    @Override
    public boolean isError() {
        return this.myIsLoadingError;
    }

    @Override
    public void unload() {
        this.myExecutorService.shutdownNow();
    }

    @Override
    @NotNull
    public List<CaptureObject.ClassifierAttribute> getClassifierAttributes() {
        List<CaptureObject.ClassifierAttribute> list = this.myHasNativeAllocations ? Arrays.asList(CaptureObject.ClassifierAttribute.LABEL, CaptureObject.ClassifierAttribute.ALLOCATIONS, CaptureObject.ClassifierAttribute.NATIVE_SIZE, CaptureObject.ClassifierAttribute.SHALLOW_SIZE, CaptureObject.ClassifierAttribute.RETAINED_SIZE) : Arrays.asList(CaptureObject.ClassifierAttribute.LABEL, CaptureObject.ClassifierAttribute.ALLOCATIONS, CaptureObject.ClassifierAttribute.SHALLOW_SIZE, CaptureObject.ClassifierAttribute.RETAINED_SIZE);
        if (list == null) {
            HeapDumpCaptureObject.$$$reportNull$$$0(9);
        }
        return list;
    }

    @Override
    @NotNull
    public List<CaptureObject.InstanceAttribute> getInstanceAttributes() {
        List<CaptureObject.InstanceAttribute> list = this.myHasNativeAllocations ? Arrays.asList(CaptureObject.InstanceAttribute.LABEL, CaptureObject.InstanceAttribute.DEPTH, CaptureObject.InstanceAttribute.NATIVE_SIZE, CaptureObject.InstanceAttribute.SHALLOW_SIZE, CaptureObject.InstanceAttribute.RETAINED_SIZE) : Arrays.asList(CaptureObject.InstanceAttribute.LABEL, CaptureObject.InstanceAttribute.DEPTH, CaptureObject.InstanceAttribute.SHALLOW_SIZE, CaptureObject.InstanceAttribute.RETAINED_SIZE);
        if (list == null) {
            HeapDumpCaptureObject.$$$reportNull$$$0(10);
        }
        return list;
    }

    @Nullable
    public InstanceObject findInstanceObject(@NotNull Instance instance) {
        if (instance == null) {
            HeapDumpCaptureObject.$$$reportNull$$$0(11);
        }
        return this.hasLoaded ? (InstanceObject)this.myInstanceIndex.get(instance.getId()) : null;
    }

    @NotNull
    InstanceObject createClassObjectInstance(@Nullable InstanceObject javaLangClass, @NotNull ClassObj classObj) {
        if (classObj == null) {
            HeapDumpCaptureObject.$$$reportNull$$$0(12);
        }
        String className = javaLangClass == null ? "java.lang.Class" : classObj.getClassName();
        ClassDb.ClassEntry classEntry = classObj.getSuperClassObj() != null ? this.myClassDb.registerClass(classObj.getId(), classObj.getSuperClassObj().getId(), className) : this.myClassDb.registerClass(classObj.getId(), className);
        return new HeapDumpInstanceObject(this, (Instance)classObj, javaLangClass == null ? classEntry : javaLangClass.getClassEntry(), ValueObject.ValueType.CLASS);
    }

    @Override
    public ActivityFragmentLeakInstanceFilter getActivityFragmentLeakFilter() {
        return this.myActivityFragmentLeakFilter;
    }

    @Override
    @NotNull
    public Set<CaptureObjectInstanceFilter> getSupportedInstanceFilters() {
        Set<CaptureObjectInstanceFilter> set = this.mySupportedInstanceFilters;
        if (set == null) {
            HeapDumpCaptureObject.$$$reportNull$$$0(13);
        }
        return set;
    }

    @Override
    @NotNull
    public Set<CaptureObjectInstanceFilter> getSelectedInstanceFilters() {
        Set<CaptureObjectInstanceFilter> set = this.myCurrentInstanceFilters;
        if (set == null) {
            HeapDumpCaptureObject.$$$reportNull$$$0(14);
        }
        return set;
    }

    @VisibleForTesting
    ExecutorService getInstanceFilterExecutor() {
        return this.myExecutorService;
    }

    @Override
    public ListenableFuture<Void> addInstanceFilter(@NotNull CaptureObjectInstanceFilter filterToAdd, @NotNull Executor analyzeJoiner) {
        if (filterToAdd == null) {
            HeapDumpCaptureObject.$$$reportNull$$$0(15);
        }
        if (analyzeJoiner == null) {
            HeapDumpCaptureObject.$$$reportNull$$$0(16);
        }
        assert (this.mySupportedInstanceFilters.contains(filterToAdd));
        this.myCurrentInstanceFilters.add(filterToAdd);
        return this.myExecutorService.submit(() -> {
            Set currentInstances = this.myHeapSets.values().stream().flatMap(ClassifierSet::getInstancesStream).collect(Collectors.toSet());
            return this.refreshInstances(filterToAdd.filter(currentInstances), analyzeJoiner);
        });
    }

    @Override
    public ListenableFuture<Void> removeInstanceFilter(@NotNull CaptureObjectInstanceFilter filterToRemove, @NotNull Executor analyzeJoiner) {
        if (filterToRemove == null) {
            HeapDumpCaptureObject.$$$reportNull$$$0(17);
        }
        if (analyzeJoiner == null) {
            HeapDumpCaptureObject.$$$reportNull$$$0(18);
        }
        if (!this.myCurrentInstanceFilters.contains(filterToRemove)) {
            return CaptureObjectUtils.makeEmptyTask();
        }
        this.myCurrentInstanceFilters.remove(filterToRemove);
        return this.myExecutorService.submit(() -> {
            Set<InstanceObject> matchedInstances = this.getAllInstances();
            for (CaptureObjectInstanceFilter filter : this.myCurrentInstanceFilters) {
                matchedInstances = filter.filter(matchedInstances);
            }
            return this.refreshInstances(matchedInstances, analyzeJoiner);
        });
    }

    @Override
    public ListenableFuture<Void> setSingleFilter(@NotNull CaptureObjectInstanceFilter filter, @NotNull Executor analyzeJoiner) {
        if (filter == null) {
            HeapDumpCaptureObject.$$$reportNull$$$0(19);
        }
        if (analyzeJoiner == null) {
            HeapDumpCaptureObject.$$$reportNull$$$0(20);
        }
        this.myCurrentInstanceFilters.clear();
        this.myCurrentInstanceFilters.add(filter);
        return this.myExecutorService.submit(() -> this.refreshInstances(filter.filter(this.getAllInstances()), analyzeJoiner));
    }

    @Override
    public ListenableFuture<Void> removeAllFilters(@NotNull Executor analyzeJoiner) {
        if (analyzeJoiner == null) {
            HeapDumpCaptureObject.$$$reportNull$$$0(21);
        }
        this.myCurrentInstanceFilters.clear();
        return this.myExecutorService.submit(() -> this.refreshInstances(this.getAllInstances(), analyzeJoiner));
    }

    private Set<InstanceObject> getAllInstances() {
        HashSet<InstanceObject> allInstances = new HashSet<InstanceObject>(this.myInstanceIndex.size());
        this.myInstanceIndex.forEachValue(allInstances::add);
        return allInstances;
    }

    private Void refreshInstances(@NotNull Set<InstanceObject> instances, @NotNull Executor executor) {
        if (instances == null) {
            HeapDumpCaptureObject.$$$reportNull$$$0(22);
        }
        if (executor == null) {
            HeapDumpCaptureObject.$$$reportNull$$$0(23);
        }
        executor.execute(() -> {
            this.myHeapSets.values().forEach(ClassifierSet::clearClassifierSets);
            Consumer<InstanceObject> onInst = this.myHeapSets.values().stream().filter(heap -> heap instanceof AllHeapSet).map(h -> h::addDeltaInstanceObject).findAny().orElse(inst -> this.myHeapSets.get(inst.getHeapId()).addDeltaInstanceObject((InstanceObject)inst));
            instances.forEach(onInst);
        });
        return null;
    }

    @Override
    public boolean canSafelyLoad() {
        Transport.BytesResponse response = this.myClient.getTransportClient().getBytes(Transport.BytesRequest.newBuilder().setStreamId(this.mySession.getStreamId()).setId(Long.toString(this.myHeapDumpInfo.getStartTime())).build());
        return MemoryProfilerStage.canSafelyLoadHprof(response.getSerializedSize());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "client";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "heapDumpInfo";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "featureTracker";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideProfilerServices";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputStream";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/memory/adapters/HeapDumpCaptureObject";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instance";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classObj";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filterToAdd";
                break;
            }
            case 16: 
            case 18: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "analyzeJoiner";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filterToRemove";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instances";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/memory/adapters/HeapDumpCaptureObject";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassDb";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getHeapSets";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstances";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassifierAttributes";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstanceAttributes";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedInstanceFilters";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedInstanceFilters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "saveToFile";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findInstanceObject";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createClassObjectInstance";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "addInstanceFilter";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "removeInstanceFilter";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "setSingleFilter";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "removeAllFilters";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "refreshInstances";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

