/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory.adapters;

import com.google.common.collect.ImmutableMap;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BitmapDecoder {
    protected static final Map<PixelFormat, BitmapExtractor> SUPPORTED_FORMATS = ImmutableMap.of((Object)((Object)PixelFormat.ARGB_8888), (Object)new ARGB8888_BitmapExtractor(), (Object)((Object)PixelFormat.RGB_565), (Object)new RGB565_BitmapExtractor(), (Object)((Object)PixelFormat.ALPHA_8), (Object)new ALPHA8_BitmapExtractor());

    @Nullable
    public static BufferedImage getBitmap(@NotNull BitmapDataProvider dataProvider) {
        PixelFormat config;
        if (dataProvider == null) {
            BitmapDecoder.$$$reportNull$$$0(0);
        }
        if ((config = dataProvider.getBitmapConfigName()) == null) {
            return null;
        }
        BitmapExtractor bitmapExtractor = SUPPORTED_FORMATS.get((Object)config);
        if (bitmapExtractor == null) {
            return null;
        }
        Dimension size = dataProvider.getDimension();
        if (size == null) {
            return null;
        }
        return bitmapExtractor.getImage(size.width, size.height, dataProvider.getPixelBytes(size));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataProvider", "com/android/tools/profilers/memory/adapters/BitmapDecoder", "getBitmap"));
    }

    private static class ALPHA8_BitmapExtractor
    implements BitmapExtractor {
        private ALPHA8_BitmapExtractor() {
        }

        @Override
        public BufferedImage getImage(int width, int height, byte[] rgb) {
            BufferedImage bufferedImage = new BufferedImage(width, height, 2);
            for (int y = 0; y < height; ++y) {
                int stride = y * width;
                for (int x = 0; x < width; ++x) {
                    int index = stride + x;
                    byte value = rgb[index];
                    int argb = value << 24 | 0xFF0000 | 0xFF00 | 0xFF;
                    bufferedImage.setRGB(x, y, argb);
                }
            }
            return bufferedImage;
        }
    }

    private static class RGB565_BitmapExtractor
    implements BitmapExtractor {
        private RGB565_BitmapExtractor() {
        }

        @Override
        public BufferedImage getImage(int width, int height, byte[] rgb) {
            int bytesPerPixel = 2;
            BufferedImage bufferedImage = new BufferedImage(width, height, 2);
            for (int y = 0; y < height; ++y) {
                int stride = y * width;
                for (int x = 0; x < width; ++x) {
                    int index = (stride + x) * bytesPerPixel;
                    int value = rgb[index] & 0xFF | rgb[index + 1] << 8 & 0xFF00;
                    int r = (value >>> 11 & 0x1F) * 255 / 31;
                    int g = (value >>> 5 & 0x3F) * 255 / 63;
                    int b = (value & 0x1F) * 255 / 31;
                    int a = 255;
                    int argb = a << 24 | r << 16 | g << 8 | b;
                    bufferedImage.setRGB(x, y, argb);
                }
            }
            return bufferedImage;
        }
    }

    private static class ARGB8888_BitmapExtractor
    implements BitmapExtractor {
        private ARGB8888_BitmapExtractor() {
        }

        @Override
        public BufferedImage getImage(int width, int height, byte[] rgba) {
            BufferedImage bufferedImage = new BufferedImage(width, height, 2);
            for (int y = 0; y < height; ++y) {
                int stride = y * width;
                for (int x = 0; x < width; ++x) {
                    int i2 = (stride + x) * 4;
                    long argb = 0L;
                    argb |= ((long)rgba[i2] & 0xFFL) << 16;
                    argb |= ((long)rgba[i2 + 1] & 0xFFL) << 8;
                    argb |= (long)rgba[i2 + 2] & 0xFFL;
                    bufferedImage.setRGB(x, y, (int)((argb |= ((long)rgba[i2 + 3] & 0xFFL) << 24) & 0xFFFFFFFFL));
                }
            }
            return bufferedImage;
        }
    }

    private static interface BitmapExtractor {
        public BufferedImage getImage(int var1, int var2, byte[] var3);
    }

    public static interface BitmapDataProvider {
        @Nullable
        public PixelFormat getBitmapConfigName();

        @Nullable
        public Dimension getDimension();

        @Nullable
        public byte[] getPixelBytes(@NotNull Dimension var1);
    }

    static enum PixelFormat {
        ARGB_8888,
        RGB_565,
        ALPHA_8;

    }
}

