/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory;

import com.android.tools.adtui.model.DurationDataModel;
import com.android.tools.adtui.model.Interpolatable;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.RangedContinuousSeries;
import com.android.tools.adtui.model.SeriesData;
import com.android.tools.adtui.model.legend.EventLegend;
import com.android.tools.adtui.model.legend.Legend;
import com.android.tools.adtui.model.legend.LegendComponentModel;
import com.android.tools.adtui.model.legend.SeriesLegend;
import com.android.tools.profiler.proto.Memory;
import com.android.tools.profilers.memory.AllocationSamplingRateDurationData;
import com.android.tools.profilers.memory.DetailedMemoryUsage;
import com.android.tools.profilers.memory.GcDurationData;
import com.android.tools.profilers.memory.MemoryProfilerStage;
import com.android.tools.profilers.memory.MemoryStageLegends;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB'\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001f\u0010\u0010\u001a\u0010\u0012\f\u0012\n \u0013*\u0004\u0018\u00010\u00120\u00120\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u000fR\u0011\u0010\u0018\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u000fR\u0011\u0010\u001a\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u000fR\u0011\u0010\u001c\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u000fR\u0011\u0010\u001e\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u000fR\u001f\u0010 \u001a\u0010\u0012\f\u0012\n \u0013*\u0004\u0018\u00010!0!0\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u0015R\u0011\u0010#\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\u000fR\u0011\u0010%\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010\u000f\u00a8\u0006'"}, d2={"Lcom/android/tools/profilers/memory/MemoryStageLegends;", "Lcom/android/tools/adtui/model/legend/LegendComponentModel;", "stage", "Lcom/android/tools/profilers/memory/MemoryProfilerStage;", "range", "Lcom/android/tools/adtui/model/Range;", "isTooltip", "", "(Lcom/android/tools/profilers/memory/MemoryProfilerStage;Lcom/android/tools/adtui/model/Range;Z)V", "usage", "Lcom/android/tools/profilers/memory/DetailedMemoryUsage;", "(Lcom/android/tools/profilers/memory/MemoryProfilerStage;Lcom/android/tools/adtui/model/Range;ZLcom/android/tools/profilers/memory/DetailedMemoryUsage;)V", "codeLegend", "Lcom/android/tools/adtui/model/legend/SeriesLegend;", "getCodeLegend", "()Lcom/android/tools/adtui/model/legend/SeriesLegend;", "gcDurationLegend", "Lcom/android/tools/adtui/model/legend/EventLegend;", "Lcom/android/tools/profilers/memory/GcDurationData;", "kotlin.jvm.PlatformType", "getGcDurationLegend", "()Lcom/android/tools/adtui/model/legend/EventLegend;", "graphicsLegend", "getGraphicsLegend", "javaLegend", "getJavaLegend", "nativeLegend", "getNativeLegend", "objectsLegend", "getObjectsLegend", "otherLegend", "getOtherLegend", "samplingRateDurationLegend", "Lcom/android/tools/profilers/memory/AllocationSamplingRateDurationData;", "getSamplingRateDurationLegend", "stackLegend", "getStackLegend", "totalLegend", "getTotalLegend", "intellij.android.profilers"})
public final class MemoryStageLegends
extends LegendComponentModel {
    @NotNull
    private final SeriesLegend javaLegend;
    @NotNull
    private final SeriesLegend nativeLegend;
    @NotNull
    private final SeriesLegend graphicsLegend;
    @NotNull
    private final SeriesLegend stackLegend;
    @NotNull
    private final SeriesLegend codeLegend;
    @NotNull
    private final SeriesLegend otherLegend;
    @NotNull
    private final SeriesLegend totalLegend;
    @NotNull
    private final SeriesLegend objectsLegend;
    @NotNull
    private final EventLegend<GcDurationData> gcDurationLegend;
    @NotNull
    private final EventLegend<AllocationSamplingRateDurationData> samplingRateDurationLegend;

    @NotNull
    public final SeriesLegend getJavaLegend() {
        return this.javaLegend;
    }

    @NotNull
    public final SeriesLegend getNativeLegend() {
        return this.nativeLegend;
    }

    @NotNull
    public final SeriesLegend getGraphicsLegend() {
        return this.graphicsLegend;
    }

    @NotNull
    public final SeriesLegend getStackLegend() {
        return this.stackLegend;
    }

    @NotNull
    public final SeriesLegend getCodeLegend() {
        return this.codeLegend;
    }

    @NotNull
    public final SeriesLegend getOtherLegend() {
        return this.otherLegend;
    }

    @NotNull
    public final SeriesLegend getTotalLegend() {
        return this.totalLegend;
    }

    @NotNull
    public final SeriesLegend getObjectsLegend() {
        return this.objectsLegend;
    }

    @NotNull
    public final EventLegend<GcDurationData> getGcDurationLegend() {
        return this.gcDurationLegend;
    }

    @NotNull
    public final EventLegend<AllocationSamplingRateDurationData> getSamplingRateDurationLegend() {
        return this.samplingRateDurationLegend;
    }

    /*
     * WARNING - void declaration
     */
    private MemoryStageLegends(MemoryProfilerStage stage, Range range, boolean isTooltip, DetailedMemoryUsage usage) {
        super(range);
        void $this$forEach$iv;
        this.javaLegend = new SeriesLegend(usage.getJavaSeries(), MemoryProfilerStage.MEMORY_AXIS_FORMATTER, range);
        this.nativeLegend = new SeriesLegend(usage.getNativeSeries(), MemoryProfilerStage.MEMORY_AXIS_FORMATTER, range);
        this.graphicsLegend = new SeriesLegend(usage.getGraphicsSeries(), MemoryProfilerStage.MEMORY_AXIS_FORMATTER, range);
        this.stackLegend = new SeriesLegend(usage.getStackSeries(), MemoryProfilerStage.MEMORY_AXIS_FORMATTER, range);
        this.codeLegend = new SeriesLegend(usage.getCodeSeries(), MemoryProfilerStage.MEMORY_AXIS_FORMATTER, range);
        this.otherLegend = new SeriesLegend(usage.getOtherSeries(), MemoryProfilerStage.MEMORY_AXIS_FORMATTER, range);
        this.totalLegend = new SeriesLegend(usage.getTotalMemorySeries(), MemoryProfilerStage.MEMORY_AXIS_FORMATTER, range);
        RangedContinuousSeries rangedContinuousSeries = usage.getObjectsSeries();
        RangedContinuousSeries rangedContinuousSeries2 = usage.getObjectsSeries();
        Intrinsics.checkNotNullExpressionValue((Object)rangedContinuousSeries2, (String)"usage.objectsSeries");
        this.objectsLegend = new SeriesLegend(rangedContinuousSeries, MemoryProfilerStage.OBJECT_COUNT_AXIS_FORMATTER, range, rangedContinuousSeries2.getName(), Interpolatable.RoundedSegmentInterpolator, new Predicate(stage, usage){
            final /* synthetic */ MemoryProfilerStage $stage;
            final /* synthetic */ DetailedMemoryUsage $usage;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean test(Range r) {
                if (!this.$stage.isLiveAllocationTrackingReady()) return true;
                DurationDataModel<AllocationSamplingRateDurationData> durationDataModel = this.$usage.getAllocationSamplingRateDurations();
                Intrinsics.checkNotNullExpressionValue(durationDataModel, (String)"usage.allocationSamplingRateDurations");
                List list = durationDataModel.getSeries().getSeriesForRange(r);
                boolean bl = false;
                boolean bl2 = false;
                List data = list;
                boolean bl3 = false;
                List list2 = data;
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"data");
                Collection collection = list2;
                boolean bl4 = false;
                if (collection.isEmpty()) return false;
                boolean bl5 = true;
                if (!bl5) return false;
                Object object = ((SeriesData)CollectionsKt.last((List)data)).value;
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"data.last().value");
                Memory.MemoryAllocSamplingData memoryAllocSamplingData = ((AllocationSamplingRateDurationData)object).getCurrentRate();
                Intrinsics.checkNotNullExpressionValue((Object)memoryAllocSamplingData, (String)"data.last().value.currentRate");
                if (MemoryProfilerStage.LiveAllocationSamplingMode.getModeFromFrequency(memoryAllocSamplingData.getSamplingNumInterval()) != MemoryProfilerStage.LiveAllocationSamplingMode.FULL) return false;
                return true;
            }
            {
                this.$stage = memoryProfilerStage;
                this.$usage = detailedMemoryUsage;
            }
        });
        this.gcDurationLegend = new EventLegend("GC Duration", (Function)gcDurationLegend.1.INSTANCE);
        this.samplingRateDurationLegend = new EventLegend("Tracking", (Function)samplingRateDurationLegend.1.INSTANCE);
        List legends = isTooltip ? CollectionsKt.listOf((Object[])new Legend[]{(Legend)this.otherLegend, (Legend)this.codeLegend, (Legend)this.stackLegend, (Legend)this.graphicsLegend, (Legend)this.nativeLegend, (Legend)this.javaLegend, (Legend)this.objectsLegend, (Legend)this.samplingRateDurationLegend, (Legend)this.gcDurationLegend, (Legend)this.totalLegend}) : CollectionsKt.listOf((Object[])new SeriesLegend[]{this.totalLegend, this.javaLegend, this.nativeLegend, this.graphicsLegend, this.stackLegend, this.codeLegend, this.otherLegend, this.objectsLegend});
        Iterable iterable = legends;
        MemoryStageLegends memoryStageLegends = this;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Legend p1 = (Legend)element$iv;
            boolean bl = false;
            memoryStageLegends.add(p1);
        }
    }

    public MemoryStageLegends(@NotNull MemoryProfilerStage stage, @NotNull Range range, boolean isTooltip) {
        Intrinsics.checkNotNullParameter((Object)stage, (String)"stage");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        DetailedMemoryUsage detailedMemoryUsage = stage.getDetailedMemoryUsage();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)detailedMemoryUsage), (String)"stage.detailedMemoryUsage");
        this(stage, range, isTooltip, detailedMemoryUsage);
    }
}

