/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory;

import com.android.tools.adtui.RangeSelectionComponent;
import com.android.tools.adtui.common.AdtUiUtils;
import com.android.tools.adtui.flat.FlatSeparator;
import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.formatter.TimeFormatter;
import com.android.tools.adtui.stdui.CommonButton;
import com.android.tools.profilers.ContextMenuInstaller;
import com.android.tools.profilers.IdeProfilerComponents;
import com.android.tools.profilers.JComboBoxView;
import com.android.tools.profilers.ProfilerAction;
import com.android.tools.profilers.ProfilerColors;
import com.android.tools.profilers.ProfilerCombobox;
import com.android.tools.profilers.ProfilerComboboxCellRenderer;
import com.android.tools.profilers.ProfilerFonts;
import com.android.tools.profilers.ProfilerLayout;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.StudioProfilersView;
import com.android.tools.profilers.event.LifecycleTooltip;
import com.android.tools.profilers.event.LifecycleTooltipView;
import com.android.tools.profilers.event.UserEventTooltip;
import com.android.tools.profilers.event.UserEventTooltipView;
import com.android.tools.profilers.memory.BaseMemoryProfilerStageView;
import com.android.tools.profilers.memory.CaptureDurationData;
import com.android.tools.profilers.memory.CapturePanel;
import com.android.tools.profilers.memory.CaptureSelectionAspect;
import com.android.tools.profilers.memory.MemoryCaptureView;
import com.android.tools.profilers.memory.MemoryClassGrouping;
import com.android.tools.profilers.memory.MemoryClassSetView;
import com.android.tools.profilers.memory.MemoryClassifierView;
import com.android.tools.profilers.memory.MemoryHeapView;
import com.android.tools.profilers.memory.MemoryInstanceDetailsView;
import com.android.tools.profilers.memory.MemoryProfiler;
import com.android.tools.profilers.memory.MemoryProfilerAspect;
import com.android.tools.profilers.memory.MemoryProfilerStage;
import com.android.tools.profilers.memory.MemoryProfilerStageLayout;
import com.android.tools.profilers.memory.MemoryTimelineComponent;
import com.android.tools.profilers.memory.MemoryUsageTooltip;
import com.android.tools.profilers.memory.MemoryUsageTooltipView;
import com.android.tools.profilers.memory.adapters.CaptureObject;
import com.android.tools.profilers.sessions.SessionAspect;
import com.android.tools.profilers.stacktrace.ContextMenuItem;
import com.android.tools.profilers.stacktrace.LoadingPanel;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.IconLoader;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ui.JBUI;
import icons.StudioIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.TimeUnit;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import kotlin.jvm.functions.Function0;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MemoryProfilerStageView
extends BaseMemoryProfilerStageView<MemoryProfilerStage> {
    private static final String RECORD_TEXT = "Record";
    private static final String STOP_TEXT = "Stop";
    private static final String LIVE_ALLOCATION_TRACKING_NOT_READY_TOOLTIP = "Allocation tracking isn't ready. Please wait.";
    @VisibleForTesting
    static final String RECORD_NATIVE_TEXT = "Record native allocations";
    @VisibleForTesting
    static final String X86_RECORD_NATIVE_TOOLTIP = "Native memory recording is unavailable on x86 or x86_64 devices";
    @VisibleForTesting
    static final String STOP_NATIVE_TEXT = "Stop recording";
    private final MemoryProfilerStageLayout myLayout;
    @Nullable
    private final MemoryTimelineComponent myTimelineComponent;
    @Nullable
    private CaptureObject myCaptureObject;
    @NotNull
    private JButton myForceGarbageCollectionButton;
    @NotNull
    private JButton myHeapDumpButton;
    @NotNull
    private JButton myAllocationButton;
    @NotNull
    private final JButton myNativeAllocationButton;
    @NotNull
    private JComboBox myAllocationSamplingRateDropDown;
    @NotNull
    private ProfilerAction myForceGarbageCollectionAction;
    @NotNull
    private ProfilerAction myHeapDumpAction;
    @NotNull
    private ProfilerAction myAllocationAction;
    @NotNull
    private ProfilerAction myStopAllocationAction;
    @NotNull
    private ProfilerAction myNativeAllocationAction;
    @NotNull
    private ProfilerAction myStopNativeAllocationAction;
    @NotNull
    private final JLabel myCaptureElapsedTime;
    @NotNull
    private final JLabel myAllocationSamplingRateLabel;
    @NotNull
    private final LoadingPanel myHeapDumpLoadingPanel;

    private static Logger getLogger() {
        return Logger.getInstance(MemoryProfilerStageView.class);
    }

    public MemoryProfilerStageView(@NotNull StudioProfilersView profilersView, @NotNull MemoryProfilerStage stage) {
        if (profilersView == null) {
            MemoryProfilerStageView.$$$reportNull$$$0(0);
        }
        if (stage == null) {
            MemoryProfilerStageView.$$$reportNull$$$0(1);
        }
        super(profilersView, stage);
        this.myCaptureObject = null;
        ((MemoryProfilerStage)this.getStage()).enableSelectLatestCapture(true, SwingUtilities::invokeLater);
        this.getTooltipBinder().bind(MemoryUsageTooltip.class, MemoryUsageTooltipView::new);
        this.getTooltipBinder().bind(LifecycleTooltip.class, (stageView, tooltip2) -> new LifecycleTooltipView(stageView.getComponent(), (LifecycleTooltip)tooltip2));
        this.getTooltipBinder().bind(UserEventTooltip.class, (stageView, tooltip2) -> new UserEventTooltipView(stageView.getComponent(), (UserEventTooltip)tooltip2));
        this.myTimelineComponent = ((MemoryProfilerStage)this.getStage()).isMemoryCaptureOnly() ? null : new MemoryTimelineComponent(this, this.buildTimeAxis(profilersView.getStudioProfilers()));
        CapturePanel capturePanel = new CapturePanel(this.getProfilersView(), ((MemoryProfilerStage)this.getStage()).getCaptureSelection(), ((MemoryProfilerStage)this.getStage()).isMemoryCaptureOnly() ? null : this.getSelectionTimeLabel(), ((MemoryProfilerStage)this.getStage()).getRangeSelectionModel().getSelectionRange(), this.getIdeComponents(), ((MemoryProfilerStage)this.getStage()).getTimeline(), false);
        this.myLayout = new MemoryProfilerStageLayout((JComponent)((Object)this.myTimelineComponent), capturePanel, (Function0<? extends LoadingPanel>)((Function0)this::makeLoadingPanel));
        this.getComponent().add((Component)this.myLayout.getComponent(), "Center");
        this.myHeapDumpLoadingPanel = this.getIdeComponents().createLoadingPanel(-1);
        this.myHeapDumpLoadingPanel.setLoadingText("Capturing heap dump");
        this.myForceGarbageCollectionButton = new CommonButton(StudioIcons.Profiler.Toolbar.FORCE_GARBAGE_COLLECTION);
        this.myForceGarbageCollectionButton.setDisabledIcon(IconLoader.getDisabledIcon((Icon)StudioIcons.Profiler.Toolbar.FORCE_GARBAGE_COLLECTION));
        this.myForceGarbageCollectionButton.addActionListener(e -> {
            ((MemoryProfilerStage)this.getStage()).forceGarbageCollection();
            ((MemoryProfilerStage)this.getStage()).getStudioProfilers().getIdeServices().getFeatureTracker().trackForceGc();
        });
        this.myForceGarbageCollectionAction = new ProfilerAction.Builder("Force garbage collection").setContainerComponent(this.getComponent()).setIcon(this.myForceGarbageCollectionButton.getIcon()).setActionRunnable(() -> this.myForceGarbageCollectionButton.doClick(0)).setKeyStrokes(KeyStroke.getKeyStroke(71, AdtUiUtils.getActionMask())).build();
        this.myForceGarbageCollectionButton.setToolTipText(this.myForceGarbageCollectionAction.getDefaultToolTipText());
        this.myHeapDumpButton = new CommonButton(StudioIcons.Profiler.Toolbar.HEAP_DUMP);
        this.myHeapDumpButton.setDisabledIcon(IconLoader.getDisabledIcon((Icon)StudioIcons.Profiler.Toolbar.HEAP_DUMP));
        this.myHeapDumpButton.addActionListener(e -> {
            ((MemoryProfilerStage)this.getStage()).requestHeapDump();
            ((MemoryProfilerStage)this.getStage()).getStudioProfilers().getIdeServices().getFeatureTracker().trackDumpHeap();
        });
        this.myHeapDumpAction = new ProfilerAction.Builder("Dump Java heap").setContainerComponent(this.getComponent()).setIcon(this.myHeapDumpButton.getIcon()).setActionRunnable(() -> this.myHeapDumpButton.doClick(0)).setKeyStrokes(KeyStroke.getKeyStroke(68, AdtUiUtils.getActionMask())).build();
        this.myHeapDumpButton.setToolTipText(this.myHeapDumpAction.getDefaultToolTipText());
        this.myCaptureElapsedTime = new JLabel("");
        this.myCaptureElapsedTime.setFont(ProfilerFonts.STANDARD_FONT);
        this.myCaptureElapsedTime.setBorder((Border)JBUI.Borders.emptyLeft((int)5));
        this.myCaptureElapsedTime.setForeground(ProfilerColors.CPU_CAPTURE_STATUS);
        this.myAllocationButton = new JButton(RECORD_TEXT);
        this.myAllocationButton.setPreferredSize(this.myAllocationButton.getPreferredSize());
        this.myAllocationButton.addActionListener(e -> {
            if (((MemoryProfilerStage)this.getStage()).isTrackingAllocations()) {
                ((MemoryProfilerStage)this.getStage()).getStudioProfilers().getIdeServices().getFeatureTracker().trackRecordAllocations();
            }
            ((MemoryProfilerStage)this.getStage()).trackAllocations(!((MemoryProfilerStage)this.getStage()).isTrackingAllocations());
        });
        this.myAllocationButton.setVisible(!((MemoryProfilerStage)this.getStage()).isLiveAllocationTrackingSupported());
        this.myAllocationAction = new ProfilerAction.Builder("Record allocations").setIcon(StudioIcons.Profiler.Toolbar.RECORD).setContainerComponent(this.getComponent()).setEnableBooleanSupplier(() -> !((MemoryProfilerStage)this.getStage()).isTrackingAllocations()).setActionRunnable(() -> this.myAllocationButton.doClick(0)).setKeyStrokes(KeyStroke.getKeyStroke(82, AdtUiUtils.getActionMask())).build();
        this.myStopAllocationAction = new ProfilerAction.Builder(STOP_NATIVE_TEXT).setIcon(StudioIcons.Profiler.Toolbar.STOP_RECORDING).setContainerComponent(this.getComponent()).setEnableBooleanSupplier(() -> ((MemoryProfilerStage)this.getStage()).isTrackingAllocations()).setActionRunnable(() -> this.myAllocationButton.doClick(0)).setKeyStrokes(KeyStroke.getKeyStroke(83, AdtUiUtils.getActionMask())).build();
        this.myNativeAllocationButton = new JButton(RECORD_NATIVE_TEXT);
        this.myNativeAllocationButton.setPreferredSize(this.myNativeAllocationButton.getPreferredSize());
        this.myNativeAllocationButton.addActionListener(e -> {
            ((MemoryProfilerStage)this.getStage()).toggleNativeAllocationTracking();
            this.disableRecordingButtons();
        });
        this.myNativeAllocationButton.setVisible(((MemoryProfilerStage)this.getStage()).isNativeAllocationSamplingEnabled());
        this.myNativeAllocationAction = new ProfilerAction.Builder(RECORD_NATIVE_TEXT).setIcon(StudioIcons.Profiler.Toolbar.RECORD).setContainerComponent(this.getComponent()).setEnableBooleanSupplier(() -> !((MemoryProfilerStage)this.getStage()).isTrackingAllocations()).setActionRunnable(() -> this.myNativeAllocationButton.doClick(0)).setKeyStrokes(KeyStroke.getKeyStroke(82, AdtUiUtils.getActionMask())).build();
        this.myStopNativeAllocationAction = new ProfilerAction.Builder(STOP_NATIVE_TEXT).setIcon(StudioIcons.Profiler.Toolbar.STOP_RECORDING).setContainerComponent(this.getComponent()).setEnableBooleanSupplier(() -> ((MemoryProfilerStage)this.getStage()).isTrackingAllocations()).setActionRunnable(() -> this.myNativeAllocationButton.doClick(0)).setKeyStrokes(KeyStroke.getKeyStroke(83, AdtUiUtils.getActionMask())).build();
        this.myAllocationSamplingRateLabel = new JLabel("Allocation Tracking");
        this.myAllocationSamplingRateLabel.setBorder((Border)JBUI.Borders.empty((int)0, (int)8));
        this.myAllocationSamplingRateDropDown = new ProfilerCombobox();
        ((MemoryProfilerStage)this.getStage()).getAspect().addDependency((AspectObserver)this).onChange((Enum)MemoryProfilerAspect.TRACKING_ENABLED, this::allocationTrackingChanged).onChange((Enum)MemoryProfilerAspect.HEAP_DUMP_STARTED, this::showHeapDumpInProgress).onChange((Enum)MemoryProfilerAspect.HEAP_DUMP_FINISHED, this::hideHeapDumpInProgress);
        ((MemoryProfilerStage)this.getStage()).getCaptureSelection().getAspect().addDependency((AspectObserver)this).onChange((Enum)CaptureSelectionAspect.CURRENT_LOADING_CAPTURE, this::captureObjectChanged).onChange((Enum)CaptureSelectionAspect.CURRENT_LOADED_CAPTURE, this::captureObjectFinishedLoading).onChange((Enum)CaptureSelectionAspect.CURRENT_CAPTURE_ELAPSED_TIME, this::updateCaptureElapsedTime);
        this.captureObjectChanged();
        this.allocationTrackingChanged();
        this.buildContextMenu();
    }

    @Override
    public boolean isToolbarVisible() {
        return !((MemoryProfilerStage)this.getStage()).isMemoryCaptureOnly();
    }

    @VisibleForTesting
    MemoryProfilerStageLayout getLayout() {
        return this.myLayout;
    }

    @VisibleForTesting
    JButton getGarbageCollectionButtion() {
        return this.myForceGarbageCollectionButton;
    }

    @VisibleForTesting
    @NotNull
    JButton getHeapDumpButton() {
        JButton jButton = this.myHeapDumpButton;
        if (jButton == null) {
            MemoryProfilerStageView.$$$reportNull$$$0(2);
        }
        return jButton;
    }

    @VisibleForTesting
    @NotNull
    JButton getAllocationButton() {
        JButton jButton = this.myAllocationButton;
        if (jButton == null) {
            MemoryProfilerStageView.$$$reportNull$$$0(3);
        }
        return jButton;
    }

    @VisibleForTesting
    @NotNull
    JButton getNativeAllocationButton() {
        JButton jButton = this.myNativeAllocationButton;
        if (jButton == null) {
            MemoryProfilerStageView.$$$reportNull$$$0(4);
        }
        return jButton;
    }

    @VisibleForTesting
    JLabel getAllocationCaptureElaspedTimeLabel() {
        return this.myCaptureElapsedTime;
    }

    @VisibleForTesting
    @NotNull
    JComboBox getAllocationSamplingRateDropDown() {
        JComboBox jComboBox = this.myAllocationSamplingRateDropDown;
        if (jComboBox == null) {
            MemoryProfilerStageView.$$$reportNull$$$0(5);
        }
        return jComboBox;
    }

    @VisibleForTesting
    @NotNull
    JLabel getAllocationSamplingRateLabel() {
        JLabel jLabel = this.myAllocationSamplingRateLabel;
        if (jLabel == null) {
            MemoryProfilerStageView.$$$reportNull$$$0(6);
        }
        return jLabel;
    }

    @VisibleForTesting
    @Nullable
    MemoryTimelineComponent getTimelineComponent() {
        return this.myTimelineComponent;
    }

    @Override
    public JComponent getToolbar() {
        JPanel panel2 = new JPanel(new BorderLayout());
        JPanel toolbar = new JPanel(ProfilerLayout.createToolbarLayout());
        panel2.add((Component)toolbar, "West");
        toolbar.removeAll();
        toolbar.add(this.myForceGarbageCollectionButton);
        toolbar.add(this.myHeapDumpButton);
        if (((MemoryProfilerStage)this.getStage()).isLiveAllocationTrackingSupported() && ((MemoryProfilerStage)this.getStage()).getStudioProfilers().getIdeServices().getFeatureConfig().isLiveAllocationsSamplingEnabled()) {
            toolbar.add(this.myAllocationSamplingRateLabel);
            toolbar.add(this.myAllocationSamplingRateDropDown);
            if (((MemoryProfilerStage)this.getStage()).isNativeAllocationSamplingEnabled()) {
                toolbar.add((Component)new FlatSeparator());
                toolbar.add(this.myNativeAllocationButton);
                toolbar.add(this.myCaptureElapsedTime);
            }
            JComboBoxView<MemoryProfilerStage.LiveAllocationSamplingMode, MemoryProfilerAspect> sampleRateComboView = new JComboBoxView<MemoryProfilerStage.LiveAllocationSamplingMode, MemoryProfilerAspect>(this.myAllocationSamplingRateDropDown, ((MemoryProfilerStage)this.getStage()).getAspect(), MemoryProfilerAspect.LIVE_ALLOCATION_SAMPLING_MODE, ((MemoryProfilerStage)this.getStage())::getSupportedLiveAllocationSamplingMode, ((MemoryProfilerStage)this.getStage())::getLiveAllocationSamplingMode, ((MemoryProfilerStage)this.getStage())::requestLiveAllocationSamplingModeUpdate);
            sampleRateComboView.bind();
            this.myAllocationSamplingRateDropDown.setRenderer(new LiveAllocationSamplingModeRenderer());
        } else {
            if (((MemoryProfilerStage)this.getStage()).isNativeAllocationSamplingEnabled()) {
                toolbar.add((Component)new FlatSeparator());
                toolbar.add(this.myNativeAllocationButton);
            } else {
                toolbar.add(this.myAllocationButton);
            }
            toolbar.add(this.myCaptureElapsedTime);
        }
        StudioProfilers profilers = ((MemoryProfilerStage)this.getStage()).getStudioProfilers();
        Runnable toggleButtons = () -> {
            this.resetRecordingButtons();
            this.liveAllocationStatusChanged();
        };
        profilers.getSessionsManager().addDependency(this).onChange((Enum)SessionAspect.SELECTED_SESSION, toggleButtons);
        ((MemoryProfilerStage)this.getStage()).getAspect().addDependency((AspectObserver)this).onChange((Enum)MemoryProfilerAspect.LIVE_ALLOCATION_STATUS, this::liveAllocationStatusChanged);
        toggleButtons.run();
        return panel2;
    }

    private void resetRecordingButtons() {
        boolean isAlive = ((MemoryProfilerStage)this.getStage()).getStudioProfilers().getSessionsManager().isSessionAlive();
        this.myForceGarbageCollectionButton.setEnabled(isAlive);
        this.myHeapDumpButton.setEnabled(isAlive && !((MemoryProfilerStage)this.getStage()).isTrackingAllocations());
        this.myAllocationButton.setEnabled(isAlive);
        this.myNativeAllocationButton.setEnabled(isAlive && !this.isSelectedSessionDeviceX86OrX64());
    }

    private void disableRecordingButtons() {
        this.myAllocationButton.setEnabled(false);
        this.myNativeAllocationButton.setEnabled(false);
        this.myHeapDumpButton.setEnabled(false);
    }

    @VisibleForTesting
    @NotNull
    public Splitter getMainSplitter() {
        JBSplitter jBSplitter = this.myLayout.getMainSplitter();
        if (jBSplitter == null) {
            MemoryProfilerStageView.$$$reportNull$$$0(7);
        }
        return jBSplitter;
    }

    @VisibleForTesting
    @NotNull
    public Splitter getChartCaptureSplitter() {
        JBSplitter jBSplitter = this.myLayout.getChartCaptureSplitter();
        if (jBSplitter == null) {
            MemoryProfilerStageView.$$$reportNull$$$0(8);
        }
        return jBSplitter;
    }

    @VisibleForTesting
    @NotNull
    public JPanel getCapturePanel() {
        JPanel jPanel = this.myLayout.getCapturePanel().getComponent();
        if (jPanel == null) {
            MemoryProfilerStageView.$$$reportNull$$$0(9);
        }
        return jPanel;
    }

    @VisibleForTesting
    @NotNull
    MemoryCaptureView getCaptureView() {
        MemoryCaptureView memoryCaptureView = this.myLayout.getCapturePanel().getCaptureView();
        if (memoryCaptureView == null) {
            MemoryProfilerStageView.$$$reportNull$$$0(10);
        }
        return memoryCaptureView;
    }

    @VisibleForTesting
    @NotNull
    MemoryHeapView getHeapView() {
        MemoryHeapView memoryHeapView = this.myLayout.getCapturePanel().getHeapView();
        if (memoryHeapView == null) {
            MemoryProfilerStageView.$$$reportNull$$$0(11);
        }
        return memoryHeapView;
    }

    @VisibleForTesting
    @NotNull
    MemoryClassGrouping getClassGrouping() {
        MemoryClassGrouping memoryClassGrouping = this.myLayout.getCapturePanel().getClassGrouping();
        if (memoryClassGrouping == null) {
            MemoryProfilerStageView.$$$reportNull$$$0(12);
        }
        return memoryClassGrouping;
    }

    @VisibleForTesting
    @NotNull
    MemoryClassifierView getClassifierView() {
        MemoryClassifierView memoryClassifierView = this.myLayout.getCapturePanel().getClassifierView();
        if (memoryClassifierView == null) {
            MemoryProfilerStageView.$$$reportNull$$$0(13);
        }
        return memoryClassifierView;
    }

    @VisibleForTesting
    @NotNull
    MemoryClassSetView getClassSetView() {
        MemoryClassSetView memoryClassSetView = this.myLayout.getCapturePanel().getClassSetView();
        if (memoryClassSetView == null) {
            MemoryProfilerStageView.$$$reportNull$$$0(14);
        }
        return memoryClassSetView;
    }

    @VisibleForTesting
    @NotNull
    MemoryInstanceDetailsView getInstanceDetailsView() {
        MemoryInstanceDetailsView memoryInstanceDetailsView = this.myLayout.getCapturePanel().getInstanceDetailsView();
        if (memoryInstanceDetailsView == null) {
            MemoryProfilerStageView.$$$reportNull$$$0(15);
        }
        return memoryInstanceDetailsView;
    }

    @VisibleForTesting
    @NotNull
    JLabel getCaptureElapsedTimeLabel() {
        JLabel jLabel = this.myCaptureElapsedTime;
        if (jLabel == null) {
            MemoryProfilerStageView.$$$reportNull$$$0(16);
        }
        return jLabel;
    }

    @VisibleForTesting
    @NotNull
    JLabel getCaptureInfoMessage() {
        JLabel jLabel = this.myLayout.getCapturePanel().getCaptureInfoMessage();
        if (jLabel == null) {
            MemoryProfilerStageView.$$$reportNull$$$0(17);
        }
        return jLabel;
    }

    private void liveAllocationStatusChanged() {
        boolean isAlive = ((MemoryProfilerStage)this.getStage()).getStudioProfilers().getSessionsManager().isSessionAlive();
        boolean isReady = ((MemoryProfilerStage)this.getStage()).isLiveAllocationTrackingReady();
        if (isAlive) {
            if (isReady) {
                this.myAllocationSamplingRateLabel.setEnabled(true);
                this.myAllocationSamplingRateDropDown.setEnabled(true);
                this.myAllocationSamplingRateLabel.setToolTipText(null);
                this.myAllocationSamplingRateDropDown.setToolTipText(null);
            } else {
                this.myAllocationSamplingRateLabel.setEnabled(false);
                this.myAllocationSamplingRateDropDown.setEnabled(false);
                this.myAllocationSamplingRateLabel.setToolTipText(LIVE_ALLOCATION_TRACKING_NOT_READY_TOOLTIP);
                this.myAllocationSamplingRateDropDown.setToolTipText(LIVE_ALLOCATION_TRACKING_NOT_READY_TOOLTIP);
            }
        } else {
            this.myAllocationSamplingRateLabel.setEnabled(false);
            this.myAllocationSamplingRateDropDown.setEnabled(false);
        }
    }

    private boolean isSelectedSessionDeviceX86OrX64() {
        String abi = ((MemoryProfilerStage)this.getStage()).getStudioProfilers().getSessionsManager().getSelectedSessionMetaData().getProcessAbi();
        return abi.equalsIgnoreCase("x86") || abi.equalsIgnoreCase("x86_64");
    }

    private void allocationTrackingChanged() {
        if (((MemoryProfilerStage)this.getStage()).isTrackingAllocations()) {
            this.myAllocationButton.setText(STOP_TEXT);
            this.myAllocationButton.setDisabledIcon(IconLoader.getDisabledIcon((Icon)StudioIcons.Profiler.Toolbar.STOP_RECORDING));
            this.myAllocationButton.setToolTipText(STOP_NATIVE_TEXT);
            this.myNativeAllocationButton.setText(STOP_NATIVE_TEXT);
            this.myNativeAllocationButton.setDisabledIcon(IconLoader.getDisabledIcon((Icon)StudioIcons.Profiler.Toolbar.STOP_RECORDING));
            this.myNativeAllocationButton.setToolTipText(STOP_NATIVE_TEXT);
            this.myCaptureElapsedTime.setText(TimeFormatter.getSemiSimplifiedClockString((long)0L));
        } else {
            this.myCaptureElapsedTime.setText("");
            this.myAllocationButton.setText(RECORD_TEXT);
            this.myAllocationButton.setDisabledIcon(IconLoader.getDisabledIcon((Icon)StudioIcons.Profiler.Toolbar.RECORD));
            this.myAllocationButton.setToolTipText("Record memory allocations");
            this.myNativeAllocationButton.setText(RECORD_NATIVE_TEXT);
            this.myNativeAllocationButton.setDisabledIcon(IconLoader.getDisabledIcon((Icon)StudioIcons.Profiler.Toolbar.RECORD));
            this.myNativeAllocationButton.setToolTipText(this.isSelectedSessionDeviceX86OrX64() ? X86_RECORD_NATIVE_TOOLTIP : RECORD_NATIVE_TEXT);
        }
        this.resetRecordingButtons();
    }

    private void updateCaptureElapsedTime() {
        if (((MemoryProfilerStage)this.getStage()).isTrackingAllocations() && (!((MemoryProfilerStage)this.getStage()).isLiveAllocationTrackingReady() || ((MemoryProfilerStage)this.getStage()).isNativeAllocationSamplingEnabled())) {
            long elapsedTimeUs = TimeUnit.NANOSECONDS.toMicros(((MemoryProfilerStage)this.getStage()).getAllocationTrackingElapsedTimeNs());
            this.myCaptureElapsedTime.setText(TimeFormatter.getSemiSimplifiedClockString((long)elapsedTimeUs));
        }
    }

    private void buildContextMenu() {
        if (this.myTimelineComponent == null) {
            return;
        }
        RangeSelectionComponent rangeSelectionComponent = this.myTimelineComponent.getRangeSelectionComponent();
        IdeProfilerComponents ideProfilerComponents = this.getIdeComponents();
        ContextMenuInstaller contextMenuInstaller = ideProfilerComponents.createContextMenuInstaller();
        ProfilerAction exportHeapDumpAction = new ProfilerAction.Builder("Export...").setIcon(AllIcons.ToolbarDecorator.Export).build();
        contextMenuInstaller.installGenericContextMenu((JComponent)rangeSelectionComponent, exportHeapDumpAction, x -> this.getCaptureIntersectingWithMouseX(x) != null && this.getCaptureIntersectingWithMouseX(x).isExportable(), x -> this.getIdeComponents().createExportDialog().open(() -> "Export capture to file", () -> MemoryProfiler.generateCaptureFileName(), () -> this.getCaptureIntersectingWithMouseX(x).getExportableExtension(), file -> ((MemoryProfilerStage)this.getStage()).getStudioProfilers().getIdeServices().saveFile((File)file, output -> {
            try {
                this.getCaptureIntersectingWithMouseX(x).saveToFile((OutputStream)output);
            }
            catch (IOException e) {
                MemoryProfilerStageView.getLogger().warn((Throwable)e);
            }
        }, null)));
        contextMenuInstaller.installGenericContextMenu((JComponent)rangeSelectionComponent, ContextMenuItem.SEPARATOR);
        if (!((MemoryProfilerStage)this.getStage()).isLiveAllocationTrackingReady()) {
            contextMenuInstaller.installGenericContextMenu((JComponent)rangeSelectionComponent, this.myAllocationAction);
            contextMenuInstaller.installGenericContextMenu((JComponent)rangeSelectionComponent, this.myStopAllocationAction);
        }
        if (((MemoryProfilerStage)this.getStage()).isNativeAllocationSamplingEnabled()) {
            contextMenuInstaller.installGenericContextMenu((JComponent)rangeSelectionComponent, this.myNativeAllocationAction);
            contextMenuInstaller.installGenericContextMenu((JComponent)rangeSelectionComponent, this.myStopNativeAllocationAction);
        }
        contextMenuInstaller.installGenericContextMenu((JComponent)rangeSelectionComponent, this.myForceGarbageCollectionAction);
        contextMenuInstaller.installGenericContextMenu((JComponent)rangeSelectionComponent, ContextMenuItem.SEPARATOR);
        contextMenuInstaller.installGenericContextMenu((JComponent)rangeSelectionComponent, this.myHeapDumpAction);
        contextMenuInstaller.installGenericContextMenu((JComponent)rangeSelectionComponent, ContextMenuItem.SEPARATOR);
        this.getProfilersView().installCommonMenuItems((JComponent)rangeSelectionComponent);
    }

    @Nullable
    private CaptureObject getCaptureIntersectingWithMouseX(int mouseXLocation) {
        assert (this.myTimelineComponent != null);
        Range range = ((MemoryProfilerStage)this.getStage()).getTimeline().getViewRange();
        double pos = (double)mouseXLocation / this.myTimelineComponent.getRangeSelectionComponent().getSize().getWidth() * range.getLength() + range.getMin();
        CaptureDurationData<? extends CaptureObject> durationData = ((MemoryProfilerStage)this.getStage()).getIntersectingCaptureDuration(new Range(pos, pos));
        return durationData == null ? null : durationData.getCaptureEntry().getCaptureObject();
    }

    private void captureObjectChanged() {
        this.stopLoadingUi();
        this.myCaptureObject = ((MemoryProfilerStage)this.getStage()).getCaptureSelection().getSelectedCapture();
        if (this.myCaptureObject == null) {
            this.resetRecordingButtons();
            this.myLayout.setShowingCaptureUi(false);
            return;
        }
        if (this.myCaptureObject.isDoneLoading()) {
            this.captureObjectFinishedLoading();
        } else {
            this.disableRecordingButtons();
            this.myLayout.setLoadingUiVisible(true);
        }
    }

    private void captureObjectFinishedLoading() {
        this.resetRecordingButtons();
        if (this.myTimelineComponent != null) {
            this.myTimelineComponent.getRangeSelectionComponent().requestFocus();
        }
        if (this.myCaptureObject != ((MemoryProfilerStage)this.getStage()).getCaptureSelection().getSelectedCapture() || this.myCaptureObject == null) {
            return;
        }
        this.myLayout.setShowingCaptureUi(true);
    }

    private void stopLoadingUi() {
        if (this.myCaptureObject != null && this.myLayout.isLoadingUiVisible()) {
            this.myLayout.setLoadingUiVisible(false);
        }
    }

    private void showHeapDumpInProgress() {
        this.getComponent().removeAll();
        this.myHeapDumpLoadingPanel.setChildComponent(this.myLayout.getComponent());
        this.getComponent().add((Component)this.myHeapDumpLoadingPanel.getComponent(), "Center");
        this.myHeapDumpLoadingPanel.startLoading();
    }

    private void hideHeapDumpInProgress() {
        this.myHeapDumpLoadingPanel.stopLoading();
        this.getComponent().removeAll();
        this.myHeapDumpLoadingPanel.setChildComponent(null);
        this.getComponent().add(this.myLayout.getComponent());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profilersView";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stage";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/memory/MemoryProfilerStageView";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/memory/MemoryProfilerStageView";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getHeapDumpButton";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllocationButton";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getNativeAllocationButton";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllocationSamplingRateDropDown";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllocationSamplingRateLabel";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getMainSplitter";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getChartCaptureSplitter";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getCapturePanel";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getCaptureView";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getHeapView";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassGrouping";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassifierView";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassSetView";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstanceDetailsView";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getCaptureElapsedTimeLabel";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getCaptureInfoMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @VisibleForTesting
    static class LiveAllocationSamplingModeRenderer
    extends ProfilerComboboxCellRenderer<MemoryProfilerStage.LiveAllocationSamplingMode> {
        LiveAllocationSamplingModeRenderer() {
        }

        protected void customizeCellRenderer(@NotNull JList list, MemoryProfilerStage.LiveAllocationSamplingMode value, int index, boolean selected, boolean hasFocus) {
            if (list == null) {
                LiveAllocationSamplingModeRenderer.$$$reportNull$$$0(0);
            }
            this.append(value.getDisplayName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/android/tools/profilers/memory/MemoryProfilerStageView$LiveAllocationSamplingModeRenderer", "customizeCellRenderer"));
        }
    }
}

