/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory;

import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.SeriesData;
import com.android.tools.adtui.model.StreamingTimeline;
import com.android.tools.idea.protobuf.ByteString;
import com.android.tools.idea.transport.poller.TransportEventListener;
import com.android.tools.profiler.proto.Commands;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.Memory;
import com.android.tools.profiler.proto.MemoryProfiler;
import com.android.tools.profiler.proto.Transport;
import com.android.tools.profilers.IdeProfilerServices;
import com.android.tools.profilers.ProfilerAspect;
import com.android.tools.profilers.ProfilerClient;
import com.android.tools.profilers.ProfilerMonitor;
import com.android.tools.profilers.StudioProfiler;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.analytics.FeatureTracker;
import com.android.tools.profilers.memory.AllocationSamplingRateDataSeries;
import com.android.tools.profilers.memory.AllocationSamplingRateDurationData;
import com.android.tools.profilers.memory.MemoryMonitor;
import com.android.tools.profilers.memory.MemoryProfilerStage;
import com.android.tools.profilers.sessions.SessionsManager;
import com.google.common.collect.ImmutableMap;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import io.grpc.StatusRuntimeException;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MemoryProfiler
extends StudioProfiler {
    @NotNull
    private final AspectObserver myAspectObserver;

    private static Logger getLogger() {
        return Logger.getInstance(MemoryProfiler.class);
    }

    public MemoryProfiler(@NotNull StudioProfilers profilers) {
        if (profilers == null) {
            MemoryProfiler.$$$reportNull$$$0(0);
        }
        super(profilers);
        this.myAspectObserver = new AspectObserver();
        this.myProfilers.addDependency(this.myAspectObserver).onChange((Enum)ProfilerAspect.AGENT, this::agentStatusChanged);
        SessionsManager sessionsManager = this.myProfilers.getSessionsManager();
        sessionsManager.registerImportHandler("hprof", this::importHprof);
        sessionsManager.registerImportHandler("alloc", this::importLegacyAllocations);
        if (profilers.getIdeServices().getFeatureConfig().isNativeMemorySampleEnabled()) {
            sessionsManager.registerImportHandler("heapprofd", this::importHeapprofd);
        }
        this.myProfilers.registerSessionChangeListener(Common.SessionMetaData.SessionType.MEMORY_CAPTURE, () -> {
            MemoryProfilerStage stage = new MemoryProfilerStage(this.myProfilers);
            this.myProfilers.setStage(stage);
            stage.setPendingCaptureStartTimeGuarded(this.myProfilers.getSession().getStartTimestamp());
            StreamingTimeline timeline = this.myProfilers.getTimeline();
            timeline.reset(this.myProfilers.getSession().getStartTimestamp(), this.myProfilers.getSession().getEndTimestamp());
            timeline.getViewRange().set(timeline.getDataRange());
            timeline.setIsPaused(true);
        });
    }

    @Override
    public ProfilerMonitor newMonitor() {
        return new MemoryMonitor(this.myProfilers);
    }

    @Override
    public void startProfiling(Common.Session session) {
    }

    @Override
    public void stopProfiling(Common.Session session) {
        try {
            MemoryProfiler.trackAllocations(this.myProfilers, session, false, null);
        }
        catch (StatusRuntimeException e) {
            MemoryProfiler.getLogger().info((Throwable)e);
        }
    }

    private void agentStatusChanged() {
        Common.Session session = this.myProfilers.getSession();
        if (Common.Session.getDefaultInstance().equals((Object)session) || session.getEndTimestamp() != Long.MAX_VALUE) {
            return;
        }
        if (!this.myProfilers.getSessionsManager().getSelectedSessionMetaData().getLiveAllocationEnabled()) {
            return;
        }
        if (!this.myProfilers.isAgentAttached()) {
            return;
        }
        try {
            MemoryProfiler.trackAllocations(this.myProfilers, session, false, null);
            MemoryProfiler.trackAllocations(this.myProfilers, session, true, null);
        }
        catch (StatusRuntimeException e) {
            MemoryProfiler.getLogger().info((Throwable)e);
        }
    }

    private void importHprof(@NotNull File file) {
        byte[] bytes;
        if (file == null) {
            MemoryProfiler.$$$reportNull$$$0(1);
        }
        SessionsManager sessionsManager = this.myProfilers.getSessionsManager();
        long startTimestampEpochMs = System.currentTimeMillis();
        Pair<Long, Long> timestampsNs = StudioProfilers.computeImportedFileStartEndTimestampsNs(file);
        long sessionStartTimeNs = (Long)timestampsNs.first;
        if (sessionsManager.setSessionById(sessionStartTimeNs)) {
            return;
        }
        long sessionEndTimeNs = (Long)timestampsNs.second;
        try {
            bytes = Files.readAllBytes(Paths.get(file.getPath(), new String[0]));
        }
        catch (IOException e) {
            MemoryProfiler.getLogger().error(String.format("Importing Session Failed: cannot read from %s.", file.getPath()));
            return;
        }
        Memory.HeapDumpInfo heapDumpInfo = Memory.HeapDumpInfo.newBuilder().setStartTime(sessionStartTimeNs).setEndTime(sessionEndTimeNs).build();
        if (this.myProfilers.getIdeServices().getFeatureConfig().isUnifiedPipelineEnabled()) {
            Common.Event heapDumpEvent = Common.Event.newBuilder().setKind(Common.Event.Kind.MEMORY_HEAP_DUMP).setGroupId(heapDumpInfo.getStartTime()).setTimestamp(heapDumpInfo.getStartTime()).setIsEnded(true).setMemoryHeapdump(Memory.MemoryHeapDumpData.newBuilder().setInfo(heapDumpInfo)).build();
            sessionsManager.createImportedSession(file.getName(), Common.SessionData.SessionStarted.SessionType.MEMORY_CAPTURE, sessionStartTimeNs, sessionEndTimeNs, startTimestampEpochMs, (Map<String, ByteString>)ImmutableMap.of((Object)Long.toString(sessionStartTimeNs), (Object)ByteString.copyFrom((byte[])bytes)), heapDumpEvent);
        } else {
            Common.Session session = sessionsManager.createImportedSessionLegacy(file.getName(), Common.SessionMetaData.SessionType.MEMORY_CAPTURE, sessionStartTimeNs, sessionEndTimeNs, startTimestampEpochMs);
            MemoryProfiler.ImportHeapDumpRequest heapDumpRequest = MemoryProfiler.ImportHeapDumpRequest.newBuilder().setSession(session).setData(ByteString.copyFrom((byte[])bytes)).setInfo(heapDumpInfo).build();
            MemoryProfiler.ImportHeapDumpResponse response = this.myProfilers.getClient().getMemoryClient().importHeapDump(heapDumpRequest);
            sessionsManager.update();
            sessionsManager.setSession(session);
        }
        this.myProfilers.getIdeServices().getFeatureTracker().trackCreateSession(Common.SessionMetaData.SessionType.MEMORY_CAPTURE, SessionsManager.SessionCreationSource.MANUAL);
    }

    private byte[] importCommon(@NotNull File file, Memory.AllocationsInfo.Builder info) {
        byte[] bytes;
        if (file == null) {
            MemoryProfiler.$$$reportNull$$$0(2);
        }
        SessionsManager sessionsManager = this.myProfilers.getSessionsManager();
        Pair<Long, Long> timestampsNs = StudioProfilers.computeImportedFileStartEndTimestampsNs(file);
        long sessionStartTimeNs = (Long)timestampsNs.first;
        if (sessionsManager.setSessionById(sessionStartTimeNs)) {
            return null;
        }
        long sessionEndTimeNs = (Long)timestampsNs.second;
        try {
            bytes = Files.readAllBytes(Paths.get(file.getPath(), new String[0]));
        }
        catch (IOException e) {
            MemoryProfiler.getLogger().error("Importing Session Failed: cannot read from file location...");
            return null;
        }
        info.setStartTime(sessionStartTimeNs);
        info.setEndTime(sessionEndTimeNs);
        return bytes;
    }

    private void importHeapprofd(@NotNull File file) {
        if (file == null) {
            MemoryProfiler.$$$reportNull$$$0(3);
        }
        SessionsManager sessionsManager = this.myProfilers.getSessionsManager();
        long startTimestampEpochMs = System.currentTimeMillis();
        Memory.AllocationsInfo.Builder info = Memory.AllocationsInfo.newBuilder();
        byte[] bytes = this.importCommon(file, info);
        if (bytes == null) {
            return;
        }
        info.setLegacy(false).setSuccess(true);
        Common.Event nativeCapture = Common.Event.newBuilder().setKind(Common.Event.Kind.MEMORY_NATIVE_SAMPLE_CAPTURE).setGroupId(info.getStartTime()).setTimestamp(info.getStartTime()).setIsEnded(true).setMemoryNativeSample(Memory.MemoryNativeSampleData.newBuilder().setStartTime(info.getStartTime()).setEndTime(info.getEndTime()).build()).build();
        sessionsManager.createImportedSession(file.getName(), Common.SessionData.SessionStarted.SessionType.MEMORY_CAPTURE, info.getStartTime(), info.getEndTime(), startTimestampEpochMs, (Map<String, ByteString>)ImmutableMap.of((Object)Long.toString(info.getStartTime()), (Object)ByteString.copyFrom((byte[])bytes)), nativeCapture);
    }

    private void importLegacyAllocations(@NotNull File file) {
        if (file == null) {
            MemoryProfiler.$$$reportNull$$$0(4);
        }
        SessionsManager sessionsManager = this.myProfilers.getSessionsManager();
        long startTimestampEpochMs = System.currentTimeMillis();
        Memory.AllocationsInfo.Builder info = Memory.AllocationsInfo.newBuilder();
        byte[] bytes = this.importCommon(file, info);
        if (bytes == null) {
            return;
        }
        info.setLegacy(true).setSuccess(true);
        if (this.myProfilers.getIdeServices().getFeatureConfig().isUnifiedPipelineEnabled()) {
            Common.Event heapDumpEvent = Common.Event.newBuilder().setKind(Common.Event.Kind.MEMORY_ALLOC_TRACKING).setGroupId(info.getStartTime()).setTimestamp(info.getStartTime()).setIsEnded(true).setMemoryAllocTracking(Memory.MemoryAllocTrackingData.newBuilder().setInfo(info)).build();
            sessionsManager.createImportedSession(file.getName(), Common.SessionData.SessionStarted.SessionType.MEMORY_CAPTURE, info.getStartTime(), info.getEndTime(), startTimestampEpochMs, (Map<String, ByteString>)ImmutableMap.of((Object)Long.toString(info.getStartTime()), (Object)ByteString.copyFrom((byte[])bytes)), heapDumpEvent);
        } else {
            Common.Session session = sessionsManager.createImportedSessionLegacy(file.getName(), Common.SessionMetaData.SessionType.MEMORY_CAPTURE, info.getStartTime(), info.getEndTime(), startTimestampEpochMs);
            MemoryProfiler.ImportLegacyAllocationsRequest request = MemoryProfiler.ImportLegacyAllocationsRequest.newBuilder().setSession(session).setInfo(info).setData(ByteString.copyFrom((byte[])bytes)).build();
            MemoryProfiler.ImportLegacyAllocationsResponse response = this.myProfilers.getClient().getMemoryClient().importLegacyAllocations(request);
            sessionsManager.update();
            sessionsManager.setSession(session);
        }
        this.myProfilers.getIdeServices().getFeatureTracker().trackCreateSession(Common.SessionMetaData.SessionType.MEMORY_CAPTURE, SessionsManager.SessionCreationSource.MANUAL);
    }

    static boolean isUsingLiveAllocation(@NotNull StudioProfilers profilers, @NotNull Common.Session session) {
        AllocationSamplingRateDataSeries samplingSeries;
        if (profilers == null) {
            MemoryProfiler.$$$reportNull$$$0(5);
        }
        if (session == null) {
            MemoryProfiler.$$$reportNull$$$0(6);
        }
        return !(samplingSeries = new AllocationSamplingRateDataSeries(profilers.getClient(), session, profilers.getIdeServices().getFeatureConfig().isUnifiedPipelineEnabled())).getDataForRange(profilers.getTimeline().getDataRange()).isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    public static boolean hasOnlyFullAllocationTrackingWithinRegion(@NotNull StudioProfilers profilers, @NotNull Common.Session session, long startTimeUs, long l) {
        void endTimeUs;
        AllocationSamplingRateDataSeries series;
        List<SeriesData<AllocationSamplingRateDurationData>> samplingModes;
        if (profilers == null) {
            MemoryProfiler.$$$reportNull$$$0(7);
        }
        if (session == null) {
            MemoryProfiler.$$$reportNull$$$0(8);
        }
        return (samplingModes = (series = new AllocationSamplingRateDataSeries(profilers.getClient(), session, profilers.getIdeServices().getFeatureConfig().isUnifiedPipelineEnabled())).getDataForRange(new Range((double)startTimeUs, (double)endTimeUs))).size() == 1 && ((AllocationSamplingRateDurationData)samplingModes.get((int)0).value).getCurrentRate().getSamplingNumInterval() == MemoryProfilerStage.LiveAllocationSamplingMode.FULL.getValue();
    }

    public static void saveHeapDumpToFile(@NotNull ProfilerClient client, @NotNull Common.Session session, @NotNull Memory.HeapDumpInfo info, @NotNull OutputStream outputStream, @NotNull FeatureTracker featureTracker) {
        Transport.BytesResponse response;
        if (client == null) {
            MemoryProfiler.$$$reportNull$$$0(9);
        }
        if (session == null) {
            MemoryProfiler.$$$reportNull$$$0(10);
        }
        if (info == null) {
            MemoryProfiler.$$$reportNull$$$0(11);
        }
        if (outputStream == null) {
            MemoryProfiler.$$$reportNull$$$0(12);
        }
        if (featureTracker == null) {
            MemoryProfiler.$$$reportNull$$$0(13);
        }
        if ((response = client.getTransportClient().getBytes(Transport.BytesRequest.newBuilder().setStreamId(session.getStreamId()).setId(Long.toString(info.getStartTime())).build())).getContents() != ByteString.EMPTY) {
            try {
                response.getContents().writeTo(outputStream);
                featureTracker.trackExportHeap();
            }
            catch (IOException exception) {
                MemoryProfiler.getLogger().warn("Failed to export heap dump file:\n" + exception);
            }
        }
    }

    public static void saveLegacyAllocationToFile(@NotNull ProfilerClient client, @NotNull Common.Session session, @NotNull Memory.AllocationsInfo info, @NotNull OutputStream outputStream, @NotNull FeatureTracker featureTracker) {
        Transport.BytesResponse response;
        if (client == null) {
            MemoryProfiler.$$$reportNull$$$0(14);
        }
        if (session == null) {
            MemoryProfiler.$$$reportNull$$$0(15);
        }
        if (info == null) {
            MemoryProfiler.$$$reportNull$$$0(16);
        }
        if (outputStream == null) {
            MemoryProfiler.$$$reportNull$$$0(17);
        }
        if (featureTracker == null) {
            MemoryProfiler.$$$reportNull$$$0(18);
        }
        if ((response = client.getTransportClient().getBytes(Transport.BytesRequest.newBuilder().setStreamId(session.getStreamId()).setId(Long.toString(info.getStartTime())).build())).getContents() != ByteString.EMPTY) {
            try {
                response.getContents().writeTo(outputStream);
                featureTracker.trackExportAllocation();
            }
            catch (IOException exception) {
                MemoryProfiler.getLogger().warn("Failed to export allocation records:\n" + exception);
            }
        }
    }

    public static void saveHeapProfdSampleToFile(@NotNull ProfilerClient client, @NotNull Common.Session session, @NotNull Memory.MemoryNativeSampleData info, @NotNull OutputStream outputStream) {
        Transport.BytesResponse response;
        if (client == null) {
            MemoryProfiler.$$$reportNull$$$0(19);
        }
        if (session == null) {
            MemoryProfiler.$$$reportNull$$$0(20);
        }
        if (info == null) {
            MemoryProfiler.$$$reportNull$$$0(21);
        }
        if (outputStream == null) {
            MemoryProfiler.$$$reportNull$$$0(22);
        }
        if ((response = client.getTransportClient().getBytes(Transport.BytesRequest.newBuilder().setStreamId(session.getStreamId()).setId(Long.toString(info.getStartTime())).build())).getContents() != ByteString.EMPTY) {
            try {
                response.getContents().writeTo(outputStream);
            }
            catch (IOException exception) {
                MemoryProfiler.getLogger().warn("Failed to export native allocation records:\n" + exception);
            }
        }
    }

    @NotNull
    static String generateCaptureFileName() {
        StringBuilder builder = new StringBuilder("memory-");
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMdd'T'HHmmss");
        builder.append(LocalDateTime.now().format(formatter));
        String string = builder.toString();
        if (string == null) {
            MemoryProfiler.$$$reportNull$$$0(23);
        }
        return string;
    }

    public static List<Memory.MemoryNativeSampleData> getNativeHeapSamplesForSession(@NotNull ProfilerClient client, @NotNull Common.Session session, @NotNull Range rangeUs) {
        if (client == null) {
            MemoryProfiler.$$$reportNull$$$0(24);
        }
        if (session == null) {
            MemoryProfiler.$$$reportNull$$$0(25);
        }
        if (rangeUs == null) {
            MemoryProfiler.$$$reportNull$$$0(26);
        }
        Transport.GetEventGroupsRequest request = Transport.GetEventGroupsRequest.newBuilder().setStreamId(session.getStreamId()).setPid(session.getPid()).setKind(Common.Event.Kind.MEMORY_NATIVE_SAMPLE_CAPTURE).setFromTimestamp(TimeUnit.MICROSECONDS.toNanos((long)rangeUs.getMin())).setToTimestamp(TimeUnit.MICROSECONDS.toNanos((long)rangeUs.getMax())).build();
        Transport.GetEventGroupsResponse response = client.getTransportClient().getEventGroups(request);
        ArrayList<Memory.MemoryNativeSampleData> infos = new ArrayList<Memory.MemoryNativeSampleData>();
        for (Transport.EventGroup group : response.getGroupsList()) {
            Common.Event lastEvent = group.getEvents(group.getEventsCount() - 1);
            infos.add(lastEvent.getMemoryNativeSample());
        }
        return infos;
    }

    public static List<Memory.MemoryNativeTrackingData> getNativeHeapStatusForSession(@NotNull ProfilerClient client, @NotNull Common.Session session, @NotNull Range rangeUs) {
        if (client == null) {
            MemoryProfiler.$$$reportNull$$$0(27);
        }
        if (session == null) {
            MemoryProfiler.$$$reportNull$$$0(28);
        }
        if (rangeUs == null) {
            MemoryProfiler.$$$reportNull$$$0(29);
        }
        Transport.GetEventGroupsRequest request = Transport.GetEventGroupsRequest.newBuilder().setStreamId(session.getStreamId()).setPid(session.getPid()).setKind(Common.Event.Kind.MEMORY_NATIVE_SAMPLE_STATUS).setFromTimestamp(TimeUnit.MICROSECONDS.toNanos((long)rangeUs.getMin())).setToTimestamp(TimeUnit.MICROSECONDS.toNanos((long)rangeUs.getMax())).build();
        Transport.GetEventGroupsResponse response = client.getTransportClient().getEventGroups(request);
        ArrayList<Memory.MemoryNativeTrackingData> infos = new ArrayList<Memory.MemoryNativeTrackingData>();
        for (Transport.EventGroup group : response.getGroupsList()) {
            Common.Event lastEvent = group.getEvents(group.getEventsCount() - 1);
            infos.add(lastEvent.getMemoryNativeTrackingStatus());
        }
        return infos;
    }

    public static List<Memory.HeapDumpInfo> getHeapDumpsForSession(@NotNull ProfilerClient client, @NotNull Common.Session session, @NotNull Range rangeUs, @NotNull IdeProfilerServices profilerService) {
        if (client == null) {
            MemoryProfiler.$$$reportNull$$$0(30);
        }
        if (session == null) {
            MemoryProfiler.$$$reportNull$$$0(31);
        }
        if (rangeUs == null) {
            MemoryProfiler.$$$reportNull$$$0(32);
        }
        if (profilerService == null) {
            MemoryProfiler.$$$reportNull$$$0(33);
        }
        if (profilerService.getFeatureConfig().isUnifiedPipelineEnabled()) {
            Transport.GetEventGroupsRequest request = Transport.GetEventGroupsRequest.newBuilder().setStreamId(session.getStreamId()).setPid(session.getPid()).setKind(Common.Event.Kind.MEMORY_HEAP_DUMP).setFromTimestamp(TimeUnit.MICROSECONDS.toNanos((long)rangeUs.getMin())).setToTimestamp(TimeUnit.MICROSECONDS.toNanos((long)rangeUs.getMax())).build();
            Transport.GetEventGroupsResponse response = client.getTransportClient().getEventGroups(request);
            ArrayList<Memory.HeapDumpInfo> infos = new ArrayList<Memory.HeapDumpInfo>();
            for (Transport.EventGroup group : response.getGroupsList()) {
                Common.Event lastEvent = group.getEvents(group.getEventsCount() - 1);
                infos.add(lastEvent.getMemoryHeapdump().getInfo());
            }
            return infos;
        }
        MemoryProfiler.ListHeapDumpInfosResponse response = client.getMemoryClient().listHeapDumpInfos(MemoryProfiler.ListDumpInfosRequest.newBuilder().setSession(session).setStartTime(TimeUnit.MICROSECONDS.toNanos((long)rangeUs.getMin())).setEndTime(TimeUnit.MICROSECONDS.toNanos((long)rangeUs.getMax())).build());
        return response.getInfosList();
    }

    public static List<Memory.AllocationsInfo> getAllocationInfosForSession(@NotNull ProfilerClient client, @NotNull Common.Session session, @NotNull Range rangeUs, @NotNull IdeProfilerServices profilerService) {
        long toTimestamp;
        if (client == null) {
            MemoryProfiler.$$$reportNull$$$0(34);
        }
        if (session == null) {
            MemoryProfiler.$$$reportNull$$$0(35);
        }
        if (rangeUs == null) {
            MemoryProfiler.$$$reportNull$$$0(36);
        }
        if (profilerService == null) {
            MemoryProfiler.$$$reportNull$$$0(37);
        }
        long fromTimestamp = (long)rangeUs.getMin() == Long.MIN_VALUE ? Long.MIN_VALUE : TimeUnit.MICROSECONDS.toNanos((long)rangeUs.getMin());
        long l = toTimestamp = (long)rangeUs.getMax() == Long.MAX_VALUE ? Long.MAX_VALUE : TimeUnit.MICROSECONDS.toNanos((long)rangeUs.getMax());
        if (profilerService.getFeatureConfig().isUnifiedPipelineEnabled()) {
            Transport.GetEventGroupsRequest request = Transport.GetEventGroupsRequest.newBuilder().setStreamId(session.getStreamId()).setPid(session.getPid()).setKind(Common.Event.Kind.MEMORY_ALLOC_TRACKING).setFromTimestamp(fromTimestamp).setToTimestamp(toTimestamp).build();
            Transport.GetEventGroupsResponse response = client.getTransportClient().getEventGroups(request);
            ArrayList<Memory.AllocationsInfo> infos = new ArrayList<Memory.AllocationsInfo>();
            for (Transport.EventGroup group : response.getGroupsList()) {
                Common.Event lastEvent = group.getEvents(group.getEventsCount() - 1);
                Memory.AllocationsInfo info = lastEvent.getMemoryAllocTracking().getInfo();
                if (info.equals((Object)Memory.AllocationsInfo.getDefaultInstance())) {
                    assert (group.getEventsCount() > 1);
                    info = group.getEvents(0).getMemoryAllocTracking().getInfo();
                    if (info.getLegacy() && info.getEndTime() == Long.MAX_VALUE) {
                        info = info.toBuilder().setEndTime(session.getEndTimestamp()).setSuccess(false).build();
                    }
                }
                infos.add(info);
            }
            return infos;
        }
        MemoryProfiler.MemoryRequest dataRequest = MemoryProfiler.MemoryRequest.newBuilder().setSession(session).setStartTime(fromTimestamp).setEndTime(toTimestamp).build();
        return client.getMemoryClient().getData(dataRequest).getAllocationsInfoList();
    }

    public static void trackAllocations(@NotNull StudioProfilers profilers, @NotNull Common.Session session, boolean enable, @Nullable Consumer<Memory.TrackStatus> responseHandler) {
        if (profilers == null) {
            MemoryProfiler.$$$reportNull$$$0(38);
        }
        if (session == null) {
            MemoryProfiler.$$$reportNull$$$0(39);
        }
        Transport.TimeResponse timeResponse = profilers.getClient().getTransportClient().getCurrentTime(Transport.TimeRequest.newBuilder().setStreamId(session.getStreamId()).build());
        long timeNs = timeResponse.getTimestampNs();
        if (profilers.getIdeServices().getFeatureConfig().isUnifiedPipelineEnabled()) {
            Commands.Command.Builder trackCommand = Commands.Command.newBuilder().setStreamId(session.getStreamId()).setPid(session.getPid());
            if (enable) {
                trackCommand.setType(Commands.Command.CommandType.START_ALLOC_TRACKING).setStartAllocTracking(Memory.StartAllocTracking.newBuilder().setRequestTime(timeNs));
            } else {
                trackCommand.setType(Commands.Command.CommandType.STOP_ALLOC_TRACKING).setStopAllocTracking(Memory.StopAllocTracking.newBuilder().setRequestTime(timeNs));
            }
            Transport.ExecuteResponse response = profilers.getClient().getTransportClient().execute(Transport.ExecuteRequest.newBuilder().setCommand(trackCommand).build());
            if (responseHandler != null) {
                TransportEventListener statusListener = new TransportEventListener(Common.Event.Kind.MEMORY_ALLOC_TRACKING_STATUS, profilers.getIdeServices().getMainExecutor(), event -> event.getCommandId() == response.getCommandId(), () -> session.getStreamId(), () -> session.getPid(), event -> {
                    responseHandler.accept(event.getMemoryAllocTrackingStatus().getStatus());
                    return true;
                });
                profilers.getTransportPoller().registerListener(statusListener);
            }
        } else {
            MemoryProfiler.TrackAllocationsResponse response = profilers.getClient().getMemoryClient().trackAllocations(MemoryProfiler.TrackAllocationsRequest.newBuilder().setSession(session).setRequestTime(timeNs).setEnabled(enable).build());
            if (responseHandler != null) {
                responseHandler.accept(response.getStatus());
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 23: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 23: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profilers";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 15: 
            case 20: 
            case 25: 
            case 28: 
            case 31: 
            case 35: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 9: 
            case 14: 
            case 19: 
            case 24: 
            case 27: 
            case 30: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "client";
                break;
            }
            case 11: 
            case 16: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 12: 
            case 17: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputStream";
                break;
            }
            case 13: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "featureTracker";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/memory/MemoryProfiler";
                break;
            }
            case 26: 
            case 29: 
            case 32: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rangeUs";
                break;
            }
            case 33: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profilerService";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/memory/MemoryProfiler";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "generateCaptureFileName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "importHprof";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "importCommon";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "importHeapprofd";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "importLegacyAllocations";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isUsingLiveAllocation";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "hasOnlyFullAllocationTrackingWithinRegion";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "saveHeapDumpToFile";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "saveLegacyAllocationToFile";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "saveHeapProfdSampleToFile";
                break;
            }
            case 23: {
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getNativeHeapSamplesForSession";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getNativeHeapStatusForSession";
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getHeapDumpsForSession";
                break;
            }
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getAllocationInfosForSession";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "trackAllocations";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 23: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

