/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory;

import com.android.tools.profilers.memory.adapters.MemoryObject;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MemoryObjectTreeNode<T extends MemoryObject>
implements MutableTreeNode {
    @Nullable
    protected MemoryObjectTreeNode<T> myParent;
    @NotNull
    protected List<MemoryObjectTreeNode<T>> myChildren;
    @Nullable
    protected Comparator<MemoryObjectTreeNode<T>> myComparator;
    @NotNull
    private final T myAdapter;
    private boolean myChildrenChanged;
    private boolean myComparatorChanged;

    public MemoryObjectTreeNode(@NotNull T adapter) {
        if (adapter == null) {
            MemoryObjectTreeNode.$$$reportNull$$$0(0);
        }
        this.myChildren = new ArrayList<MemoryObjectTreeNode<T>>();
        this.myComparator = null;
        this.myAdapter = adapter;
    }

    @Override
    public TreeNode getChildAt(int i2) {
        this.ensureOrder();
        return this.myChildren.get(i2);
    }

    @Override
    public int getChildCount() {
        return this.myChildren.size();
    }

    @Override
    public TreeNode getParent() {
        return this.myParent;
    }

    @Override
    public int getIndex(TreeNode treeNode) {
        assert (treeNode instanceof MemoryObjectTreeNode);
        this.ensureOrder();
        return this.myChildren.indexOf(treeNode);
    }

    @Override
    public boolean isLeaf() {
        return this.myChildren.isEmpty();
    }

    public Enumeration children() {
        this.ensureOrder();
        return Collections.enumeration(this.myChildren);
    }

    @NotNull
    public ImmutableList<MemoryObjectTreeNode<T>> getChildren() {
        this.ensureOrder();
        ImmutableList immutableList = ContainerUtil.immutableList(this.myChildren);
        if (immutableList == null) {
            MemoryObjectTreeNode.$$$reportNull$$$0(1);
        }
        return immutableList;
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    public void add(@NotNull MemoryObjectTreeNode child) {
        if (child == null) {
            MemoryObjectTreeNode.$$$reportNull$$$0(2);
        }
        this.insert(child, this.myChildren.size());
        this.myChildrenChanged = true;
    }

    @Override
    public void insert(MutableTreeNode newChild, int childIndex) {
        assert (newChild instanceof MemoryObjectTreeNode);
        MemoryObjectTreeNode child = (MemoryObjectTreeNode)newChild;
        if (child.myParent != null && child.myParent != this) {
            child.myParent.remove(child);
        }
        child.setParent(this);
        this.myChildren.add(childIndex, child);
        this.myChildrenChanged = true;
    }

    @Override
    public void setParent(@Nullable MutableTreeNode newParent) {
        assert (newParent == null || newParent instanceof MemoryObjectTreeNode);
        this.myParent = (MemoryObjectTreeNode)newParent;
    }

    @Override
    public void remove(int childIndex) {
        MemoryObjectTreeNode<T> child = this.myChildren.get(childIndex);
        this.myChildren.remove(childIndex);
        child.setParent(null);
        this.myChildrenChanged = true;
    }

    @Override
    public void remove(MutableTreeNode node) {
        assert (node instanceof MemoryObjectTreeNode);
        this.remove(this.myChildren.indexOf(node));
        this.myChildrenChanged = true;
    }

    @Override
    public void removeFromParent() {
        if (this.myParent != null) {
            this.myParent.remove(this);
            this.myParent = null;
        }
    }

    public void removeAll() {
        this.myChildren.forEach(child -> {
            child.myParent = null;
        });
        this.myChildren.clear();
        this.myChildrenChanged = true;
    }

    @Override
    public void setUserObject(Object object) {
        throw new RuntimeException("Not implemented, use setData/getAdapter instead.");
    }

    @NotNull
    public T getAdapter() {
        T t = this.myAdapter;
        if (t == null) {
            MemoryObjectTreeNode.$$$reportNull$$$0(3);
        }
        return t;
    }

    public void sort(@NotNull Comparator<MemoryObjectTreeNode<T>> comparator) {
        if (comparator == null) {
            MemoryObjectTreeNode.$$$reportNull$$$0(4);
        }
        assert (this.myParent == null);
        if (this.myComparator != comparator) {
            this.myComparator = comparator;
            this.myComparatorChanged = true;
            this.ensureOrder();
        }
    }

    @Nullable
    public Comparator<MemoryObjectTreeNode<T>> getComparator() {
        return this.myComparator;
    }

    @NotNull
    public List<MemoryObjectTreeNode<T>> getPathToRoot() {
        ArrayList<MemoryObjectTreeNode<T>> path = new ArrayList<MemoryObjectTreeNode<T>>();
        MemoryObjectTreeNode<T> currentNode = this;
        MemoryObjectTreeNode<T> cycleDetector = this;
        while (currentNode != null) {
            for (int i2 = 0; i2 < 2 && cycleDetector != null; ++i2) {
                assert (cycleDetector.myParent != currentNode);
                cycleDetector = cycleDetector.myParent;
            }
            path.add(currentNode);
            currentNode = currentNode.myParent;
        }
        Collections.reverse(path);
        ArrayList<MemoryObjectTreeNode<T>> arrayList = path;
        if (arrayList == null) {
            MemoryObjectTreeNode.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    protected void ensureOrder() {
        if (this.orderNeedsUpdating()) {
            Comparator<MemoryObjectTreeNode<MemoryObjectTreeNode<T>>> comparator = this.myComparator = this.myParent != null ? this.myParent.myComparator : this.myComparator;
            if (this.myComparator != null) {
                this.myChildren.sort(this.myComparator);
            }
            this.myComparatorChanged = false;
            this.myChildrenChanged = false;
        }
    }

    @VisibleForTesting
    boolean orderNeedsUpdating() {
        return this.myParent != null && this.myParent.myComparator != this.myComparator || this.myComparatorChanged || this.myChildrenChanged;
    }

    public void select() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "adapter";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/memory/MemoryObjectTreeNode";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comparator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/memory/MemoryObjectTreeNode";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdapter";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathToRoot";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "sort";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

