/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory;

import com.android.ddmlib.AllocationInfo;
import com.android.ddmlib.AllocationsParser;
import com.android.tools.profiler.proto.Memory;
import com.intellij.util.containers.ContainerUtil;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class LegacyAllocationConverter {
    @NotNull
    private List<Allocation> myAllocations = new ArrayList<Allocation>();
    @NotNull
    private Map<String, ClassName> myAllocatedClasses = new HashMap<String, ClassName>();
    @NotNull
    private Map<List<StackTraceElement>, CallStack> myAllocationStacks = new HashMap<List<StackTraceElement>, CallStack>();

    public int addClassName(@NotNull String className) {
        int id;
        if (className == null) {
            LegacyAllocationConverter.$$$reportNull$$$0(0);
        }
        if (!this.myAllocatedClasses.containsKey(className)) {
            id = this.myAllocatedClasses.size();
            this.myAllocatedClasses.put(className, new ClassName(className, id));
        } else {
            id = this.myAllocatedClasses.get((Object)className).myClassId;
        }
        return id;
    }

    @NotNull
    public CallStack addCallStack(@NotNull List<StackTraceElement> stackTraceElements) {
        CallStack result;
        if (stackTraceElements == null) {
            LegacyAllocationConverter.$$$reportNull$$$0(1);
        }
        if (!this.myAllocationStacks.containsKey(stackTraceElements)) {
            result = new CallStack(stackTraceElements);
            this.myAllocationStacks.put(stackTraceElements, result);
        } else {
            result = this.myAllocationStacks.get(stackTraceElements);
        }
        CallStack callStack = result;
        if (callStack == null) {
            LegacyAllocationConverter.$$$reportNull$$$0(2);
        }
        return callStack;
    }

    public void resetAllocations() {
        this.myAllocations.clear();
    }

    public void addAllocation(@NotNull Allocation allocationInfo) {
        if (allocationInfo == null) {
            LegacyAllocationConverter.$$$reportNull$$$0(3);
        }
        this.myAllocations.add(allocationInfo);
    }

    public List<Memory.AllocationEvent.Allocation> getAllocationEvents() {
        return ContainerUtil.map(this.myAllocations, allocation -> allocation.bindAllocationEventInfos());
    }

    public List<Memory.AllocationStack> getAllocationStacks() {
        return ContainerUtil.map(this.myAllocationStacks.values(), CallStack::getAllocationStack);
    }

    public List<Memory.AllocatedClass> getClassNames() {
        return ContainerUtil.map(this.myAllocatedClasses.values(), ClassName::getAllocatedClass);
    }

    public void parseDump(@NotNull byte[] dumpData) {
        AllocationInfo[] rawInfos;
        if (dumpData == null) {
            LegacyAllocationConverter.$$$reportNull$$$0(4);
        }
        this.resetAllocations();
        for (AllocationInfo info : rawInfos = AllocationsParser.parse((ByteBuffer)ByteBuffer.wrap(dumpData))) {
            List<StackTraceElement> stackTraceElements = Arrays.asList(info.getStackTrace());
            CallStack callStack = this.addCallStack(stackTraceElements);
            int classId = this.addClassName(info.getAllocatedClass());
            this.addAllocation(new Allocation(classId, info.getSize(), info.getThreadId(), callStack.hashCode()));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stackTraceElements";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/memory/LegacyAllocationConverter";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allocationInfo";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dumpData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/memory/LegacyAllocationConverter";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "addCallStack";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addClassName";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addCallStack";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addAllocation";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "parseDump";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Allocation {
        private final int myClassId;
        private final int mySize;
        private final int myThreadId;
        private final int myCallStackId;

        public Allocation(int classId, int size, int threadId, int callStackId) {
            this.myClassId = classId;
            this.mySize = size;
            this.myThreadId = threadId;
            this.myCallStackId = callStackId;
        }

        @NotNull
        public Memory.AllocationEvent.Allocation bindAllocationEventInfos() {
            Memory.AllocationEvent.Allocation allocation = Memory.AllocationEvent.Allocation.newBuilder().setClassTag(this.myClassId).setSize((long)this.mySize).setThreadId(this.myThreadId).setStackId(this.myCallStackId).build();
            if (allocation == null) {
                Allocation.$$$reportNull$$$0(0);
            }
            return allocation;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/profilers/memory/LegacyAllocationConverter$Allocation", "bindAllocationEventInfos"));
        }
    }

    public static class ClassName {
        private final String myClassName;
        private final int myClassId;

        public ClassName(@NotNull String className, int classId) {
            if (className == null) {
                ClassName.$$$reportNull$$$0(0);
            }
            this.myClassName = className;
            this.myClassId = classId;
        }

        @NotNull
        public Memory.AllocatedClass getAllocatedClass() {
            Memory.AllocatedClass allocatedClass = Memory.AllocatedClass.newBuilder().setClassName(this.myClassName).setClassId(this.myClassId).build();
            if (allocatedClass == null) {
                ClassName.$$$reportNull$$$0(1);
            }
            return allocatedClass;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "className";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/profilers/memory/LegacyAllocationConverter$ClassName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/profilers/memory/LegacyAllocationConverter$ClassName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAllocatedClass";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class CallStack {
        @NotNull
        private final List<StackTraceElement> myCallStackFrames;

        public CallStack(@NotNull List<StackTraceElement> frames) {
            if (frames == null) {
                CallStack.$$$reportNull$$$0(0);
            }
            this.myCallStackFrames = frames;
        }

        public int hashCode() {
            return this.myCallStackFrames.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof CallStack)) {
                return false;
            }
            return this.myCallStackFrames.equals(((CallStack)obj).myCallStackFrames);
        }

        @NotNull
        public Memory.AllocationStack getAllocationStack() {
            Memory.AllocationStack.Builder builder = Memory.AllocationStack.newBuilder().setStackId(this.hashCode());
            Memory.AllocationStack.StackFrameWrapper.Builder frameBuilder = Memory.AllocationStack.StackFrameWrapper.newBuilder();
            for (StackTraceElement frame : this.myCallStackFrames) {
                frameBuilder.addFrames(Memory.AllocationStack.StackFrame.newBuilder().setClassName(frame.getClassName()).setMethodName(frame.getMethodName()).setFileName(frame.getFileName()).setLineNumber(frame.getLineNumber()).build());
            }
            builder.setFullStack(frameBuilder);
            Memory.AllocationStack allocationStack = builder.build();
            if (allocationStack == null) {
                CallStack.$$$reportNull$$$0(1);
            }
            return allocationStack;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "frames";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/profilers/memory/LegacyAllocationConverter$CallStack";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/profilers/memory/LegacyAllocationConverter$CallStack";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAllocationStack";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

