/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory;

import com.android.tools.profilers.memory.MemoryObjectTreeNode;
import com.android.tools.profilers.memory.adapters.MemoryObject;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ImmutableList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LazyMemoryObjectTreeNode<T extends MemoryObject>
extends MemoryObjectTreeNode<T> {
    static final int INVALID_CHILDREN_COUNT = -1;
    static final int NUM_CHILDREN_PER_PAGE = 100;
    protected int myMemoizedChildrenCount;
    private int myCurrentPageCount;
    private List<MemoryObjectTreeNode<T>> myChildrenView;
    @Nullable
    private DefaultTreeModel myTreeModel;
    @Nullable
    private MemoryObjectTreeNode<MemoryObject> myPagingNode;

    public LazyMemoryObjectTreeNode(@NotNull T adapter, boolean usePaging) {
        if (adapter == null) {
            LazyMemoryObjectTreeNode.$$$reportNull$$$0(0);
        }
        super(adapter);
        this.myMemoizedChildrenCount = -1;
        this.myCurrentPageCount = 1;
        this.myChildrenView = this.myChildren.subList(0, 0);
        this.myPagingNode = usePaging ? new PagingNode(this) : null;
    }

    public void setTreeModel(@Nullable DefaultTreeModel treeModel) {
        this.myTreeModel = treeModel;
    }

    @Nullable
    public DefaultTreeModel getTreeModel() {
        return this.myTreeModel;
    }

    public abstract int computeChildrenCount();

    public abstract void expandNode();

    @Override
    public TreeNode getChildAt(int i2) {
        this.expandNode();
        this.ensureOrder();
        if (this.myPagingNode != null && this.myChildren.size() == this.myChildrenView.size() && i2 >= this.myChildren.size()) {
            throw new IndexOutOfBoundsException();
        }
        return this.myPagingNode != null && i2 == this.myChildrenView.size() ? this.myPagingNode : (MemoryObjectTreeNode<MemoryObject>)this.myChildren.get(i2);
    }

    @Override
    public int getChildCount() {
        if (this.myMemoizedChildrenCount == -1) {
            this.myMemoizedChildrenCount = this.computeChildrenCount();
            if (this.myPagingNode == null) {
                this.myCurrentPageCount = (this.myMemoizedChildrenCount + 100 - 1) / 100;
                this.myChildrenView = this.myChildren;
            }
        }
        return this.myPagingNode != null && this.myMemoizedChildrenCount > this.myCurrentPageCount * 100 ? this.myCurrentPageCount * 100 + 1 : this.myMemoizedChildrenCount;
    }

    @Override
    public int getIndex(TreeNode treeNode) {
        this.expandNode();
        this.ensureOrder();
        if (treeNode == null) {
            return -1;
        }
        if (treeNode instanceof LazyMemoryObjectTreeNode) {
            return this.myPagingNode == null ? this.myChildren.indexOf(treeNode) : this.myChildrenView.indexOf(treeNode);
        }
        if (treeNode == this.myPagingNode) {
            return this.myChildrenView.size();
        }
        return -1;
    }

    @Override
    public boolean isLeaf() {
        return this.getChildCount() == 0;
    }

    @Override
    public Enumeration children() {
        this.expandNode();
        return super.children();
    }

    @Override
    @NotNull
    public ImmutableList<MemoryObjectTreeNode<T>> getChildren() {
        this.expandNode();
        ImmutableList immutableList = super.getChildren();
        if (immutableList == null) {
            LazyMemoryObjectTreeNode.$$$reportNull$$$0(1);
        }
        return immutableList;
    }

    @VisibleForTesting
    ImmutableList<MemoryObjectTreeNode<T>> getBuiltChildren() {
        this.ensureOrder();
        return ContainerUtil.immutableList(this.myChildrenView);
    }

    public void reset() {
        this.removeAll();
        this.myMemoizedChildrenCount = -1;
        this.myCurrentPageCount = 1;
        this.myChildrenView = this.myChildren.subList(0, 0);
    }

    @Override
    protected void ensureOrder() {
        this.getChildCount();
        super.ensureOrder();
        this.myChildrenView = this.myChildren.subList(0, Math.min(this.myChildren.size(), this.myPagingNode != null ? this.myCurrentPageCount * 100 : this.myMemoizedChildrenCount));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "adapter";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/memory/LazyMemoryObjectTreeNode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/memory/LazyMemoryObjectTreeNode";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class PagingNode
    extends MemoryObjectTreeNode<MemoryObject> {
        @NotNull
        private final LazyMemoryObjectTreeNode myOwnerNode;

        public PagingNode(@NotNull LazyMemoryObjectTreeNode ownerNode) {
            if (ownerNode == null) {
                PagingNode.$$$reportNull$$$0(0);
            }
            super(() -> String.format("Click to see next %d...", Math.min(100, ownerNode.myChildren.size() - ownerNode.myChildrenView.size())));
            this.myOwnerNode = ownerNode;
        }

        @Override
        public void select() {
            ++this.myOwnerNode.myCurrentPageCount;
            int[] newIndices = this.myOwnerNode.myCurrentPageCount * 100 >= this.myOwnerNode.myChildren.size() ? new int[this.myOwnerNode.myChildren.size() - this.myOwnerNode.myChildrenView.size()] : new int[101];
            for (int i2 = 0; i2 < newIndices.length; ++i2) {
                newIndices[i2] = this.myOwnerNode.myChildrenView.size() + i2;
            }
            assert (this.myOwnerNode.myTreeModel != null);
            int previousViewSize = this.myOwnerNode.myChildrenView.size();
            this.myOwnerNode.myChildrenView = this.myOwnerNode.myChildren.subList(0, Math.min(this.myOwnerNode.myChildren.size(), this.myOwnerNode.myCurrentPageCount * 100));
            this.myOwnerNode.myTreeModel.nodesWereRemoved(this.myOwnerNode, new int[]{previousViewSize}, new Object[]{this});
            this.myOwnerNode.myTreeModel.nodesWereInserted(this.myOwnerNode, newIndices);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ownerNode", "com/android/tools/profilers/memory/LazyMemoryObjectTreeNode$PagingNode", "<init>"));
        }
    }
}

