/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory;

import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.SeriesData;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.Memory;
import com.android.tools.profilers.ProfilerClient;
import com.android.tools.profilers.analytics.FeatureTracker;
import com.android.tools.profilers.memory.CaptureDataSeries;
import com.android.tools.profilers.memory.CaptureDurationData;
import com.android.tools.profilers.memory.CaptureEntry;
import com.android.tools.profilers.memory.MemoryProfiler;
import com.android.tools.profilers.memory.MemoryProfilerStage;
import com.android.tools.profilers.memory.adapters.CaptureObject;
import com.android.tools.profilers.memory.adapters.LegacyAllocationCaptureObject;
import com.android.tools.profilers.memory.adapters.LiveAllocationCaptureObject;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class AllocationInfosDataSeries
extends CaptureDataSeries<CaptureObject> {
    @NotNull
    private MemoryProfilerStage myStage;

    public AllocationInfosDataSeries(@NotNull ProfilerClient client, @NotNull Common.Session session, @NotNull FeatureTracker featureTracker, @NotNull MemoryProfilerStage stage) {
        if (client == null) {
            AllocationInfosDataSeries.$$$reportNull$$$0(0);
        }
        if (session == null) {
            AllocationInfosDataSeries.$$$reportNull$$$0(1);
        }
        if (featureTracker == null) {
            AllocationInfosDataSeries.$$$reportNull$$$0(2);
        }
        if (stage == null) {
            AllocationInfosDataSeries.$$$reportNull$$$0(3);
        }
        super(client, session, featureTracker);
        this.myStage = stage;
    }

    public List<SeriesData<CaptureDurationData<CaptureObject>>> getDataForRange(Range range) {
        List<Memory.AllocationsInfo> infos = MemoryProfiler.getAllocationInfosForSession(this.myClient, this.mySession, range, this.myStage.getStudioProfilers().getIdeServices());
        ArrayList<SeriesData<CaptureDurationData<CaptureObject>>> seriesData = new ArrayList<SeriesData<CaptureDurationData<CaptureObject>>>();
        for (Memory.AllocationsInfo info : infos) {
            long startTimeNs = info.getStartTime();
            long durationUs = AllocationInfosDataSeries.getDurationUs(startTimeNs, info.getEndTime());
            seriesData.add((SeriesData<CaptureDurationData<CaptureObject>>)new SeriesData(AllocationInfosDataSeries.getHostTime(startTimeNs), new CaptureDurationData<CaptureObject>(durationUs, !info.getLegacy(), !info.getLegacy(), new CaptureEntry<CaptureObject>(info, () -> {
                if (info.getLegacy()) {
                    return new LegacyAllocationCaptureObject(this.myClient, this.mySession, info, this.myFeatureTracker);
                }
                return new LiveAllocationCaptureObject(this.myClient, this.mySession, startTimeNs, null, this.myStage);
            }))));
        }
        return seriesData;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "client";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "session";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "featureTracker";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "stage";
                break;
            }
        }
        objectArray[1] = "com/android/tools/profilers/memory/AllocationInfosDataSeries";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

