/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory;

import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.DataSeries;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.SeriesData;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.Memory;
import com.android.tools.profiler.proto.MemoryProfiler;
import com.android.tools.profiler.proto.Transport;
import com.android.tools.profilers.ProfilerAspect;
import com.android.tools.profilers.ProfilerClient;
import com.android.tools.profilers.StudioProfilers;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public final class AllocStatsDataSeries
implements DataSeries<Long> {
    @NotNull
    private final StudioProfilers myProfilers;
    @NotNull
    private final ProfilerClient myClient;
    @NotNull
    private final Common.Session mySession;
    @NotNull
    private final AspectObserver myObserver;
    private boolean myIsAgentAttached;
    @NotNull
    private Function<Memory.MemoryAllocStatsData, Long> myFilter;

    public AllocStatsDataSeries(@NotNull StudioProfilers profilers, @NotNull Function<Memory.MemoryAllocStatsData, Long> filter) {
        if (profilers == null) {
            AllocStatsDataSeries.$$$reportNull$$$0(0);
        }
        if (filter == null) {
            AllocStatsDataSeries.$$$reportNull$$$0(1);
        }
        this.myIsAgentAttached = false;
        this.myProfilers = profilers;
        this.myClient = profilers.getClient();
        this.mySession = this.myProfilers.getSession();
        this.myFilter = filter;
        this.myObserver = new AspectObserver();
        this.myProfilers.addDependency(this.myObserver).onChange((Enum)ProfilerAspect.AGENT, this::agentStatusChanged);
        this.agentStatusChanged();
    }

    public List<SeriesData<Long>> getDataForRange(@NotNull Range rangeUs) {
        if (rangeUs == null) {
            AllocStatsDataSeries.$$$reportNull$$$0(2);
        }
        if (!this.myIsAgentAttached) {
            return Collections.emptyList();
        }
        if (!this.myProfilers.getIdeServices().getFeatureConfig().isUnifiedPipelineEnabled()) {
            return this.getLegacyAllocationStats(rangeUs);
        }
        Transport.GetEventGroupsRequest request = Transport.GetEventGroupsRequest.newBuilder().setStreamId(this.mySession.getStreamId()).setPid(this.mySession.getPid()).setKind(Common.Event.Kind.MEMORY_ALLOC_STATS).setFromTimestamp(TimeUnit.MICROSECONDS.toNanos((long)rangeUs.getMin())).setToTimestamp(TimeUnit.MICROSECONDS.toNanos((long)rangeUs.getMax())).build();
        Transport.GetEventGroupsResponse response = this.myClient.getTransportClient().getEventGroups(request);
        assert (response.getGroupsCount() <= 1);
        ArrayList<SeriesData<Long>> seriesData = new ArrayList<SeriesData<Long>>();
        if (response.getGroupsCount() > 0) {
            response.getGroups(0).getEventsList().forEach(event -> {
                long dataTimestamp = TimeUnit.NANOSECONDS.toMicros(event.getTimestamp());
                seriesData.add(new SeriesData(dataTimestamp, (Object)this.myFilter.apply(event.getMemoryAllocStats())));
            });
        }
        return seriesData;
    }

    private List<SeriesData<Long>> getLegacyAllocationStats(@NotNull Range rangeUs) {
        if (rangeUs == null) {
            AllocStatsDataSeries.$$$reportNull$$$0(3);
        }
        long bufferNs = TimeUnit.SECONDS.toNanos(1L);
        MemoryProfiler.MemoryRequest.Builder dataRequestBuilder = MemoryProfiler.MemoryRequest.newBuilder().setSession(this.mySession).setStartTime(TimeUnit.MICROSECONDS.toNanos((long)rangeUs.getMin()) - bufferNs).setEndTime(TimeUnit.MICROSECONDS.toNanos((long)rangeUs.getMax()) + bufferNs);
        MemoryProfiler.MemoryData response = this.myClient.getMemoryClient().getData(dataRequestBuilder.build());
        ArrayList<SeriesData<Long>> seriesData = new ArrayList<SeriesData<Long>>();
        for (MemoryProfiler.MemoryData.AllocStatsSample sample : response.getAllocStatsSamplesList()) {
            long dataTimestamp = TimeUnit.NANOSECONDS.toMicros(sample.getTimestamp());
            seriesData.add((SeriesData<Long>)new SeriesData(dataTimestamp, (Object)this.myFilter.apply(sample.getAllocStats())));
        }
        return seriesData;
    }

    private void agentStatusChanged() {
        this.myIsAgentAttached = this.myProfilers.isAgentAttached();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profilers";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rangeUs";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/profilers/memory/AllocStatsDataSeries";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getDataForRange";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getLegacyAllocationStats";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

