/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.event;

import com.android.tools.adtui.model.DataSeries;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.SeriesData;
import com.android.tools.adtui.model.event.EventAction;
import com.android.tools.adtui.model.event.LifecycleAction;
import com.android.tools.adtui.model.event.LifecycleEvent;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.EventProfiler;
import com.android.tools.profiler.proto.EventServiceGrpc;
import com.android.tools.profiler.proto.Interaction;
import com.android.tools.profiler.proto.Transport;
import com.android.tools.profilers.StudioProfilers;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class LifecycleEventDataSeries
implements DataSeries<EventAction<LifecycleEvent>> {
    @NotNull
    private StudioProfilers myProfilers;
    @NotNull
    private final Common.Session mySession;
    private final boolean myFragmentsOnly;

    public LifecycleEventDataSeries(@NotNull StudioProfilers profilers, boolean fragmentOnly) {
        if (profilers == null) {
            LifecycleEventDataSeries.$$$reportNull$$$0(0);
        }
        this.myProfilers = profilers;
        this.mySession = profilers.getSession();
        this.myFragmentsOnly = fragmentOnly;
    }

    public List<SeriesData<EventAction<LifecycleEvent>>> getDataForRange(@NotNull Range timeCurrentRangeUs) {
        if (timeCurrentRangeUs == null) {
            LifecycleEventDataSeries.$$$reportNull$$$0(1);
        }
        if (this.myProfilers.getIdeServices().getFeatureConfig().isUnifiedPipelineEnabled()) {
            return this.getTransportData(timeCurrentRangeUs);
        }
        return this.getLegacyData(timeCurrentRangeUs);
    }

    @NotNull
    private List<SeriesData<EventAction<LifecycleEvent>>> getTransportData(@NotNull Range rangeUs) {
        if (rangeUs == null) {
            LifecycleEventDataSeries.$$$reportNull$$$0(2);
        }
        ArrayList<SeriesData<EventAction<LifecycleEvent>>> series = new ArrayList<SeriesData<EventAction<LifecycleEvent>>>();
        Transport.GetEventGroupsRequest request = Transport.GetEventGroupsRequest.newBuilder().setKind(Common.Event.Kind.VIEW).setStreamId(this.mySession.getStreamId()).setPid(this.mySession.getPid()).setFromTimestamp(TimeUnit.MICROSECONDS.toNanos((long)rangeUs.getMin())).setToTimestamp(TimeUnit.MICROSECONDS.toNanos((long)rangeUs.getMax())).build();
        Transport.GetEventGroupsResponse response = this.myProfilers.getClient().getTransportClient().getEventGroups(request);
        for (Transport.EventGroup group : response.getGroupsList()) {
            boolean isFragment;
            boolean bl = isFragment = group.getEvents(0).getView().getParentActivityId() != 0L;
            if (this.myFragmentsOnly != isFragment) continue;
            long actionStart = 0L;
            long actionEnd = 0L;
            boolean hasEndEvent = false;
            LifecycleEvent lifecycleEvent = LifecycleEvent.NONE;
            for (int i2 = 0; i2 < group.getEventsCount(); ++i2) {
                Common.Event event = group.getEvents(i2);
                Interaction.ViewData data2 = event.getView();
                Object displayString = data2.getName();
                switch (data2.getState()) {
                    case ADDED: 
                    case RESUMED: {
                        lifecycleEvent = LifecycleEvent.STARTED;
                        actionStart = TimeUnit.NANOSECONDS.toMicros(event.getTimestamp());
                        break;
                    }
                    case DESTROYED: {
                        if (i2 != group.getEventsCount() - 1) break;
                        displayString = (String)displayString + String.format(" - %s", data2.getState().toString().toLowerCase());
                    }
                    case REMOVED: 
                    case PAUSED: {
                        lifecycleEvent = LifecycleEvent.COMPLETED;
                        actionEnd = TimeUnit.NANOSECONDS.toMicros(event.getTimestamp());
                        hasEndEvent = true;
                        break;
                    }
                }
                if (hasEndEvent) {
                    while (++i2 < group.getEventsCount()) {
                        Common.Event nextEvent = group.getEvents(i2);
                        if (nextEvent.getIsEnded()) {
                            displayString = (String)displayString + String.format(" - %s", nextEvent.getView().getState().toString().toLowerCase());
                            continue;
                        }
                        --i2;
                        break;
                    }
                }
                if (!hasEndEvent && (i2 != group.getEventsCount() - 1 || actionStart == 0L)) continue;
                series.add((SeriesData<EventAction<LifecycleEvent>>)new SeriesData(actionStart, (Object)new LifecycleAction(actionStart, actionEnd, lifecycleEvent, (String)displayString, event.getGroupId())));
                actionStart = 0L;
                actionEnd = 0L;
                hasEndEvent = false;
                lifecycleEvent = LifecycleEvent.NONE;
            }
        }
        series.sort(Comparator.comparingLong(data -> data.x));
        ArrayList<SeriesData<EventAction<LifecycleEvent>>> arrayList = series;
        if (arrayList == null) {
            LifecycleEventDataSeries.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    @NotNull
    private List<SeriesData<EventAction<LifecycleEvent>>> getLegacyData(@NotNull Range rangeUs) {
        if (rangeUs == null) {
            LifecycleEventDataSeries.$$$reportNull$$$0(4);
        }
        ArrayList<SeriesData<EventAction<LifecycleEvent>>> seriesData = new ArrayList<SeriesData<EventAction<LifecycleEvent>>>();
        EventServiceGrpc.EventServiceBlockingStub eventService = this.myProfilers.getClient().getEventClient();
        EventProfiler.EventDataRequest.Builder dataRequestBuilder = EventProfiler.EventDataRequest.newBuilder().setSession(this.mySession).setStartTimestamp(TimeUnit.MICROSECONDS.toNanos((long)rangeUs.getMin())).setEndTimestamp(TimeUnit.MICROSECONDS.toNanos((long)rangeUs.getMax()));
        EventProfiler.ActivityDataResponse response = eventService.getActivityData(dataRequestBuilder.build());
        for (EventProfiler.ActivityData data : response.getDataList()) {
            boolean isFragment;
            long actionStart = 0L;
            long actionEnd = 0L;
            boolean bl = isFragment = data.getActivityContextHash() != 0L;
            if (this.myFragmentsOnly != isFragment) continue;
            boolean haveEvent = false;
            for (int i2 = 0; i2 < data.getStateChangesCount(); ++i2) {
                EventProfiler.ActivityStateData state = data.getStateChanges(i2);
                LifecycleEvent lifecycleEvent = LifecycleEvent.NONE;
                String displayString = data.getName();
                switch (state.getState()) {
                    case ADDED: 
                    case RESUMED: {
                        lifecycleEvent = LifecycleEvent.STARTED;
                        actionStart = TimeUnit.NANOSECONDS.toMicros(state.getTimestamp());
                        break;
                    }
                    case DESTROYED: {
                        if (i2 != data.getStateChangesCount() - 1) break;
                        displayString = String.format("%s - %s", displayString, StringUtil.toLowerCase((String)state.getState().toString()));
                    }
                    case REMOVED: 
                    case PAUSED: {
                        lifecycleEvent = LifecycleEvent.COMPLETED;
                        actionEnd = TimeUnit.NANOSECONDS.toMicros(state.getTimestamp());
                        haveEvent = true;
                        break;
                    }
                }
                while (haveEvent && ++i2 < data.getStateChangesCount()) {
                    state = data.getStateChanges(i2);
                    Interaction.ViewData.State activityState = state.getState();
                    if (this.getComponentInStartingOrRunningState(activityState)) {
                        --i2;
                        break;
                    }
                    displayString = String.format("%s - %s", displayString, StringUtil.toLowerCase((String)state.getState().toString()));
                }
                if (!haveEvent && (i2 != data.getStateChangesCount() - 1 || lifecycleEvent == LifecycleEvent.NONE)) continue;
                seriesData.add((SeriesData<EventAction<LifecycleEvent>>)new SeriesData(actionStart, (Object)new LifecycleAction(actionStart, actionEnd, lifecycleEvent, displayString, data.getHash())));
                actionEnd = 0L;
                actionStart = 0L;
                haveEvent = false;
            }
        }
        ArrayList<SeriesData<EventAction<LifecycleEvent>>> arrayList = seriesData;
        if (arrayList == null) {
            LifecycleEventDataSeries.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    private boolean getComponentInStartingOrRunningState(Interaction.ViewData.State state) {
        switch (state) {
            case ADDED: 
            case RESUMED: 
            case ATTACHED: 
            case CREATED: 
            case CREATEDVIEW: 
            case ACTIVITYCREATED: 
            case STARTED: {
                return true;
            }
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profilers";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "timeCurrentRangeUs";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rangeUs";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/event/LifecycleEventDataSeries";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/event/LifecycleEventDataSeries";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTransportData";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getLegacyData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getDataForRange";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getTransportData";
                break;
            }
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getLegacyData";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

