/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.energy;

import com.android.tools.adtui.TooltipComponent;
import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.DataSeries;
import com.android.tools.adtui.model.DefaultDataSeries;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.RangedSeries;
import com.android.tools.adtui.model.StreamingTimeline;
import com.android.tools.adtui.model.Timeline;
import com.android.tools.adtui.model.event.EventAction;
import com.android.tools.adtui.model.event.EventModel;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profilers.BorderlessTableCellRenderer;
import com.android.tools.profilers.ProfilerColors;
import com.android.tools.profilers.ProfilerFonts;
import com.android.tools.profilers.ProfilerLayout;
import com.android.tools.profilers.StageView;
import com.android.tools.profilers.TimelineTable;
import com.android.tools.profilers.energy.EnergyDuration;
import com.android.tools.profilers.energy.EnergyEventComponent;
import com.android.tools.profilers.energy.EnergyEventStateChart;
import com.android.tools.profilers.energy.EnergyEventsTableTooltipInfoComponent;
import com.android.tools.profilers.energy.EnergyEventsTableTooltipInfoModel;
import com.android.tools.profilers.energy.EnergyProfilerAspect;
import com.android.tools.profilers.energy.EnergyProfilerStage;
import com.android.tools.profilers.energy.EnergyProfilerStageView;
import com.google.common.collect.UnmodifiableIterator;
import com.intellij.ui.table.JBTable;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumnModel;
import org.jetbrains.annotations.NotNull;

public final class EnergyEventsView {
    @NotNull
    private final EnergyProfilerStage myStage;
    @NotNull
    private final EventsTableModel myTableModel;
    @NotNull
    private final JBTable myEventsTable;
    private AspectObserver myAspectObserver;

    public EnergyEventsView(@NotNull EnergyProfilerStageView stageView) {
        if (stageView == null) {
            EnergyEventsView.$$$reportNull$$$0(0);
        }
        this.myAspectObserver = new AspectObserver();
        this.myStage = (EnergyProfilerStage)stageView.getStage();
        this.myTableModel = new EventsTableModel(this.myStage);
        this.myTableModel.addTableModelListener(e -> this.updateTableSelection());
        this.myEventsTable = TimelineTable.create(this.myTableModel, (Timeline)this.myStage.getTimeline(), Column.TIMELINE.ordinal());
        this.buildEventsTable(stageView);
        this.myStage.getAspect().addDependency(this.myAspectObserver).onChange((Enum)EnergyProfilerAspect.SELECTED_EVENT_DURATION, this::updateTableSelection).onChange((Enum)EnergyProfilerAspect.SELECTED_ORIGIN_FILTER, this.myTableModel::updateTableByOrigin);
    }

    private void buildEventsTable(@NotNull StageView stageView) {
        if (stageView == null) {
            EnergyEventsView.$$$reportNull$$$0(1);
        }
        this.myEventsTable.setAutoCreateRowSorter(true);
        this.myEventsTable.getColumnModel().getColumn(Column.EVENT.ordinal()).setCellRenderer(new BorderlessTableCellRenderer());
        this.myEventsTable.getColumnModel().getColumn(Column.DESCRIPTION.ordinal()).setCellRenderer(new BorderlessTableCellRenderer());
        this.myEventsTable.getColumnModel().getColumn(Column.CALLED_BY.ordinal()).setCellRenderer(new CalledByRenderer());
        this.myEventsTable.getColumnModel().getColumn(Column.TIMELINE.ordinal()).setCellRenderer(new TimelineRenderer((JTable)this.myEventsTable, this.myStage.getTimeline()));
        this.myEventsTable.getEmptyText().setText("No system events for the selected range or filter.");
        this.myEventsTable.getEmptyText().setShowAboveCenter(false).setFont(ProfilerFonts.H2_FONT);
        this.myEventsTable.setSelectionMode(0);
        this.myEventsTable.setBackground(ProfilerColors.DEFAULT_BACKGROUND);
        this.myEventsTable.setShowVerticalLines(true);
        this.myEventsTable.setShowHorizontalLines(false);
        int defaultFontHeight = this.myEventsTable.getFontMetrics(this.myEventsTable.getFont()).getHeight();
        this.myEventsTable.setRowMargin(0);
        this.myEventsTable.setRowHeight(defaultFontHeight + ProfilerLayout.ROW_HEIGHT_PADDING);
        this.myEventsTable.setFocusTraversalKeys(0, null);
        this.myEventsTable.setFocusTraversalKeys(1, null);
        this.myEventsTable.addComponentListener((ComponentListener)new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                for (int i2 = 0; i2 < Column.values().length; ++i2) {
                    Column column = Column.values()[i2];
                    EnergyEventsView.this.myEventsTable.getColumnModel().getColumn(i2).setPreferredWidth((int)((double)EnergyEventsView.this.myEventsTable.getWidth() * column.getWidthPercentage()));
                }
            }
        });
        this.myEventsTable.getSelectionModel().addListSelectionListener(e -> {
            if (e.getValueIsAdjusting()) {
                return;
            }
            int row = this.myEventsTable.getSelectedRow();
            if (row >= 0 && row < this.myEventsTable.getRowCount()) {
                EnergyDuration duration = this.myTableModel.getValue(this.myEventsTable.convertRowIndexToModel(row));
                duration = this.myStage.updateDuration(duration);
                this.myStage.setSelectedDuration(duration);
            }
        });
        this.createTooltip(stageView);
    }

    private void updateTableSelection() {
        EnergyDuration duration = this.myStage.getSelectedDuration();
        if (duration != null) {
            long id = ((Common.Event)duration.getEventList().get(0)).getGroupId();
            for (int i2 = 0; i2 < this.myTableModel.getRowCount(); ++i2) {
                if (id != ((Common.Event)this.myTableModel.getValue(i2).getEventList().get(0)).getGroupId()) continue;
                int row = this.myEventsTable.convertRowIndexToView(i2);
                this.myEventsTable.setRowSelectionInterval(row, row);
                return;
            }
        } else {
            this.myEventsTable.clearSelection();
        }
    }

    public JComponent getComponent() {
        return this.myEventsTable;
    }

    private void createTooltip(@NotNull StageView stageView) {
        if (stageView == null) {
            EnergyEventsView.$$$reportNull$$$0(2);
        }
        final EnergyEventsTableTooltipInfoModel tooltipModel = new EnergyEventsTableTooltipInfoModel(this.myStage.getTimeline().getDataRange());
        EnergyEventsTableTooltipInfoComponent tooltipInfoComponent = new EnergyEventsTableTooltipInfoComponent(tooltipModel);
        tooltipInfoComponent.setForeground(ProfilerColors.TOOLTIP_TEXT);
        tooltipInfoComponent.setBackground(ProfilerColors.TOOLTIP_BACKGROUND);
        final TooltipComponent tooltip2 = new TooltipComponent.Builder((JComponent)((Object)tooltipInfoComponent), (JComponent)this.myEventsTable, stageView.getProfilersView().getComponent()).build();
        tooltip2.registerListenersOn((Component)this.myEventsTable);
        this.myEventsTable.addMouseMotionListener((MouseMotionListener)new MouseAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                int row = EnergyEventsView.this.myEventsTable.rowAtPoint(e.getPoint());
                int col = EnergyEventsView.this.myEventsTable.columnAtPoint(e.getPoint());
                boolean isTooltipVisible = false;
                if (row >= 0 && col == Column.TIMELINE.ordinal()) {
                    TableColumnModel columnModel = EnergyEventsView.this.myEventsTable.getColumnModel();
                    int position = e.getX();
                    for (int c = 0; c < Column.TIMELINE.ordinal(); ++c) {
                        position -= columnModel.getColumn(c).getWidth();
                    }
                    int width = columnModel.getColumn(Column.TIMELINE.ordinal()).getWidth();
                    Range range = EnergyEventsView.this.myStage.getTimeline().getSelectionRange();
                    long timestampUs = (long)(range.getMin() + range.getLength() * (double)position / (double)width);
                    double highlightWidth = 2.0 * range.getLength() / (double)Math.max(1, width);
                    Range tooltipRange = new Range((double)timestampUs - highlightWidth, (double)timestampUs);
                    tooltipModel.update(((EventsTableModel)EnergyEventsView.this.myEventsTable.getModel()).getValue(row), tooltipRange);
                    if (tooltipModel.getDuration() != null) {
                        isTooltipVisible = true;
                    }
                }
                tooltip2.setVisible(isTooltipVisible);
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "stageView";
        objectArray2[1] = "com/android/tools/profilers/energy/EnergyEventsView";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "buildEventsTable";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "createTooltip";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class TimelineRenderer
    extends TimelineTable.CellRenderer
    implements TableModelListener {
        @NotNull
        private final List<EnergyEventComponent> myEventComponents;
        @NotNull
        private final JTable myTable;

        TimelineRenderer(@NotNull JTable table, @NotNull StreamingTimeline timeline) {
            if (table == null) {
                TimelineRenderer.$$$reportNull$$$0(0);
            }
            if (timeline == null) {
                TimelineRenderer.$$$reportNull$$$0(1);
            }
            super((Timeline)timeline);
            this.myEventComponents = new ArrayList<EnergyEventComponent>();
            this.myTable = table;
            this.myTable.getModel().addTableModelListener(this);
            this.tableChanged(new TableModelEvent(this.myTable.getModel()));
        }

        @Override
        @NotNull
        protected Component getTableCellRendererComponent(boolean isSelected, int row) {
            Component component = (Component)((Object)this.myEventComponents.get(this.myTable.convertRowIndexToModel(row)));
            if (component == null) {
                TimelineRenderer.$$$reportNull$$$0(2);
            }
            return component;
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            this.myEventComponents.clear();
            EventsTableModel model = (EventsTableModel)this.myTable.getModel();
            for (int i2 = 0; i2 < model.getRowCount(); ++i2) {
                long startTimeUs;
                EnergyDuration duration = model.getValue(i2);
                DefaultDataSeries series = new DefaultDataSeries();
                UnmodifiableIterator iterator = duration.getEventList().iterator();
                Common.Event event = iterator.hasNext() ? (Common.Event)iterator.next() : null;
                long l = startTimeUs = event != null ? TimeUnit.NANOSECONDS.toMicros(event.getTimestamp()) : -1L;
                while (event != null) {
                    Common.Event nextEvent = iterator.hasNext() ? (Common.Event)iterator.next() : null;
                    long endTimeUs = nextEvent != null ? TimeUnit.NANOSECONDS.toMicros(nextEvent.getTimestamp()) : Long.MAX_VALUE;
                    series.add(startTimeUs, (Object)new EventAction(startTimeUs, endTimeUs, (Object)event));
                    startTimeUs = endTimeUs;
                    event = nextEvent;
                }
                EventModel eventModel = new EventModel(new RangedSeries(this.getTimeline().getSelectionRange(), (DataSeries)series));
                Color highlightColor = EnergyEventStateChart.DURATION_STATE_ENUM_COLORS.getColor((Enum)duration.getKind());
                EnergyEventComponent component = new EnergyEventComponent((EventModel<Common.Event>)eventModel, highlightColor);
                this.myEventComponents.add(component);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "table";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "timeline";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/profilers/energy/EnergyEventsView$TimelineRenderer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/profilers/energy/EnergyEventsView$TimelineRenderer";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTableCellRendererComponent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static final class CalledByRenderer
    extends BorderlessTableCellRenderer {
        private CalledByRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            int secondLastDotIndex;
            int lastDotIndex;
            String calledByValue = "";
            if (value instanceof String && (lastDotIndex = (calledByValue = (String)value).lastIndexOf(46)) > 0 && (secondLastDotIndex = calledByValue.substring(0, lastDotIndex).lastIndexOf(46)) != -1) {
                calledByValue = calledByValue.substring(secondLastDotIndex + 1);
            }
            return super.getTableCellRendererComponent(table, calledByValue, isSelected, hasFocus, row, column);
        }
    }

    private static final class EventsTableModel
    extends AbstractTableModel {
        @NotNull
        private final EnergyProfilerStage myStage;
        @NotNull
        private List<EnergyDuration> myDataList;
        @NotNull
        private List<EnergyDuration> myList;

        private EventsTableModel(@NotNull EnergyProfilerStage stage) {
            if (stage == null) {
                EventsTableModel.$$$reportNull$$$0(0);
            }
            this.myDataList = new ArrayList<EnergyDuration>();
            this.myList = new ArrayList<EnergyDuration>();
            this.myStage = stage;
            stage.getEnergyEventsFetcher().addListener(list -> {
                this.myDataList = list;
                this.updateTableByOrigin();
            });
        }

        @Override
        public int getRowCount() {
            return this.myList.size();
        }

        @Override
        public int getColumnCount() {
            return Column.values().length;
        }

        @Override
        public String getColumnName(int column) {
            return Column.values()[column].toDisplayString();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            EnergyDuration duration = this.myList.get(rowIndex);
            return Column.values()[columnIndex].getValueFrom(duration);
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return Column.values()[columnIndex].getType();
        }

        @NotNull
        public EnergyDuration getValue(int rowIndex) {
            EnergyDuration energyDuration = this.myList.get(rowIndex);
            if (energyDuration == null) {
                EventsTableModel.$$$reportNull$$$0(1);
            }
            return energyDuration;
        }

        public void updateTableByOrigin() {
            this.myList = this.myStage.filterByOrigin(this.myDataList);
            this.fireTableDataChanged();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "stage";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/profilers/energy/EnergyEventsView$EventsTableModel";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/profilers/energy/EnergyEventsView$EventsTableModel";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getValue";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static enum Column {
        EVENT(0.18, (Class)String.class, "System Event"){

            @Override
            Object getValueFrom(@NotNull EnergyDuration data) {
                if (data == null) {
                    1.$$$reportNull$$$0(0);
                }
                return data.getName();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/android/tools/profilers/energy/EnergyEventsView$Column$1", "getValueFrom"));
            }
        }
        ,
        DESCRIPTION(0.16, (Class)String.class, "Description"){

            @Override
            Object getValueFrom(@NotNull EnergyDuration data) {
                if (data == null) {
                    2.$$$reportNull$$$0(0);
                }
                return data.getDescription();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/android/tools/profilers/energy/EnergyEventsView$Column$2", "getValueFrom"));
            }
        }
        ,
        CALLED_BY(0.16, (Class)String.class, "Called By"){

            @Override
            Object getValueFrom(@NotNull EnergyDuration data) {
                if (data == null) {
                    3.$$$reportNull$$$0(0);
                }
                return data.getCalledBy();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/android/tools/profilers/energy/EnergyEventsView$Column$3", "getValueFrom"));
            }
        }
        ,
        TIMELINE(0.5, (Class)Long.class, "Timeline"){

            @Override
            Object getValueFrom(@NotNull EnergyDuration data) {
                if (data == null) {
                    4.$$$reportNull$$$0(0);
                }
                return data.getInitialTimestamp();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/android/tools/profilers/energy/EnergyEventsView$Column$4", "getValueFrom"));
            }
        };

        private final double myWidthPercentage;
        private final Class<?> myType;
        private final String myDisplayName;

        private Column(double widthPercentage, Class<?> type, String name) {
            this.myWidthPercentage = widthPercentage;
            this.myType = type;
            this.myDisplayName = name;
        }

        public double getWidthPercentage() {
            return this.myWidthPercentage;
        }

        public Class<?> getType() {
            return this.myType;
        }

        public String toDisplayString() {
            return this.myDisplayName;
        }

        abstract Object getValueFrom(@NotNull EnergyDuration var1);
    }
}

