/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.energy;

import com.android.tools.adtui.AnimatedComponent;
import com.android.tools.adtui.common.AdtUiUtils;
import com.android.tools.adtui.model.SeriesData;
import com.android.tools.adtui.model.event.EventAction;
import com.android.tools.adtui.model.event.EventModel;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profilers.ProfilerColors;
import com.google.common.annotations.VisibleForTesting;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class EnergyEventComponent
extends AnimatedComponent {
    protected static final int HIGHLIGHT_WIDTH = 2;
    @NotNull
    private final List<EventAction<Common.Event>> myActionToDrawList;
    @NotNull
    private final EventModel<Common.Event> myModel;
    @NotNull
    private final Color myHighlightColor;
    @NotNull
    private final Color myDurationColor;
    private boolean myRender;

    EnergyEventComponent(@NotNull EventModel<Common.Event> model, @NotNull Color highlightColor) {
        if (model == null) {
            EnergyEventComponent.$$$reportNull$$$0(0);
        }
        if (highlightColor == null) {
            EnergyEventComponent.$$$reportNull$$$0(1);
        }
        this.myModel = model;
        this.myHighlightColor = highlightColor;
        this.myDurationColor = AdtUiUtils.overlayColor((int)ProfilerColors.DEFAULT_BACKGROUND.getRGB(), (int)this.myHighlightColor.getRGB(), (float)0.25f);
        this.myActionToDrawList = new ArrayList<EventAction<Common.Event>>();
        this.myRender = true;
        this.myModel.addDependency(this.myAspectObserver).onChange((Enum)EventModel.Aspect.EVENT, this::modelChanged);
    }

    private void modelChanged() {
        this.myRender = true;
        this.opaqueRepaint();
    }

    private void renderToAction() {
        this.myActionToDrawList.clear();
        double minUs = this.myModel.getRangedSeries().getXRange().getMin();
        double maxUs = this.myModel.getRangedSeries().getXRange().getMax();
        for (SeriesData data : this.myModel.getRangedSeries().getSeries()) {
            if (!((double)((EventAction)data.value).getStartUs() <= maxUs) || !((double)((EventAction)data.value).getEndUs() >= minUs)) continue;
            this.myActionToDrawList.add((EventAction<Common.Event>)((EventAction)data.value));
        }
    }

    protected void draw(Graphics2D g, Dimension dim) {
        if (this.myRender) {
            this.renderToAction();
            this.myRender = false;
        }
        Color currentColor = g.getColor();
        Stroke currentStroke = g.getStroke();
        double minUs = this.myModel.getRangedSeries().getXRange().getMin();
        double maxUs = this.myModel.getRangedSeries().getXRange().getMax();
        double scaleFactor = dim.getWidth();
        double height = dim.getHeight() - 2.0;
        for (EventAction<Common.Event> action : this.myActionToDrawList) {
            double normalizedPositionStart = (Math.max(minUs, (double)action.getStartUs()) - minUs) / (maxUs - minUs);
            AffineTransform transform = AffineTransform.getTranslateInstance(normalizedPositionStart * scaleFactor, 0.0);
            double xPosition = transform.getTranslateX() - 1.0;
            double yPosition = transform.getTranslateY() + 1.0;
            if ((double)action.getStartUs() >= minUs) {
                g.setColor(this.myHighlightColor);
                g.fill(new Rectangle2D.Double(xPosition, yPosition, 2.0, height));
                xPosition += 2.0;
            }
            if (((Common.Event)action.getType()).getIsEnded()) continue;
            double normalizedPositionEnd = (Math.min(maxUs, (double)action.getEndUs()) - minUs) / (maxUs - minUs);
            double length = (normalizedPositionEnd - normalizedPositionStart) * scaleFactor;
            g.setColor(this.myDurationColor);
            g.fill(new Rectangle2D.Double(xPosition, yPosition, length, height));
        }
        g.setColor(currentColor);
        g.setStroke(currentStroke);
    }

    @VisibleForTesting
    @NotNull
    List<EventAction<Common.Event>> getActionToDrawList() {
        List<EventAction<Common.Event>> list = this.myActionToDrawList;
        if (list == null) {
            EnergyEventComponent.$$$reportNull$$$0(2);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlightColor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/energy/EnergyEventComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/energy/EnergyEventComponent";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionToDrawList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

