/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu.systemtrace;

import com.android.tools.profiler.proto.Cpu;
import com.android.tools.profilers.cpu.ThreadState;
import com.android.tools.profilers.cpu.systemtrace.CounterModel;
import com.android.tools.profilers.cpu.systemtrace.CpuCoreModel;
import com.android.tools.profilers.cpu.systemtrace.ProcessModel;
import com.android.tools.profilers.cpu.systemtrace.SchedulingEventModel;
import com.android.tools.profilers.cpu.systemtrace.SystemTraceModelAdapter;
import com.android.tools.profilers.cpu.systemtrace.ThreadModel;
import com.android.tools.profilers.cpu.systemtrace.TraceEventModel;
import com.android.tools.profilers.cpu.systemtrace.TrebuchetModelAdapter$WhenMappings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import trebuchet.model.Counter;
import trebuchet.model.CounterValue;
import trebuchet.model.CpuModel;
import trebuchet.model.CpuProcessSlice;
import trebuchet.model.Model;
import trebuchet.model.SchedSlice;
import trebuchet.model.base.SliceGroup;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 02\u00020\u0001:\u00010B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\bH\u0002J\b\u0010\u001b\u001a\u00020\u0019H\u0016J\b\u0010\u001c\u001a\u00020\u0019H\u0016J\u000e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010 \u001a\u00020\u0011H\u0016J\u0012\u0010!\u001a\u0004\u0018\u00010\u00122\u0006\u0010\"\u001a\u00020\u0011H\u0016J\u000e\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00120\nH\u0016J\b\u0010$\u001a\u00020\u0005H\u0016J\b\u0010%\u001a\u00020\u000eH\u0016J$\u0010&\u001a\b\u0012\u0004\u0012\u00020'0\n2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020)0\n2\u0006\u0010*\u001a\u00020\u0011H\u0002J,\u0010+\u001a\b\u0012\u0004\u0012\u00020'0\n2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00170\n2\u0006\u0010,\u001a\u00020\u00112\u0006\u0010 \u001a\u00020\u0011H\u0002J\u001c\u0010-\u001a\b\u0012\u0004\u0012\u00020.0\n2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020/0\nH\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lcom/android/tools/profilers/cpu/systemtrace/TrebuchetModelAdapter;", "Lcom/android/tools/profilers/cpu/systemtrace/SystemTraceModelAdapter;", "trebuchetModel", "Ltrebuchet/model/Model;", "technology", "Lcom/android/tools/profiler/proto/Cpu$CpuTraceType;", "(Ltrebuchet/model/Model;Lcom/android/tools/profiler/proto/Cpu$CpuTraceType;)V", "beginTimestampSeconds", "", "cores", "", "Lcom/android/tools/profilers/cpu/systemtrace/CpuCoreModel;", "endTimestampSeconds", "possibleCorruption", "", "processById", "Ljava/util/SortedMap;", "", "Lcom/android/tools/profilers/cpu/systemtrace/ProcessModel;", "timeShiftFromBeginningSeconds", "convertSchedulingState", "Lcom/android/tools/profilers/cpu/ThreadState;", "slice", "Ltrebuchet/model/SchedSlice;", "convertToUserTimeUs", "", "timestampInSeconds", "getCaptureEndTimestampUs", "getCaptureStartTimestampUs", "getCpuCores", "getDanglingThread", "Lcom/android/tools/profilers/cpu/systemtrace/ThreadModel;", "tid", "getProcessById", "id", "getProcesses", "getSystemTraceTechnology", "isCapturePossibleCorrupted", "mapCpuProcessSliceToSchedEvent", "Lcom/android/tools/profilers/cpu/systemtrace/SchedulingEventModel;", "slices", "Ltrebuchet/model/CpuProcessSlice;", "core", "mapSchedSliceToSchedEvent", "pid", "mapSlicesToTraceEvents", "Lcom/android/tools/profilers/cpu/systemtrace/TraceEventModel;", "Ltrebuchet/model/base/SliceGroup;", "Companion", "intellij.android.profilers"})
public final class TrebuchetModelAdapter
implements SystemTraceModelAdapter {
    private final double beginTimestampSeconds;
    private final double endTimestampSeconds;
    private final double timeShiftFromBeginningSeconds;
    private final boolean possibleCorruption;
    private final SortedMap<Integer, ProcessModel> processById;
    private final List<CpuCoreModel> cores;
    private final Cpu.CpuTraceType technology;
    private static final long SECONDS_TO_US;
    @NotNull
    public static final Companion Companion;

    @Override
    public long getCaptureStartTimestampUs() {
        return this.convertToUserTimeUs(this.beginTimestampSeconds);
    }

    @Override
    public long getCaptureEndTimestampUs() {
        return this.convertToUserTimeUs(this.endTimestampSeconds);
    }

    @Override
    @Nullable
    public ProcessModel getProcessById(int id) {
        return (ProcessModel)this.processById.get(id);
    }

    @Override
    @NotNull
    public List<ProcessModel> getProcesses() {
        Collection<ProcessModel> collection = this.processById.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"processById.values");
        return CollectionsKt.toList((Iterable)collection);
    }

    @Override
    @Nullable
    public ThreadModel getDanglingThread(int tid) {
        return null;
    }

    @Override
    @NotNull
    public List<CpuCoreModel> getCpuCores() {
        return this.cores;
    }

    @Override
    @NotNull
    public Cpu.CpuTraceType getSystemTraceTechnology() {
        return this.technology;
    }

    @Override
    public boolean isCapturePossibleCorrupted() {
        return this.possibleCorruption;
    }

    /*
     * WARNING - void declaration
     */
    private final List<TraceEventModel> mapSlicesToTraceEvents(List<? extends SliceGroup> slices) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = slices;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            SliceGroup sliceGroup = (SliceGroup)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            TraceEventModel traceEventModel = new TraceEventModel(it.getName(), this.convertToUserTimeUs(it.getStartTime()), this.convertToUserTimeUs(it.getEndTime()), TrebuchetModelAdapter.Companion.convertSecondsToUs(it.getCpuTime()), this.mapSlicesToTraceEvents(it.getChildren()));
            collection.add(traceEventModel);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<SchedulingEventModel> mapSchedSliceToSchedEvent(List<? extends SchedSlice> slices, int pid, int tid) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = slices;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            SchedSlice schedSlice = (SchedSlice)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            SchedulingEventModel schedulingEventModel = new SchedulingEventModel(this.convertSchedulingState((SchedSlice)it), this.convertToUserTimeUs(it.getStartTime()), this.convertToUserTimeUs(it.getEndTime()), TrebuchetModelAdapter.Companion.convertSecondsToUs(it.getDuration()), TrebuchetModelAdapter.Companion.convertSecondsToUs(it.getCpuTime()), pid, tid, 0);
            collection.add(schedulingEventModel);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<SchedulingEventModel> mapCpuProcessSliceToSchedEvent(List<? extends CpuProcessSlice> slices, int core) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = slices;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            CpuProcessSlice cpuProcessSlice = (CpuProcessSlice)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            SchedulingEventModel schedulingEventModel = new SchedulingEventModel(ThreadState.RUNNING_CAPTURED, this.convertToUserTimeUs(it.getStartTime()), this.convertToUserTimeUs(it.getEndTime()), TrebuchetModelAdapter.Companion.convertSecondsToUs(it.getDuration()), TrebuchetModelAdapter.Companion.convertSecondsToUs(it.getCpuTime()), it.getId(), it.getThreadId(), core);
            collection.add(schedulingEventModel);
        }
        return (List)destination$iv$iv;
    }

    private final ThreadState convertSchedulingState(SchedSlice slice) {
        ThreadState threadState;
        switch (TrebuchetModelAdapter$WhenMappings.$EnumSwitchMapping$0[slice.getState().ordinal()]) {
            case 1: {
                threadState = ThreadState.RUNNING_CAPTURED;
                break;
            }
            case 2: 
            case 3: {
                threadState = ThreadState.RUNNABLE_CAPTURED;
                break;
            }
            case 4: {
                threadState = ThreadState.DEAD_CAPTURED;
                break;
            }
            case 5: {
                threadState = ThreadState.SLEEPING_CAPTURED;
                break;
            }
            case 6: {
                threadState = ThreadState.WAITING_CAPTURED;
                break;
            }
            case 7: {
                threadState = ThreadState.WAITING_IO_CAPTURED;
                break;
            }
            default: {
                threadState = ThreadState.UNKNOWN;
            }
        }
        return threadState;
    }

    private final long convertToUserTimeUs(double timestampInSeconds) {
        return TrebuchetModelAdapter.Companion.convertSecondsToUs(timestampInSeconds + this.timeShiftFromBeginningSeconds);
    }

    /*
     * WARNING - void declaration
     */
    public TrebuchetModelAdapter(@NotNull Model trebuchetModel, @NotNull Cpu.CpuTraceType technology) {
        Collection<CpuCoreModel> collection;
        void $this$mapTo$iv$iv;
        Object threadMap;
        Intrinsics.checkNotNullParameter((Object)trebuchetModel, (String)"trebuchetModel");
        Intrinsics.checkNotNullParameter((Object)technology, (String)"technology");
        this.technology = technology;
        this.beginTimestampSeconds = trebuchetModel.getBeginTimestamp();
        this.endTimestampSeconds = trebuchetModel.getEndTimestamp();
        this.possibleCorruption = trebuchetModel.getRealtimeTimestamp() == 0L;
        this.processById = MapsKt.sortedMapOf((Pair[])new Pair[0]);
        this.timeShiftFromBeginningSeconds = Double.compare(trebuchetModel.getParentTimestamp(), 0.0) == 0 ? 0.0 : trebuchetModel.getParentTimestamp() - trebuchetModel.getParentTimestampBootTime();
        for (trebuchet.model.ProcessModel processModel : trebuchetModel.getProcesses().values()) {
            boolean bl = false;
            threadMap = new LinkedHashMap();
            for (trebuchet.model.ThreadModel thread2 : processModel.getThreads()) {
                List<TraceEventModel> traceEvents = this.mapSlicesToTraceEvents(thread2.getSlices());
                List<SchedulingEventModel> schedEvents = this.mapSchedSliceToSchedEvent(thread2.getSchedSlices(), processModel.getId(), thread2.getId());
                threadMap.put(thread2.getId(), new ThreadModel(thread2.getId(), processModel.getId(), thread2.getName(), traceEvents, schedEvents));
            }
            boolean bl2 = false;
            Map counterMap = new LinkedHashMap();
            for (Counter counter : processModel.getCounters()) {
                counterMap.put(counter.getName(), new CounterModel(counter.getName(), MapsKt.toSortedMap((Map)MapsKt.toMap((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)counter.getEvents()), (Function1)((Function1)new Function1<CounterValue, Pair<? extends Long, ? extends Double>>(){

                    @NotNull
                    public final Pair<Long, Double> invoke(@NotNull CounterValue it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return TuplesKt.to((Object)this.convertToUserTimeUs(it.getTimestamp()), (Object)it.getCount());
                    }
                }))))));
            }
            ((Map)this.processById).put(processModel.getId(), new ProcessModel(processModel.getId(), processModel.getName(), (Map<Integer, ThreadModel>)threadMap, counterMap));
        }
        Iterable iterable = trebuchetModel.getCpus();
        TrebuchetModelAdapter trebuchetModelAdapter = this;
        boolean $i$f$map = false;
        threadMap = iterable;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void cpu;
            CpuModel cpuModel = (CpuModel)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            CpuCoreModel cpuCoreModel = new CpuCoreModel(cpu.getId(), this.mapCpuProcessSliceToSchedEvent(cpu.getSlices(), cpu.getId()), MapsKt.emptyMap());
            collection.add(cpuCoreModel);
        }
        collection = (List)destination$iv$iv;
        Iterable iterable2 = collection;
        boolean $i$f$sortedBy = false;
        boolean bl = false;
        trebuchetModelAdapter.cores = CollectionsKt.sortedWith((Iterable)iterable2, (Comparator)new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                CpuCoreModel core = (CpuCoreModel)a;
                boolean bl2 = false;
                Comparable comparable = Integer.valueOf(core.getId());
                core = (CpuCoreModel)b;
                Comparable comparable2 = comparable;
                bl2 = false;
                Integer n = core.getId();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)n);
            }
        });
    }

    static {
        Companion = new Companion(null);
        SECONDS_TO_US = TimeUnit.SECONDS.toMicros(1L);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/android/tools/profilers/cpu/systemtrace/TrebuchetModelAdapter$Companion;", "", "()V", "SECONDS_TO_US", "", "convertSecondsToUs", "seconds", "", "intellij.android.profilers"})
    public static final class Companion {
        private final long convertSecondsToUs(double seconds) {
            return (long)((double)SECONDS_TO_US * seconds);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

