/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu.systemtrace;

import com.android.tools.adtui.model.DurationData;
import com.android.tools.adtui.model.event.EventAction;
import com.android.tools.profilers.cpu.systemtrace.TraceEventModel;
import com.google.common.annotations.VisibleForTesting;
import org.jetbrains.annotations.NotNull;

public class SystemTraceFrame
extends EventAction<PerfClass>
implements DurationData {
    public static final SystemTraceFrame EMPTY = new SystemTraceFrame(0L, 0L, 0.0, 0L, FrameThread.OTHER);
    private static final String APP_MAIN_THREAD_FRAME_ID_MPLUS = "Choreographer#doFrame";
    private static final String APP_RENDER_THREAD_FRAME_ID_MPLUS = "(DrawFrame|doFrame|queueBuffer)";
    private SystemTraceFrame myAssociatedFrame;
    private final double myCpuTimeUs;
    private final long myLongFrameTimeUs;
    @NotNull
    private final PerfClass myPerfClass;
    private final FrameThread myThread;

    /*
     * WARNING - void declaration
     */
    public SystemTraceFrame(@NotNull TraceEventModel eventModel, long longFrameTimeUs, FrameThread frameThread) {
        void thread2;
        if (eventModel == null) {
            SystemTraceFrame.$$$reportNull$$$0(0);
        }
        this(eventModel.getStartTimestampUs(), eventModel.getEndTimestampUs(), eventModel.getCpuTimeUs(), longFrameTimeUs, (FrameThread)thread2);
    }

    @VisibleForTesting
    public SystemTraceFrame(long startUs, long endUs, double cpuTimeUs, long longFrameTimeUs, FrameThread thread2) {
        super(startUs, endUs, (Object)PerfClass.NOT_SET);
        this.myCpuTimeUs = cpuTimeUs;
        this.myLongFrameTimeUs = longFrameTimeUs;
        this.myThread = thread2;
        this.myPerfClass = this.getDurationUs() > this.myLongFrameTimeUs ? PerfClass.BAD : PerfClass.GOOD;
    }

    public FrameThread getThread() {
        return this.myThread;
    }

    public void setAssociatedFrame(SystemTraceFrame associatedFrame) {
        this.myAssociatedFrame = associatedFrame;
    }

    public SystemTraceFrame getAssociatedFrame() {
        return this.myAssociatedFrame;
    }

    @NotNull
    public PerfClass getPerfClass() {
        PerfClass perfClass = this.myPerfClass;
        if (perfClass == null) {
            SystemTraceFrame.$$$reportNull$$$0(1);
        }
        return perfClass;
    }

    public PerfClass getTotalPerfClass() {
        double associatedFrameLengthUs;
        if (this == EMPTY || this.myPerfClass == PerfClass.NOT_SET) {
            return PerfClass.NOT_SET;
        }
        double d = associatedFrameLengthUs = this.myAssociatedFrame == null ? 0.0 : (double)this.myAssociatedFrame.getDurationUs();
        if (associatedFrameLengthUs + (double)this.getDurationUs() > (double)this.myLongFrameTimeUs) {
            return PerfClass.BAD;
        }
        return PerfClass.GOOD;
    }

    public long getDurationUs() {
        return this.getEndUs() - this.getStartUs();
    }

    public double getCpuTimeUs() {
        return this.myCpuTimeUs;
    }

    @NotNull
    public PerfClass getType() {
        PerfClass perfClass = this.getPerfClass();
        if (perfClass == null) {
            SystemTraceFrame.$$$reportNull$$$0(2);
        }
        return perfClass;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eventModel";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/cpu/systemtrace/SystemTraceFrame";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/cpu/systemtrace/SystemTraceFrame";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPerfClass";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum FrameThread {
        MAIN("Choreographer#doFrame"),
        RENDER("(DrawFrame|doFrame|queueBuffer)"),
        OTHER("");

        private final String myIdentifierRegEx;

        public String getIdentifierRegEx() {
            return this.myIdentifierRegEx;
        }

        private FrameThread(String identifierRegEx) {
            this.myIdentifierRegEx = identifierRegEx;
        }
    }

    public static enum PerfClass {
        NOT_SET,
        GOOD,
        BAD;

    }
}

