/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu.systemtrace;

import com.android.tools.adtui.model.SeriesData;
import com.android.tools.profilers.cpu.CaptureNode;
import com.android.tools.profilers.cpu.CpuThreadInfo;
import com.android.tools.profilers.cpu.ThreadState;
import com.android.tools.profilers.cpu.nodemodel.SystemTraceNodeFactory;
import com.android.tools.profilers.cpu.systemtrace.CounterModel;
import com.android.tools.profilers.cpu.systemtrace.CpuCoreModel;
import com.android.tools.profilers.cpu.systemtrace.CpuThreadSliceInfo;
import com.android.tools.profilers.cpu.systemtrace.ProcessModel;
import com.android.tools.profilers.cpu.systemtrace.SchedulingEventModel;
import com.android.tools.profilers.cpu.systemtrace.SystemTraceCpuCapture;
import com.android.tools.profilers.cpu.systemtrace.SystemTraceFrameManager;
import com.android.tools.profilers.cpu.systemtrace.SystemTraceModelAdapter;
import com.android.tools.profilers.cpu.systemtrace.SystemTraceSurfaceflingerManager;
import com.android.tools.profilers.cpu.systemtrace.ThreadModel;
import com.android.tools.profilers.cpu.systemtrace.TraceEventModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.UnaryOperator;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 #2\u00020\u0001:\u0002#$B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u001c\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J&\u0010\u0011\u001a \u0012\u001c\u0012\u001a\u0012\u0004\u0012\u00020\u0013\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00140\u00120\f0\u0012H\u0002J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J(\u0010\u0017\u001a\u001a\u0012\u0004\u0012\u00020\u0013\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00140\u00120\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J(\u0010\u0018\u001a\u001a\u0012\u0004\u0012\u00020\n\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00190\u00140\u00120\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u001c\u0010\u001a\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00140\u00122\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\"\u0010\u001d\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\n2\u0006\u0010!\u001a\u00020\"H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/android/tools/profilers/cpu/systemtrace/SystemTraceCpuCaptureBuilder;", "", "model", "Lcom/android/tools/profilers/cpu/systemtrace/SystemTraceModelAdapter;", "(Lcom/android/tools/profilers/cpu/systemtrace/SystemTraceModelAdapter;)V", "build", "Lcom/android/tools/profilers/cpu/systemtrace/SystemTraceCpuCapture;", "traceId", "", "mainProcessId", "", "buildCaptureTreeNodes", "", "Lcom/android/tools/profilers/cpu/CpuThreadInfo;", "Lcom/android/tools/profilers/cpu/CaptureNode;", "mainProcessModel", "Lcom/android/tools/profilers/cpu/systemtrace/ProcessModel;", "buildCpuCountersData", "", "", "Lcom/android/tools/adtui/model/SeriesData;", "buildCpuStateData", "Lcom/android/tools/profilers/cpu/systemtrace/SystemTraceCpuCaptureBuilder$CpuStateData;", "buildMainProcessMemoryCountersData", "buildThreadStateData", "Lcom/android/tools/profilers/cpu/ThreadState;", "convertCounterToSeriesData", "counter", "Lcom/android/tools/profilers/cpu/systemtrace/CounterModel;", "populateCaptureNode", "traceEventModel", "Lcom/android/tools/profilers/cpu/systemtrace/TraceEventModel;", "depth", "nodeFactory", "Lcom/android/tools/profilers/cpu/nodemodel/SystemTraceNodeFactory;", "Companion", "CpuStateData", "intellij.android.profilers"})
public final class SystemTraceCpuCaptureBuilder {
    private final SystemTraceModelAdapter model;
    private static final long UTILIZATION_BUCKET_LENGTH_US;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public final SystemTraceCpuCapture build(long traceId, int mainProcessId) {
        ProcessModel processModel = this.model.getProcessById(mainProcessId);
        if (processModel == null) {
            throw (Throwable)new IllegalArgumentException("A process with the id " + mainProcessId + " was not found while parsing the capture.");
        }
        ProcessModel mainProcess = processModel;
        Map<CpuThreadInfo, CaptureNode> captureTreeNodes = this.buildCaptureTreeNodes(mainProcess);
        Map<Integer, List<SeriesData<ThreadState>>> threadState = this.buildThreadStateData(mainProcess);
        CpuStateData cpuState = this.buildCpuStateData(mainProcess);
        List<Map<String, List<SeriesData<Long>>>> cpuCounters = this.buildCpuCountersData();
        Map<String, List<SeriesData<Long>>> memoryCounters = this.buildMainProcessMemoryCountersData(mainProcess);
        SystemTraceFrameManager frameManager = new SystemTraceFrameManager(mainProcess);
        SystemTraceSurfaceflingerManager sfManager = new SystemTraceSurfaceflingerManager(this.model, mainProcess.getName());
        return new SystemTraceCpuCapture(traceId, this.model, captureTreeNodes, threadState, cpuState.getSchedulingData(), cpuState.getUtilizationData(), cpuCounters, memoryCounters, frameManager, sfManager);
    }

    private final Map<CpuThreadInfo, CaptureNode> buildCaptureTreeNodes(ProcessModel mainProcessModel) {
        boolean bl = false;
        Map threadToCaptureNodeMap = new LinkedHashMap();
        SystemTraceNodeFactory nodeFactory = new SystemTraceNodeFactory();
        for (ThreadModel thread2 : mainProcessModel.getThreads()) {
            CpuThreadSliceInfo threadInfo = new CpuThreadSliceInfo(thread2.getId(), thread2.getName(), mainProcessModel.getId(), mainProcessModel.getName());
            CaptureNode root = new CaptureNode(nodeFactory.getNode(thread2.getName()));
            root.setStartGlobal(this.model.getCaptureStartTimestampUs());
            root.setEndGlobal(this.model.getCaptureEndTimestampUs());
            threadToCaptureNodeMap.put(threadInfo, root);
            for (TraceEventModel event : thread2.getTraceEvents()) {
                root.addChild(this.populateCaptureNode(event, 1, nodeFactory));
            }
        }
        return threadToCaptureNodeMap;
    }

    private final CaptureNode populateCaptureNode(TraceEventModel traceEventModel, int depth, SystemTraceNodeFactory nodeFactory) {
        CaptureNode node = new CaptureNode(nodeFactory.getNode(traceEventModel.getName()));
        node.setStartGlobal(traceEventModel.getStartTimestampUs());
        node.setEndGlobal(traceEventModel.getEndTimestampUs());
        node.setStartThread(traceEventModel.getStartTimestampUs());
        node.setEndThread(traceEventModel.getStartTimestampUs() + traceEventModel.getCpuTimeUs());
        node.setDepth(depth);
        for (TraceEventModel event : traceEventModel.getChildrenEvents()) {
            node.addChild(this.populateCaptureNode(event, depth + 1, nodeFactory));
        }
        return node;
    }

    private final Map<Integer, List<SeriesData<ThreadState>>> buildThreadStateData(ProcessModel mainProcessModel) {
        boolean bl = false;
        Map threadToStateSeries = new LinkedHashMap();
        for (ThreadModel thread2 : mainProcessModel.getThreads()) {
            List states = new ArrayList();
            threadToStateSeries.put(thread2.getId(), states);
            ThreadState lastState = ThreadState.UNKNOWN;
            for (SchedulingEventModel sched : thread2.getSchedulingEvents()) {
                if (sched.getState() == lastState) continue;
                states.add(new SeriesData(sched.getStartTimestampUs(), (Object)sched.getState()));
                lastState = sched.getState();
            }
        }
        return threadToStateSeries;
    }

    /*
     * WARNING - void declaration
     */
    private final CpuStateData buildCpuStateData(ProcessModel mainProcessModel) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Object list$iv$iv;
        ProcessModel it;
        void $this$flatMapTo$iv$iv;
        boolean bl = false;
        List utilizationData = new ArrayList();
        long startUserTimeUs = this.model.getCaptureStartTimestampUs();
        long endUserTimeUs = this.model.getCaptureEndTimestampUs();
        for (long i2 = startUserTimeUs; i2 < endUserTimeUs + UTILIZATION_BUCKET_LENGTH_US; i2 += UTILIZATION_BUCKET_LENGTH_US) {
            utilizationData.add(new SeriesData(i2, (Object)0L));
        }
        boolean bl2 = false;
        Map schedData = new LinkedHashMap();
        Iterable $this$flatMap$iv = this.model.getProcesses();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (ProcessModel)element$iv$iv;
            boolean bl3 = false;
            list$iv$iv = it.getThreads();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$flatMapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            list$iv$iv = (ThreadModel)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl4 = false;
            Pair pair = TuplesKt.to((Object)((ThreadModel)((Object)it)).getId(), (Object)((ThreadModel)((Object)it)).getName());
            collection.add(pair);
        }
        Map threadNames = MapsKt.toMap((Iterable)((List)destination$iv$iv));
        for (CpuCoreModel cpu : this.model.getCpuCores()) {
            List processList = new ArrayList();
            SchedulingEventModel schedulingEventModel = (SchedulingEventModel)CollectionsKt.firstOrNull(cpu.getSchedulingEvents());
            long lastSliceEnd = schedulingEventModel != null ? schedulingEventModel.getEndTimestampUs() : startUserTimeUs;
            for (SchedulingEventModel sched : cpu.getSchedulingEvents()) {
                long bucketTime;
                Object object;
                Object object2;
                Object processName;
                Object object3;
                if (sched.getStartTimestampUs() > lastSliceEnd) {
                    processList.add(new SeriesData(lastSliceEnd, (Object)CpuThreadSliceInfo.NULL_THREAD));
                }
                if ((object3 = this.model.getProcessById(sched.getProcessId())) == null || (object3 = ((ProcessModel)object3).getSafeProcessName()) == null) {
                    object3 = processName = "";
                }
                if ((object2 = this.model.getProcessById(sched.getProcessId())) == null || (object2 = ((ProcessModel)object2).getThreadById()) == null || (object2 = (ThreadModel)object2.get(sched.getThreadId())) == null || (object2 = ((ThreadModel)object2).getName()) == null) {
                    ThreadModel threadModel = this.model.getDanglingThread(sched.getThreadId());
                    object2 = object = threadModel != null ? threadModel.getName() : null;
                }
                if (object2 == null) {
                    object = "";
                }
                Object threadName = object;
                processList.add(new SeriesData(sched.getStartTimestampUs(), (Object)new CpuThreadSliceInfo(sched.getThreadId(), (String)threadName, sched.getProcessId(), (String)processName, sched.getDurationUs())));
                lastSliceEnd = sched.getEndTimestampUs();
                if (sched.getProcessId() != mainProcessModel.getId()) continue;
                long startBucket = (sched.getStartTimestampUs() - startUserTimeUs) / UTILIZATION_BUCKET_LENGTH_US;
                long sliceTimeInBucket = sched.getStartTimestampUs();
                long l = 0L;
                boolean bl5 = false;
                for (int i3 = (int)Math.max(l, startBucket); sched.getEndTimestampUs() > sliceTimeInBucket && i3 < utilizationData.size(); sliceTimeInBucket += bucketTime, ++i3) {
                    long bucketEndTime = startUserTimeUs + UTILIZATION_BUCKET_LENGTH_US * (long)(i3 + 1);
                    long l2 = sched.getEndTimestampUs();
                    boolean bl6 = false;
                    bucketTime = Math.min(bucketEndTime, l2) - sliceTimeInBucket;
                    ((SeriesData)utilizationData.get((int)i3)).value = (Long)((SeriesData)utilizationData.get((int)i3)).value + bucketTime;
                }
            }
            processList.add(new SeriesData(endUserTimeUs, (Object)CpuThreadSliceInfo.NULL_THREAD));
            schedData.put(cpu.getId(), processList);
        }
        double utilizationTotalTime = (double)UTILIZATION_BUCKET_LENGTH_US * (double)this.model.getCpuCores().size();
        utilizationData.replaceAll(new UnaryOperator(utilizationTotalTime){
            final /* synthetic */ double $utilizationTotalTime;

            @NotNull
            public final SeriesData<Long> apply(@NotNull SeriesData<Long> series) {
                Intrinsics.checkNotNullParameter(series, (String)"series");
                series.value = (long)(((Number)series.value).doubleValue() / this.$utilizationTotalTime * 100.0);
                return series;
            }
            {
                this.$utilizationTotalTime = d;
            }
        });
        return new CpuStateData(schedData, utilizationData);
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, List<SeriesData<Long>>> buildMainProcessMemoryCountersData(ProcessModel mainProcessModel) {
        void $this$mapTo$iv$iv;
        Map.Entry it;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = mainProcessModel.getCounterByName().entrySet();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Map.Entry)element$iv$iv;
            boolean bl = false;
            if (!StringsKt.startsWith$default((String)((String)it.getKey()), (String)"mem.", (boolean)false, (int)2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Map.Entry)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to(it.getKey(), this.convertCounterToSeriesData((CounterModel)it.getValue()));
            collection.add(pair);
        }
        return MapsKt.toSortedMap((Map)MapsKt.toMap((Iterable)((List)destination$iv$iv)));
    }

    /*
     * WARNING - void declaration
     */
    private final List<Map<String, List<SeriesData<Long>>>> buildCpuCountersData() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.model.getCpuCores();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void $this$mapTo$iv$iv2;
            void cpuCoreModel;
            CpuCoreModel cpuCoreModel2 = (CpuCoreModel)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Map<String, CounterModel> $this$map$iv2 = cpuCoreModel.getCountersMap();
            boolean $i$f$map2 = false;
            Map<String, CounterModel> map = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList($this$map$iv2.size());
            boolean $i$f$mapTo2 = false;
            void var15_15 = $this$mapTo$iv$iv2;
            boolean bl2 = false;
            Iterator iterator = var15_15.entrySet().iterator();
            while (iterator.hasNext()) {
                void it;
                Map.Entry item$iv$iv2;
                Map.Entry entry = item$iv$iv2 = iterator.next();
                Collection collection2 = destination$iv$iv2;
                boolean bl3 = false;
                Pair pair = TuplesKt.to(it.getKey(), this.convertCounterToSeriesData((CounterModel)it.getValue()));
                collection2.add(pair);
            }
            Map map2 = MapsKt.toMap((Iterable)((List)destination$iv$iv2));
            collection.add(map2);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<SeriesData<Long>> convertCounterToSeriesData(CounterModel counter) {
        void $this$mapTo$iv$iv;
        Map $this$map$iv = counter.getValuesByTimestampUs();
        boolean $i$f$map = false;
        Map map = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        void var7_7 = $this$mapTo$iv$iv;
        boolean bl = false;
        Iterator iterator = var7_7.entrySet().iterator();
        while (iterator.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            Object k = it.getKey();
            Intrinsics.checkNotNullExpressionValue(k, (String)"it.key");
            SeriesData seriesData = new SeriesData(((Number)k).longValue(), (Object)((long)((Number)it.getValue()).doubleValue()));
            collection.add(seriesData);
        }
        return CollectionsKt.toList((Iterable)((List)destination$iv$iv));
    }

    public SystemTraceCpuCaptureBuilder(@NotNull SystemTraceModelAdapter model) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        this.model = model;
    }

    static {
        Companion = new Companion(null);
        UTILIZATION_BUCKET_LENGTH_US = TimeUnit.MILLISECONDS.toMicros(50L);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B9\u0012\u001e\u0010\u0002\u001a\u001a\u0012\u0004\u0012\u00020\u0004\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u00050\u0003\u0012\u0012\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u00060\u0005\u00a2\u0006\u0002\u0010\nJ!\u0010\u000f\u001a\u001a\u0012\u0004\u0012\u00020\u0004\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u00050\u0003H\u00c6\u0003J\u0015\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u00060\u0005H\u00c6\u0003JA\u0010\u0011\u001a\u00020\u00002 \b\u0002\u0010\u0002\u001a\u001a\u0012\u0004\u0012\u00020\u0004\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u00050\u00032\u0014\b\u0002\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u00060\u0005H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0004H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R)\u0010\u0002\u001a\u001a\u0012\u0004\u0012\u00020\u0004\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001d\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0018"}, d2={"Lcom/android/tools/profilers/cpu/systemtrace/SystemTraceCpuCaptureBuilder$CpuStateData;", "", "schedulingData", "", "", "", "Lcom/android/tools/adtui/model/SeriesData;", "Lcom/android/tools/profilers/cpu/systemtrace/CpuThreadSliceInfo;", "utilizationData", "", "(Ljava/util/Map;Ljava/util/List;)V", "getSchedulingData", "()Ljava/util/Map;", "getUtilizationData", "()Ljava/util/List;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "intellij.android.profilers"})
    private static final class CpuStateData {
        @NotNull
        private final Map<Integer, List<SeriesData<CpuThreadSliceInfo>>> schedulingData;
        @NotNull
        private final List<SeriesData<Long>> utilizationData;

        @NotNull
        public final Map<Integer, List<SeriesData<CpuThreadSliceInfo>>> getSchedulingData() {
            return this.schedulingData;
        }

        @NotNull
        public final List<SeriesData<Long>> getUtilizationData() {
            return this.utilizationData;
        }

        public CpuStateData(@NotNull Map<Integer, ? extends List<? extends SeriesData<CpuThreadSliceInfo>>> schedulingData, @NotNull List<? extends SeriesData<Long>> utilizationData) {
            Intrinsics.checkNotNullParameter(schedulingData, (String)"schedulingData");
            Intrinsics.checkNotNullParameter(utilizationData, (String)"utilizationData");
            this.schedulingData = schedulingData;
            this.utilizationData = utilizationData;
        }

        @NotNull
        public final Map<Integer, List<SeriesData<CpuThreadSliceInfo>>> component1() {
            return this.schedulingData;
        }

        @NotNull
        public final List<SeriesData<Long>> component2() {
            return this.utilizationData;
        }

        @NotNull
        public final CpuStateData copy(@NotNull Map<Integer, ? extends List<? extends SeriesData<CpuThreadSliceInfo>>> schedulingData, @NotNull List<? extends SeriesData<Long>> utilizationData) {
            Intrinsics.checkNotNullParameter(schedulingData, (String)"schedulingData");
            Intrinsics.checkNotNullParameter(utilizationData, (String)"utilizationData");
            return new CpuStateData(schedulingData, utilizationData);
        }

        public static /* synthetic */ CpuStateData copy$default(CpuStateData cpuStateData, Map map, List list, int n, Object object) {
            if ((n & 1) != 0) {
                map = cpuStateData.schedulingData;
            }
            if ((n & 2) != 0) {
                list = cpuStateData.utilizationData;
            }
            return cpuStateData.copy(map, list);
        }

        @NotNull
        public String toString() {
            return "CpuStateData(schedulingData=" + this.schedulingData + ", utilizationData=" + this.utilizationData + ")";
        }

        public int hashCode() {
            Map<Integer, List<SeriesData<CpuThreadSliceInfo>>> map = this.schedulingData;
            List<SeriesData<Long>> list = this.utilizationData;
            return (map != null ? ((Object)map).hashCode() : 0) * 31 + (list != null ? ((Object)list).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof CpuStateData)) break block3;
                    CpuStateData cpuStateData = (CpuStateData)object;
                    if (!Intrinsics.areEqual(this.schedulingData, cpuStateData.schedulingData) || !Intrinsics.areEqual(this.utilizationData, cpuStateData.utilizationData)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/android/tools/profilers/cpu/systemtrace/SystemTraceCpuCaptureBuilder$Companion;", "", "()V", "UTILIZATION_BUCKET_LENGTH_US", "", "getUTILIZATION_BUCKET_LENGTH_US", "()J", "intellij.android.profilers"})
    public static final class Companion {
        public final long getUTILIZATION_BUCKET_LENGTH_US() {
            return UTILIZATION_BUCKET_LENGTH_US;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

