/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu.systemtrace;

import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.SeriesData;
import com.android.tools.profilers.cpu.BaseCpuCapture;
import com.android.tools.profilers.cpu.CaptureNode;
import com.android.tools.profilers.cpu.CpuThreadInfo;
import com.android.tools.profilers.cpu.ThreadState;
import com.android.tools.profilers.cpu.systemtrace.CpuSystemTraceData;
import com.android.tools.profilers.cpu.systemtrace.CpuThreadSliceInfo;
import com.android.tools.profilers.cpu.systemtrace.SurfaceflingerEvent;
import com.android.tools.profilers.cpu.systemtrace.SystemTraceFrame;
import com.android.tools.profilers.cpu.systemtrace.SystemTraceFrameManager;
import com.android.tools.profilers.cpu.systemtrace.SystemTraceModelAdapter;
import com.android.tools.profilers.cpu.systemtrace.SystemTraceSurfaceflingerManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class SystemTraceCpuCapture
extends BaseCpuCapture
implements CpuSystemTraceData {
    @NotNull
    private final Map<Integer, List<SeriesData<ThreadState>>> myThreadStateDataSeries;
    @NotNull
    private final Map<Integer, List<SeriesData<CpuThreadSliceInfo>>> myCpuThreadSliceInfoStates;
    @NotNull
    private final List<SeriesData<Long>> myCpuUtilizationSeries;
    @NotNull
    private final Map<String, List<SeriesData<Long>>> myProcessMemoryCountersMap;
    @NotNull
    private final List<Map<String, List<SeriesData<Long>>>> myCpuCounters;
    private final boolean myIsMissingData;
    @NotNull
    private final SystemTraceFrameManager myFrameManager;
    @NotNull
    private final SystemTraceSurfaceflingerManager mySurfaceflingerManager;

    /*
     * WARNING - void declaration
     */
    public SystemTraceCpuCapture(long traceId, @NotNull SystemTraceModelAdapter model, @NotNull Map<CpuThreadInfo, CaptureNode> captureNodes, @NotNull Map<Integer, List<SeriesData<ThreadState>>> threadStateData, @NotNull Map<Integer, List<SeriesData<CpuThreadSliceInfo>>> cpuSchedData, @NotNull List<SeriesData<Long>> cpuUtilizationData, @NotNull List<Map<String, List<SeriesData<Long>>>> cpuCounters, @NotNull Map<String, List<SeriesData<Long>>> processMemoryCountersMap, @NotNull SystemTraceFrameManager frameManager, @NotNull SystemTraceSurfaceflingerManager systemTraceSurfaceflingerManager) {
        void surfaceflingerManager;
        if (model == null) {
            SystemTraceCpuCapture.$$$reportNull$$$0(0);
        }
        if (captureNodes == null) {
            SystemTraceCpuCapture.$$$reportNull$$$0(1);
        }
        if (threadStateData == null) {
            SystemTraceCpuCapture.$$$reportNull$$$0(2);
        }
        if (cpuSchedData == null) {
            SystemTraceCpuCapture.$$$reportNull$$$0(3);
        }
        if (cpuUtilizationData == null) {
            SystemTraceCpuCapture.$$$reportNull$$$0(4);
        }
        if (cpuCounters == null) {
            SystemTraceCpuCapture.$$$reportNull$$$0(5);
        }
        if (processMemoryCountersMap == null) {
            SystemTraceCpuCapture.$$$reportNull$$$0(6);
        }
        if (frameManager == null) {
            SystemTraceCpuCapture.$$$reportNull$$$0(7);
        }
        if (systemTraceSurfaceflingerManager == null) {
            SystemTraceCpuCapture.$$$reportNull$$$0(8);
        }
        super(traceId, model.getSystemTraceTechnology(), new Range((double)model.getCaptureStartTimestampUs(), (double)model.getCaptureEndTimestampUs()), captureNodes);
        this.myThreadStateDataSeries = threadStateData;
        this.myCpuThreadSliceInfoStates = cpuSchedData;
        this.myCpuUtilizationSeries = cpuUtilizationData;
        this.myCpuCounters = cpuCounters;
        this.myProcessMemoryCountersMap = processMemoryCountersMap;
        this.myIsMissingData = model.isCapturePossibleCorrupted();
        this.myFrameManager = frameManager;
        this.mySurfaceflingerManager = surfaceflingerManager;
    }

    @Override
    public CpuSystemTraceData getSystemTraceData() {
        return this;
    }

    @Override
    @NotNull
    public List<SeriesData<ThreadState>> getThreadStatesForThread(int threadId) {
        List list = this.myThreadStateDataSeries.getOrDefault(threadId, new ArrayList());
        if (list == null) {
            SystemTraceCpuCapture.$$$reportNull$$$0(9);
        }
        return list;
    }

    @Override
    @NotNull
    public List<SeriesData<CpuThreadSliceInfo>> getCpuThreadSliceInfoStates(int cpu) {
        List list = this.myCpuThreadSliceInfoStates.getOrDefault(cpu, new ArrayList());
        if (list == null) {
            SystemTraceCpuCapture.$$$reportNull$$$0(10);
        }
        return list;
    }

    @Override
    @NotNull
    public List<SeriesData<Long>> getCpuUtilizationSeries() {
        List<SeriesData<Long>> list = this.myCpuUtilizationSeries;
        if (list == null) {
            SystemTraceCpuCapture.$$$reportNull$$$0(11);
        }
        return list;
    }

    @Override
    @NotNull
    public List<Map<String, List<SeriesData<Long>>>> getCpuCounters() {
        List<Map<String, List<SeriesData<Long>>>> list = this.myCpuCounters;
        if (list == null) {
            SystemTraceCpuCapture.$$$reportNull$$$0(12);
        }
        return list;
    }

    @Override
    public int getCpuCount() {
        return this.myCpuThreadSliceInfoStates.size();
    }

    @Override
    @NotNull
    public Map<String, List<SeriesData<Long>>> getMemoryCounters() {
        Map<String, List<SeriesData<Long>>> map = this.myProcessMemoryCountersMap;
        if (map == null) {
            SystemTraceCpuCapture.$$$reportNull$$$0(13);
        }
        return map;
    }

    @Override
    public boolean isMissingData() {
        return this.myIsMissingData;
    }

    @Override
    @NotNull
    public List<SeriesData<SystemTraceFrame>> getFrames(@NotNull SystemTraceFrame.FrameThread threadType) {
        if (threadType == null) {
            SystemTraceCpuCapture.$$$reportNull$$$0(14);
        }
        List<SeriesData<SystemTraceFrame>> list = this.myFrameManager.getFrames(threadType);
        if (list == null) {
            SystemTraceCpuCapture.$$$reportNull$$$0(15);
        }
        return list;
    }

    @Override
    @NotNull
    public List<SeriesData<SurfaceflingerEvent>> getSurfaceflingerEvents() {
        List<SeriesData<SurfaceflingerEvent>> list = this.mySurfaceflingerManager.getSurfaceflingerEvents();
        if (list == null) {
            SystemTraceCpuCapture.$$$reportNull$$$0(16);
        }
        return list;
    }

    @Override
    @NotNull
    public List<SeriesData<Long>> getVsyncCounterValues() {
        List<SeriesData<Long>> list = this.mySurfaceflingerManager.getVsyncCounterValues();
        if (list == null) {
            SystemTraceCpuCapture.$$$reportNull$$$0(17);
        }
        return list;
    }

    @Override
    @NotNull
    public List<SeriesData<Long>> getBufferQueueCounterValues() {
        List<SeriesData<Long>> list = this.mySurfaceflingerManager.getBufferQueueValues();
        if (list == null) {
            SystemTraceCpuCapture.$$$reportNull$$$0(18);
        }
        return list;
    }

    @Override
    public int getRenderThreadId() {
        return this.myFrameManager.getRenderThreadId();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "captureNodes";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "threadStateData";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cpuSchedData";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cpuUtilizationData";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cpuCounters";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processMemoryCountersMap";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frameManager";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "surfaceflingerManager";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/cpu/systemtrace/SystemTraceCpuCapture";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "threadType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/cpu/systemtrace/SystemTraceCpuCapture";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getThreadStatesForThread";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getCpuThreadSliceInfoStates";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getCpuUtilizationSeries";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getCpuCounters";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getMemoryCounters";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getFrames";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getSurfaceflingerEvents";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getVsyncCounterValues";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getBufferQueueCounterValues";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getFrames";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

