/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu.simpleperf;

import com.android.tools.adtui.model.Range;
import com.android.tools.profiler.proto.Cpu;
import com.android.tools.profiler.proto.SimpleperfReport;
import com.android.tools.profilers.cpu.BaseCpuCapture;
import com.android.tools.profilers.cpu.CaptureNode;
import com.android.tools.profilers.cpu.CpuCapture;
import com.android.tools.profilers.cpu.CpuThreadInfo;
import com.android.tools.profilers.cpu.TraceParser;
import com.android.tools.profilers.cpu.nodemodel.CaptureNodeModel;
import com.android.tools.profilers.cpu.nodemodel.NoSymbolModel;
import com.android.tools.profilers.cpu.nodemodel.SingleNameModel;
import com.android.tools.profilers.cpu.simpleperf.NodeNameParser;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.intellij.openapi.diagnostic.Logger;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class SimpleperfTraceParser
implements TraceParser {
    private static final String MAGIC = "SIMPLEPERF";
    private static final int INVALID_SYMBOL_ID = -1;
    private static final String DATA_APP_DIR = "/data/app";
    private int myTraceVersion;
    private final Map<Integer, SimpleperfReport.File> myFiles = new HashMap<Integer, SimpleperfReport.File>();
    private final Map<Integer, SimpleperfReport.Thread> myThreads;
    @VisibleForTesting
    final List<SimpleperfReport.Sample> mySamples = new ArrayList<SimpleperfReport.Sample>();
    private final Map<CpuThreadInfo, CaptureNode> myCaptureTrees = new HashMap<CpuThreadInfo, CaptureNode>();
    private long mySampleCount;
    private long myLostSampleCount;
    private Range myRange;
    private List<String> myEventTypes;
    private String myAppPackageName;
    private String myAppDataFolderPrefix;

    public SimpleperfTraceParser() {
        this.myThreads = new HashMap<Integer, SimpleperfReport.Thread>();
    }

    private static String fileNameFromPath(String path) {
        String[] splitPath = path.split("/");
        return splitPath[splitPath.length - 1];
    }

    private static boolean equals(SimpleperfReport.Sample.CallChainEntry c1, SimpleperfReport.Sample.CallChainEntry c2) {
        boolean isSameFileAndSymbolId;
        boolean bl = isSameFileAndSymbolId = c1.getFileId() == c2.getFileId() && c1.getSymbolId() == c2.getSymbolId();
        if (!isSameFileAndSymbolId) {
            return false;
        }
        if (c1.getSymbolId() == -1) {
            return c1.getVaddrInFile() == c2.getVaddrInFile();
        }
        return true;
    }

    private static Logger getLog() {
        return Logger.getInstance(SimpleperfTraceParser.class);
    }

    private static ByteBuffer byteBufferFromFile(File f, ByteOrder byteOrder) throws IOException {
        try (FileInputStream dataFile = new FileInputStream(f);){
            MappedByteBuffer buffer = dataFile.getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, f.length());
            buffer.order(byteOrder);
            MappedByteBuffer mappedByteBuffer = buffer;
            return mappedByteBuffer;
        }
    }

    @Override
    public CpuCapture parse(@NotNull File trace, long traceId) throws IOException {
        if (trace == null) {
            SimpleperfTraceParser.$$$reportNull$$$0(0);
        }
        this.parseTraceFile(trace);
        this.parseSampleData();
        return new BaseCpuCapture(traceId, Cpu.CpuTraceType.SIMPLEPERF, this.myRange, this.getCaptureTrees());
    }

    public Map<CpuThreadInfo, CaptureNode> getCaptureTrees() {
        return this.myCaptureTrees;
    }

    public long getLostSampleCount() {
        return this.myLostSampleCount;
    }

    public long getSampleCount() {
        return this.mySampleCount;
    }

    @NotNull
    private static CaptureNode createCaptureNode(CaptureNodeModel model, long timestamp) {
        CaptureNode node = new CaptureNode(model);
        SimpleperfTraceParser.setNodeStartTime(node, timestamp);
        node.setDepth(0);
        CaptureNode captureNode = node;
        if (captureNode == null) {
            SimpleperfTraceParser.$$$reportNull$$$0(1);
        }
        return captureNode;
    }

    @VisibleForTesting
    void parseTraceFile(File trace) throws IOException {
        ByteBuffer buffer = SimpleperfTraceParser.byteBufferFromFile(trace, ByteOrder.LITTLE_ENDIAN);
        SimpleperfTraceParser.verifyMagicNumber(buffer);
        this.parseVersionNumber(buffer);
        int recordSize = buffer.getInt();
        while (recordSize != 0) {
            byte[] recordBytes = new byte[recordSize];
            buffer.get(recordBytes);
            SimpleperfReport.Record record = SimpleperfReport.Record.parseFrom((byte[])recordBytes);
            switch (record.getRecordDataCase()) {
                case FILE: {
                    SimpleperfReport.File file = record.getFile();
                    this.myFiles.put(file.getId(), file);
                    break;
                }
                case LOST: {
                    SimpleperfReport.LostSituation situation = record.getLost();
                    this.mySampleCount = situation.getSampleCount();
                    this.myLostSampleCount = situation.getLostCount();
                    break;
                }
                case SAMPLE: {
                    SimpleperfReport.Sample sample = record.getSample();
                    this.mySamples.add(sample);
                    break;
                }
                case THREAD: {
                    SimpleperfReport.Thread thread2 = record.getThread();
                    this.myThreads.put(thread2.getThreadId(), thread2);
                    break;
                }
                case META_INFO: {
                    SimpleperfReport.MetaInfo info = record.getMetaInfo();
                    this.myEventTypes = info.getEventTypeList();
                    this.myAppPackageName = info.getAppPackageName();
                    this.myAppDataFolderPrefix = String.format("%s/%s", DATA_APP_DIR, this.myAppPackageName);
                    break;
                }
                default: {
                    SimpleperfTraceParser.getLog().warn("Unexpected record data type " + record.getRecordDataCase());
                }
            }
            recordSize = buffer.getInt();
        }
        if ((long)this.mySamples.size() != this.mySampleCount) {
            throw new IllegalStateException("Samples count doesn't match the number of samples read.");
        }
    }

    private void parseVersionNumber(ByteBuffer buffer) {
        this.myTraceVersion = buffer.getShort();
    }

    private static void verifyMagicNumber(ByteBuffer buffer) {
        byte[] magic = new byte[MAGIC.length()];
        buffer.get(magic);
        if (!new String(magic).equals(MAGIC)) {
            throw new IllegalStateException("Simpleperf trace could not be parsed due to magic number mismatch.");
        }
    }

    private void parseSampleData() {
        if (this.mySamples.isEmpty()) {
            return;
        }
        long startTimestamp = this.mySamples.get(0).getTime();
        long endTimestamp = this.mySamples.get(this.mySamples.size() - 1).getTime();
        this.myRange = new Range((double)TimeUnit.NANOSECONDS.toMicros(startTimestamp), (double)TimeUnit.NANOSECONDS.toMicros(endTimestamp));
        Map<Integer, List<SimpleperfReport.Sample>> threadSamples = this.splitSamplesPerThread();
        for (Map.Entry<Integer, List<SimpleperfReport.Sample>> threadSamplesEntry : threadSamples.entrySet()) {
            this.parseThreadSamples(threadSamplesEntry.getKey(), threadSamplesEntry.getValue());
        }
    }

    private Map<Integer, List<SimpleperfReport.Sample>> splitSamplesPerThread() {
        HashMap<Integer, List<SimpleperfReport.Sample>> threadSamples = new HashMap<Integer, List<SimpleperfReport.Sample>>();
        for (SimpleperfReport.Sample sample : this.mySamples) {
            int threadId = sample.getThreadId();
            if (!threadSamples.containsKey(threadId)) {
                threadSamples.put(threadId, new ArrayList());
            }
            ((List)threadSamples.get(threadId)).add(sample);
        }
        return threadSamples;
    }

    private static void setNodeEndTime(CaptureNode node, long endTimeNs) {
        node.setEndGlobal(TimeUnit.NANOSECONDS.toMicros(endTimeNs));
        node.setEndThread(TimeUnit.NANOSECONDS.toMicros(endTimeNs));
    }

    private static void setNodeStartTime(CaptureNode node, long startTimeNs) {
        node.setStartGlobal(TimeUnit.NANOSECONDS.toMicros(startTimeNs));
        node.setStartThread(TimeUnit.NANOSECONDS.toMicros(startTimeNs));
    }

    private void parseThreadSamples(int threadId, List<SimpleperfReport.Sample> threadSamples) {
        if (threadSamples.isEmpty()) {
            SimpleperfTraceParser.getLog().warn(String.format("Warning: No samples read for thread %s (%d)", this.myThreads.get(threadId), threadId));
            return;
        }
        if (!this.myThreads.containsKey(threadId)) {
            throw new IllegalStateException("Malformed trace file: thread with id " + threadId + " not found.");
        }
        long firstTimestamp = threadSamples.get(0).getTime();
        SimpleperfReport.Thread thread2 = this.myThreads.get(threadId);
        CaptureNode root = SimpleperfTraceParser.createCaptureNode(new SingleNameModel(thread2.getThreadName()), firstTimestamp);
        root.setDepth(0);
        this.myCaptureTrees.put(new CpuThreadInfo(threadId, thread2.getThreadName(), threadId == thread2.getProcessId()), root);
        List previousCallChain = Lists.reverse((List)threadSamples.get(0).getCallchainList());
        CaptureNode lastVisitedNode = this.parseCallChain(previousCallChain, Collections.emptyList(), threadSamples.get(0).getTime(), root);
        for (int i2 = 1; i2 < threadSamples.size(); ++i2) {
            SimpleperfReport.Sample sample = threadSamples.get(i2);
            List callChain = Lists.reverse((List)sample.getCallchainList());
            lastVisitedNode = this.parseCallChain(callChain, previousCallChain, sample.getTime(), lastVisitedNode);
            previousCallChain = callChain;
        }
        long lastTimestamp = this.mySamples.get(this.mySamples.size() - 1).getTime();
        SimpleperfTraceParser.updateAncestorsEndTime(lastTimestamp, lastVisitedNode);
        SimpleperfTraceParser.setNodeEndTime(root, lastTimestamp);
    }

    private static void updateAncestorsEndTime(long endTimestamp, CaptureNode lastVisited) {
        CaptureNode node = lastVisited;
        while (node.getParent() != null && node.getEnd() == 0L) {
            SimpleperfTraceParser.setNodeEndTime(node, endTimestamp);
            node = node.getParent();
            assert (node != null);
        }
    }

    private CaptureNode parseCallChain(List<SimpleperfReport.Sample.CallChainEntry> callChain, List<SimpleperfReport.Sample.CallChainEntry> previousCallChain, long sampleTimestamp, CaptureNode lastVisitedNode) {
        int divergenceIndex;
        CaptureNode traversalNode = lastVisitedNode;
        for (divergenceIndex = 0; divergenceIndex < callChain.size() && divergenceIndex < previousCallChain.size() && SimpleperfTraceParser.equals(previousCallChain.get(divergenceIndex), callChain.get(divergenceIndex)); ++divergenceIndex) {
        }
        if (divergenceIndex < previousCallChain.size()) {
            int divergenceCount = previousCallChain.size() - divergenceIndex;
            traversalNode = SimpleperfTraceParser.findDivergenceAndUpdateEndTime(divergenceCount, sampleTimestamp, traversalNode);
        }
        if (divergenceIndex < callChain.size()) {
            traversalNode = this.addNewNodes(callChain, traversalNode, divergenceIndex, sampleTimestamp);
        }
        return traversalNode;
    }

    private static CaptureNode findDivergenceAndUpdateEndTime(int divergenceCount, long endTimestamp, CaptureNode node) {
        for (int i2 = 0; i2 < divergenceCount; ++i2) {
            assert (node != null);
            SimpleperfTraceParser.setNodeEndTime(node, endTimestamp);
            node = node.getParent();
        }
        return node;
    }

    private CaptureNode addNewNodes(List<SimpleperfReport.Sample.CallChainEntry> callChain, CaptureNode node, int startIndex, long startTimestamp) {
        assert (node != null);
        for (int i2 = startIndex; i2 < callChain.size(); ++i2) {
            long parentVAddress = i2 > 0 ? callChain.get(i2 - 1).getVaddrInFile() : -1L;
            CaptureNode child = SimpleperfTraceParser.createCaptureNode(this.methodModelFromCallchainEntry(callChain.get(i2), parentVAddress), startTimestamp);
            node.addChild(child);
            child.setDepth(node.getDepth() + 1);
            node = child;
        }
        return node;
    }

    private CaptureNodeModel methodModelFromCallchainEntry(SimpleperfReport.Sample.CallChainEntry callChainEntry, long parentVAddress) {
        int symbolId = callChainEntry.getSymbolId();
        SimpleperfReport.File symbolFile = this.myFiles.get(callChainEntry.getFileId());
        if (symbolFile == null) {
            throw new IllegalStateException("Symbol file with id \"" + callChainEntry.getFileId() + "\" not found.");
        }
        if (symbolId == -1) {
            String hexAddress = "0x" + Long.toHexString(callChainEntry.getVaddrInFile());
            String methodName = SimpleperfTraceParser.fileNameFromPath(symbolFile.getPath()) + "+" + hexAddress;
            return new NoSymbolModel(methodName);
        }
        boolean isUserWritten = symbolFile.getPath().startsWith(this.myAppDataFolderPrefix);
        return NodeNameParser.parseNodeName(symbolFile.getSymbol(symbolId), isUserWritten, symbolFile.getPath(), parentVAddress);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "trace";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/cpu/simpleperf/SimpleperfTraceParser";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/cpu/simpleperf/SimpleperfTraceParser";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createCaptureNode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

