/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu.simpleperf;

import com.android.tools.idea.protobuf.ByteString;
import com.android.tools.idea.util.StudioPathManager;
import com.android.tools.profilers.cpu.TracePreProcessor;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.system.CpuArch;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class SimpleperfSampleReporter
implements TracePreProcessor {
    private static Logger getLogger() {
        return Logger.getInstance(SimpleperfSampleReporter.class);
    }

    @Override
    @NotNull
    public ByteString preProcessTrace(@NotNull ByteString trace, @NotNull List<String> symbolDirs) {
        ByteString byteString;
        File processedTraceFile;
        block10: {
            boolean reportSampleSuccess;
            if (trace == null) {
                SimpleperfSampleReporter.$$$reportNull$$$0(0);
            }
            if (symbolDirs == null) {
                SimpleperfSampleReporter.$$$reportNull$$$0(1);
            }
            processedTraceFile = FileUtil.createTempFile((String)String.format("%s%ctrace-%d", FileUtil.getTempDirectory(), Character.valueOf(File.separatorChar), System.currentTimeMillis()), (String)".trace", (boolean)true);
            Process reportSample = new ProcessBuilder(this.getReportSampleCommand(trace, processedTraceFile, symbolDirs)).start();
            reportSample.waitFor();
            boolean bl = reportSampleSuccess = reportSample.exitValue() == 0;
            if (reportSampleSuccess) break block10;
            String error = new BufferedReader(new InputStreamReader(reportSample.getErrorStream())).readLine();
            SimpleperfSampleReporter.getLogger().warn("simpleperf report-sample exited unsuccessfully. " + error);
            ByteString byteString2 = FAILURE;
            if (byteString2 == null) {
                SimpleperfSampleReporter.$$$reportNull$$$0(2);
            }
            return byteString2;
        }
        try {
            ByteString processedTrace = ByteString.copyFrom((byte[])Files.readAllBytes(processedTraceFile.toPath()));
            processedTraceFile.delete();
            byteString = processedTrace;
        }
        catch (IOException e) {
            SimpleperfSampleReporter.getLogger().warn(String.format("I/O error when trying to execute simpleperf report-sample:\n%s", e.getMessage()));
            ByteString byteString3 = FAILURE;
            if (byteString3 == null) {
                SimpleperfSampleReporter.$$$reportNull$$$0(4);
            }
            return byteString3;
        }
        catch (InterruptedException e) {
            SimpleperfSampleReporter.getLogger().warn(String.format("Failed to wait for simpleperf report-sample command to run:\n%s", e.getMessage()));
            ByteString byteString4 = FAILURE;
            if (byteString4 == null) {
                SimpleperfSampleReporter.$$$reportNull$$$0(5);
            }
            return byteString4;
        }
        if (byteString == null) {
            SimpleperfSampleReporter.$$$reportNull$$$0(3);
        }
        return byteString;
    }

    @VisibleForTesting
    List<String> getReportSampleCommand(@NotNull ByteString trace, @NotNull File processedTrace, @NotNull List<String> symbolDirs) throws IOException {
        if (trace == null) {
            SimpleperfSampleReporter.$$$reportNull$$$0(6);
        }
        if (processedTrace == null) {
            SimpleperfSampleReporter.$$$reportNull$$$0(7);
        }
        if (symbolDirs == null) {
            SimpleperfSampleReporter.$$$reportNull$$$0(8);
        }
        ArrayList<String> command = new ArrayList<String>();
        command.add(this.getSimpleperfBinaryPath());
        command.add("report-sample");
        command.add("--protobuf");
        command.add("--show-callchain");
        command.add("-i");
        command.add(SimpleperfSampleReporter.tempFileFromByteString(trace).getAbsolutePath());
        command.add("-o");
        command.add(processedTrace.getAbsolutePath());
        for (String path : symbolDirs) {
            command.add("--symdir");
            command.add(path);
        }
        return command;
    }

    @VisibleForTesting
    String getSimpleperfBinaryPath() {
        String subDir = SimpleperfSampleReporter.getSimpleperfBinarySubdirectory();
        String binaryName = SimpleperfSampleReporter.getSimpleperfBinaryName();
        if (StudioPathManager.isRunningFromSources()) {
            return Paths.get(StudioPathManager.getSourcesRoot(), "prebuilts", "tools", subDir, "simpleperf", binaryName).toString();
        }
        return Paths.get(PathManager.getHomePath(), "plugins", "android", "resources", "simpleperf", subDir, binaryName).toString();
    }

    private static File tempFileFromByteString(@NotNull ByteString bytes) throws IOException {
        if (bytes == null) {
            SimpleperfSampleReporter.$$$reportNull$$$0(9);
        }
        File file = FileUtil.createTempFile((String)String.format("cpu_trace_%d", System.currentTimeMillis()), (String)".trace", (boolean)true);
        try (FileOutputStream out = new FileOutputStream(file);){
            out.write(bytes.toByteArray());
        }
        return file;
    }

    private static String getSimpleperfBinarySubdirectory() {
        if (SystemInfo.isLinux && CpuArch.isIntel32()) {
            return "linux-x86";
        }
        if (SystemInfo.isLinux && CpuArch.isIntel64()) {
            return "linux-x86_64";
        }
        if (SystemInfo.isMac && CpuArch.isIntel64()) {
            return "darwin-x86_64";
        }
        if (SystemInfo.isWindows && CpuArch.isIntel32()) {
            return "windows";
        }
        if (SystemInfo.isWindows && CpuArch.isIntel64()) {
            return "windows-x86_64";
        }
        throw new IllegalStateException("Unknown operating system/CPU architecture");
    }

    private static String getSimpleperfBinaryName() {
        return SystemInfo.isWindows ? "simpleperf.exe" : "simpleperf";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "trace";
                break;
            }
            case 1: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbolDirs";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/cpu/simpleperf/SimpleperfSampleReporter";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processedTrace";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bytes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/cpu/simpleperf/SimpleperfSampleReporter";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "preProcessTrace";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "preProcessTrace";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getReportSampleCommand";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "tempFileFromByteString";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

