/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu.config;

import com.android.tools.adtui.model.options.OptionsProperty;
import com.android.tools.adtui.model.options.OptionsProvider;
import com.android.tools.profiler.proto.Cpu;
import com.android.tools.profilers.cpu.config.ArtInstrumentedConfiguration;
import com.android.tools.profilers.cpu.config.ArtSampledConfiguration;
import com.android.tools.profilers.cpu.config.AtraceConfiguration;
import com.android.tools.profilers.cpu.config.PerfettoConfiguration;
import com.android.tools.profilers.cpu.config.SimpleperfConfiguration;
import com.android.tools.profilers.cpu.config.UnspecifiedConfiguration;
import org.jetbrains.annotations.NotNull;

public abstract class ProfilingConfiguration
implements OptionsProvider {
    public static final String DEFAULT_CONFIGURATION_NAME = "Unnamed";
    public static final int DEFAULT_BUFFER_SIZE_MB = 8;
    public static final int DEFAULT_SAMPLING_INTERVAL_US = 1000;
    public static final String TRACE_CONFIG_GROUP = "Trace config";
    @NotNull
    private String myName;
    private boolean myDisableLiveAllocation;

    protected ProfilingConfiguration(@NotNull String name) {
        if (name == null) {
            ProfilingConfiguration.$$$reportNull$$$0(0);
        }
        this.myDisableLiveAllocation = true;
        this.myName = name;
    }

    @NotNull
    public abstract Cpu.CpuTraceType getTraceType();

    @OptionsProperty(name="Configuration name: ", group="Trace config", order=99)
    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            ProfilingConfiguration.$$$reportNull$$$0(1);
        }
        return string;
    }

    @OptionsProperty
    public void setName(@NotNull String name) {
        if (name == null) {
            ProfilingConfiguration.$$$reportNull$$$0(2);
        }
        this.myName = name;
    }

    @OptionsProperty(group="Performance", name="Live allocation tracking:", description="Live allocation tracking tracks allocated java objects. This can have an impact on overall app performance. It is recommended to disable this when recording a trace.")
    public boolean isDisableLiveAllocation() {
        return this.myDisableLiveAllocation;
    }

    @OptionsProperty
    public void setDisableLiveAllocation(boolean disableLiveAllocation) {
        this.myDisableLiveAllocation = disableLiveAllocation;
    }

    public abstract int getRequiredDeviceLevel();

    public boolean isDeviceLevelSupported(int deviceLevel) {
        return deviceLevel >= this.getRequiredDeviceLevel();
    }

    @NotNull
    public static ProfilingConfiguration fromProto(@NotNull Cpu.CpuTraceConfiguration.UserOptions proto) {
        if (proto == null) {
            ProfilingConfiguration.$$$reportNull$$$0(3);
        }
        ProfilingConfiguration configuration = null;
        switch (proto.getTraceType()) {
            case ART: {
                if (proto.getTraceMode() == Cpu.CpuTraceMode.SAMPLED) {
                    ArtSampledConfiguration artSampled = new ArtSampledConfiguration(proto.getName());
                    artSampled.setProfilingSamplingIntervalUs(proto.getSamplingIntervalUs());
                    artSampled.setProfilingBufferSizeInMb(proto.getBufferSizeInMb());
                    configuration = artSampled;
                    break;
                }
                ArtInstrumentedConfiguration art = new ArtInstrumentedConfiguration(proto.getName());
                art.setProfilingBufferSizeInMb(proto.getBufferSizeInMb());
                configuration = art;
                break;
            }
            case PERFETTO: {
                PerfettoConfiguration perfetto = new PerfettoConfiguration(proto.getName());
                perfetto.setProfilingBufferSizeInMb(proto.getBufferSizeInMb());
                configuration = perfetto;
                break;
            }
            case ATRACE: {
                AtraceConfiguration atrace = new AtraceConfiguration(proto.getName());
                atrace.setProfilingBufferSizeInMb(proto.getBufferSizeInMb());
                configuration = atrace;
                break;
            }
            case SIMPLEPERF: {
                SimpleperfConfiguration simpleperf = new SimpleperfConfiguration(proto.getName());
                simpleperf.setProfilingSamplingIntervalUs(proto.getSamplingIntervalUs());
                configuration = simpleperf;
                break;
            }
            case UNRECOGNIZED: 
            case UNSPECIFIED_TYPE: {
                return new UnspecifiedConfiguration(DEFAULT_CONFIGURATION_NAME);
            }
        }
        configuration.setDisableLiveAllocation(proto.getDisableLiveAllocation());
        ProfilingConfiguration profilingConfiguration = configuration;
        if (profilingConfiguration == null) {
            ProfilingConfiguration.$$$reportNull$$$0(4);
        }
        return profilingConfiguration;
    }

    @NotNull
    public Cpu.CpuTraceConfiguration.UserOptions toProto() {
        Cpu.CpuTraceConfiguration.UserOptions userOptions = this.buildUserOptions().setName(this.getName()).setTraceType(this.getTraceType()).setDisableLiveAllocation(this.isDisableLiveAllocation()).build();
        if (userOptions == null) {
            ProfilingConfiguration.$$$reportNull$$$0(5);
        }
        return userOptions;
    }

    protected abstract Cpu.CpuTraceConfiguration.UserOptions.Builder buildUserOptions();

    public boolean equals(Object obj) {
        if (!(obj instanceof ProfilingConfiguration)) {
            return false;
        }
        ProfilingConfiguration incoming = (ProfilingConfiguration)obj;
        return incoming.toProto().equals((Object)this.toProto());
    }

    public int hashCode() {
        return this.toProto().hashCode();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/cpu/config/ProfilingConfiguration";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "proto";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/cpu/config/ProfilingConfiguration";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "fromProto";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "toProto";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "fromProto";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

