/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu.capturedetails;

import com.android.tools.adtui.FilterComponent;
import com.android.tools.adtui.common.AdtUiUtils;
import com.android.tools.adtui.model.ViewBinder;
import com.android.tools.adtui.model.filter.Filter;
import com.android.tools.adtui.model.filter.FilterHandler;
import com.android.tools.adtui.model.filter.FilterResult;
import com.android.tools.profilers.ProfilerLayout;
import com.android.tools.profilers.StudioProfilersView;
import com.android.tools.profilers.cpu.CpuProfilerStage;
import com.android.tools.profilers.cpu.CpuProfilerStageView;
import com.android.tools.profilers.cpu.capturedetails.CaptureDetails;
import com.android.tools.profilers.cpu.capturedetails.CaptureDetailsView;
import com.android.tools.profilers.cpu.capturedetails.CapturePane;
import com.android.tools.profilers.cpu.capturedetails.ChartDetailsView;
import com.android.tools.profilers.cpu.capturedetails.TreeDetailsView;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DetailsCapturePane
extends CapturePane {
    @Nullable
    private CaptureDetailsView myDetailsView;
    @NotNull
    private final FilterComponent myFilterComponent;
    @NotNull
    private final ViewBinder<StudioProfilersView, CaptureDetails, CaptureDetailsView> myBinder;

    DetailsCapturePane(@NotNull CpuProfilerStageView view) {
        if (view == null) {
            DetailsCapturePane.$$$reportNull$$$0(0);
        }
        super(view);
        this.myBinder = new ViewBinder();
        this.myBinder.bind(CaptureDetails.TopDown.class, TreeDetailsView.TopDownDetailsView::new);
        this.myBinder.bind(CaptureDetails.BottomUp.class, TreeDetailsView.BottomUpDetailsView::new);
        this.myBinder.bind(CaptureDetails.CallChart.class, ChartDetailsView.CallChartDetailsView::new);
        this.myBinder.bind(CaptureDetails.FlameChart.class, ChartDetailsView.FlameChartDetailsView::new);
        this.myTabsPanel.addChangeListener(event -> this.setCaptureDetailToTab());
        final CpuProfilerStage stage = (CpuProfilerStage)this.myStageView.getStage();
        this.myFilterComponent = new FilterComponent(stage.getCaptureModel().getFilter(), ProfilerLayout.FILTER_TEXT_FIELD_WIDTH, 5, 250).setMatchCountVisibility(false);
        this.myFilterComponent.getModel().setFilterHandler(new FilterHandler(){

            @NotNull
            protected FilterResult applyFilter(@NotNull Filter filter) {
                if (filter == null) {
                    1.$$$reportNull$$$0(0);
                }
                FilterResult filterResult = stage.applyCaptureFilter(filter);
                if (filterResult == null) {
                    1.$$$reportNull$$$0(1);
                }
                return filterResult;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "filter";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/android/tools/profilers/cpu/capturedetails/DetailsCapturePane$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/android/tools/profilers/cpu/capturedetails/DetailsCapturePane$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "applyFilter";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "applyFilter";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
        this.myFilterComponent.setVisible(!this.myFilterComponent.getModel().getFilter().isEmpty());
        this.myFilterComponent.setBorder(AdtUiUtils.DEFAULT_BOTTOM_BORDER);
        FilterComponent.configureKeyBindingAndFocusBehaviors((JComponent)this, (FilterComponent)this.myFilterComponent, (JToggleButton)this.myToolbar.getFilterButton());
        this.updateView();
    }

    @Override
    void populateContent(@NotNull JPanel panel2) {
        CaptureDetails details;
        if (panel2 == null) {
            DetailsCapturePane.$$$reportNull$$$0(1);
        }
        boolean filterHasFocus = this.myFilterComponent.isAncestorOf(KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner());
        if (this.myFilterComponent.getParent() != null) {
            this.myFilterComponent.getParent().remove((Component)this.myFilterComponent);
        }
        if ((details = ((CpuProfilerStage)this.myStageView.getStage()).getCaptureDetails()) == null) {
            return;
        }
        this.myDetailsView = (CaptureDetailsView)this.myBinder.build((Object)this.myStageView.getProfilersView(), (Object)details);
        panel2.add((Component)this.myFilterComponent, "North");
        panel2.add((Component)this.myDetailsView.getComponent(), "Center");
        if (filterHasFocus) {
            this.myFilterComponent.requestFocusInWindow();
        }
    }

    private void setCaptureDetailToTab() {
        String tabTitle = this.myTabsPanel.getTitleAt(this.myTabsPanel.getSelectedIndex());
        CaptureDetails.Type type = this.myTabs.entrySet().stream().filter(e -> tabTitle.equals(e.getValue())).map(e -> (CaptureDetails.Type)((Object)((Object)e.getKey()))).findFirst().orElse(null);
        ((CpuProfilerStage)this.myStageView.getStage()).setCaptureDetails(type);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panel";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/profilers/cpu/capturedetails/DetailsCapturePane";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "populateContent";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

