/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.adtui.RangeTooltipComponent;
import com.android.tools.adtui.TabularLayout;
import com.android.tools.adtui.common.AdtUiUtils;
import com.android.tools.adtui.instructions.InstructionsPanel;
import com.android.tools.adtui.instructions.RenderInstruction;
import com.android.tools.adtui.instructions.TextInstruction;
import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.Timeline;
import com.android.tools.profilers.ProfilerAspect;
import com.android.tools.profilers.ProfilerColors;
import com.android.tools.profilers.ProfilerFonts;
import com.android.tools.profilers.ProfilerLayout;
import com.android.tools.profilers.ProfilerMode;
import com.android.tools.profilers.ProfilerScrollbar;
import com.android.tools.profilers.ProfilerTooltipMouseAdapter;
import com.android.tools.profilers.Stage;
import com.android.tools.profilers.StageView;
import com.android.tools.profilers.StudioProfilersView;
import com.android.tools.profilers.cpu.CpuFrameTooltipView;
import com.android.tools.profilers.cpu.CpuFramesView;
import com.android.tools.profilers.cpu.CpuKernelTooltipView;
import com.android.tools.profilers.cpu.CpuKernelsView;
import com.android.tools.profilers.cpu.CpuProfilerAspect;
import com.android.tools.profilers.cpu.CpuProfilerContextMenuInstaller;
import com.android.tools.profilers.cpu.CpuProfilerStage;
import com.android.tools.profilers.cpu.CpuProfilerStageCpuUsageTooltip;
import com.android.tools.profilers.cpu.CpuProfilerStageCpuUsageTooltipView;
import com.android.tools.profilers.cpu.CpuProfilerToolbar;
import com.android.tools.profilers.cpu.CpuThreadsTooltip;
import com.android.tools.profilers.cpu.CpuThreadsTooltipView;
import com.android.tools.profilers.cpu.CpuThreadsView;
import com.android.tools.profilers.cpu.CpuUsageView;
import com.android.tools.profilers.cpu.capturedetails.CpuCaptureView;
import com.android.tools.profilers.cpu.systemtrace.CpuFrameTooltip;
import com.android.tools.profilers.cpu.systemtrace.CpuKernelTooltip;
import com.android.tools.profilers.event.EventMonitorView;
import com.android.tools.profilers.event.LifecycleTooltip;
import com.android.tools.profilers.event.LifecycleTooltipView;
import com.android.tools.profilers.event.UserEventTooltip;
import com.android.tools.profilers.event.UserEventTooltipView;
import com.android.tools.profilers.sessions.SessionAspect;
import com.android.tools.profilers.sessions.SessionsManager;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.components.JBPanel;
import com.intellij.util.ui.UIUtilities;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.LayoutManager;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class CpuProfilerStageView
extends StageView<CpuProfilerStage> {
    private static final float SPLITTER_DEFAULT_RATIO = 0.5f;
    private static final float KERNEL_VIEW_SPLITTER_RATIO = 0.75f;
    private final CpuProfilerStage myStage;
    @NotNull
    private final CpuThreadsView myThreads;
    @NotNull
    private final CpuKernelsView myCpus;
    @NotNull
    private final CpuFramesView myFrames;
    @NotNull
    private final JBSplitter mySplitter;
    @NotNull
    private final CpuCaptureView myCaptureView;
    @NotNull
    private final RangeTooltipComponent myTooltipComponent;
    @NotNull
    private final CpuUsageView myUsageView;
    @NotNull
    private final CpuProfilerToolbar myToolbar;

    public CpuProfilerStageView(@NotNull StudioProfilersView profilersView, @NotNull CpuProfilerStage stage) {
        if (profilersView == null) {
            CpuProfilerStageView.$$$reportNull$$$0(0);
        }
        if (stage == null) {
            CpuProfilerStageView.$$$reportNull$$$0(1);
        }
        super(profilersView, stage);
        this.myStage = stage;
        this.myThreads = new CpuThreadsView(this.myStage);
        this.myCpus = new CpuKernelsView(this.myStage);
        this.myFrames = new CpuFramesView(this.myStage);
        if (this.myStage.isImportTraceMode()) {
            this.myUsageView = new CpuUsageView.ImportModeView(this.myStage);
            this.myToolbar = new CpuProfilerToolbar.ImportMode(this.myStage);
        } else {
            this.myUsageView = new CpuUsageView.NormalModeView(this.myStage);
            this.myToolbar = new CpuProfilerToolbar.NormalMode(stage, this.getIdeComponents());
        }
        this.myTooltipComponent = new RangeTooltipComponent((Timeline)((CpuProfilerStage)this.getStage()).getTimeline(), (JComponent)this.getTooltipPanel(), this.getProfilersView().getComponent(), this::shouldShowTooltipSeekComponent);
        stage.getAspect().addDependency((AspectObserver)this).onChange((Enum)CpuProfilerAspect.CAPTURE_STATE, this.myToolbar::update).onChange((Enum)CpuProfilerAspect.CAPTURE_SELECTION, this.myToolbar::update);
        this.getTooltipBinder().bind(CpuProfilerStageCpuUsageTooltip.class, CpuProfilerStageCpuUsageTooltipView::new);
        this.getTooltipBinder().bind(CpuKernelTooltip.class, (stageView, tooltip2) -> new CpuKernelTooltipView(stageView.getComponent(), (CpuKernelTooltip)((Object)tooltip2)));
        this.getTooltipBinder().bind(CpuThreadsTooltip.class, (stageView, tooltip2) -> new CpuThreadsTooltipView(stageView.getComponent(), (CpuThreadsTooltip)((Object)tooltip2)));
        this.getTooltipBinder().bind(CpuFrameTooltip.class, (stageView, tooltip2) -> new CpuFrameTooltipView(stageView.getComponent(), (CpuFrameTooltip)((Object)tooltip2)));
        this.getTooltipBinder().bind(LifecycleTooltip.class, (stageView, tooltip2) -> new LifecycleTooltipView(stageView.getComponent(), (LifecycleTooltip)tooltip2));
        this.getTooltipBinder().bind(UserEventTooltip.class, (stageView, tooltip2) -> new UserEventTooltipView(stageView.getComponent(), (UserEventTooltip)tooltip2));
        this.getTooltipPanel().setLayout(new FlowLayout(0, 0, 0));
        if (!this.myStage.isImportTraceMode()) {
            this.myTooltipComponent.registerListenersOn((JComponent)((Object)this.myUsageView));
            ProfilerTooltipMouseAdapter listener = new ProfilerTooltipMouseAdapter(this.myStage, () -> new CpuProfilerStageCpuUsageTooltip(this.myStage));
            this.myUsageView.addMouseListener(listener);
        }
        JPanel details = new JPanel((LayoutManager)new TabularLayout("*", "Fit-,*"));
        details.setBackground(ProfilerColors.DEFAULT_STAGE_BACKGROUND);
        details.add((Component)this.myTooltipComponent, new TabularLayout.Constraint(0, 0, 3, 1));
        if (!this.myStage.isImportTraceMode()) {
            EventMonitorView eventsView = new EventMonitorView(profilersView, stage.getEventMonitor());
            eventsView.registerTooltip(this.myTooltipComponent, (Stage)((Object)this.getStage()));
            details.add((Component)eventsView.getComponent(), new TabularLayout.Constraint(0, 0));
        }
        TabularLayout mainLayout = new TabularLayout("*");
        mainLayout.setRowSizing(PanelSizing.MONITOR.getRow(), PanelSizing.MONITOR.getRowRule());
        mainLayout.setRowSizing(PanelSizing.DETAILS.getRow(), PanelSizing.DETAILS.getRowRule());
        JBPanel mainPanel = new JBPanel((LayoutManager)mainLayout);
        mainPanel.setBackground(ProfilerColors.DEFAULT_STAGE_BACKGROUND);
        mainPanel.add((Component)((Object)this.myUsageView), new TabularLayout.Constraint(PanelSizing.MONITOR.getRow(), 0));
        mainPanel.add((Component)this.createCpuStatePanel(), new TabularLayout.Constraint(PanelSizing.DETAILS.getRow(), 0));
        details.add((Component)mainPanel, new TabularLayout.Constraint(1, 0));
        details.add((Component)this.buildTimeAxis(this.myStage.getStudioProfilers()), new TabularLayout.Constraint(3, 0));
        details.add((Component)((Object)new ProfilerScrollbar(this.myStage.getTimeline(), details)), new TabularLayout.Constraint(4, 0));
        this.myCaptureView = new CpuCaptureView(this);
        this.mySplitter = new JBSplitter(true);
        this.mySplitter.setFirstComponent((JComponent)details);
        this.mySplitter.setSecondComponent(null);
        this.mySplitter.getDivider().setBorder(AdtUiUtils.DEFAULT_HORIZONTAL_BORDERS);
        this.getComponent().add((Component)this.mySplitter, "Center");
        stage.getStudioProfilers().addDependency(this).onChange((Enum)ProfilerAspect.MODE, this::updateCaptureViewVisibility);
        this.updateCaptureViewVisibility();
        CpuProfilerContextMenuInstaller.install(this.myStage, this.getIdeComponents(), (JComponent)((Object)this.myUsageView), this.getComponent());
        this.getProfilersView().installCommonMenuItems((JComponent)((Object)this.myUsageView));
        if (!((CpuProfilerStage)this.getStage()).hasUserUsedCpuCapture() && !((CpuProfilerStage)this.getStage()).isImportTraceMode()) {
            this.installProfilingInstructions((JPanel)((Object)this.myUsageView));
        }
        SessionsManager sessions = ((CpuProfilerStage)this.getStage()).getStudioProfilers().getSessionsManager();
        sessions.addDependency(this).onChange((Enum)SessionAspect.SELECTED_SESSION, this.myToolbar::update);
    }

    @NotNull
    private JPanel createCpuStatePanel() {
        TabularLayout cpuStateLayout = new TabularLayout("*");
        JBPanel cpuStatePanel = new JBPanel((LayoutManager)cpuStateLayout);
        cpuStatePanel.setBackground(ProfilerColors.DEFAULT_STAGE_BACKGROUND);
        cpuStateLayout.setRowSizing(PanelSizing.FRAME.getRow(), PanelSizing.FRAME.getRowRule());
        cpuStateLayout.setRowSizing(PanelSizing.KERNEL.getRow(), PanelSizing.KERNEL.getRowRule());
        cpuStateLayout.setRowSizing(PanelSizing.THREADS.getRow(), PanelSizing.THREADS.getRowRule());
        this.myTooltipComponent.registerListenersOn(this.myThreads.getComponent());
        cpuStatePanel.add((Component)this.myThreads.getComponent(), new TabularLayout.Constraint(PanelSizing.THREADS.getRow(), 0));
        this.myCpus.getComponent().addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                CpuProfilerStageView.this.mySplitter.setProportion(0.75f);
            }

            @Override
            public void componentHidden(ComponentEvent e) {
                CpuProfilerStageView.this.mySplitter.setProportion(0.5f);
            }
        });
        this.myTooltipComponent.registerListenersOn(this.myCpus.getComponent());
        cpuStatePanel.add((Component)this.myCpus.getComponent(), new TabularLayout.Constraint(PanelSizing.KERNEL.getRow(), 0));
        this.myTooltipComponent.registerListenersOn(this.myFrames.getComponent());
        cpuStatePanel.add((Component)this.myFrames.getComponent(), new TabularLayout.Constraint(PanelSizing.FRAME.getRow(), 0));
        JBPanel jBPanel = cpuStatePanel;
        if (jBPanel == null) {
            CpuProfilerStageView.$$$reportNull$$$0(2);
        }
        return jBPanel;
    }

    private void installProfilingInstructions(@NotNull JPanel parent) {
        if (parent == null) {
            CpuProfilerStageView.$$$reportNull$$$0(3);
        }
        assert (parent.getLayout().getClass() == TabularLayout.class);
        FontMetrics metrics = UIUtilities.getFontMetrics((JComponent)parent, (Font)ProfilerFonts.H2_FONT);
        InstructionsPanel panel2 = new InstructionsPanel.Builder(new RenderInstruction[]{new TextInstruction(metrics, "Click Record to start capturing CPU activity")}).setEaseOut(this.myStage.getInstructionsEaseOutModel(), instructionsPanel -> parent.remove((Component)instructionsPanel)).setBackgroundCornerRadius(ProfilerLayout.PROFILING_INSTRUCTIONS_BACKGROUND_ARC_DIAMETER, ProfilerLayout.PROFILING_INSTRUCTIONS_BACKGROUND_ARC_DIAMETER).build();
        parent.add((Component)panel2, new TabularLayout.Constraint(0, 0), 0);
    }

    @Override
    public JComponent getToolbar() {
        return this.myToolbar.getComponent();
    }

    @Override
    public boolean supportsStreaming() {
        if (((CpuProfilerStage)this.getStage()).getStudioProfilers().getIdeServices().getFeatureConfig().isCpuCaptureStageEnabled()) {
            return super.supportsStreaming();
        }
        return !this.myStage.isImportTraceMode();
    }

    @Override
    public boolean supportsStageNavigation() {
        if (((CpuProfilerStage)this.getStage()).getStudioProfilers().getIdeServices().getFeatureConfig().isCpuCaptureStageEnabled()) {
            return super.supportsStageNavigation();
        }
        return !this.myStage.isImportTraceMode();
    }

    private void updateCaptureViewVisibility() {
        if (this.myStage.getProfilerMode() == ProfilerMode.EXPANDED) {
            this.mySplitter.setSecondComponent(this.myCaptureView.getComponent());
        }
    }

    @VisibleForTesting
    boolean shouldShowTooltipSeekComponent() {
        return this.myStage.getTooltip() instanceof CpuProfilerStageCpuUsageTooltip && this.myUsageView.shouldShowTooltipSeekComponent();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profilersView";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stage";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/cpu/CpuProfilerStageView";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/cpu/CpuProfilerStageView";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createCpuStatePanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "installProfilingInstructions";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static enum PanelSizing {
        MONITOR("140px", 0),
        DETAILS("*", 1),
        FRAME("Fit", 0),
        KERNEL("Fit", 1),
        THREADS("*", 2);

        @NotNull
        private final String myRowRule;
        private final int myRow;

        private PanelSizing(String rowRule, int row) {
            if (rowRule == null) {
                PanelSizing.$$$reportNull$$$0(0);
            }
            this.myRowRule = rowRule;
            this.myRow = row;
        }

        @NotNull
        public String getRowRule() {
            String string = this.myRowRule;
            if (string == null) {
                PanelSizing.$$$reportNull$$$0(1);
            }
            return string;
        }

        public int getRow() {
            return this.myRow;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rowRule";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/profilers/cpu/CpuProfilerStageView$PanelSizing";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/profilers/cpu/CpuProfilerStageView$PanelSizing";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRowRule";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

