/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.adtui.TabularLayout;
import com.android.tools.adtui.event.DelegateMouseEventHandler;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.RangedSeries;
import com.android.tools.adtui.model.SeriesData;
import com.android.tools.adtui.model.Timeline;
import com.android.tools.adtui.ui.HideablePanel;
import com.android.tools.profilers.ProfilerColors;
import com.android.tools.profilers.ProfilerTooltipMouseAdapter;
import com.android.tools.profilers.cpu.CpuKernelCellRenderer;
import com.android.tools.profilers.cpu.CpuListScrollPane;
import com.android.tools.profilers.cpu.CpuProfilerStage;
import com.android.tools.profilers.cpu.CpuThreadsModel;
import com.android.tools.profilers.cpu.systemtrace.CpuKernelModel;
import com.android.tools.profilers.cpu.systemtrace.CpuKernelTooltip;
import com.android.tools.profilers.cpu.systemtrace.CpuThreadSliceInfo;
import com.intellij.ui.components.JBList;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.border.Border;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.jetbrains.annotations.NotNull;

public final class CpuKernelsView {
    @NotNull
    private final HideablePanel myPanel;
    @NotNull
    private final CpuProfilerStage myStage;
    @NotNull
    private final JBList<CpuKernelModel.CpuState> myKernels;

    public CpuKernelsView(@NotNull CpuProfilerStage stage) {
        if (stage == null) {
            CpuKernelsView.$$$reportNull$$$0(0);
        }
        this.myStage = stage;
        this.myKernels = new JBList((ListModel)stage.getCpuKernelModel());
        this.myPanel = this.createKernelsPanel();
        this.setupListeners();
        this.myKernels.setBackground(ProfilerColors.DEFAULT_STAGE_BACKGROUND);
        this.myKernels.setCellRenderer((ListCellRenderer)new CpuKernelCellRenderer(this.myStage, this.myStage.getStudioProfilers().getIdeServices().getFeatureConfig(), this.myStage.getStudioProfilers().getSession().getPid(), (JList<CpuKernelModel.CpuState>)this.myKernels));
        this.myKernels.getModel().addListDataListener(new ListDataListener(){

            @Override
            public void contentsChanged(ListDataEvent e) {
                int size = CpuKernelsView.this.myKernels.getModel().getSize();
                boolean hasElements = size != 0;
                CpuKernelsView.this.myKernels.setVisibleRowCount(Math.min(4, size));
                CpuKernelsView.this.myPanel.setVisible(hasElements);
                CpuKernelsView.this.myPanel.setExpanded(hasElements);
                CpuKernelsView.this.myPanel.setTitle(String.format("KERNEL (%d)", size));
            }

            @Override
            public void intervalAdded(ListDataEvent e) {
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
            }
        });
        DelegateMouseEventHandler.delegateTo((Component)this.myPanel).installListenerOn(this.myKernels).installMotionListenerOn(this.myKernels);
    }

    @NotNull
    public JComponent getComponent() {
        HideablePanel hideablePanel = this.myPanel;
        if (hideablePanel == null) {
            CpuKernelsView.$$$reportNull$$$0(1);
        }
        return hideablePanel;
    }

    private void setupListeners() {
        this.myKernels.addListSelectionListener(e -> this.cpuKernelRunningStateSelected(this.myKernels.getModel()));
        this.myKernels.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                CpuKernelsView.this.cpuKernelRunningStateSelected(CpuKernelsView.this.myKernels.getModel());
                CpuKernelsView.this.myStage.getStudioProfilers().getIdeServices().getFeatureTracker().trackSelectCpuKernelElement();
            }
        });
        int pid = this.myStage.getStudioProfilers().getSession().getPid();
        this.myKernels.addMouseListener((MouseListener)new ProfilerTooltipMouseAdapter(this.myStage, () -> new CpuKernelTooltip((Timeline)this.myStage.getTimeline(), pid)));
        this.myKernels.addMouseMotionListener((MouseMotionListener)new MouseAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                int row = CpuKernelsView.this.myKernels.locationToIndex(e.getPoint());
                if (row != -1) {
                    CpuKernelModel.CpuState model = (CpuKernelModel.CpuState)CpuKernelsView.this.myKernels.getModel().getElementAt(row);
                    if (CpuKernelsView.this.myStage.getTooltip() instanceof CpuKernelTooltip) {
                        CpuKernelTooltip tooltip2 = (CpuKernelTooltip)CpuKernelsView.this.myStage.getTooltip();
                        tooltip2.setCpuSeries(model.getCpuId(), model.getSeries());
                    }
                }
            }
        });
    }

    @NotNull
    private HideablePanel createKernelsPanel() {
        JPanel kernelsContent = new JPanel((LayoutManager)new TabularLayout("*", "*"));
        HideablePanel kernelsPanel = new HideablePanel.Builder("KERNEL", (JComponent)kernelsContent).setShowSeparator(false).setInitiallyExpanded(false).setClickableComponent(HideablePanel.ClickableComponent.TITLE).setIconTextGap(6).setTitleLeftPadding(7).build();
        kernelsContent.add((Component)((Object)new CpuListScrollPane((JList)this.myKernels, (JComponent)kernelsPanel)), new TabularLayout.Constraint(0, 0));
        kernelsPanel.setVisible(false);
        kernelsPanel.setBorder(JBUI.Borders.customLine((Color)ProfilerColors.CPU_AXIS_GUIDE_COLOR, (int)2, (int)0, (int)0, (int)0));
        kernelsPanel.setBackground(ProfilerColors.DEFAULT_STAGE_BACKGROUND);
        kernelsPanel.addStateChangedListener(e -> this.myStage.getStudioProfilers().getIdeServices().getFeatureTracker().trackToggleCpuKernelHideablePanel());
        kernelsContent.setBorder((Border)JBUI.Borders.empty());
        HideablePanel hideablePanel = kernelsPanel;
        if (hideablePanel == null) {
            CpuKernelsView.$$$reportNull$$$0(2);
        }
        return hideablePanel;
    }

    private void cpuKernelRunningStateSelected(@NotNull ListModel<CpuKernelModel.CpuState> cpuModel) {
        int selectedIndex;
        if (cpuModel == null) {
            CpuKernelsView.$$$reportNull$$$0(3);
        }
        if ((selectedIndex = this.myKernels.getSelectedIndex()) < 0) {
            this.myStage.setSelectedThread(-1);
            return;
        }
        CpuKernelModel.CpuState state = cpuModel.getElementAt(selectedIndex);
        Range tooltipRange = this.myStage.getTimeline().getTooltipRange();
        List process = ((RangedSeries)state.getModel().getSeries().get(0)).getSeriesForRange(tooltipRange);
        if (process.isEmpty()) {
            return;
        }
        int id = ((CpuThreadSliceInfo)((SeriesData)process.get((int)0)).value).getId();
        CpuThreadsModel threadsModel = this.myStage.getThreadStates();
        for (int i2 = 0; i2 < threadsModel.getSize(); ++i2) {
            CpuThreadsModel.RangedCpuThread thread2 = (CpuThreadsModel.RangedCpuThread)threadsModel.getElementAt(i2);
            if (id != thread2.getThreadId()) continue;
            this.myStage.setSelectedThread(thread2.getThreadId());
            this.myStage.getStudioProfilers().getIdeServices().getFeatureTracker().trackSelectThread();
            break;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stage";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/cpu/CpuKernelsView";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cpuModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/cpu/CpuKernelsView";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createKernelsPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "cpuKernelRunningStateSelected";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

