/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.adtui.AxisComponent;
import com.android.tools.adtui.RangeTooltipComponent;
import com.android.tools.adtui.TabularLayout;
import com.android.tools.adtui.common.AdtUiCursorType;
import com.android.tools.adtui.common.AdtUiCursorsProvider;
import com.android.tools.adtui.common.AdtUiUtils;
import com.android.tools.adtui.common.StudioColorsKt;
import com.android.tools.adtui.flat.FlatSeparator;
import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.MultiSelectionModel;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.RangeSelectionModel;
import com.android.tools.adtui.model.axis.AxisComponentModel;
import com.android.tools.adtui.model.axis.ResizingAxisComponentModel;
import com.android.tools.adtui.model.formatter.BaseAxisFormatter;
import com.android.tools.adtui.model.formatter.TimeAxisFormatter;
import com.android.tools.adtui.trackgroup.TrackGroupListPanel;
import com.android.tools.adtui.trackgroup.TrackRendererFactory;
import com.android.tools.profilers.ProfilerColors;
import com.android.tools.profilers.ProfilerLayout;
import com.android.tools.profilers.ProfilerTooltipMouseAdapter;
import com.android.tools.profilers.ProfilerTrackRendererFactory;
import com.android.tools.profilers.Stage;
import com.android.tools.profilers.StageView;
import com.android.tools.profilers.StudioProfilersView;
import com.android.tools.profilers.cpu.BufferQueueTooltipView;
import com.android.tools.profilers.cpu.CaptureNode;
import com.android.tools.profilers.cpu.CpuCaptureMinimapModel;
import com.android.tools.profilers.cpu.CpuCaptureMinimapView;
import com.android.tools.profilers.cpu.CpuCaptureStage;
import com.android.tools.profilers.cpu.CpuCaptureStageCpuUsageTooltip;
import com.android.tools.profilers.cpu.CpuCaptureStageCpuUsageTooltipView;
import com.android.tools.profilers.cpu.CpuFrameTooltipView;
import com.android.tools.profilers.cpu.CpuFrequencyTooltipView;
import com.android.tools.profilers.cpu.CpuKernelTooltipView;
import com.android.tools.profilers.cpu.CpuThreadsTooltip;
import com.android.tools.profilers.cpu.CpuThreadsTooltipView;
import com.android.tools.profilers.cpu.RssMemoryTooltipView;
import com.android.tools.profilers.cpu.StatusPanel;
import com.android.tools.profilers.cpu.SurfaceflingerTooltipView;
import com.android.tools.profilers.cpu.VsyncTooltipView;
import com.android.tools.profilers.cpu.analysis.CaptureNodeAnalysisModel;
import com.android.tools.profilers.cpu.analysis.CpuAnalysisModel;
import com.android.tools.profilers.cpu.analysis.CpuAnalysisPanel;
import com.android.tools.profilers.cpu.analysis.CpuAnalyzable;
import com.android.tools.profilers.cpu.capturedetails.CpuCaptureNodeTooltip;
import com.android.tools.profilers.cpu.capturedetails.CpuCaptureNodeTooltipView;
import com.android.tools.profilers.cpu.systemtrace.BufferQueueTooltip;
import com.android.tools.profilers.cpu.systemtrace.CpuFrameTooltip;
import com.android.tools.profilers.cpu.systemtrace.CpuFrequencyTooltip;
import com.android.tools.profilers.cpu.systemtrace.CpuKernelTooltip;
import com.android.tools.profilers.cpu.systemtrace.RssMemoryTooltip;
import com.android.tools.profilers.cpu.systemtrace.SurfaceflingerTooltip;
import com.android.tools.profilers.cpu.systemtrace.VsyncTooltip;
import com.android.tools.profilers.event.LifecycleTooltip;
import com.android.tools.profilers.event.LifecycleTooltipView;
import com.android.tools.profilers.event.UserEventTooltip;
import com.android.tools.profilers.event.UserEventTooltipView;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public class CpuCaptureStageView
extends StageView<CpuCaptureStage> {
    private static final double TIMELINE_PAN_FACTOR = 0.1;
    private static final double TIMELINE_DRAG_FACTOR = 0.001;
    private static final String ZOOM_IN_KEY = "zoom_in";
    private static final String ZOOM_OUT_KEY = "zoom_out";
    private static final String PAN_LEFT_KEY = "pan_left";
    private static final String PAN_RIGHT_KEY = "pan_right";
    private static final String PANNING_MODE_ON_KEY = "panning_mode_on";
    private static final String PANNING_MODE_OFF_KEY = "panning_mode_off";
    private final ProfilerTrackRendererFactory myTrackRendererFactory;
    private final TrackGroupListPanel myTrackGroupList;
    private final CpuAnalysisPanel myAnalysisPanel;
    private final JScrollPane myScrollPane;
    private final LinkLabel<?> myDeselectAllLabel;
    private final JPanel myDeselectAllToolbar;
    private boolean myIsPanningMode;

    public CpuCaptureStageView(@NotNull StudioProfilersView view, @NotNull CpuCaptureStage stage) {
        if (view == null) {
            CpuCaptureStageView.$$$reportNull$$$0(0);
        }
        if (stage == null) {
            CpuCaptureStageView.$$$reportNull$$$0(1);
        }
        super(view, stage);
        this.myIsPanningMode = false;
        this.myTrackRendererFactory = new ProfilerTrackRendererFactory(this.getProfilersView());
        this.myTrackGroupList = this.createTrackGroupListPanel();
        this.myScrollPane = new JBScrollPane((Component)this.myTrackGroupList.getComponent(), 20, 31);
        this.myScrollPane.setBorder((Border)JBUI.Borders.empty());
        this.myAnalysisPanel = new CpuAnalysisPanel(view, stage);
        this.myDeselectAllToolbar = new JPanel(ProfilerLayout.createToolbarLayout());
        this.myDeselectAllLabel = this.createDeselectAllLabel();
        this.getTooltipBinder().bind(CpuCaptureStageCpuUsageTooltip.class, CpuCaptureStageCpuUsageTooltipView::new);
        this.myTrackGroupList.getTooltipBinder().bind(CpuFrameTooltip.class, CpuFrameTooltipView::new);
        this.myTrackGroupList.getTooltipBinder().bind(CpuThreadsTooltip.class, CpuThreadsTooltipView::new);
        this.myTrackGroupList.getTooltipBinder().bind(CpuCaptureNodeTooltip.class, CpuCaptureNodeTooltipView::new);
        this.myTrackGroupList.getTooltipBinder().bind(CpuKernelTooltip.class, CpuKernelTooltipView::new);
        this.myTrackGroupList.getTooltipBinder().bind(UserEventTooltip.class, UserEventTooltipView::new);
        this.myTrackGroupList.getTooltipBinder().bind(LifecycleTooltip.class, LifecycleTooltipView::new);
        this.myTrackGroupList.getTooltipBinder().bind(SurfaceflingerTooltip.class, SurfaceflingerTooltipView::new);
        this.myTrackGroupList.getTooltipBinder().bind(VsyncTooltip.class, VsyncTooltipView::new);
        this.myTrackGroupList.getTooltipBinder().bind(BufferQueueTooltip.class, BufferQueueTooltipView::new);
        this.myTrackGroupList.getTooltipBinder().bind(RssMemoryTooltip.class, RssMemoryTooltipView::new);
        this.myTrackGroupList.getTooltipBinder().bind(CpuFrequencyTooltip.class, CpuFrequencyTooltipView::new);
        stage.getAspect().addDependency((AspectObserver)this).onChange((Enum)CpuCaptureStage.Aspect.STATE, this::updateComponents);
        stage.getMultiSelectionModel().addDependency((AspectObserver)this).onChange((Enum)MultiSelectionModel.Aspect.CHANGE_SELECTION, this::onTrackGroupSelectionChange);
        this.updateComponents();
    }

    @Override
    public JComponent getToolbar() {
        JPanel panel2 = new JPanel(new BorderLayout());
        this.myDeselectAllToolbar.add((Component)this.myDeselectAllLabel);
        this.myDeselectAllToolbar.add((Component)new FlatSeparator());
        this.myDeselectAllToolbar.setVisible(false);
        panel2.add((Component)this.myDeselectAllToolbar, "East");
        return panel2;
    }

    private void updateComponents() {
        this.getComponent().removeAll();
        if (((CpuCaptureStage)((Object)this.getStage())).getState() == CpuCaptureStage.State.PARSING) {
            this.getComponent().add(new StatusPanel(((CpuCaptureStage)((Object)this.getStage())).getCaptureHandler(), "Parsing", "Abort"));
        } else {
            this.unregisterAnalyzingEvents();
            this.registerAnalyzingEvents();
            this.getComponent().add(this.createAnalyzingComponents());
            this.getComponent().revalidate();
            this.myTrackGroupList.getComponent().requestFocusInWindow();
        }
    }

    private void registerAnalyzingEvents() {
        ((CpuCaptureStage)((Object)this.getStage())).getMinimapModel().getRangeSelectionModel().addDependency((AspectObserver)this).onChange((Enum)RangeSelectionModel.Aspect.SELECTION, this::updateTrackGroupList);
        ((CpuCaptureStage)((Object)this.getStage())).getCapture().getCaptureNodes().forEach(node -> node.getAspectModel().addDependency((AspectObserver)this).onChange((Enum)CaptureNode.Aspect.FILTER_APPLIED, this::updateTrackGroupList));
    }

    private void unregisterAnalyzingEvents() {
        ((CpuCaptureStage)((Object)this.getStage())).getMinimapModel().getRangeSelectionModel().removeDependencies((AspectObserver)this);
        ((CpuCaptureStage)((Object)this.getStage())).getCapture().getCaptureNodes().forEach(node -> node.getAspectModel().removeDependencies((AspectObserver)this));
    }

    private JComponent createAnalyzingComponents() {
        CpuCaptureMinimapModel minimapModel = ((CpuCaptureStage)((Object)this.getStage())).getMinimapModel();
        CpuCaptureMinimapView minimap = new CpuCaptureMinimapView(minimapModel);
        RangeTooltipComponent minimapTooltipComponent = new RangeTooltipComponent(((CpuCaptureStage)((Object)this.getStage())).getCaptureTimeline(), (JComponent)this.getTooltipPanel(), this.getProfilersView().getComponent(), () -> false);
        minimap.registerRangeTooltipComponent(minimapTooltipComponent);
        minimap.addMouseListener(new ProfilerTooltipMouseAdapter((Stage)((Object)this.getStage()), () -> new CpuCaptureStageCpuUsageTooltip(minimapModel.getCpuUsage(), ((CpuCaptureStage)((Object)((Object)this.getStage()))).getCaptureTimeline().getTooltipRange())));
        this.loadTrackGroupModels();
        JPanel container = new JPanel((LayoutManager)new TabularLayout("*", "Fit-,*"));
        container.add((Component)minimapTooltipComponent, new TabularLayout.Constraint(0, 0));
        container.add((Component)minimap.getComponent(), new TabularLayout.Constraint(0, 0));
        container.add((Component)this.myScrollPane, new TabularLayout.Constraint(1, 0));
        container.add((Component)CpuCaptureStageView.createBottomAxisPanel(minimapModel.getRangeSelectionModel().getSelectionRange()), new TabularLayout.Constraint(2, 0));
        this.initKeyBindings(container);
        JBSplitter splitter = new JBSplitter(false, 0.5f);
        splitter.setFirstComponent((JComponent)container);
        splitter.setSecondComponent(this.myAnalysisPanel.getComponent());
        splitter.getDivider().setBorder(JBUI.Borders.customLine((Color)StudioColorsKt.getBorder(), (int)0, (int)1, (int)0, (int)1));
        return splitter;
    }

    private void initKeyBindings(@NotNull JComponent container) {
        if (container == null) {
            CpuCaptureStageView.$$$reportNull$$$0(2);
        }
        InputMap inputMap = container.getInputMap(1);
        ActionMap actionMap = container.getActionMap();
        inputMap.put(KeyStroke.getKeyStroke(87, 0), ZOOM_IN_KEY);
        inputMap.put(KeyStroke.getKeyStroke(83, 0), ZOOM_OUT_KEY);
        inputMap.put(KeyStroke.getKeyStroke(65, 0), PAN_LEFT_KEY);
        inputMap.put(KeyStroke.getKeyStroke(68, 0), PAN_RIGHT_KEY);
        inputMap.put(KeyStroke.getKeyStroke(32, 0), PANNING_MODE_ON_KEY);
        inputMap.put(KeyStroke.getKeyStroke(32, 0, true), PANNING_MODE_OFF_KEY);
        actionMap.put(ZOOM_IN_KEY, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((CpuCaptureStage)((Object)CpuCaptureStageView.this.getStage())).getTimeline().zoomIn();
                CpuCaptureStageView.this.getProfilersView().getStudioProfilers().getIdeServices().getFeatureTracker().trackZoomIn();
            }
        });
        actionMap.put(ZOOM_OUT_KEY, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((CpuCaptureStage)((Object)CpuCaptureStageView.this.getStage())).getTimeline().zoomOut();
                CpuCaptureStageView.this.getProfilersView().getStudioProfilers().getIdeServices().getFeatureTracker().trackZoomOut();
            }
        });
        actionMap.put(PAN_LEFT_KEY, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((CpuCaptureStage)((Object)CpuCaptureStageView.this.getStage())).getTimeline().panView(-((CpuCaptureStage)((Object)CpuCaptureStageView.this.getStage())).getTimeline().getViewRange().getLength() * 0.1);
            }
        });
        actionMap.put(PAN_RIGHT_KEY, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((CpuCaptureStage)((Object)CpuCaptureStageView.this.getStage())).getTimeline().panView(((CpuCaptureStage)((Object)CpuCaptureStageView.this.getStage())).getTimeline().getViewRange().getLength() * 0.1);
            }
        });
        actionMap.put(PANNING_MODE_ON_KEY, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CpuCaptureStageView.this.setPanningMode(true, CpuCaptureStageView.this.myTrackGroupList);
            }
        });
        actionMap.put(PANNING_MODE_OFF_KEY, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CpuCaptureStageView.this.setPanningMode(false, CpuCaptureStageView.this.myTrackGroupList);
            }
        });
    }

    @NotNull
    private TrackGroupListPanel createTrackGroupListPanel() {
        TrackGroupListPanel trackGroupListPanel = new TrackGroupListPanel((TrackRendererFactory)this.myTrackRendererFactory);
        MouseAdapter mouseListener = new MouseAdapter(){
            private int myLastX = 0;

            @Override
            public void mousePressed(MouseEvent e) {
                if (CpuCaptureStageView.this.myIsPanningMode) {
                    this.myLastX = e.getX();
                }
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                if (CpuCaptureStageView.this.myIsPanningMode) {
                    int deltaX = this.myLastX - e.getX();
                    this.myLastX = e.getX();
                    ((CpuCaptureStage)((Object)CpuCaptureStageView.this.getStage())).getTimeline().panView(((CpuCaptureStage)((Object)CpuCaptureStageView.this.getStage())).getTimeline().getViewRange().getLength() * (double)deltaX * 0.001);
                }
            }
        };
        trackGroupListPanel.getComponent().addMouseListener(mouseListener);
        trackGroupListPanel.getComponent().addMouseMotionListener(mouseListener);
        trackGroupListPanel.getComponent().addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                if (AdtUiUtils.isActionKeyDown((InputEvent)e)) {
                    if (e.getWheelRotation() > 0) {
                        ((CpuCaptureStage)((Object)CpuCaptureStageView.this.getStage())).getTimeline().zoomOut();
                        CpuCaptureStageView.this.getProfilersView().getStudioProfilers().getIdeServices().getFeatureTracker().trackZoomOut();
                    } else {
                        ((CpuCaptureStage)((Object)CpuCaptureStageView.this.getStage())).getTimeline().zoomIn();
                        CpuCaptureStageView.this.getProfilersView().getStudioProfilers().getIdeServices().getFeatureTracker().trackZoomIn();
                    }
                } else {
                    e.setSource(CpuCaptureStageView.this.myScrollPane);
                    CpuCaptureStageView.this.myScrollPane.dispatchEvent(e);
                }
            }
        });
        TrackGroupListPanel trackGroupListPanel2 = trackGroupListPanel;
        if (trackGroupListPanel2 == null) {
            CpuCaptureStageView.$$$reportNull$$$0(3);
        }
        return trackGroupListPanel2;
    }

    private void setPanningMode(boolean isPanningMode, @NotNull TrackGroupListPanel trackGroupListPanel) {
        if (trackGroupListPanel == null) {
            CpuCaptureStageView.$$$reportNull$$$0(4);
        }
        this.myIsPanningMode = isPanningMode;
        trackGroupListPanel.setEnabled(!isPanningMode);
        this.getProfilersView().getComponent().setCursor(isPanningMode ? AdtUiCursorsProvider.getInstance().getCursor(AdtUiCursorType.GRABBING) : null);
    }

    private static JComponent createBottomAxisPanel(@NotNull Range range) {
        if (range == null) {
            CpuCaptureStageView.$$$reportNull$$$0(5);
        }
        JPanel axisPanel = new JPanel((LayoutManager)new TabularLayout("150px,*"));
        axisPanel.setBackground(ProfilerColors.DEFAULT_BACKGROUND);
        AxisComponent timeAxis = new AxisComponent((AxisComponentModel)new ResizingAxisComponentModel.Builder(range, (BaseAxisFormatter)TimeAxisFormatter.DEFAULT).build(), AxisComponent.AxisOrientation.BOTTOM);
        timeAxis.setMinimumSize(new Dimension(0, ProfilerLayout.TIME_AXIS_HEIGHT));
        timeAxis.setPreferredSize(new Dimension(Integer.MAX_VALUE, ProfilerLayout.TIME_AXIS_HEIGHT));
        axisPanel.add((Component)timeAxis, new TabularLayout.Constraint(0, 1));
        return axisPanel;
    }

    private LinkLabel<?> createDeselectAllLabel() {
        LinkLabel label = LinkLabel.create((String)"Clear thread/event selection", () -> ((CpuCaptureStage)((Object)((Object)this.getStage()))).getMultiSelectionModel().clearSelection());
        label.setBorder((Border)new JBEmptyBorder(0, 0, 0, 4));
        label.setToolTipText("Click to deselect all threads/events");
        return label;
    }

    private void updateTrackGroupList() {
        this.myTrackGroupList.getComponent().updateUI();
    }

    private void loadTrackGroupModels() {
        this.myTrackGroupList.setRangeTooltipComponent(new RangeTooltipComponent(((CpuCaptureStage)((Object)this.getStage())).getTimeline(), (JComponent)this.myTrackGroupList.getTooltipPanel(), this.getProfilersView().getComponent(), () -> false));
        this.myTrackGroupList.loadTrackGroups(((CpuCaptureStage)((Object)this.getStage())).getTrackGroupModels(), true);
        this.myTrackGroupList.registerMultiSelectionModel(((CpuCaptureStage)((Object)this.getStage())).getMultiSelectionModel());
    }

    private void onTrackGroupSelectionChange() {
        if (((CpuCaptureStage)((Object)this.getStage())).getAnalysisModels().size() > 1) {
            ((CpuCaptureStage)((Object)this.getStage())).removeCpuAnalysisModel(((CpuCaptureStage)((Object)this.getStage())).getAnalysisModels().size() - 1);
        }
        ImmutableList selection2 = ((CpuCaptureStage)((Object)this.getStage())).getMultiSelectionModel().getSelection();
        ((CpuCaptureStage)((Object)this.getStage())).getMultiSelectionModel().getSelection().stream().map(CpuAnalyzable::getAnalysisModel).reduce(CpuAnalysisModel::mergeWith).ifPresent(((CpuCaptureStage)((Object)this.getStage()))::addCpuAnalysisModel);
        this.updateTrackGroupList();
        if (selection2.isEmpty()) {
            ((CpuCaptureStage)((Object)this.getStage())).getTimeline().getSelectionRange().clear();
        } else if (selection2.get(0) instanceof CaptureNodeAnalysisModel) {
            Range selectedNodeRange = ((CaptureNodeAnalysisModel)selection2.get(0)).getNodeRange();
            ((CpuCaptureStage)((Object)this.getStage())).getTimeline().getSelectionRange().set(selectedNodeRange);
        }
        this.myDeselectAllToolbar.setVisible(!selection2.isEmpty());
    }

    @VisibleForTesting
    @NotNull
    protected final TrackGroupListPanel getTrackGroupList() {
        TrackGroupListPanel trackGroupListPanel = this.myTrackGroupList;
        if (trackGroupListPanel == null) {
            CpuCaptureStageView.$$$reportNull$$$0(6);
        }
        return trackGroupListPanel;
    }

    @VisibleForTesting
    @NotNull
    protected final CpuAnalysisPanel getAnalysisPanel() {
        CpuAnalysisPanel cpuAnalysisPanel = this.myAnalysisPanel;
        if (cpuAnalysisPanel == null) {
            CpuCaptureStageView.$$$reportNull$$$0(7);
        }
        return cpuAnalysisPanel;
    }

    @VisibleForTesting
    LinkLabel<?> getDeselectAllLabel() {
        return this.myDeselectAllLabel;
    }

    @VisibleForTesting
    JPanel getDeselectAllToolbar() {
        return this.myDeselectAllToolbar;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stage";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 3: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/cpu/CpuCaptureStageView";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "trackGroupListPanel";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/cpu/CpuCaptureStageView";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createTrackGroupListPanel";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getTrackGroupList";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnalysisPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "initKeyBindings";
                break;
            }
            case 3: 
            case 6: 
            case 7: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setPanningMode";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createBottomAxisPanel";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

